//********************************************************************************
//  : main.c
// 汾     : V1.0 2020/06/22MQ6833
//      : 
// ע     : TC00 TC01ϲΪ12bit PWMݔ,15.625 KHz, ռձ0%99.976%
//********************************************************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif

#include "main.h"
#include "math.h"


/* ----------------------  ------------------------------ */
uint  pwmduty_0to4095;

/* ----------------------  -------------------------------- */
void main(){
	
    /* ---------------------- ϵͳʼ ------------------------ */
    System_Init();    
    pwmduty_0to4095 = 0;

    /* ---------------------- ܳʼ ------------------------ */
    T001_12BitPWM_Init();
	//  TC00,TC01ϲΪ12bit PWM, PWMƵ 15.625 KHz, ռձ0%99.976%
	//    1. Ƶ趨Ϊ 8MHz,
	//    2. TC00, TC01Ϊ12λPWM, ؼ趨:
	//        a. T001CR<TCAS> = 1
	//        b. T01MOD<TCM1> = 2
	//        c. T01PWM<3:0>, T00PWM<7:4>, T00PWM<3:0> Ϊ12λPWMռձ趨λλ, ϸο10.5.3.7½
	//        d. TC00ĻΪЧ, T00PWM
	//    3. ƵѡΪfcgck/2
	//    4. ɹܽTC01(P71), ÿ10msıռձ(PWMƵΪ62.5KHz )
	//    5. ռձ0%, 0.024%, 0.049,  99.976%, ֱԼΪǧ֮2.4

    //----------------------------------------------------------------
    T001_12BitPWM_Start();
    //----------------------------------------------------------------


	


//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

	while(1)
    {
        CLR_WDT;                        // Źʱ (ι)
        //ÿ10msռձ
        if( pwmduty_0to4095 < 4095 ){   // ռձ 0/4096 ~ 4095/4096
            pwmduty_0to4095++;
            T001_12BitPWM_SetDuty( pwmduty_0to4095 );
        }
        else{
            pwmduty_0to4095 = 0;
            T001_12BitPWM_SetDuty( pwmduty_0to4095 );
        }
        Delay_Times(t_1ms, 10);
        NOP;                            // ָ
        NOP;                            // ָ
        NOP;                            // ָ
    }
//  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}


















/*---------------------- жϷ ------------------------*/
//=============== Dummy function for interrupt ============
void __interrupt Int_dummy(void)
{

}
//=========================================================
void __interrupt OnlyReti(void)
{
    NOP;                                // ָ
}

void __interrupt_n OnlyRetn(void)
{
    NOP;                                // ָ
}

void __interrupt_n IntWDT(void)
{
    NOP;                                // ָ
}

void __interrupt_n IntSWI(void)
{
    unsigned char *p_coming_opcode = ((*(unsigned short *)(__SP + (6 * 2) + 1)) - 1);
    unsigned char r_index;
    static const unsigned char a_invalid_opcode[] = {  /* invalid opcode */
            0x01,0x02,0x03,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0xf8,0xff };		

    for( r_index = 0; r_index < ( sizeof(a_invalid_opcode)/sizeof(a_invalid_opcode[0])); r_index++ )
    {
        if ( *p_coming_opcode == a_invalid_opcode[r_index] )
            SYSCR2 = 0x10;  	//system clock reset
    }

    // adjust address for return from IntSWI // '
    (*(unsigned short *)(__SP + (6 * 2) + 1))--;
		
    // cost 6 bytes for fix stack //
    __asm("dec	wa");
    __asm("dec	bc");
    __asm("dec	de");
    __asm("dec	hl");
    __asm("dec	ix");
    __asm("dec	iy");	
}      
/*-----------------  жϷ ------------------------*/

/*------------------------ MQ6833ж ------------------------*/
#pragma section const INT_VECTOR 0xffc2
void * const IntTbl1[] = {  
    OnlyReti,           // 0xffc2 : IntTCC0T
    OnlyReti,           // 0xffc4 : IntTCC0P
    OnlyReti,           // 0xffc6 : IntTEMG0
    OnlyReti,           // 0xffc8 : IntTXD2
    OnlyReti,           // 0xffca : IntRXD2
    Int_dummy,          // 0xffcc : Reserved
    Int_dummy,          // 0xffce : Reserved
    OnlyReti,           // 0xffd0 : IntTXD1
    OnlyReti,           // 0xffd2 : IntRXD1
    Int_dummy,          // 0xffd4 : Reserved
    Int_dummy,          // 0xffd6 : Reserved
    OnlyReti,           // 0xffd8 : Int3
    OnlyReti,           // 0xffda : Int2
    OnlyReti,           // 0xffdc : Int1
    OnlyReti,           // 0xffde : Int0
    OnlyReti,           // 0xffe0 : IntSBI0 / IntSIO0
    OnlyReti,           // 0xffe2 : IntTCA0
    OnlyReti,           // 0xffe4 : IntTC01
    OnlyReti,           // 0xffe6 : IntTC00
    OnlyReti,           // 0xffe8 : IntRTC
    OnlyReti,           // 0xffea : IntADC
    OnlyReti,           // 0xffec : IntVLTD
    OnlyReti,           // 0xffee : Int5
    OnlyReti,           // 0xfff0 : IntTXD0
    OnlyReti,           // 0xfff2 : IntRXD0
    OnlyReti,           // 0xfff4 : IntTBT
    OnlyReti,           // 0xfff6 : IntWUC
    IntWDT,             // 0xfff8 : IntWDT
    (void *)0xffff,     // 0xfffa : Reserved
    IntSWI,             // 0xfffc : IntSWI/INTUNDEF
    STARTUP             // 0xfffe : RESET					
};
#pragma section const
/*-------------------  MQ6833ж ------------------------*/

















//*********************************************************************
//    : System_Init(void)
//  : IO, CGCR ʼ P10/P20/P21 ڷʱ֮趨
// ע     :
//*********************************************************************
void System_Init(void)
{


    
#ifdef _DEBUG   //...  _DEBUG(ģʽ): ڷ ev board
//------------------------------------------------------------------
//  (ϵͳĬ): ʱP10趨ΪReset PinԱӰ漰¼.
//  SET_P10_RESET_PIN;
//------------------------------------------------------------------
#else           //...  һϵܳ(Ƿģʽ) P10(RESET) λΪһ IO 
//------------------------------------------------------------------
//-- P10趨ΪһIO ------
    SET_P10_IO_PIN;
//------------------------------------------------------------------
#endif



//-- ʼ IO  (λ)------
#ifdef _DEBUG   //...  _DEBUG: ڷ ev board
//------------------------------------------------------------------
//   P10/P20/P21  Debug modeڷʱ趨Ϊ룬
//  ԱӰ漰¼.
    P1DR = 0x00;
    P1CR = set8bit(11111110);           //  P10 Ϊ
    P2DR = 0x00;
    P2CR = set8bit(11111100);           //  P20/P21 Ϊ
//------------------------------------------------------------------
#else           //...  һϵܳ(Ƿģʽ)
//------------------------------------------------------------------
    P1DR = 0x00;
    P1CR = 0xff;
    P2DR = 0x00;
    P2CR = 0xff;
//------------------------------------------------------------------
#endif

//-- ʼ IO  ------
    P0DR = 0x00;
    P0CR = 0xff;
//  P1DR = 0x00;
//  P1CR = 0xff;
//  P2DR = 0x00;
//  P2CR = 0xff;
    P4DR = 0x00;
    P4CR = 0xff;    
    P7DR = 0x00;
    P7CR = 0xff;
    P9DR = 0x00;
    P9CR = 0xff;

    CLR_WDT;                            // Źʱ (ι)
}



//*********************************************************************
//    : Delay_Times
//  : ʱ
// ע     : ==> t_1ms   = 0;          // ӳʱ䵥λ ms
//          : ==> t_100us = 1;          // ӳʱ䵥λ usϴ
//          : ɹ̶Ȧʱһʱ䣬ʹ÷£
//          : Delay_Times(t_1ms, 800);  // ӳ 800ms
//*********************************************************************
void Delay_Times(uchar tBase, uint x)
{
    uint  i, cgcrT;

    uchar cgcrF[4]={ 2, 4,  8, 1 };     // پƵΪ  8MHz ʱʹô
//  uchar cgcrF[4]={ 4, 8, 16, 2 };     // پƵΪ 16MHz ʱʹô

//  ϵͳڸʱ(ͨ1ͨ2ģʽ) ʱ
    if( SYSCR2_SYSCK == 0 )
    {
        cgcrT = cgcrF[CGCR_FCGCKSEL];   // 0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
        switch(tBase)
        {
            case 0:                     // t_1ms
                cgcrT *= 110;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
            case 1:                     // t_100us
                cgcrT *= 11;
                for(; x>0; x--)
                    for(i=0; i<cgcrT; i++){}
            break;
        }
    }
//  ϵͳڵʱ(12ģʽ) ʱϴ󣬲οʹã
    else for(; x>0; x--){}

    CLR_WDT;                            // Źʱ (ι)
}



 







