//**********************************************************************
//  : MQ6833_Flash.c
// 汾     : V1.0 2020/06/22MQ6833
//      : Flashʹú
// ע		***ȷFLASHʽִǰоƬϵ硢λ
//**********************************************************************
#include "main.h"


uint  FLASH_ADDR, CHECK_SIZE, DATA_CMD;
uchar ERS_FLAG, PGM_FLAG;		// д󣬴״̬, 0X81:ok, 0XA5:fail

//===  RAM ִеλַռԤ ===
#define       def_RAM_RETN        0x0300
#define       def_RAM_Start       0x0302
uint __io(def_RAM_RETN)  RAM_RETN;
uint __io(def_RAM_Start) RAM_Start;

#define	      def_RAM_code_START  0x0304
#define       def_RAM_code_SIZE   0x0032	//  0x32(50) byte ռ
//	 RAM С(def_RAM_code_SIZE) ִ flash ֮
uchar __io(def_RAM_code_START) RAM_EXE_CodeSize[def_RAM_code_SIZE];


#pragma asm
_WDCTR		EQU	 0x0FD4
_EIRL		EQU	 0x003A
_WDCDR		EQU	 0x0FD5
_SYSCR3		EQU	 0x0FDE
_SYS4		EQU	 0x0FDF ;SYSCR4
_FLSCR1		EQU	 0x0FD0
_FLCM		EQU	 0x0FD1 ;FLSCRM
_ILL		EQU	 0x0FE0
_ILH		EQU	 0x0FE1
_ILE		EQU	 0x0FE2
_ILD		EQU	 0x0FE3
#pragma endasm

//*********************************************************************
// 	: Flash_PGM_Byte()
// 	: дַָ addr  byte
// ע		: ַָ addr, ϵͳ˵ַԶжϡдַָ addr  byte
//			: --------------------------------
//			: FCGCK = 2MHz
//			: --------------------------------
//			: С  | дʱ | ȡʱ
//			:-----------|----------|----------
//			:    1 byte | ~ 550 us | ~  27 us
//			:   10 byte | ~ 970 us | ~ 112 us
//			:   50 byte | ~2883 us | ~ 490 us
//			:  129 byte | ~6660 us | ~1238 us
//			: --------------------------------
//*********************************************************************
void Flash_PGM_Byte(uint pgm_addr, uint length, uchar* data)
{
	CLR_WDT;                        	// Źʱ (ι)

	#pragma asm
; --------------------------------
	PUSH	WA						; SP+2

;  WDCTR ж״̬
	LD		W, (_WDCTR)
	LD		A, (_EIRL)
	DI
	PUSH	WA						; SP+2
    CLR     (_WDCTR).5				; WDT disable
    LD		(_WDCDR), 0xB1			; WDT disable

;  FLASH ֵ
	LD		WA, (SP+0x07)			; pgm_addr: дַ
	LD		(_FLASH_ADDR), WA

	LD		WA, (SP+0x09)			; pgm_addr: дϳ
	LD		(_CHECK_SIZE), WA

	LD		WA,  (SP+0x0B)			; data:     дλַ
	LD		(_DATA_CMD),   WA

	PUSH	BC
	PUSH	DE
	PUSH	HL
	PUSH	IX

;  RAM(0x01FC) λֵַ֮
	LD		WA,  (0x01FC)
	PUSH	WA


PGM_FLASH_CODE_START:
; д󣬴״̬, 0X81:ok, 0XA5:fail
	LD		(_PGM_FLAG), 0X00

; ================================
; ====== ж RAM
; --------------------------------
	LD		HL,   0x01FC			; Set INTUNDEF and INTSWI interrupt vectors.
	LDW		(HL), _RAM_RETN

; ================================
; ======  RAM
; --------------------------------
	LD		HL, _RAM_RETN
	LD		IX, PGM_FLASH_LOOP

PGM_TRANS_CODE2RAM_LOOP:
	LD		A, (IX)
	LD		(HL), A
	INC		IX
	INC		HL
	CMP		IX, PGM_FLASH_LOOP_END
	J		NE, PGM_TRANS_CODE2RAM_LOOP
; --------------------------------


; λַΧСָʼԤ
	LD		BC, (_CHECK_SIZE)
	ADD		BC, (_FLASH_ADDR)
	LD		HL, (_FLASH_ADDR)
	LD		IX, (_DATA_CMD)
; лж RAM ִ
	LD		(_SYSCR3), 0x06
	LD		(_SYS4),   0xD4
	CALL	_RAM_Start				;  RAM ִг

; Disable Flash Command
	LD		(_FLSCR1), 0x40
	LD		(_FLCM),   0xD5
	LD		(_SYSCR3), 0x00
	LD		(_SYS4),   0xD4

;	J		PGM_Done_Before_return	; Ҫʡʱ䣬ִдгԺԶȡ֤
; дٴζȡдǷȷ,
	LD		BC, (_CHECK_SIZE)
	ADD		BC, (_FLASH_ADDR)
	LD		HL, (_FLASH_ADDR)
	LD		IX, (_DATA_CMD)
PGM_Data_Read_loop:
	LD		W, (IX)
	CMP		W, (HL)
	J		NE, PGM_ERROR
	INC		IX
	INC		HL
	CMP		HL, BC
	J		NE, PGM_Data_Read_loop

; д󣬴״̬, 0X81:ok, 0XA5:fail
PGM_PASS:
	LD		(_PGM_FLAG), 0X81
	J		PGM_Done_Before_return
PGM_ERROR:
	LD		(_PGM_FLAG), 0XA5


; --------------------------------
PGM_Done_Before_return:
	LD		(_ILL), 0X00
	LD		(_ILH), 0X00
	LD		(_ILE), 0X00
	LD		(_ILD), 0X00
; --------------------------------
; ظ RAM(0x01FC) λֵַ֮
	POP		WA
	LD		(0x01FC), WA

	POP		IX
	POP		HL
	POP		DE
	POP		BC

; ظ WDCTR ж״̬
	POP		WA
	LD		(_WDCTR), W
	LD		(_EIRL),  A

	POP		WA
; --------------------------------
	RET




PGM_FLASH_LOOP:
; RAM_RETN
	RETN							; 2 bytes: RETN = 0xE8FB
; ================================
; ====== FLASH ERASE 
; --------------------------------
; RAM_Start:
; Flash initial
	LD		(_FLSCR1), 0xA0
	LD		(_FLCM),   0xD5

Program_data_loop:
	LD		W, (IX)
	LD		(0xF555), 0xAA
	LD		(0xFAAA), 0x55
	LD		(0xF555), 0xA0
	LD		(HL), W
	NOP
	NOP
	NOP

Check_PGM_done:
	LD		W, (HL)
	CMP		W, (HL)
	J		NE, Check_PGM_done

	INC		IX
	INC		HL
	CMP		HL, BC
	J		NE, Program_data_loop
	RET

PGM_FLASH_LOOP_END:
	NOP
; --------------------------------
	#pragma endasm
}





//*********************************************************************
// 	: Flash_SEC_ERS()
// 	: ַָ addr  sector
// ע		: ַָ addr, ϵͳ˵ַԶжϡַָ addr  sector
//			: erase command ==> 0x20: 128 byte0x30: 1024 byte
//			: --------------------------------
//			: FCGCK = 2MHz
//			: --------------------------------
//			: С   | ʱ | ȡʱ
//			:-----------|----------|----------
//			:  128 byte | ~ 5.1 ms |  ~1.1 ms
//			: 1024 byte | ~37.0 ms |  ~8.7 ms
//			: --------------------------------
//*********************************************************************
void Flash_SEC_ERS(uint ers_addr, uchar ers_cmd)
{
	CLR_WDT;                        	// Źʱ (ι)

	#pragma asm
; --------------------------------
	PUSH	WA						; SP+2

;  WDCTR ж״̬
	LD		W, (_WDCTR)
	LD		A, (_EIRL)
	DI
	PUSH	WA						; SP+2
    CLR     (_WDCTR).5				; WDT disable
    LD		(_WDCDR), 0xB1			; WDT disable

;  FLASH ֵ
	LD		WA, (SP+0x07)			; ers_addr: ַ
	LD		(_FLASH_ADDR), WA
	LD		W,  (SP+0x09)			; ers_cmd:  ָ
	LD		(_DATA_CMD),   W

	PUSH	BC
	PUSH	DE
	PUSH	HL
	PUSH	IX

;  RAM(0x01FC) λֵַ֮
	LD		WA,  (0x01FC)
	PUSH	WA

; --------------------------------
	LDW		(_CHECK_SIZE), 0x0080	; Ԥȡ֤Ϊ 128 byte
	CMP		(_DATA_CMD), 0x30		; жϲСָ ==> 0x20: 128 byte0x30: 1024 byte
	J		NE, ERS_FLASH_CODE_START
	LDW		(_CHECK_SIZE), 0x0400	; Ϊ 1K Сٴöȡ֤Ϊ 1024 byte
; --------------------------------


ERS_FLASH_CODE_START:
; д󣬴״̬, 0X81:ok, 0XA5:fail
	LD		(_ERS_FLAG), 0X00

; ================================
; ====== ж RAM
; --------------------------------
	LD		HL,   0x01FC			; Set INTUNDEF and INTSWI interrupt vectors.
	LDW		(HL), _RAM_RETN

; ================================
; ======  RAM
; --------------------------------
	LD		HL, _RAM_RETN
	LD		IX, ERS_FLASH_LOOP

ERS_TRANS_CODE2RAM_LOOP:
	LD		A, (IX)
	LD		(HL), A
	INC		IX
	INC		HL
	CMP		IX, ERS_FLASH_LOOP_END
	J		NE, ERS_TRANS_CODE2RAM_LOOP
; --------------------------------


; λַΧСָʼԤ
	LD		HL, (_FLASH_ADDR)
	LD		W, (_DATA_CMD)
; лж RAM ִ
	LD		(_SYSCR3), 0x06
	LD		(_SYS4),   0xD4
	CALL	_RAM_Start				;  RAM ִг

; Disable Flash Command
	LD		(_FLSCR1), 0x40
	LD		(_FLCM),   0xD5
	LD		(_SYSCR3), 0x00
	LD		(_SYS4),   0xD4

;	J		ERS_Done_Before_return	; Ҫʡʱ䣬ִдгԺԶȡ֤
; ٴζȡǷΪ 0xff,
	ADD		HL, (_CHECK_SIZE)
	LD		BC, HL
	LD		HL, (_FLASH_ADDR)
ERS_Read_FF_loop:
	LD		D, (HL)
	CMP		D, 0xFF
	J		NE, ERS_ERROR
	INC		HL
	CMP		HL, BC
	J		NE, ERS_Read_FF_loop

; д󣬴״̬, 0X81:ok, 0XA5:fail
ERS_PASS:
	LD		(_ERS_FLAG), 0X81
	J		ERS_Done_Before_return
ERS_ERROR:
	LD		(_ERS_FLAG), 0XA5


; --------------------------------
ERS_Done_Before_return:
	LD		(_ILL), 0X00
	LD		(_ILH), 0X00
	LD		(_ILE), 0X00
	LD		(_ILD), 0X00
; --------------------------------
; ظ RAM(0x01FC) λֵַ֮
	POP		WA
	LD		(0x01FC), WA

	POP		IX
	POP		HL
	POP		DE
	POP		BC

; ظ WDCTR ж״̬
	POP		WA
	LD		(_WDCTR), W
	LD		(_EIRL),  A

	POP		WA
; --------------------------------
	RET




ERS_FLASH_LOOP:
; RAM_RETN
	RETN							; 2 bytes: RETN = 0xE8FB
; ================================
; ====== FLASH ERASE 
; --------------------------------
; RAM_Start:
; Flash initial
	LD		(_FLSCR1), 0xA0
	LD		(_FLCM),   0xD5

	LD		(0xF555), 0xAA
	LD		(0xFAAA), 0x55
	LD		(0xF555), 0x80
	LD		(0xF555), 0xAA
	LD		(0xFAAA), 0x55
	LD		(HL), W
	NOP
	NOP
	NOP

Check_ERS_done:
	LD		W, (HL)
	CMP		W, (HL)
	J		NE, Check_ERS_done
	RET

ERS_FLASH_LOOP_END:
	NOP
; --------------------------------
	#pragma endasm
}




//*********************************************************************
// 	: FlashReadSequence()
// 	:  FLASH ȡ
// ע		:  addr ַʼȡ FLASH ָ length ϣ data 
//*********************************************************************
void FlashReadSequence(uint addr, uint length, uchar* data)
{
	uint  i;
	uchar *p_addr;

	p_addr = (uchar *) addr;

	for( i = 0; i < length; i++ )
	{
		data[i] = *( p_addr + i );
		CLR_WDT;                        	// Źʱ (ι)
	}
}

//*********************************************************************
// 	: FlashReadByte()
// 	:  FLASH ȡ
// ע		: ַָ addr ȡϺش
//*********************************************************************
uchar FlashReadByte(uint addr)
{
	return *((uchar *)addr);
}



