//******************************************************************************
// file         : main.c
// version      : V1.3  2023/11/20
// description  : at the beginning of the program, LED1(P2.0) lights up for a short time 
//                and then starts to blink, and then WDT starts
//              1. when the LED is blinking, it means program keeps clearing watchdog timer
//              2. when pressing button 1,  program stop clearing watchdog timer 
//                 and then WDT reset occurs, the system is reset and LED1 (P2.0) can be 
//                 seen to return to light for a short time and then start to blink
// note         : [Button Configuration] button 1 :  BTN1 (P1.0)
//                [LED Configuration]  LED1 (P2.0)
//              * please do not run this program in debug mode
//******************************************************************************
#ifndef IO_MEM
#define IO_MEM
#endif
#include "ADM_main.h"
#include "DRV_SQ7705_GPIO.h"
#include "DRV_SQ7705_SYSCLK.h"
#include "DRV_SQ7705_TBT.h"

/* --------------------------- global variables ----------------------------- */
uint8_t bWDT_test;
uint16_t cnt1,cnt2 = 0;                    // variables for delayed loop
extern uint8_t TBT_Int_Flag;               // flag for TBT interrupt
TBT_REG tbtReg;                            // TBT data structure

/* ---------------------------- main program -------------------------------- */
void ADM_Main()
{
    DRV_Clock_Init(Clk_Source_SYS, 1);                   // PLL 24MHz Initial system clock.

    DRV_GPIO_Init(GPIO_P20, GPIO_OUTPUT, GPIO_PULL_UP);  // set P2.0 as output pin
                                                         // enable P2.0 built-in pull-up resistor   
    DRV_GPIO_Init(GPIO_P10, GPIO_INPUT, GPIO_PULL_UP);   // set P1.0 as input pin
                                                         // enable P1.0 built-in pull-up resistor
    DRV_GPIO_WritePin(GPIO_P20, GPIO_PIN_LOW);           // set LED1(P2.0) to light on
    
    tbtReg.tbtDV9CK = DV9CK_FSYSCLK;                     // selects the input clock to stage 9 of the divider:fsysclk/2^9
    tbtReg.tbtTBTCK = TBTCK_1000;                        // selects the time base timer interrupt frequency:fsysclk/2^22
    DRV_TBT_Init(tbtReg);                                // initialize TBT
    DRV_TBT_Start();                                     // start TBT
    
    for(cnt1=0;cnt1<2000;cnt1++){
        for(cnt2=0;cnt2<2000;cnt2++){
            __ASM("NOP");                                // no operation
            __ASM("NOP");                                // no operation
            __ASM("NOP");                                // no operation
        }
    }

    WDCTR_WDTEN = 0;        // disable WDT
    WDCDR = 0xB1;           // write disable code        
    
    WDCTR_WDTW = 0x00;      // the 8-bit up counter is cleared by writing the clear code 
                            // at any point within the overflow time of the 8-bit up counter
    WDCTR_WDTT = 0x03;      // set overflow time : 2^24 / fsysclk(24MHz) = 0.699s
    
    WDCTR_WDTOUT = 1;       // WDT reset request signal when overflow
    //WDCTR_WDTOUT = 0;     // WDT interrupt request signal when overflow

    WDCTR_WDTEN = 1;        // enable WDT    
    bWDT_test = 0;

    while(1){
        if(bWDT_test==0){
            __ASM("NOP");                         // no operation
            WDCDR = 0x4E;                         // clear the watchdog timer 
            
            if(TBT_Int_Flag){                     // wait for TBT interrupt flag to be 1
                TBT_Int_Flag = 0;                 // clear TBT interrupt flag to 0 for the next interrupt    
                DRV_GPIO_TogglePin(GPIO_P20);     // LED1(P2.0) inverted
            }

            if(DRV_GPIO_ReadPin(GPIO_P10) == 0){  // wait for pressing button 1
                bWDT_test =1;                     // stop clearing watchdog timer
            }
        }
    }
}

/* ----------------------- interrupt service routine ------------------------ */
void __interrupt OnlyReti(void)
{
    __ASM("NOP");                              // no operation
}

void __interrupt_n OnlyRetn(void)
{
    __ASM("NOP");                              // no operation
}

void __interrupt_n WDT_IRQ(void)
{
    __ASM("NOP");                              // no operation
}

void __interrupt_n SWI_IRQ(void)               // software reset interrupt service routine
{
    SWRST = 0x5a;
    SWRST = 0xa5;
    SWRST = 0xc3;
    SWRST = 0x3c;
}

void __interrupt IntADM_Req(void)
{

}

/* ---------------------- end of interrupt service routine ------------------ */


/* ----------------------- SQ7705 interrupt vector -------------------------- */
#pragma section const ADM_INT_VECTOR
void * const IntTbl1[] = {
    ADM_STARTUP,             /* 0x0000 : RESET               */    //non-maskable
    SWI_IRQ,                 /* 0x0002 : SWI_IRQ/INTUNDEF    */    //non-maskable
    (void *)0xffff,          /* 0x0004 : Reserved            */    
    WDT_IRQ,                 /* 0x0006 : WDT_IRQ             */    //non-maskable interrupt source:watchdog timer
    OnlyReti,                /* 0x0008 : TAMPER_IRQ          */    //interrupt source:tamper detection
    OnlyReti,                /* 0x000A : CFD_IRQ             */    //interrupt source:clock faildetection
    OnlyReti,                /* 0x000C : HVD_IRQ             */
    IntADM_Req,              /* 0x000E : U2A_IRQ/IntADM_Req  */    //interrupt source:user mode to admin mode
    OnlyReti,                /* 0x0010 : RTC_IRQ             */    //interrupt source:real-time clock timer
    OnlyReti,                /* 0x0012 : TMRA00_IRQ          */    //interrupt source:TMRA00 8-bit timer
    OnlyReti,                /* 0x0014 : TMRA01_IRQ          */    //interrupt source:TMRA01 8-bit timer
    OnlyReti,                /* 0x0016 : TMRA10_IRQ          */    //interrupt source:TMRA10 8-bit timer
    OnlyReti,                /* 0x0018 : TMRA11_IRQ          */    //interrupt source:TMRA11 8-bit timer
    OnlyReti,                /* 0x001A : TMRA20_IRQ          */
    OnlyReti,                /* 0x001C : TMRA21_IRQ          */
    DRV_TBT_IRQ,             /* 0x001E : TBT_IRQ             */
    OnlyReti,                /* 0x0020 : RX0_IRQ             */    //interrupt source:UART0 RX0
    OnlyReti,                /* 0x0022 : TX0_IRQ             */    //interrupt source:UART0 TX0
    OnlyReti,                /* 0x0024 : I2C0_IRQ            */    //interrupt source:I2C0
    OnlyReti,                /* 0x0026 : SPI0_IRQ            */    //interrupt source:SPI0
    OnlyReti,                /* 0x0028 : EXT0_IRQ            */    //external interrupt0
    OnlyReti,                /* 0x002A : EXT1_IRQ            */    //external interrupt1
    OnlyReti,                /* 0x002C : EXT2_IRQ            */    //external interrupt2
    OnlyReti,                /* 0x002E : EXT3_IRQ            */    //external interrupt3
    OnlyReti,                /* 0x0030 : ADC_IRQ             */    //interrupt source:ADC
    OnlyReti,                /* 0x0032 : LVD0_IRQ            */
    OnlyReti,                /* 0x0034 : LVD1_IRQ            */
    OnlyReti,                /* 0x0036 : Reserved            */
    OnlyReti,                /* 0x0038 : Reserved            */
    OnlyReti,                /* 0x003A : FMC_IRQ             */    //interrupt source:flash memory controller
    OnlyReti,                /* 0x003C : DMACH0_IRQ          */
    OnlyReti,                /* 0x003E : DMACH1_IRQ          */
    OnlyReti,                /* 0x0040 : DMACH2_IRQ          */
    OnlyReti,                /* 0x0042 : DMACH3_IRQ          */
    OnlyReti,                /* 0x0044 : Reserved            */
    OnlyReti,                /* 0x0046 : Reserved            */
    OnlyReti,                /* 0x0048 : Reserved            */
    OnlyReti,                /* 0x004A : Reserved            */
    OnlyReti,                /* 0x004C : Reserved            */
    OnlyReti,                /* 0x004E : DIC_IRQ             */    //interrupt source:DIC
    OnlyReti,                /* 0x0050 : LEUART_RX_IRQ       */
    OnlyReti,                /* 0x0052 : LEUART_TX_IRQ       */
    OnlyReti,                /* 0x0054 : TRNG_IRQ            */
    OnlyReti,                /* 0x0056 : EXT4_IRQ            */    //external interrupt4
    OnlyReti,                /* 0x0058 : EXT5_IRQ            */    //external interrupt5
    OnlyReti,                /* 0x005A : EXT6_IRQ            */    //external interrupt6
    OnlyReti,                /* 0x005C : EXT7_IRQ            */    //external interrupt7
    OnlyReti,                /* 0x005E : EEMC_IRQ            */    //interrupt source:EEPROM controller
    OnlyReti,                /* 0x0060 : TCA0_IRQ            */    //interrupt source:TCA0 16-bit timer
    OnlyReti,                /* 0x0062 : TCA1_IRQ            */    //interrupt source:TCA1 16-bit timer
    OnlyReti,                /* 0x0064 : STM0_IRQ            */
    OnlyReti,                /* 0x0066 : STM1_IRQ            */
    OnlyReti,                /* 0x0068 : AES_IRQ             */
    OnlyReti,                /* 0x006A : SHA_IRQ             */
    OnlyReti,                /* 0x006C : RX1_IRQ             */    //interrupt source:UART1 RX1
    OnlyReti,                /* 0x006E : TX1_IRQ             */    //interrupt source:UART1 TX1
    OnlyReti,                /* 0x0070 : I2C1_IRQ            */    //interrupt source:I2C1
    OnlyReti,                /* 0x0072 : SPI1_IRQ            */    //interrupt source:SPI1
    OnlyReti,                /* 0x0074 : RX2_IRQ             */    //interrupt source:UART2 RX2
    OnlyReti,                /* 0x0076 : TX2_IRQ             */    //interrupt source:UART2 TX2
    OnlyReti                 /* 0x0078 : TCA2_IRQ            */    //interrupt source:TCA2 16-bit timer
};
#pragma section const
/* -------------------- end of SQ7705 interrupt vector ---------------------- */

