//******************************************************************************
// file         : SQ7705_SFR.h
// version      : V1.32 (2025/03/13)
// description  : Declare the detailed name of each the special function register
// note         : 
//******************************************************************************
#ifndef _SQ7705_SFR_H_
#define _SQ7705_SFR_H_

#include "SQ7705_SFR_addr.h"

//**********************************************************
//******
#define NOP                 __asm("NOP")                        // no operation
//******
#define DI                  __asm("DI")                         // disable all maskable interrupts // MIFR_IMF = 0
#define EI                  __asm("EI")                         // enable all maskable interrupts // MIFR_IMF = 1
//******
#define CLR_WDT             WDCDR=0x4E                    // clear the watchdog timer
//******
#define DIS_WDT             WDCTR_WDTEN=0; WDCDR=0xB1     // disable the watchdog timer operation and clear the 8-bit up counter
//******
//**********************************************************

//========================== 
//          MPCA             
//========================== 
#define     MPCA                        _0x0006.byte
#define     MPCA_MPCW                   _0x0006.bit.b6
#define     MPCA_MPCADDR                _0x0006.b5_0.b5_0
                             
//==========================
//          MPCD            
//==========================
#define     MPCD                        _0x0007.byte

//==========================
//          SYSCR0          
//==========================
#define     SYSCR0                      _0x0008.byte
#define     SYSCR0_XRSTDIS              _0x0008.bit.b3
#define     SYSCR0_OCDDIS               _0x0008.bit.b2
#define     SYSCR0_ROMST                _0x0008.bit.b1
                                       
//==========================
//          PMR
//==========================
#define     PMR                         _0x000A.byte
#define     PMR_LDOON                   _0x000A.bit.b4
#define     PMR_DSM                     _0x000A.bit.b3


//==========================
//          RSTFLG
//==========================
#define     RSTFLG                      _0x000B.byte
#define     RSTFLG_TAMPER_RST           _0x000B.bit.b7
#define     RSTFLG_LVDRST1              _0x000B.bit.b6
#define     RSTFLG_LVDRST0              _0x000B.bit.b5
#define     RSTFLG_BRRST                _0x000B.bit.b4
#define     RSTFLG_WDTF                 _0x000B.bit.b2
#define     RSTFLG_PRRST                _0x000B.bit.b1
#define     RSTFLG_EXRST                _0x000B.bit.b0
//==========================
//          UIDR
//==========================
#define     UID                         _0x000C.byte

//==========================
//          SWRST
//==========================
#define     SWRST                       _0x000D.byte

//==========================
//          RTCCR0
//==========================
#define     RTCCR0                      _0x0010.byte
#define     RTCCR0_WREN                 _0x0010.bit.b7
#define     RTCCR0_RTCEN                _0x0010.bit.b6
#define     RTCCR0_H12                  _0x0010.bit.b5
#define     RTCCR0_CLKOEN               _0x0010.bit.b4
#define     RTCCR0_CLKOSEL              _0x0010.b3_2.b3_2
#define     RTCCR0_CLKSEL               _0x0010.b1_0.b1_0

//==========================
//          RTCCR1
//==========================
#define     RTCCR1                      _0x0011.byte
#define     RTCCR1_TOF                  _0x0011.bit.b7
#define     RTCCR1_SECF                 _0x0011.bit.b6
#define     RTCCR1_ALF                  _0x0011.bit.b5
#define     RTCCR1_WRFENF               _0x0011.bit.b4
#define     RTCCR1_TOIE                 _0x0011.bit.b3
#define     RTCCR1_SECIE                _0x0011.bit.b2
#define     RTCCR1_ALIE                 _0x0011.bit.b1
#define     RTCCR1_WRENIE               _0x0011.bit.b0

//==========================
//          RTCSEC
//==========================
#define     RTCSEC                      _0x0012.byte
#define     RTCSEC_SECONDS              _0x0012.b6_0.b6_0
                                        
//==========================
//          RTCMIN
//==========================
#define     RTCMIN                      _0x0013.byte
#define     RTCMIN_MINUTES              _0x0013.b6_0.b6_0
                                
//==========================
//          RTCHR
//==========================
#define     RTCHR                       _0x0014.byte
#define     RTCHR_AMPM                  _0x0014.bit.b5
#define     RTCHR_HOURS                 _0x0014.b4_0.b4_0
                                        
//==========================
//          RTCDAY
//==========================
#define     RTCDAY                      _0x0015.byte
#define     RTCDAY_DAYS                 _0x0015.b5_0.b5_0
                                        
//==========================
//          RTCWDAY
//==========================
#define     RTCWDAY                     _0x0016.byte
#define     RTCWDAY_WEEKDAYS            _0x0016.b2_0.b2_0
                                            
//==========================
//          RTCMONTH
//==========================
#define     RTCMONTH                    _0x0017.byte
#define     RTCMONTH_MONTHS             _0x0017.b3_0.b3_0
                                        
//==========================
//          RTCYEAR
//==========================
#define     RTCYEAR                     _0x0018.byte
#define     RTCYEAR_YEARS               _0x0018.byte
                                            
//==========================
//          RTCALMIN
//==========================
#define     RTCALMIN                    _0x0019.byte
#define     RTCALMIN_MINBYP             _0x0019.bit.b7
#define     RTCALMIN_ALMIN              _0x0019.b6_0.b6_0
                                        
//==========================
//          RTCALHR
//==========================
#define     RTCALHR                     _0x001A.byte
#define     RTCALHR_HRBYP               _0x001A.bit.b7
#define     RTCALHR_AMPM                _0x001A.bit.b5
#define     RTCALHR_ALHR                _0x001A.b4_0.b4_0
                                           
//==========================
//          RTCALDAY
//==========================
#define     RTCALDAY                    _0x001B.byte
#define     RTCALDAY_DAYBYP             _0x001B.bit.b7
#define     RTCALDAY_ALDAY              _0x001B.b5_0.b5_0
                                        
//==========================
//          RTCALWDAY
//==========================
#define     RTCALWDAY                   _0x001C.byte
#define     RTCALWDAY_WAYBYP            _0x001C.bit.b7
#define     RTCALWDAY_ALWDAY            _0x001C.b2_0.b2_0
                                        
//==========================
//          RTCTMRCR
//==========================
#define     RTCTMRCR                    _0x001D.byte
#define     RTCTMRCR_TMRST              _0x001D.bit.b7
#define     RTCTMRCR_CONT               _0x001D.bit.b6
#define     RTCTMRCR_TMREN              _0x001D.bit.b5
#define     RTCTMRCR_CALEN              _0x001D.bit.b2
#define     RTCTMRCR_TMRSEL             _0x001D.b1_0.b1_0
                                
//==========================
//          RTCTMRTO
//==========================
#define     RTCTMRTO                    _0x001E.byte
#define     RTCTMRTO_TMRTO              _0x001E.byte
                                
//==========================
//          RTCOFST
//==========================
#define     RTCOFST                     _0x001F.byte
#define     RTCOFST_MODE                _0x001F.bit.b7      
#define     RTCOFST_SIGN                _0x001F.bit.b6
#define     RTCOFST_OFFSET              _0x001F.b5_0.b5_0
                                
//==========================
//          CLKCR0
//==========================
#define     CLKCR0                      _0x0020.byte
#define     CLKCR0_SCKPSC               _0x0020.b5_3.b5_3
#define     CLKCR0_SCKSEL               _0x0020.b2_0.b2_0

//==========================
//          CLKCR1
//==========================
#define     CLKCR1                      _0x0021.byte
#define     CLKCR1_LXEN                 _0x0021.bit.b3
#define     CLKCR1_HXEN                 _0x0021.bit.b2
#define     CLKCR1_LIRCEN               _0x0021.bit.b1
#define     CLKCR1_HIRCEN               _0x0021.bit.b0

//==========================
//          CLKCR2
//==========================
#define     CLKCR2                      _0x0022.byte
#define     CLKCR2_CMIE                 _0x0022.bit.b7
#define     CLKCR2_SCKLF                _0x0022.bit.b0

//==========================
//          CLKST
//==========================
#define     CLKST                       _0x0023.byte
#define     CLKST_SCKSRC                _0x0023.b7_5.b7_5
#define     CLKST_SCKRDY                _0x0023.bit.b4
#define     CLKST_LXRDY                 _0x0023.bit.b3
#define     CLKST_HXRDY                 _0x0023.bit.b2
#define     CLKST_HIRCRDY               _0x0023.bit.b0

//==========================
//          PLLCR0
//==========================
#define     PLLCR0                      _0x0024.byte
#define     PLLCR0_PLLWUP               _0x0024.b6_4.b6_4
#define     PLLCR0_PLLREF               _0x0024.b3_2.b3_2
#define     PLLCR0_PLLRDY               _0x0024.bit.b1
#define     PLLCR0_PLLEN                _0x0024.bit.b0

//==========================
//          CLKWUP
//==========================
#define     CLKWUP                      _0x0026.byte
#define     CLKWUP_LXWUP                _0x0026.b6_4.b6_4
#define     CLKWUP_HXWUP                _0x0026.b2_0.b2_0


                                
//==========================
//          FCKDIV
//==========================
#define     FCKDIV                      _0x0027.byte

//==========================
//          WDCTR
//==========================
#define     WDCTR                       _0x0028.byte
#define     WDCTR_WDTEN                 _0x0028.bit.b5
#define     WDCTR_WDTW                  _0x0028.b4_3.b4_3
#define     WDCTR_WDTT                  _0x0028.b2_1.b2_1
#define     WDCTR_WDTOUT                _0x0028.bit.b0

//==========================
//          WDCDR
//==========================
#define     WDCDR                       _0x0029.byte
#define     WDCDR_WDCDR                 _0x0029.byte
                                  
//==========================
//          WDCNT
//==========================
#define     WDCNT                       _0x002A.byte
                                  
//==========================
//          WDST
//==========================
#define     WDST                        _0x002B.byte
#define     WDST_WINTST2                _0x002B.bit.b2
#define     WDST_WINTST1                _0x002B.bit.b1
#define     WDST_WDTST                  _0x002B.bit.b0

//==========================
//          TBTCR
//==========================
#define     TBTCR                       _0x002E.byte
#define     TBTCR_DV9CK                 _0x002E.bit.b5
#define     TBTCR_TBTEN                 _0x002E.bit.b4
#define     TBTCR_TBTCK                 _0x002E.b3_0.b3_0

//==========================
//          DVOCR
//==========================
#define     DVOCR                       _0x002F.byte
#define     DVOCR_DVOEN                 _0x002F.bit.b2
#define     DVOCR_DVOCK                 _0x002F.b1_0.b1_0
 
//==========================
//          CMSR
//==========================
#define     CMSR                        _0x0030.byte
#define     CMSR_LF_GLITCH              _0x0030.bit.b7
#define     CMSR_LF_SLOW                _0x0030.bit.b6
#define     CMSR_LF_FAST                _0x0030.bit.b5
#define     CMSR_LF_FAIL                _0x0030.bit.b4
#define     CMSR_HF_GLITCH              _0x0030.bit.b3
#define     CMSR_HF_SLOW                _0x0030.bit.b2
#define     CMSR_HF_FAST                _0x0030.bit.b1
#define     CMSR_HF_FAIL                _0x0030.bit.b0
                                  
//==========================
//          LVDCR0
//==========================
#define     LVDCR0                      _0x0031.byte
#define     LVDCR0_LVDLP                _0x0031.bit.b7
#define     LVDCR0_LVDCFG               _0x0031.b6_4.b6_4
#define     LVDCR0_LVDRSTEN             _0x0031.bit.b3
#define     LVDCR0_LVDF                 _0x0031.bit.b2
#define     LVDCR0_LVDIEN               _0x0031.bit.b1
#define     LVDCR0_LVDEN                _0x0031.bit.b0

//==========================
//          HVDCR
//==========================
#define     HVDCR                       _0x0032.byte
#define     HVDCR_HVDLP                 _0x0032.bit.b7
#define     HVDCR_HVDEN                 _0x0032.bit.b0


//==========================
//          CMCR
//==========================
#define     CMCR                        _0x0035.byte
#define     CMCR_LF_GLITCH_EN           _0x0035.bit.b7
#define     CMCR_LF_SLOW_EN             _0x0035.bit.b6
#define     CMCR_LF_FAST_EN             _0x0035.bit.b5
#define     CMCR_LF_FAIL_EN             _0x0035.bit.b4
#define     CMCR_HF_GLITCH_EN           _0x0035.bit.b3
#define     CMCR_HF_SLOW_EN             _0x0035.bit.b2
#define     CMCR_HF_FAST_EN             _0x0035.bit.b1
#define     CMCR_HF_FAIL_EN             _0x0035.bit.b0

//==========================
//          LVDCR1
//==========================
#define     LVDCR1                      _0x0036.byte
#define     LVDCR1_LVDLP                _0x0036.bit.b7
#define     LVDCR1_LVDCFG               _0x0036.b6_4.b6_4
#define     LVDCR1_LVDRSTEN             _0x0036.bit.b3
#define     LVDCR1_LVDF                 _0x0036.bit.b2
#define     LVDCR1_LVDIEN               _0x0036.bit.b1
#define     LVDCR1_LVDEN                _0x0036.bit.b0

//==========================
//          PMCFG
//==========================
#define     PMCFG                       _0x0038.byte

//==========================
//          DMCFG
//==========================
#define     DMCFG                       _0x0039.byte
     
//==========================
//          MIFR
//==========================
#define     MIFR                        _0x003A.byte
#define     MIFR_IMF                    _0x003A.bit.b0
                                        
//==========================
//          MODEEXC = ADM_REQ
//==========================
#define     MODEEXC                     _0x003B.byte

//==========================
//          CACHECR             
//==========================
#define     CACHECR                     _0x003E.byte
#define     CACHECR_CLEAR               _0x003E.bit.b1
#define     CACHECR_ICACHEEN            _0x003E.bit.b0

//==========================
//          PSW
//==========================
#define     PSW                         _0x003F.byte
#define     PSW_JF                      _0x003F.bit.b7
#define     PSW_ZF                      _0x003F.bit.b6
#define     PSW_CF                      _0x003F.bit.b5
#define     PSW_HF                      _0x003F.bit.b4
#define     PSW_SF                      _0x003F.bit.b3
#define     PSW_VF                      _0x003F.bit.b2
#define     PSW_RBS                     _0x003F.bit.b1


//==========================
//          FCR
//==========================
#define     FCR                         _0x0040.byte
#define     FCR_AREA                    _0x0040.b7_5.b7_5
#define     FCR_FCMD                    _0x0040.b4_0.b4_0
//==========================
//          FSR
//==========================
#define     FSR                         _0x0041.byte
#define     FSR_BUSY                    _0x0041.bit.b7
#define     FSR_FERR                    _0x0041.b2_0.b2_0
                                        
//==========================
//          FADDR0
//==========================
#define     FADDR0                      _0x0042.byte
#define     FADDR0_FADDR                _0x0042.byte

//==========================
//          FADDR1
//==========================
#define     FADDR1                      _0x0043.byte
#define     FADDR1_FADDR                _0x0043.byte

//==========================     
//          FDATA0
//==========================
#define     FDATA0                      _0x0044.byte
#define     FDATA0_FDATA                _0x0044.byte

//==========================
//          EECR
//==========================
#define     EECR                        _0x0048.byte
#define     EECR_AREA                   _0x0048.b7_5.b7_5
#define     EECR_EECMD                  _0x0048.b4_0.b4_0
//==========================
//          EESR
//==========================
#define     EESR                        _0x0049.byte
#define     EESR_BUSY                   _0x0049.bit.b7
#define     EESR_EEERR                  _0x0049.b2_0.b2_0
                                        
//==========================
//          EEADDR0
//==========================
#define     EEADDR0                     _0x004A.byte
#define     EEADDR0_EEADDR              _0x004A.byte

//==========================            
//          EEADDR1
//==========================
#define     EEADDR1                     _0x004B.byte
#define     EEADDR1_EEADDR              _0x004B.byte

//==========================            
//          EEDATA0
//==========================
#define     EEDATA0                     _0x004C.byte
#define     EEDATA0_EEDATA              _0x004C.byte

//==========================
//        TMRA0CFG
//==========================                   
#define     TMRA0CFG                    _0x0050.byte
#define     TMRA0CFG_TCFG               _0x0050.b2_0.b2_0
                                        
//==========================
//        TMRA0SR
//==========================
#define     TMRA0SR                     _0x0051.byte
#define     TMRA0SR_TMROVI1             _0x0051.bit.b3
#define     TMRA0SR_TMROVI0             _0x0051.bit.b2
#define     TMRA0SR_EDGEI1              _0x0051.bit.b1
#define     TMRA0SR_EDGEI0              _0x0051.bit.b0
                                
//==========================        
//        TMRA0CR0                  
//==========================        
#define     TMRA0CR0                    _0x0052.byte
#define     TMRA0CR0_TMR0OVIE           _0x0052.bit.b7
#define     TMRA0CR0_EDGE0IE            _0x0052.bit.b6
#define     TMRA0CR0_OE                 _0x0052.bit.b4
#define     TMRA0CR0_EDGE               _0x0052.b3_1.b3_1
#define     TMRA0CR0_RUN                _0x0052.bit.b0
                                        
//==========================        
//        TMRA0CR1                  
//==========================        
#define     TMRA0CR1                    _0x0053.byte
#define     TMRA0CR1_TMR1OVIE           _0x0053.bit.b7
#define     TMRA0CR1_EDGE1IE            _0x0053.bit.b6
#define     TMRA0CR1_OE                 _0x0053.bit.b4
#define     TMRA0CR1_EDGE               _0x0053.b3_1.b3_1
#define     TMRA0CR1_RUN                _0x0053.bit.b0
                                
//==========================        
//        TMRA0MD0                  
//==========================        
#define     TMRA0MD0                    _0x0054.byte
#define     TMRA0MD0_TFF                _0x0054.bit.b7
#define     TMRA0MD0_DBE                _0x0054.bit.b6
#define     TMRA0MD0_TCK                _0x0054.b5_3.b5_3
#define     TMRA0MD0_TCM                _0x0054.b2_0.b2_0
                                    
//==========================        
//        TMRA0MD1                  
//==========================        
#define     TMRA0MD1                    _0x0055.byte
#define     TMRA0MD1_TFF                _0x0055.bit.b7
#define     TMRA0MD1_DBE                _0x0055.bit.b6
#define     TMRA0MD1_TCK                _0x0055.b5_3.b5_3
#define     TMRA0MD1_TCM                _0x0055.b2_0.b2_0
                                        
//==========================        
//        TMRA0CPL                  
//==========================        
#define     TMRA0CPL                    _0x0056.byte
#define     TMRA0CPL_FLTIF              _0x0056.bit.b7
#define     TMRA0CPL_FLTIE              _0x0056.bit.b6
#define     TMRA0CPL_FLTMD              _0x0056.b5_4.b5_4
#define     TMRA0CPL_CPLMD              _0x0056.b1_0.b1_0
                                        
//==========================        
//        TMRA0DTM                  
//==========================        
#define     TMRA0DTM                    _0x0057.byte
#define     TMRA0DTM_DTMPSC             _0x0057.b7_6.b7_6 
#define     TMRA0DTM_DTM                _0x0057.b5_0.b5_0  
                                        
//==========================        
//        TMRA0DR0                  
//==========================                  
#define     TMRA0DR0                    _0x0058.byte
#define     TMRA0DR0_TMRADR0            _0x0058.byte

//==========================            
//        TMRA0DR1
//==========================
#define     TMRA0DR1                    _0x0059.byte
#define     TMRA0DR1_TMRADR1            _0x0059.byte

//==========================            
//        TMRA0PWM0
//==========================
#define     TMRA0PWM0                   _0x005A.byte
#define     TMRA0PWM0_TMRAPWM0          _0x005A.byte

//==========================            
//        TMRA0PWM1
//==========================
#define     TMRA0PWM1                   _0x005B.byte
#define     TMRA0PWM1_TMRAPWM1          _0x005B.byte

//==========================        
//        TMRA0ADCDLY                   
//==========================        
#define     TMRA0ADCDLY                 _0x005C.byte
#define     TMRA0ADCDLY_TMRAADCDLY      _0x005C.b5_0.b5_0  
                             
//==========================
//        TMRA1CFG
//==========================                    
#define     TMRA1CFG                    _0x0060.byte
#define     TMRA1CFG_TCFG               _0x0060.b2_0.b2_0
                                        
//==========================
//        TMRA1SR
//==========================
#define     TMRA1SR                     _0x0061.byte
#define     TMRA1SR_TMROVI1             _0x0061.bit.b3
#define     TMRA1SR_TMROVI0             _0x0061.bit.b2
#define     TMRA1SR_EDGEI1              _0x0061.bit.b1
#define     TMRA1SR_EDGEI0              _0x0061.bit.b0
                                        
//==========================
//        TMRA1CR0
//==========================
#define     TMRA1CR0                    _0x0062.byte
#define     TMRA1CR0_TMR0OVIE           _0x0062.bit.b7
#define     TMRA1CR0_EDGE0IE            _0x0062.bit.b6
#define     TMRA1CR0_OE                 _0x0062.bit.b4
#define     TMRA1CR0_EDGE               _0x0062.b3_1.b3_1
#define     TMRA1CR0_RUN                _0x0062.bit.b0
                                    
//==========================
//        TMRA1CR1
//==========================
#define     TMRA1CR1                    _0x0063.byte
#define     TMRA1CR1_TMR1OVIE           _0x0063.bit.b7
#define     TMRA1CR1_EDGE1IE            _0x0063.bit.b6
#define     TMRA1CR1_OE                 _0x0063.bit.b4
#define     TMRA1CR1_EDGE               _0x0063.b3_1.b3_1
#define     TMRA1CR1_RUN                _0x0063.bit.b0
                                         
//==========================
//        TMRA1MD0
//==========================
#define     TMRA1MD0                    _0x0064.byte
#define     TMRA1MD0_TFF                _0x0064.bit.b7
#define     TMRA1MD0_DBE                _0x0064.bit.b6
#define     TMRA1MD0_TCK                _0x0064.b5_3.b5_3
#define     TMRA1MD0_TCM                _0x0064.b2_0.b2_0
                                        
//==========================         
//        TMRA1MD1                   
//==========================         
#define     TMRA1MD1                    _0x0065.byte
#define     TMRA1MD1_TFF                _0x0065.bit.b7
#define     TMRA1MD1_DBE                _0x0065.bit.b6
#define     TMRA1MD1_TCK                _0x0065.b5_3.b5_3
#define     TMRA1MD1_TCM                _0x0065.b2_0.b2_0
                                         
//==========================         
//        TMRA1CPL                   
//==========================         
#define     TMRA1CPL                    _0x0066.byte
#define     TMRA1CPL_FLTIF              _0x0066.bit.b7
#define     TMRA1CPL_FLTIE              _0x0066.bit.b6
#define     TMRA1CPL_FLTMD              _0x0066.b5_4.b5_4
#define     TMRA1CPL_CPLMD              _0x0066.b1_0.b1_0
                                 
//==========================
//        TMRA1DTM
//==========================
#define     TMRA1DTM                    _0x0067.byte 
#define     TMRA1DTM_DTMPSC             _0x0067.b7_6.b7_6 
#define     TMRA1DTM_DTM                _0x0067.b5_0.b5_0  
                                        
//==========================
//        TMRA1DR0
//==========================
#define     TMRA1DR0                    _0x0068.byte
#define     TMRA1DR0_TMRADR0            _0x0068.byte

//==========================            
//        TMRA1DR1
//==========================
#define     TMRA1DR1                    _0x0069.byte
#define     TMRA1DR1_TMRADR1            _0x0069.byte

//==========================
//        TMRA1PWM0
//==========================
#define     TMRA1PWM0                   _0x006A.byte
#define     TMRA1PWM0_TMRAPWM0          _0x006A.byte
//==========================
//        TMRA1PWM1
//==========================
#define     TMRA1PWM1                   _0x006B.byte
#define     TMRA1PWM1_TMRAPWM1          _0x006B.byte
                                        
//==========================        
//        TMRA1ADCDLY                   
//==========================        
#define     TMRA1ADCDLY                 _0x006C.byte
#define     TMRA1ADCDLY_TMRAADCDLY      _0x006C.b5_0.b5_0  

//==========================
//        TMRA2CFG
//==========================                   
#define     TMRA2CFG                    _0x0070.byte
#define     TMRA2CFG_TCFG               _0x0070.b2_0.b2_0

//==========================
//        TMRA2SR
//==========================
#define     TMRA2SR                     _0x0071.byte
#define     TMRA2SR_TMROVI1             _0x0071.bit.b3
#define     TMRA2SR_TMROVI0             _0x0071.bit.b2
#define     TMRA2SR_EDGEI1              _0x0071.bit.b1
#define     TMRA2SR_EDGEI0              _0x0071.bit.b0
                                
//==========================
//        TMRA2CR0
//==========================
#define     TMRA2CR0                    _0x0072.byte
#define     TMRA2CR0_TMR0OVIE           _0x0072.bit.b7
#define     TMRA2CR0_EDGE0IE            _0x0072.bit.b6
#define     TMRA2CR0_OE                 _0x0072.bit.b4
#define     TMRA2CR0_EDGE               _0x0072.b3_1.b3_1
#define     TMRA2CR0_RUN                _0x0072.bit.b0
                                         
//==========================
//        TMRA2CR1
//==========================
#define     TMRA2CR1                    _0x0073.byte
#define     TMRA2CR1_TMR1OVIE           _0x0073.bit.b7
#define     TMRA2CR1_EDGE1IE            _0x0073.bit.b6
#define     TMRA2CR1_OE                 _0x0073.bit.b4
#define     TMRA2CR1_EDGE               _0x0073.b3_1.b3_1
#define     TMRA2CR1_RUN                _0x0073.bit.b0
                                          
//==========================
//        TMRA2MD0
//==========================
#define     TMRA2MD0                    _0x0074.byte
#define     TMRA2MD0_TFF                _0x0074.bit.b7
#define     TMRA2MD0_DBE                _0x0074.bit.b6
#define     TMRA2MD0_TCK                _0x0074.b5_3.b5_3
#define     TMRA2MD0_TCM                _0x0074.b2_0.b2_0
                                        
//==========================
//        TMRA2MD1
//==========================
#define     TMRA2MD1                    _0x0075.byte
#define     TMRA2MD1_TFF                _0x0075.bit.b7
#define     TMRA2MD1_DBE                _0x0075.bit.b6
#define     TMRA2MD1_TCK                _0x0075.b5_3.b5_3
#define     TMRA2MD1_TCM                _0x0075.b2_0.b2_0
         
//==========================
//        TMRA2CPL
//==========================
#define     TMRA2CPL                    _0x0076.byte
#define     TMRA2CPL_FLTIF              _0x0076.bit.b7
#define     TMRA2CPL_FLTIE              _0x0076.bit.b6
#define     TMRA2CPL_FLTMD              _0x0076.b5_4.b5_4
#define     TMRA2CPL_CPLMD              _0x0076.b1_0.b1_0
                              
//==========================
//        TMRA2DTM
//==========================
#define     TMRA2DTM                    _0x0077.byte
#define     TMRA2DTM_DTMPSC             _0x0077.b7_6.b7_6 
#define     TMRA2DTM_DTM                _0x0077.b5_0.b5_0  
                              
//==========================
//        TMRA2DR0
//==========================                     
#define     TMRA2DR0                    _0x0078.byte
#define     TMRA2DR0_TMRADR0            _0x0078.byte

//==========================
//        TMRA2DR1
//==========================
#define     TMRA2DR1                    _0x0079.byte
#define     TMRA2DR1_TMRADR1            _0x0079.byte

//==========================            
//        TMRA2PWM0
//==========================
#define     TMRA2PWM0                   _0x007A.byte
#define     TMRA2PWM0_TMRAPWM0          _0x007A.byte

//==========================            
//        TMRA2PWM1
//==========================
#define     TMRA2PWM1                   _0x007B.byte
#define     TMRA2PWM1_TMRAPWM1          _0x007B.byte

//==========================        
//        TMRA2ADCDLY                   
//==========================        
#define     TMRA2ADCDLY                 _0x007C.byte
#define     TMRA2ADCDLY_TMRAADCDLY      _0x007C.b5_0.b5_0  

//==========================
//          TA0CR
//==========================
#define     TA0CR                       _0x0080.byte
#define     TA0CR_TAOVE                 _0x0080.bit.b7
#define     TA0CR_TATFF                 _0x0080.bit.b6
#define     TA0CR_TANC                  _0x0080.b5_4.b5_4
#define     TA0CR_TAEIN                 _0x0080.bit.b2
#define     TA0CR_TACAP                 _0x0080.bit.b1
#define     TA0CR_TAMPPG                _0x0080.bit.b1
#define     TA0CR_TAS                   _0x0080.bit.b0
//==========================
//          TA0MOD
//==========================
#define     TA0MOD                      _0x0081.byte
#define     TA0MOD_TADBE                _0x0081.bit.b7
#define     TA0MOD_TATED                _0x0081.bit.b6
#define     TA0MOD_TAMCAP               _0x0081.bit.b5
#define     TA0MOD_TAMETT               _0x0081.bit.b5
#define     TA0MOD_TACK                 _0x0081.b4_3.b4_3
#define     TA0MOD_TAM                  _0x0081.b2_0.b2_0
                                           
//==========================
//          TA0SR
//==========================
#define     TA0SR                       _0x0082.byte
#define     TA0SR_TAOVF                 _0x0082.bit.b7
#define     TA0SR_TACPFA                _0x0082.bit.b1
#define     TA0SR_TACPFB                _0x0082.bit.b0
                                        
//==========================                                    
//          TA0DRA
//==========================
#define     TA0DRA                      _0x0084.word
#define     TA0DRAL                     _0x0084.byte[0]
#define     TA0DRA_TADRAL               _0x0084.byte[0]
#define     TA0DRAH                     _0x0084.byte[1]
#define     TA0DRA_TADRAH               _0x0084.byte[1]

//==========================
//          TA0DRB
//==========================
#define     TA0DRB                      _0x0086.word
#define     TA0DRBL                     _0x0086.byte[0]
#define     TA0DRB_TADRBL               _0x0086.byte[0]
#define     TA0DRBH                     _0x0086.byte[1]
#define     TA0DRB_TADRBH               _0x0086.byte[1]
                                    
//==========================
//          TA1CR
//==========================
#define     TA1CR                       _0x0088.byte
#define     TA1CR_TAOVE                 _0x0088.bit.b7
#define     TA1CR_TATFF                 _0x0088.bit.b6
#define     TA1CR_TANC                  _0x0088.b5_4.b5_4
#define     TA1CR_TAEIN                 _0x0088.bit.b2
#define     TA1CR_TACAP                 _0x0088.bit.b1
#define     TA1CR_TAMPPG                _0x0088.bit.b1
#define     TA1CR_TAS                   _0x0088.bit.b0
//==========================
//          TA1MOD
//==========================
#define     TA1MOD                      _0x0089.byte
#define     TA1MOD_TADBE                _0x0089.bit.b7
#define     TA1MOD_TATED                _0x0089.bit.b6
#define     TA1MOD_TAMCAP               _0x0089.bit.b5
#define     TA1MOD_TAMETT               _0x0089.bit.b5
#define     TA1MOD_TACK                 _0x0089.b4_3.b4_3
#define     TA1MOD_TAM                  _0x0089.b2_0.b2_0
                                           
//==========================
//          TA1SR
//==========================
#define     TA1SR                       _0x008A.byte
#define     TA1SR_TAOVF                 _0x008A.bit.b7
#define     TA1SR_TACPFA                _0x008A.bit.b1
#define     TA1SR_TACPFB                _0x008A.bit.b0
                                        
//==========================                                    
//          TA1DRA
//==========================
#define     TA1DRA                      _0x008C.word
#define     TA1DRAL                     _0x008C.byte[0]
#define     TA1DRA_TADRAL               _0x008C.byte[0]
#define     TA1DRAH                     _0x008C.byte[1]
#define     TA1DRA_TADRAH               _0x008C.byte[1]

//==========================
//          TA1DRB
//==========================
#define     TA1DRB                      _0x008E.word
#define     TA1DRBL                     _0x008E.byte[0]
#define     TA1DRB_TADRBL               _0x008E.byte[0]
#define     TA1DRBH                     _0x008E.byte[1]
#define     TA1DRB_TADRBH               _0x008E.byte[1]
                                    
//==========================
//          TA2CR
//==========================
#define     TA2CR                       _0x0090.byte
#define     TA2CR_TAOVE                 _0x0090.bit.b7
#define     TA2CR_TATFF                 _0x0090.bit.b6
#define     TA2CR_TANC                  _0x0090.b5_4.b5_4
#define     TA2CR_TAEIN                 _0x0090.bit.b2
#define     TA2CR_TACAP                 _0x0090.bit.b1
#define     TA2CR_TAMPPG                _0x0090.bit.b1
#define     TA2CR_TAS                   _0x0090.bit.b0
//==========================
//          TA2MOD
//==========================
#define     TA2MOD                      _0x0091.byte
#define     TA2MOD_TADBE                _0x0091.bit.b7
#define     TA2MOD_TATED                _0x0091.bit.b6
#define     TA2MOD_TAMCAP               _0x0091.bit.b5
#define     TA2MOD_TAMETT               _0x0091.bit.b5
#define     TA2MOD_TACK                 _0x0091.b4_3.b4_3
#define     TA2MOD_TAM                  _0x0091.b2_0.b2_0
                                           
//==========================
//          TA2SR
//==========================
#define     TA2SR                       _0x0092.byte
#define     TA2SR_TAOVF                 _0x0092.bit.b7
#define     TA2SR_TACPFA                _0x0092.bit.b1
#define     TA2SR_TACPFB                _0x0092.bit.b0
                                        
//==========================                                    
//          TA2DRA
//==========================
#define     TA2DRA                      _0x0094.word
#define     TA2DRAL                     _0x0094.byte[0]
#define     TA2DRA_TADRAL               _0x0094.byte[0]
#define     TA2DRAH                     _0x0094.byte[1]
#define     TA2DRA_TADRAH               _0x0094.byte[1]

//==========================
//          TA2DRB
//==========================
#define     TA2DRB                      _0x0096.word
#define     TA2DRBL                     _0x0096.byte[0]
#define     TA2DRB_TADRBL               _0x0096.byte[0]
#define     TA2DRBH                     _0x0096.byte[1]
#define     TA2DRB_TADRBH               _0x0096.byte[1]
                                                                           

//==========================
//          UART0CR1
//==========================
#define     UART0CR1                    _0x00A0.byte
#define     UART0CR1_TXE                _0x00A0.bit.b7
#define     UART0CR1_RXE                _0x00A0.bit.b6
#define     UART0CR1_STOPBT             _0x00A0.bit.b5
#define     UART0CR1_EVEN               _0x00A0.bit.b4
#define     UART0CR1_PE                 _0x00A0.bit.b3
#define     UART0CR1_IRDASEL            _0x00A0.bit.b2
#define     UART0CR1_BRG                _0x00A0.bit.b1

//==========================
//          UART0CR2
//==========================
#define     UART0CR2                    _0x00A1.byte
#define     UART0CR2_DV                 _0x00A1.b7_6.b7_6
#define     UART0CR2_RTSEL              _0x00A1.b5_3.b5_3
#define     UART0CR2_RXDNC              _0x00A1.b2_1.b2_1
#define     UART0CR2_STOPBR             _0x00A1.bit.b0
                                        
//==========================
//          UART0DR
//==========================
#define     UART0DR                     _0x00A2.byte
#define     UART0DR_DR7                 _0x00A2.bit.b7
#define     UART0DR_DR6                 _0x00A2.bit.b6
#define     UART0DR_DR5                 _0x00A2.bit.b5
#define     UART0DR_DR4                 _0x00A2.bit.b4
#define     UART0DR_DR3                 _0x00A2.bit.b3
#define     UART0DR_DR2                 _0x00A2.bit.b2
#define     UART0DR_DR1                 _0x00A2.bit.b1
#define     UART0DR_DR0                 _0x00A2.bit.b0

//==========================
//          UART0SR
//==========================
#define     UART0SR                     _0x00A3.byte
#define     UART0SR_PERR                _0x00A3.bit.b7
#define     UART0SR_FERR                _0x00A3.bit.b6
#define     UART0SR_OERR                _0x00A3.bit.b5
#define     UART0SR_RBSY                _0x00A3.bit.b3
#define     UART0SR_RBFL                _0x00A3.bit.b2
#define     UART0SR_TBSY                _0x00A3.bit.b1
#define     UART0SR_TBFL                _0x00A3.bit.b0
                             
//==========================
//          RD0BUF
//==========================
#define     RD0BUF                      _0x00A4.byte
#define     RD0BUF_DR7                  _0x00A4.bit.b7
#define     RD0BUF_DR6                  _0x00A4.bit.b6
#define     RD0BUF_DR5                  _0x00A4.bit.b5
#define     RD0BUF_DR4                  _0x00A4.bit.b4
#define     RD0BUF_DR3                  _0x00A4.bit.b3
#define     RD0BUF_DR2                  _0x00A4.bit.b2
#define     RD0BUF_DR1                  _0x00A4.bit.b1
#define     RD0BUF_DR0                  _0x00A4.bit.b0

//==========================
//          TD0BUF
//==========================
#define     TD0BUF                      _0x00A5.byte
#define     TD0BUF_DR7                  _0x00A5.bit.b7
#define     TD0BUF_DR6                  _0x00A5.bit.b6
#define     TD0BUF_DR5                  _0x00A5.bit.b5
#define     TD0BUF_DR4                  _0x00A5.bit.b4
#define     TD0BUF_DR3                  _0x00A5.bit.b3
#define     TD0BUF_DR2                  _0x00A5.bit.b2
#define     TD0BUF_DR1                  _0x00A5.bit.b1
#define     TD0BUF_DR0                  _0x00A5.bit.b0

//==========================
//          UART1CR1
//==========================
#define     UART1CR1                    _0x00A6.byte
#define     UART1CR1_TXE                _0x00A6.bit.b7
#define     UART1CR1_RXE                _0x00A6.bit.b6
#define     UART1CR1_STOPBT             _0x00A6.bit.b5
#define     UART1CR1_EVEN               _0x00A6.bit.b4
#define     UART1CR1_PE                 _0x00A6.bit.b3
#define     UART1CR1_IRDASEL            _0x00A6.bit.b2
#define     UART1CR1_BRG                _0x00A6.bit.b1
                                        
//==========================
//          UART1CR2
//==========================
#define     UART1CR2                    _0x00A7.byte
#define     UART1CR2_DV                 _0x00A7.b7_6.b7_6
#define     UART1CR2_RTSEL              _0x00A7.b5_3.b5_3
#define     UART1CR2_RXDNC              _0x00A7.b2_1.b2_1
#define     UART1CR2_STOPBR             _0x00A7.bit.b0
                                        
//==========================
//          UART1DR
//==========================
#define     UART1DR                     _0x00A8.byte
#define     UART1DR_DR7                 _0x00A8.bit.b7
#define     UART1DR_DR6                 _0x00A8.bit.b6
#define     UART1DR_DR5                 _0x00A8.bit.b5
#define     UART1DR_DR4                 _0x00A8.bit.b4
#define     UART1DR_DR3                 _0x00A8.bit.b3
#define     UART1DR_DR2                 _0x00A8.bit.b2
#define     UART1DR_DR1                 _0x00A8.bit.b1
#define     UART1DR_DR0                 _0x00A8.bit.b0
                                        
//==========================
//          UART1SR
//==========================
#define     UART1SR                     _0x00A9.byte
#define     UART1SR_PERR                _0x00A9.bit.b7
#define     UART1SR_FERR                _0x00A9.bit.b6
#define     UART1SR_OERR                _0x00A9.bit.b5
#define     UART1SR_RBSY                _0x00A9.bit.b3
#define     UART1SR_RBFL                _0x00A9.bit.b2
#define     UART1SR_TBSY                _0x00A9.bit.b1
#define     UART1SR_TBFL                _0x00A9.bit.b0

//==========================
//          RD1BUF
//==========================
#define     RD1BUF                      _0x00AA.byte
#define     RD1BUF_DR7                  _0x00AA.bit.b7
#define     RD1BUF_DR6                  _0x00AA.bit.b6
#define     RD1BUF_DR5                  _0x00AA.bit.b5
#define     RD1BUF_DR4                  _0x00AA.bit.b4
#define     RD1BUF_DR3                  _0x00AA.bit.b3
#define     RD1BUF_DR2                  _0x00AA.bit.b2
#define     RD1BUF_DR1                  _0x00AA.bit.b1
#define     RD1BUF_DR0                  _0x00AA.bit.b0

//==========================
//          TD1BUF
//==========================
#define     TD1BUF                      _0x00AB.byte
#define     TD1BUF_DR7                  _0x00AB.bit.b7
#define     TD1BUF_DR6                  _0x00AB.bit.b6
#define     TD1BUF_DR5                  _0x00AB.bit.b5
#define     TD1BUF_DR4                  _0x00AB.bit.b4
#define     TD1BUF_DR3                  _0x00AB.bit.b3
#define     TD1BUF_DR2                  _0x00AB.bit.b2
#define     TD1BUF_DR1                  _0x00AB.bit.b1
#define     TD1BUF_DR0                  _0x00AB.bit.b0
//==========================
//          UART2CR1
//==========================
#define     UART2CR1                    _0x00AC.byte
#define     UART2CR1_TXE                _0x00AC.bit.b7
#define     UART2CR1_RXE                _0x00AC.bit.b6
#define     UART2CR1_STOPBT             _0x00AC.bit.b5
#define     UART2CR1_EVEN               _0x00AC.bit.b4
#define     UART2CR1_PE                 _0x00AC.bit.b3
#define     UART2CR1_IRDASEL            _0x00AC.bit.b2
#define     UART2CR1_BRG                _0x00AC.bit.b1

//==========================
//          UART2CR2
//==========================
#define     UART2CR2                    _0x00AD.byte
#define     UART2CR2_DV                 _0x00AD.b7_6.b7_6
#define     UART2CR2_RTSEL              _0x00AD.b5_3.b5_3
#define     UART2CR2_RXDNC              _0x00AD.b2_1.b2_1
#define     UART2CR2_STOPBR             _0x00AD.bit.b0
                                        
//==========================
//          UART2DR
//==========================
#define     UART2DR                     _0x00AE.byte
#define     UART2DR_DR7                 _0x00AE.bit.b7
#define     UART2DR_DR6                 _0x00AE.bit.b6
#define     UART2DR_DR5                 _0x00AE.bit.b5
#define     UART2DR_DR4                 _0x00AE.bit.b4
#define     UART2DR_DR3                 _0x00AE.bit.b3
#define     UART2DR_DR2                 _0x00AE.bit.b2
#define     UART2DR_DR1                 _0x00AE.bit.b1
#define     UART2DR_DR0                 _0x00AE.bit.b0

//==========================
//          UART2SR
//==========================
#define     UART2SR                     _0x00AF.byte
#define     UART2SR_PERR                _0x00AF.bit.b7
#define     UART2SR_FERR                _0x00AF.bit.b6
#define     UART2SR_OERR                _0x00AF.bit.b5
#define     UART2SR_RBSY                _0x00AF.bit.b3
#define     UART2SR_RBFL                _0x00AF.bit.b2
#define     UART2SR_TBSY                _0x00AF.bit.b1
#define     UART2SR_TBFL                _0x00AF.bit.b0

//==========================
//          RD2BUF
//==========================
#define     RD2BUF                      _0x00B0.byte
#define     RD2BUF_DR7                  _0x00B0.bit.b7
#define     RD2BUF_DR6                  _0x00B0.bit.b6
#define     RD2BUF_DR5                  _0x00B0.bit.b5
#define     RD2BUF_DR4                  _0x00B0.bit.b4
#define     RD2BUF_DR3                  _0x00B0.bit.b3
#define     RD2BUF_DR2                  _0x00B0.bit.b2
#define     RD2BUF_DR1                  _0x00B0.bit.b1
#define     RD2BUF_DR0                  _0x00B0.bit.b0

//==========================
//          TD2BUF
//==========================
#define     TD2BUF                      _0x00B1.byte
#define     TD2BUF_DR7                  _0x00B1.bit.b7
#define     TD2BUF_DR6                  _0x00B1.bit.b6
#define     TD2BUF_DR5                  _0x00B1.bit.b5
#define     TD2BUF_DR4                  _0x00B1.bit.b4
#define     TD2BUF_DR3                  _0x00B1.bit.b3
#define     TD2BUF_DR2                  _0x00B1.bit.b2
#define     TD2BUF_DR1                  _0x00B1.bit.b1
#define     TD2BUF_DR0                  _0x00B1.bit.b0

//==========================
//          SBI0CR1
//==========================
#define     SBI0CR1                     _0x00B8.byte
#define     SBI0CR1_BC                  _0x00B8.b7_5.b7_5
#define     SBI0CR1_ACK                 _0x00B8.bit.b4
#define     SBI0CR1_NOACK               _0x00B8.bit.b3
#define     SBI0CR1_SCK                 _0x00B8.b2_0.b2_0

//==========================
//          SBI0CR2
//==========================
#define     SBI0CR2                     _0x00B9.byte
#define     SBI0CR2_MST                 _0x00B9.bit.b7
#define     SBI0CR2_TRX                 _0x00B9.bit.b6
#define     SBI0CR2_BB                  _0x00B9.bit.b5
#define     SBI0CR2_PIN                 _0x00B9.bit.b4
#define     SBI0CR2_SBIM                _0x00B9.bit.b3
#define     SBI0CR2_SWRST               _0x00B9.b1_0.b1_0

//==========================
//          SBI0SR
//==========================
#define     SBI0SR                      _0x00BA.byte
#define     SBI0SR_MST                  _0x00BA.bit.b7
#define     SBI0SR_TRX                  _0x00BA.bit.b6
#define     SBI0SR_BB                   _0x00BA.bit.b5
#define     SBI0SR_PIN                  _0x00BA.bit.b4
#define     SBI0SR_AL                   _0x00BA.bit.b3
#define     SBI0SR_AAS                  _0x00BA.bit.b2
#define     SBI0SR_AD0                  _0x00BA.bit.b1
#define     SBI0SR_LRB                  _0x00BA.bit.b0
                                        
//==========================
//          I2C0AR
//==========================
#define     I2C0AR                      _0x00BB.byte
#define     I2C0AR_SA                   _0x00BB.b7_1.b7_1
#define     I2C0AR_ALS                  _0x00BB.bit.b0
                                        
//==========================
//          SBI0DBR
//==========================
#define     SBI0DBR                     _0x00BC.byte
                                        
//==========================
//          SBI1CR1
//==========================
#define     SBI1CR1                     _0x00BD.byte
#define     SBI1CR1_BC                  _0x00BD.b7_5.b7_5
#define     SBI1CR1_ACK                 _0x00BD.bit.b4
#define     SBI1CR1_NOACK               _0x00BD.bit.b3
#define     SBI1CR1_SCK                 _0x00BD.b2_0.b2_0

//==========================
//          SBI1CR2
//==========================
#define     SBI1CR2                     _0x00BE.byte
#define     SBI1CR2_MST                 _0x00BE.bit.b7
#define     SBI1CR2_TRX                 _0x00BE.bit.b6
#define     SBI1CR2_BB                  _0x00BE.bit.b5
#define     SBI1CR2_PIN                 _0x00BE.bit.b4
#define     SBI1CR2_SBIM                _0x00BE.bit.b3
#define     SBI1CR2_SWRST               _0x00BE.b1_0.b1_0

//==========================
//          SBI1SR
//==========================
#define     SBI1SR                      _0x00BF.byte
#define     SBI1SR_MST                  _0x00BF.bit.b7
#define     SBI1SR_TRX                  _0x00BF.bit.b6
#define     SBI1SR_BB                   _0x00BF.bit.b5
#define     SBI1SR_PIN                  _0x00BF.bit.b4
#define     SBI1SR_AL                   _0x00BF.bit.b3
#define     SBI1SR_AAS                  _0x00BF.bit.b2
#define     SBI1SR_AD0                  _0x00BF.bit.b1
#define     SBI1SR_LRB                  _0x00BF.bit.b0
                                        
//==========================
//          I2C1AR
//==========================
#define     I2C1AR                      _0x00C0.byte
#define     I2C1AR_SA                   _0x00C0.b7_1.b7_1
#define     I2C1AR_ALS                  _0x00C0.bit.b0
                                        
//==========================
//          SBI1DBR
//==========================
#define     SBI1DBR                     _0x00C1.byte

//==========================
//          P0DO
//==========================
#define     P0DO                        _0x00E0.byte
#define     P0DO_P7                     _0x00E0.bit.b7
#define     P0DO_P6                     _0x00E0.bit.b6
#define     P0DO_P5                     _0x00E0.bit.b5
#define     P0DO_P4                     _0x00E0.bit.b4
#define     P0DO_P3                     _0x00E0.bit.b3
#define     P0DO_P2                     _0x00E0.bit.b2
#define     P0DO_P1                     _0x00E0.bit.b1
#define     P0DO_P0                     _0x00E0.bit.b0
                                        
//==========================
//          P1DO
//==========================
#define     P1DO                        _0x00E1.byte
#define     P1DO_P7                     _0x00E1.bit.b7
#define     P1DO_P6                     _0x00E1.bit.b6
#define     P1DO_P5                     _0x00E1.bit.b5
#define     P1DO_P4                     _0x00E1.bit.b4
#define     P1DO_P3                     _0x00E1.bit.b3
#define     P1DO_P2                     _0x00E1.bit.b2
#define     P1DO_P1                     _0x00E1.bit.b1
#define     P1DO_P0                     _0x00E1.bit.b0
                                        
//==========================
//          P2DO
//==========================
#define     P2DO                        _0x00E2.byte
#define     P2DO_P6                     _0x00E2.bit.b6
#define     P2DO_P5                     _0x00E2.bit.b5
#define     P2DO_P4                     _0x00E2.bit.b4
#define     P2DO_P3                     _0x00E2.bit.b3
#define     P2DO_P2                     _0x00E2.bit.b2
#define     P2DO_P1                     _0x00E2.bit.b1
#define     P2DO_P0                     _0x00E2.bit.b0
                                        
//==========================
//          P3DO
//==========================
#define     P3DO                        _0x00E3.byte
#define     P3DO_P7                     _0x00E3.bit.b7
#define     P3DO_P6                     _0x00E3.bit.b6
#define     P3DO_P5                     _0x00E3.bit.b5
#define     P3DO_P4                     _0x00E3.bit.b4
            
//==========================
//          P4DO
//==========================
#define     P4DO                        _0x00E4.byte
#define     P4DO_P7                     _0x00E4.bit.b7
#define     P4DO_P6                     _0x00E4.bit.b6
#define     P4DO_P5                     _0x00E4.bit.b5
#define     P4DO_P4                     _0x00E4.bit.b4
#define     P4DO_P3                     _0x00E4.bit.b3
#define     P4DO_P2                     _0x00E4.bit.b2

//==========================
//          P5DO
//==========================
#define     P5DO                        _0x00E5.byte
#define     P5DO_P7                     _0x00E5.bit.b7
#define     P5DO_P6                     _0x00E5.bit.b6
#define     P5DO_P5                     _0x00E5.bit.b5
#define     P5DO_P4                     _0x00E5.bit.b4
#define     P5DO_P3                     _0x00E5.bit.b3
#define     P5DO_P2                     _0x00E5.bit.b2
#define     P5DO_P1                     _0x00E5.bit.b1
#define     P5DO_P0                     _0x00E5.bit.b0
                                        
//==========================
//          P6DO
//==========================
#define     P6DO                        _0x00E6.byte
#define     P6DO_P6                     _0x00E6.bit.b6
#define     P6DO_P5                     _0x00E6.bit.b5
#define     P6DO_P4                     _0x00E6.bit.b4
#define     P6DO_P3                     _0x00E6.bit.b3
#define     P6DO_P2                     _0x00E6.bit.b2
#define     P6DO_P1                     _0x00E6.bit.b1
#define     P6DO_P0                     _0x00E6.bit.b0
                                        
//==========================
//          P7DO
//==========================
#define     P7DO                        _0x00E7.byte
#define     P7DO_P5                     _0x00E7.bit.b5
#define     P7DO_P4                     _0x00E7.bit.b4
#define     P7DO_P2                     _0x00E7.bit.b2
#define     P7DO_P1                     _0x00E7.bit.b1
#define     P7DO_P0                     _0x00E7.bit.b0


//==========================
//          P0DI
//==========================
#define     P0DI                        _0x00F0.byte
#define     P0DI_P7                     _0x00F0.bit.b7
#define     P0DI_P6                     _0x00F0.bit.b6
#define     P0DI_P5                     _0x00F0.bit.b5
#define     P0DI_P4                     _0x00F0.bit.b4
#define     P0DI_P3                     _0x00F0.bit.b3
#define     P0DI_P2                     _0x00F0.bit.b2
#define     P0DI_P1                     _0x00F0.bit.b1
#define     P0DI_P0                     _0x00F0.bit.b0

//==========================
//          P1DI
//==========================
#define     P1DI                        _0x00F1.byte
#define     P1DI_P7                     _0x00F1.bit.b7
#define     P1DI_P6                     _0x00F1.bit.b6
#define     P1DI_P5                     _0x00F1.bit.b5
#define     P1DI_P4                     _0x00F1.bit.b4
#define     P1DI_P3                     _0x00F1.bit.b3
#define     P1DI_P2                     _0x00F1.bit.b2
#define     P1DI_P1                     _0x00F1.bit.b1
#define     P1DI_P0                     _0x00F1.bit.b0

//==========================
//          P2DI
//==========================
#define     P2DI                        _0x00F2.byte
#define     P2DI_P6                     _0x00F2.bit.b6
#define     P2DI_P5                     _0x00F2.bit.b5
#define     P2DI_P4                     _0x00F2.bit.b4
#define     P2DI_P3                     _0x00F2.bit.b3
#define     P2DI_P2                     _0x00F2.bit.b2
#define     P2DI_P1                     _0x00F2.bit.b1
#define     P2DI_P0                     _0x00F2.bit.b0

//==========================
//          P3DI
//==========================
#define     P3DI                        _0x00F3.byte
#define     P3DI_P7                     _0x00F3.bit.b7
#define     P3DI_P6                     _0x00F3.bit.b6
#define     P3DI_P5                     _0x00F3.bit.b5
#define     P3DI_P4                     _0x00F3.bit.b4

//==========================
//          P4DI
//==========================
#define     P4DI                        _0x00F4.byte
#define     P4DI_P7                     _0x00F4.bit.b7
#define     P4DI_P6                     _0x00F4.bit.b6
#define     P4DI_P5                     _0x00F4.bit.b5
#define     P4DI_P4                     _0x00F4.bit.b4
#define     P4DI_P3                     _0x00F4.bit.b3
#define     P4DI_P2                     _0x00F4.bit.b2
                                        
//==========================
//          P5DI
//==========================
#define     P5DI                        _0x00F5.byte
#define     P5DI_P7                     _0x00F5.bit.b7
#define     P5DI_P6                     _0x00F5.bit.b6
#define     P5DI_P5                     _0x00F5.bit.b5
#define     P5DI_P4                     _0x00F5.bit.b4
#define     P5DI_P3                     _0x00F5.bit.b3
#define     P5DI_P2                     _0x00F5.bit.b2
#define     P5DI_P1                     _0x00F5.bit.b1
#define     P5DI_P0                     _0x00F5.bit.b0

//==========================
//          P6DI
//==========================
#define     P6DI                        _0x00F6.byte
#define     P6DI_P6                     _0x00F6.bit.b6
#define     P6DI_P5                     _0x00F6.bit.b5
#define     P6DI_P4                     _0x00F6.bit.b4
#define     P6DI_P3                     _0x00F6.bit.b3
#define     P6DI_P2                     _0x00F6.bit.b2
#define     P6DI_P1                     _0x00F6.bit.b1
#define     P6DI_P0                     _0x00F6.bit.b0
//==========================
//          P7DI
//==========================
#define     P7DI                        _0x00F7.byte
#define     P7DI_P5                     _0x00F7.bit.b5
#define     P7DI_P4                     _0x00F7.bit.b4
#define     P7DI_P2                     _0x00F7.bit.b2
#define     P7DI_P1                     _0x00F7.bit.b1
#define     P7DI_P0                     _0x00F7.bit.b0

//==========================
//          P0OE
//==========================
#define     P0OE                        _0x0100.byte
#define     P0OE_P7                     _0x0100.bit.b7
#define     P0OE_P6                     _0x0100.bit.b6
#define     P0OE_P5                     _0x0100.bit.b5
#define     P0OE_P4                     _0x0100.bit.b4
#define     P0OE_P3                     _0x0100.bit.b3
#define     P0OE_P2                     _0x0100.bit.b2
#define     P0OE_P1                     _0x0100.bit.b1
#define     P0OE_P0                     _0x0100.bit.b0
                                         
//==========================
//          P1OE
//==========================
#define     P1OE                        _0x0101.byte
#define     P1OE_P7                     _0x0101.bit.b7
#define     P1OE_P6                     _0x0101.bit.b6
#define     P1OE_P5                     _0x0101.bit.b5
#define     P1OE_P4                     _0x0101.bit.b4
#define     P1OE_P3                     _0x0101.bit.b3
#define     P1OE_P2                     _0x0101.bit.b2
#define     P1OE_P1                     _0x0101.bit.b1
#define     P1OE_P0                     _0x0101.bit.b0
                                         
//==========================
//          P2OE
//==========================
#define     P2OE                        _0x0102.byte
#define     P2OE_P6                     _0x0102.bit.b6
#define     P2OE_P5                     _0x0102.bit.b5
#define     P2OE_P4                     _0x0102.bit.b4
#define     P2OE_P3                     _0x0102.bit.b3
#define     P2OE_P2                     _0x0102.bit.b2
#define     P2OE_P1                     _0x0102.bit.b1
#define     P2OE_P0                     _0x0102.bit.b0

//==========================
//          P3OE
//==========================
#define     P3OE                        _0x0103.byte
#define     P3OE_P7                     _0x0103.bit.b7
#define     P3OE_P6                     _0x0103.bit.b6
#define     P3OE_P5                     _0x0103.bit.b5
#define     P3OE_P4                     _0x0103.bit.b4
                                        
//==========================
//          P4OE
//==========================
#define     P4OE                        _0x0104.byte
#define     P4OE_P7                     _0x0104.bit.b7
#define     P4OE_P6                     _0x0104.bit.b6
#define     P4OE_P5                     _0x0104.bit.b5
#define     P4OE_P4                     _0x0104.bit.b4
#define     P4OE_P3                     _0x0104.bit.b3
#define     P4OE_P2                     _0x0104.bit.b2

//==========================
//          P5OE
//==========================
#define     P5OE                        _0x0105.byte
#define     P5OE_P7                     _0x0105.bit.b7
#define     P5OE_P6                     _0x0105.bit.b6
#define     P5OE_P5                     _0x0105.bit.b5
#define     P5OE_P4                     _0x0105.bit.b4
#define     P5OE_P3                     _0x0105.bit.b3
#define     P5OE_P2                     _0x0105.bit.b2
#define     P5OE_P1                     _0x0105.bit.b1
#define     P5OE_P0                     _0x0105.bit.b0
                                        
//==========================
//          P6OE
//==========================
#define     P6OE                        _0x0106.byte
#define     P6OE_P6                     _0x0106.bit.b6
#define     P6OE_P5                     _0x0106.bit.b5
#define     P6OE_P4                     _0x0106.bit.b4
#define     P6OE_P3                     _0x0106.bit.b3
#define     P6OE_P2                     _0x0106.bit.b2
#define     P6OE_P1                     _0x0106.bit.b1
#define     P6OE_P0                     _0x0106.bit.b0

//==========================
//          P7OE
//==========================
#define     P7OE                        _0x0107.byte
#define     P7OE_P5                     _0x0107.bit.b5
#define     P7OE_P4                     _0x0107.bit.b4
#define     P7OE_P2                     _0x0107.bit.b2
#define     P7OE_P1                     _0x0107.bit.b1
#define     P7OE_P0                     _0x0107.bit.b0

//==========================
//          P0PU
//==========================
#define     P0PU                        _0x0110.byte
#define     P0PU_P7                     _0x0110.bit.b7
#define     P0PU_P6                     _0x0110.bit.b6
#define     P0PU_P5                     _0x0110.bit.b5
#define     P0PU_P4                     _0x0110.bit.b4
#define     P0PU_P3                     _0x0110.bit.b3
#define     P0PU_P2                     _0x0110.bit.b2
#define     P0PU_P1                     _0x0110.bit.b1
#define     P0PU_P0                     _0x0110.bit.b0
                                        
//==========================
//          P1PU
//==========================
#define     P1PU                        _0x0111.byte
#define     P1PU_P7                     _0x0111.bit.b7
#define     P1PU_P6                     _0x0111.bit.b6
#define     P1PU_P5                     _0x0111.bit.b5
#define     P1PU_P4                     _0x0111.bit.b4
#define     P1PU_P3                     _0x0111.bit.b3
#define     P1PU_P2                     _0x0111.bit.b2
#define     P1PU_P1                     _0x0111.bit.b1
#define     P1PU_P0                     _0x0111.bit.b0

//==========================
//          P2PU
//==========================
#define     P2PU                        _0x0112.byte
#define     P2PU_P6                     _0x0112.bit.b6
#define     P2PU_P5                     _0x0112.bit.b5
#define     P2PU_P4                     _0x0112.bit.b4
#define     P2PU_P3                     _0x0112.bit.b3
#define     P2PU_P2                     _0x0112.bit.b2
#define     P2PU_P1                     _0x0112.bit.b1
#define     P2PU_P0                     _0x0112.bit.b0

//==========================
//          P3PU
//==========================
#define     P3PU                        _0x0113.byte
#define     P3PU_P7                     _0x0113.bit.b7
#define     P3PU_P6                     _0x0113.bit.b6
#define     P3PU_P5                     _0x0113.bit.b5
#define     P3PU_P4                     _0x0113.bit.b4

//==========================
//          P4PU
//==========================
#define     P4PU                        _0x0114.byte
#define     P4PU_P7                     _0x0114.bit.b7
#define     P4PU_P6                     _0x0114.bit.b6
#define     P4PU_P5                     _0x0114.bit.b5
#define     P4PU_P4                     _0x0114.bit.b4
#define     P4PU_P3                     _0x0114.bit.b3
#define     P4PU_P2                     _0x0114.bit.b2

//==========================
//          P5PU
//==========================
#define     P5PU                        _0x0115.byte
#define     P5PU_P7                     _0x0115.bit.b7
#define     P5PU_P6                     _0x0115.bit.b6
#define     P5PU_P5                     _0x0115.bit.b5
#define     P5PU_P4                     _0x0115.bit.b4
#define     P5PU_P3                     _0x0115.bit.b3
#define     P5PU_P2                     _0x0115.bit.b2
#define     P5PU_P1                     _0x0115.bit.b1
#define     P5PU_P0                     _0x0115.bit.b0
                                        
//==========================
//          P6PU
//==========================
#define     P6PU                        _0x0116.byte
#define     P6PU_P6                     _0x0116.bit.b6
#define     P6PU_P5                     _0x0116.bit.b5
#define     P6PU_P4                     _0x0116.bit.b4
#define     P6PU_P3                     _0x0116.bit.b3
#define     P6PU_P2                     _0x0116.bit.b2
#define     P6PU_P1                     _0x0116.bit.b1
#define     P6PU_P0                     _0x0116.bit.b0
//==========================
//          P7PU
//==========================
#define     P7PU                        _0x0117.byte
#define     P7PU_P5                     _0x0117.bit.b5
#define     P7PU_P4                     _0x0117.bit.b4
#define     P7PU_P2                     _0x0117.bit.b2
#define     P7PU_P1                     _0x0117.bit.b1
#define     P7PU_P0                     _0x0117.bit.b0


//==========================
//          P0PD
//==========================
#define     P0PD                        _0x0120.byte
#define     P0PD_P7                     _0x0120.bit.b7
#define     P0PD_P6                     _0x0120.bit.b6
#define     P0PD_P5                     _0x0120.bit.b5
#define     P0PD_P4                     _0x0120.bit.b4
#define     P0PD_P3                     _0x0120.bit.b3
#define     P0PD_P2                     _0x0120.bit.b2
#define     P0PD_P1                     _0x0120.bit.b1
#define     P0PD_P0                     _0x0120.bit.b0
                                        
//==========================
//          P1PD
//==========================
#define     P1PD                        _0x0121.byte
#define     P1PD_P7                     _0x0121.bit.b7
#define     P1PD_P6                     _0x0121.bit.b6
#define     P1PD_P5                     _0x0121.bit.b5
#define     P1PD_P4                     _0x0121.bit.b4
#define     P1PD_P3                     _0x0121.bit.b3
#define     P1PD_P2                     _0x0121.bit.b2
#define     P1PD_P1                     _0x0121.bit.b1
#define     P1PD_P0                     _0x0121.bit.b0

//==========================
//          P2PD
//==========================
#define     P2PD                        _0x0122.byte
#define     P2PD_P6                     _0x0122.bit.b6
#define     P2PD_P5                     _0x0122.bit.b5
#define     P2PD_P4                     _0x0122.bit.b4
#define     P2PD_P3                     _0x0122.bit.b3
#define     P2PD_P2                     _0x0122.bit.b2
#define     P2PD_P1                     _0x0122.bit.b1
#define     P2PD_P0                     _0x0122.bit.b0
                                        
//==========================
//          P3PD
//==========================
#define     P3PD                        _0x0123.byte
#define     P3PD_P7                     _0x0123.bit.b7
#define     P3PD_P6                     _0x0123.bit.b6
#define     P3PD_P5                     _0x0123.bit.b5
#define     P3PD_P4                     _0x0123.bit.b4
                                        
//==========================
//          P4PD
//==========================
#define     P4PD                        _0x0124.byte
#define     P4PD_P7                     _0x0124.bit.b7
#define     P4PD_P6                     _0x0124.bit.b6
#define     P4PD_P5                     _0x0124.bit.b5
#define     P4PD_P4                     _0x0124.bit.b4
#define     P4PD_P3                     _0x0124.bit.b3
#define     P4PD_P2                     _0x0124.bit.b2

//==========================
//          P5PD
//==========================
#define     P5PD                        _0x0125.byte
#define     P5PD_P7                     _0x0125.bit.b7
#define     P5PD_P6                     _0x0125.bit.b6
#define     P5PD_P5                     _0x0125.bit.b5
#define     P5PD_P4                     _0x0125.bit.b4
#define     P5PD_P3                     _0x0125.bit.b3
#define     P5PD_P2                     _0x0125.bit.b2
#define     P5PD_P1                     _0x0125.bit.b1
#define     P5PD_P0                     _0x0125.bit.b0
                                        
//==========================
//          P6PD
//==========================
#define     P6PD                        _0x0126.byte
#define     P6PD_P6                     _0x0126.bit.b6
#define     P6PD_P5                     _0x0126.bit.b5
#define     P6PD_P4                     _0x0126.bit.b4
#define     P6PD_P3                     _0x0126.bit.b3
#define     P6PD_P2                     _0x0126.bit.b2
#define     P6PD_P1                     _0x0126.bit.b1
#define     P6PD_P0                     _0x0126.bit.b0
//==========================
//          P7PD
//==========================
#define     P7PD                        _0x0127.byte
#define     P7PD_P5                     _0x0127.bit.b5
#define     P7PD_P4                     _0x0127.bit.b4
#define     P7PD_P2                     _0x0127.bit.b2
#define     P7PD_P1                     _0x0127.bit.b1
#define     P7PD_P0                     _0x0127.bit.b0

                              
//==========================
//          P0DSEL
//==========================
#define     P0DSEL                      _0x0130.byte
#define     P0DSEL_P7                   _0x0130.bit.b7
#define     P0DSEL_P6                   _0x0130.bit.b6
#define     P0DSEL_P5                   _0x0130.bit.b5
#define     P0DSEL_P4                   _0x0130.bit.b4
#define     P0DSEL_P3                   _0x0130.bit.b3
#define     P0DSEL_P2                   _0x0130.bit.b2
#define     P0DSEL_P1                   _0x0130.bit.b1
#define     P0DSEL_P0                   _0x0130.bit.b0
                                        
//==========================
//          P1DSEL
//==========================
#define     P1DSEL                      _0x0131.byte
#define     P1DSEL_P7                   _0x0131.bit.b7
#define     P1DSEL_P6                   _0x0131.bit.b6
#define     P1DSEL_P5                   _0x0131.bit.b5
#define     P1DSEL_P4                   _0x0131.bit.b4
#define     P1DSEL_P3                   _0x0131.bit.b3
#define     P1DSEL_P2                   _0x0131.bit.b2
#define     P1DSEL_P1                   _0x0131.bit.b1
#define     P1DSEL_P0                   _0x0131.bit.b0
                           
//==========================
//          P2DSEL
//==========================
#define     P2DSEL                      _0x0132.byte
#define     P2DSEL_P6                   _0x0132.bit.b6
#define     P2DSEL_P5                   _0x0132.bit.b5
#define     P2DSEL_P4                   _0x0132.bit.b4
#define     P2DSEL_P3                   _0x0132.bit.b3
#define     P2DSEL_P2                   _0x0132.bit.b2
#define     P2DSEL_P1                   _0x0132.bit.b1
#define     P2DSEL_P0                   _0x0132.bit.b0
                                        
//==========================
//          P3DSEL
//==========================
#define     P3DSEL                      _0x0133.byte
#define     P3DSEL_P7                   _0x0133.bit.b7
#define     P3DSEL_P6                   _0x0133.bit.b6
#define     P3DSEL_P5                   _0x0133.bit.b5
#define     P3DSEL_P4                   _0x0133.bit.b4
                                        
//==========================
//          P4DSEL
//==========================
#define     P4DSEL                      _0x0134.byte
#define     P4DSEL_P7                   _0x0134.bit.b7
#define     P4DSEL_P6                   _0x0134.bit.b6
#define     P4DSEL_P5                   _0x0134.bit.b5
#define     P4DSEL_P4                   _0x0134.bit.b4
#define     P4DSEL_P3                   _0x0134.bit.b3
#define     P4DSEL_P2                   _0x0134.bit.b2
                               
//==========================
//          P5DSEL
//==========================
#define     P5DSEL                      _0x0135.byte
#define     P5DSEL_P7                   _0x0135.bit.b7
#define     P5DSEL_P6                   _0x0135.bit.b6
#define     P5DSEL_P5                   _0x0135.bit.b5
#define     P5DSEL_P4                   _0x0135.bit.b4
#define     P5DSEL_P3                   _0x0135.bit.b3
#define     P5DSEL_P2                   _0x0135.bit.b2
#define     P5DSEL_P1                   _0x0135.bit.b1
#define     P5DSEL_P0                   _0x0135.bit.b0
                                        
//==========================
//          P6DSEL
//==========================
#define     P6DSEL                      _0x0136.byte
#define     P6DSEL_P6                   _0x0136.bit.b6
#define     P6DSEL_P5                   _0x0136.bit.b5
#define     P6DSEL_P4                   _0x0136.bit.b4
#define     P6DSEL_P3                   _0x0136.bit.b3
#define     P6DSEL_P2                   _0x0136.bit.b2
#define     P6DSEL_P1                   _0x0136.bit.b1
#define     P6DSEL_P0                   _0x0136.bit.b0
                               
//==========================
//          P7DSEL
//==========================
#define     P7DSEL                      _0x0137.byte
#define     P7DSEL_P5                   _0x0137.bit.b5
#define     P7DSEL_P4                   _0x0137.bit.b4
#define     P7DSEL_P2                   _0x0137.bit.b2
#define     P7DSEL_P1                   _0x0137.bit.b1
#define     P7DSEL_P0                   _0x0137.bit.b0

              
//==========================
//          P0CFGCR
//==========================
#define     P0CFGCR                     _0x0140.byte
#define     P0CFGCR_P0CFGW              _0x0140.bit.b7
#define     P0CFGCR_P0SEL               _0x0140.b6_4.b6_4
#define     P0CFGCR_P0CFG               _0x0140.b2_0.b2_0
            
//==========================
//          P0CFGV
//==========================
#define     P0CFGV                      _0x0141.byte
#define     P0CFGV_P0CFGV               _0x0141.b2_0.b2_0
                                        
//==========================
//          P1CFGCR
//==========================
#define     P1CFGCR                     _0x0142.byte
#define     P1CFGCR_P1CFGW              _0x0142.bit.b7
#define     P1CFGCR_P1SEL               _0x0142.b6_4.b6_4
#define     P1CFGCR_P1CFG               _0x0142.b2_0.b2_0                                    
                                                                          
//==========================         
//          P1CFGV                   
//==========================         
#define     P1CFGV                      _0x0143.byte
#define     P1CFGV_P1CFGV               _0x0143.b2_0.b2_0
                                                                             
//==========================         
//          P2CFGCR                  
//==========================         
#define     P2CFGCR                     _0x0144.byte
#define     P2CFGCR_P2CFGW              _0x0144.bit.b7
#define     P2CFGCR_P2SEL               _0x0144.b6_4.b6_4
#define     P2CFGCR_P2CFG               _0x0144.b2_0.b2_0
                                        
//==========================    
//          P2CFGV              
//==========================    
#define     P2CFGV                      _0x0145.byte
#define     P2CFGV_P2CFGV               _0x0145.b2_0.b2_0
                                          
                                
//==========================         
//          P3CFGCR                  
//==========================         
#define     P3CFGCR                     _0x0146.byte
#define     P3CFGCR_P3CFGW              _0x0146.bit.b7
#define     P3CFGCR_P3SEL               _0x0146.b6_4.b6_4
#define     P3CFGCR_P3CFG               _0x0146.b2_0.b2_0
                                                               
//==========================    
//          P3CFGV              
//==========================    
#define     P3CFGV                      _0x0147.byte
#define     P3CFGV_P3CFGV               _0x0147.b2_0.b2_0
                                                                   
//==========================    
//          P4CFGCR             
//==========================    
#define     P4CFGCR                     _0x0148.byte
#define     P4CFGCR_P4CFGW              _0x0148.bit.b7
#define     P4CFGCR_P4SEL               _0x0148.b6_4.b6_4
#define     P4CFGCR_P4CFG               _0x0148.b2_0.b2_0
                                        
//==========================
//          P4CFGV
//==========================
#define     P4CFGV                      _0x0149.byte
#define     P4CFGV_P4CFGV               _0x0149.b2_0.b2_0
                                        
//==========================         
//          P5CFGCR                  
//==========================         
#define     P5CFGCR                     _0x014A.byte
#define     P5CFGCR_P5CFGW              _0x014A.bit.b7
#define     P5CFGCR_P5SEL               _0x014A.b6_4.b6_4
#define     P5CFGCR_P5CFG               _0x014A.b2_0.b2_0
                                        
//==========================    
//          P5CFGV              
//==========================    
#define     P5CFGV                      _0x014B.byte
#define     P5CFGV_P5CFGV               _0x014B.b2_0.b2_0
                                        
                                
//==========================
//          P6CFGCR
//==========================
#define     P6CFGCR                     _0x014C.byte
#define     P6CFGCR_P6CFGW              _0x014C.bit.b7
#define     P6CFGCR_P6SEL               _0x014C.b6_4.b6_4
#define     P6CFGCR_P6CFG               _0x014C.b2_0.b2_0
                                        
//==========================    
//          P6CFGV              
//==========================    
#define     P6CFGV                      _0x014D.byte
#define     P6CFGV_P6CFGV               _0x014D.b2_0.b2_0
                                        
//==========================         
//          P7CFGCR                  
//==========================         
#define     P7CFGCR                     _0x014E.byte
#define     P7CFGCR_P7CFGW              _0x014E.bit.b7
#define     P7CFGCR_P7SEL               _0x014E.b6_4.b6_4
#define     P7CFGCR_P7CFG               _0x014E.b2_0.b2_0
                                        
//==========================
//          P7CFGV
//==========================
#define     P7CFGV                      _0x014F.byte
#define     P7CFGV_P7CFGV               _0x014F.b2_0.b2_0
                                        
//==========================
//          TAMPPINCR0
//==========================
#define     TAMPPINCR0                  _0x0170.byte
#define     TAMPPINCR0_PINSEL           _0x0170.b7_5.b7_5
#define     TAMPPINCR0_TAMPERPINLVL     _0x0170.bit.b4
#define     TAMPPINCR0_TAMPERES         _0x0170.b3_2.b3_2
#define     TAMPPINCR0_TAMPERNC         _0x0170.b1_0.b1_0
                                        
//==========================
//          TAMPPINCR1
//==========================
#define     TAMPPINCR1                  _0x0171.byte
#define     TAMPPINCR1_PINSEL           _0x0171.b7_5.b7_5
#define     TAMPPINCR1_TAMPERPINLVL     _0x0171.bit.b4
#define     TAMPPINCR1_TAMPERES         _0x0171.b3_2.b3_2
#define     TAMPPINCR1_TAMPERNC         _0x0171.b1_0.b1_0
                                        
//==========================
//          PCKEN0
//==========================
#define     PCKEN0                      _0x0178.byte
#define     PCKEN0_TMRA2                _0x0178.bit.b6
#define     PCKEN0_TMRA1                _0x0178.bit.b5
#define     PCKEN0_TMRA0                _0x0178.bit.b4
#define     PCKEN0_STM1                 _0x0178.bit.b1
#define     PCKEN0_STM0                 _0x0178.bit.b0
                                
//==========================
//          PCKEN1
//==========================
#define     PCKEN1                      _0x0179.byte
#define     PCKEN1_LEUART               _0x0179.bit.b7
#define     PCKEN1_UART2                _0x0179.bit.b6
#define     PCKEN1_UART1                _0x0179.bit.b5
#define     PCKEN1_UART0                _0x0179.bit.b4
#define     PCKEN1_TCA2                 _0x0179.bit.b2
#define     PCKEN1_TCA1                 _0x0179.bit.b1
#define     PCKEN1_TCA0                 _0x0179.bit.b0
                                 

//==========================
//          PCKEN2
//==========================
#define     PCKEN2                      _0x017A.byte
#define     PCKEN2_SPI1                 _0x017A.bit.b5
#define     PCKEN2_SPI0                 _0x017A.bit.b4
#define     PCKEN2_I2C1                 _0x017A.bit.b1
#define     PCKEN2_I2C0                 _0x017A.bit.b0
                                        
//==========================
//          PCKEN3
//==========================
#define     PCKEN3                      _0x017B.byte
#define     PCKEN3_EINT7                _0x017B.bit.b7
#define     PCKEN3_EINT6                _0x017B.bit.b6
#define     PCKEN3_EINT5                _0x017B.bit.b5
#define     PCKEN3_EINT4                _0x017B.bit.b4
#define     PCKEN3_EINT3                _0x017B.bit.b3
#define     PCKEN3_EINT2                _0x017B.bit.b2
#define     PCKEN3_EINT1                _0x017B.bit.b1
#define     PCKEN3_EINT0                _0x017B.bit.b0
                                 
//==========================       
//          PCKEN4                 
//==========================       
#define     PCKEN4                      _0x017C.byte
#define     PCKEN4_TRNG                 _0x017C.bit.b6
#define     PCKEN4_SHA                  _0x017C.bit.b5
#define     PCKEN4_AES                  _0x017C.bit.b4
#define     PCKEN4_DIC                  _0x017C.bit.b2
#define     PCKEN4_CRC                  _0x017C.bit.b2
#define     PCKEN4_TAMPIN1              _0x017C.bit.b1
#define     PCKEN4_TAMPIN0              _0x017C.bit.b0
                                        
//==========================
//          PCKEN5
//==========================
#define     PCKEN5                      _0x017D.byte
#define     PCKEN5_DMA                  _0x017D.bit.b3
#define     PCKEN5_ADC                  _0x017D.bit.b2


//==========================         
//          PRSTR0                     
//==========================          
#define     PRSTR0                      _0x0180.byte
#define     PRSTR0_TMRA0                _0x0180.bit.b7
#define     PRSTR0_STM1                 _0x0180.bit.b4
#define     PRSTR0_STM0                 _0x0180.bit.b3
                                        
                                     
//==========================         
//          PRSTR1                     
//==========================         
#define     PRSTR1                      _0x0181.byte
#define     PRSTR1_UART0                _0x0181.bit.b7
#define     PRSTR1_TCA2                 _0x0181.bit.b5
#define     PRSTR1_TCA1                 _0x0181.bit.b4
#define     PRSTR1_TCA0                 _0x0181.bit.b3
#define     PRSTR1_TMRA2                _0x0181.bit.b1
#define     PRSTR1_TMRA1                _0x0181.bit.b0
                                        
//==========================         
//          PRSTR2                     
//==========================         
#define     PRSTR2                      _0x0182.byte
#define     PRSTR2_SPI0                 _0x0182.bit.b7
#define     PRSTR2_I2C1                 _0x0182.bit.b4
#define     PRSTR2_I2C0                 _0x0182.bit.b3
#define     PRSTR2_LEUART               _0x0182.bit.b2
#define     PRSTR2_UART2                _0x0182.bit.b1
#define     PRSTR2_UART1                _0x0182.bit.b0
                                     
//==========================         
//          PRSTR3                     
//==========================         
#define     PRSTR3                      _0x0183.byte
#define     PRSTR3_EINT4                _0x0183.bit.b7
#define     PRSTR3_EINT3                _0x0183.bit.b6
#define     PRSTR3_EINT2                _0x0183.bit.b5
#define     PRSTR3_EINT1                _0x0183.bit.b4
#define     PRSTR3_EINT0                _0x0183.bit.b3
#define     PRSTR3_SPI1                 _0x0183.bit.b0
                                     
//==========================         
//          PRSTR4                     
//==========================            
#define     PRSTR4                      _0x0184.byte
#define     PRSTR4_AES                  _0x0184.bit.b7
#define     PRSTR4_DIC                  _0x0184.bit.b6
#define     PRSTR4_CRC                  _0x0184.bit.b5
#define     PRSTR4_TAMPIN1              _0x0184.bit.b4
#define     PRSTR4_TAMPIN0              _0x0184.bit.b3
#define     PRSTR4_EINT7                _0x0184.bit.b2
#define     PRSTR4_EINT6                _0x0184.bit.b1
#define     PRSTR4_EINT5                _0x0184.bit.b0

//==========================         
//          PRSTR5                     
//==========================                                    
#define     PRSTR5                      _0x0185.byte
#define     PRSTR5_DMA                  _0x0185.bit.b6
#define     PRSTR5_ADC                  _0x0185.bit.b5
#define     PRSTR5_RTC                  _0x0185.bit.b3
#define     PRSTR5_SHA                  _0x0185.bit.b0
                                    
                                   
//==========================
//          KWUCR0
//==========================
#define     KWUCR0                      _0x0188.byte
#define     KWUCR0_KW3LE                _0x0188.bit.b7
#define     KWUCR0_KW3EN                _0x0188.bit.b6
#define     KWUCR0_KW2LE                _0x0188.bit.b5
#define     KWUCR0_KW2EN                _0x0188.bit.b4
#define     KWUCR0_KW1LE                _0x0188.bit.b3
#define     KWUCR0_KW1EN                _0x0188.bit.b2
#define     KWUCR0_KW0LE                _0x0188.bit.b1
#define     KWUCR0_KW0EN                _0x0188.bit.b0

//==========================
//          KWUCR1
//==========================
#define     KWUCR1                      _0x0189.byte
#define     KWUCR1_KW7LE                _0x0189.bit.b7                        
#define     KWUCR1_KW7EN                _0x0189.bit.b6
#define     KWUCR1_KW6LE                _0x0189.bit.b5                        
#define     KWUCR1_KW6EN                _0x0189.bit.b4
#define     KWUCR1_KW5LE                _0x0189.bit.b3                       
#define     KWUCR1_KW5EN                _0x0189.bit.b2
#define     KWUCR1_KW4LE                _0x0189.bit.b1                        
#define     KWUCR1_KW4EN                _0x0189.bit.b0

//==========================         
//          KWUCR2                   
//==========================         
#define     KWUCR2                      _0x018A.byte
#define     KWUCR2_KW11LE               _0x018A.bit.b7                        
#define     KWUCR2_KW11EN               _0x018A.bit.b6
#define     KWUCR2_KW10LE               _0x018A.bit.b5                        
#define     KWUCR2_KW10EN               _0x018A.bit.b4
#define     KWUCR2_KW9LE                _0x018A.bit.b3                       
#define     KWUCR2_KW9EN                _0x018A.bit.b2
#define     KWUCR2_KW8LE                _0x018A.bit.b1                        
#define     KWUCR2_KW8EN                _0x018A.bit.b0

//==========================         
//          KWUCR3                   
//==========================         
#define     KWUCR3                      _0x018B.byte
#define     KWUCR3_KW15LE               _0x018B.bit.b7                        
#define     KWUCR3_KW15EN               _0x018B.bit.b6
#define     KWUCR3_KW14LE               _0x018B.bit.b5                        
#define     KWUCR3_KW14EN               _0x018B.bit.b4
#define     KWUCR3_KW13LE               _0x018B.bit.b3                       
#define     KWUCR3_KW13EN               _0x018B.bit.b2
#define     KWUCR3_KW12LE               _0x018B.bit.b1                        
#define     KWUCR3_KW12EN               _0x018B.bit.b0

//==========================
//          KWUSR0
//==========================
#define     KWUSR0                      _0x018C.byte
#define     KWUSR0_KWU3                 _0x018C.b7_6.b7_6
#define     KWUSR0_KWU2                 _0x018C.b5_4.b5_4
#define     KWUSR0_KWU1                 _0x018C.b3_2.b3_2
#define     KWUSR0_KWU0                 _0x018C.b1_0.b1_0

//==========================
//          KWUSR1
//==========================
#define     KWUSR1                      _0x018D.byte
#define     KWUSR1_KWU7                 _0x018D.b7_6.b7_6
#define     KWUSR1_KWU6                 _0x018D.b5_4.b5_4
#define     KWUSR1_KWU5                 _0x018D.b3_2.b3_2
#define     KWUSR1_KWU4                 _0x018D.b1_0.b1_0

//==========================
//          KWUSR2
//==========================
#define     KWUSR2                      _0x018E.byte
#define     KWUSR2_KWU11                _0x018E.bE_6.b7_6
#define     KWUSR2_KWU10                _0x018E.bE_4.b5_4
#define     KWUSR2_KWU9                 _0x018E.bE_2.b3_2
#define     KWUSR2_KWU8                 _0x018E.bE_0.b1_0

//==========================
//          KWUSR3
//==========================
#define     KWUSR3                      _0x018F.byte
#define     KWUSR3_KWU15                _0x018F.bE_6.b7_6
#define     KWUSR3_KWU14                _0x018F.bE_4.b5_4
#define     KWUSR3_KWU13                _0x018F.bE_2.b3_2
#define     KWUSR3_KWU12                _0x018F.bE_0.b1_0



//==========================
//          EINTCR0
//==========================
#define     EINTCR0                     _0x0190.byte
#define     EINTCR0_INTSEL              _0x0190.b7_5.b7_5
#define     EINTCR0_INT0VL              _0x0190.bit.b4
#define     EINTCR0_INT0ES              _0x0190.b3_2.b3_2
#define     EINTCR0_INT0NC              _0x0190.b1_0.b1_0
                                        
//==========================
//          EINTCR1
//==========================
#define     EINTCR1                     _0x0191.byte
#define     EINTCR1_INTSEL              _0x0191.b7_5.b7_5
#define     EINTCR1_INT1VL              _0x0191.bit.b4
#define     EINTCR1_INT1ES              _0x0191.b3_2.b3_2
#define     EINTCR1_INT1NC              _0x0191.b1_0.b1_0
                                        
//==========================
//          EINTCR2
//==========================
#define     EINTCR2                     _0x0192.byte
#define     EINTCR2_INTSEL              _0x0192.b7_5.b7_5
#define     EINTCR2_INT2VL              _0x0192.bit.b4
#define     EINTCR2_INT2ES              _0x0192.b3_2.b3_2
#define     EINTCR2_INT2NC              _0x0192.b1_0.b1_0
                                        
//==========================
//          EINTCR3
//==========================
#define     EINTCR3                     _0x0193.byte
#define     EINTCR3_INTSEL              _0x0193.b7_5.b7_5
#define     EINTCR3_INT3VL              _0x0193.bit.b4
#define     EINTCR3_INT3ES              _0x0193.b3_2.b3_2
#define     EINTCR3_INT3NC              _0x0193.b1_0.b1_0
                                        
//==========================
//          EINTCR4
//==========================
#define     EINTCR4                     _0x0194.byte
#define     EINTCR4_INTSEL              _0x0194.b7_5.b7_5
#define     EINTCR4_INT4VL              _0x0194.bit.b4
#define     EINTCR4_INT4ES              _0x0194.b3_2.b3_2
#define     EINTCR4_INT4NC              _0x0194.b1_0.b1_0
                                        
//==========================
//          EINTCR5
//==========================
#define     EINTCR5                     _0x0195.byte
#define     EINTCR5_INTSEL              _0x0195.b7_5.b7_5
#define     EINTCR5_INT5VL              _0x0195.bit.b4
#define     EINTCR5_INT5ES              _0x0195.b3_2.b3_2
#define     EINTCR5_INT5NC              _0x0195.b1_0.b1_0
                                        
//==========================
//          EINTCR6
//==========================
#define     EINTCR6                     _0x0196.byte
#define     EINTCR6_INTSEL              _0x0196.b7_5.b7_5
#define     EINTCR6_INT6VL              _0x0196.bit.b4
#define     EINTCR6_INT6ES              _0x0196.b3_2.b3_2
#define     EINTCR6_INT6NC              _0x0196.b1_0.b1_0
                                        
//==========================
//          EINTCR7
//==========================
#define     EINTCR7                     _0x0197.byte
#define     EINTCR7_INTSEL              _0x0197.b7_5.b7_5
#define     EINTCR7_INT7VL              _0x0197.bit.b4
#define     EINTCR7_INT7ES              _0x0197.b3_2.b3_2
#define     EINTCR7_INT7NC              _0x0197.b1_0.b1_0
                                        

//==========================
//          IFR0
//==========================
#define     IFR0                        _0x01A0.byte
#define     IFR_U2A                     _0x01A0.bit.b7
#define     IFR_CFD                     _0x01A0.bit.b5
#define     IFR_TAMPER                  _0x01A0.bit.b4

//==========================
//          IFR1
//==========================
#define     IFR1                        _0x01A1.byte
#define     IFR_TBT                     _0x01A1.bit.b7
#define     IFR_TMRA21                  _0x01A1.bit.b6
#define     IFR_TMRA20                  _0x01A1.bit.b5
#define     IFR_TMRA11                  _0x01A1.bit.b4
#define     IFR_TMRA10                  _0x01A1.bit.b3
#define     IFR_TMRA01                  _0x01A1.bit.b2
#define     IFR_TMRA00                  _0x01A1.bit.b1
#define     IFR_RTC                     _0x01A1.bit.b0
                                        
//==========================
//          IFR2
//==========================
#define     IFR2                        _0x01A2.byte
#define     IFR_EXT3                    _0x01A2.bit.b7
#define     IFR_EXT2                    _0x01A2.bit.b6
#define     IFR_EXT1                    _0x01A2.bit.b5
#define     IFR_EXT0                    _0x01A2.bit.b4
#define     IFR_SPI0                    _0x01A2.bit.b3
#define     IFR_I2C0                    _0x01A2.bit.b2
#define     IFR_UART0_TX                _0x01A2.bit.b1
#define     IFR_UART0_RX                _0x01A2.bit.b0
                                            
//==========================
//          IFR3
//==========================
#define     IFR3                        _0x01A3.byte
#define     IFR_DMACH1                  _0x01A3.bit.b7
#define     IFR_DMACH0                  _0x01A3.bit.b6
#define     IFR_FMC                     _0x01A3.bit.b5
#define     IFR_LVD1                    _0x01A3.bit.b2
#define     IFR_LVD0                    _0x01A3.bit.b1
#define     IFR_ADC                     _0x01A3.bit.b0
                                        
//==========================
//          IFR4
//==========================
#define     IFR4                        _0x01A4.byte
#define     IFR_DIC                     _0x01A4.bit.b7
#define     IFR_DMACH3                  _0x01A4.bit.b1
#define     IFR_DMACH2                  _0x01A4.bit.b0
                                        
//==========================
//          IFR5
//==========================
#define     IFR5                        _0x01A5.byte
#define     IFR_EEMC                    _0x01A5.bit.b7
#define     IFR_EXT7                    _0x01A5.bit.b6
#define     IFR_EXT6                    _0x01A5.bit.b5
#define     IFR_EXT5                    _0x01A5.bit.b4
#define     IFR_EXT4                    _0x01A5.bit.b3
#define     IFR_TRNG                    _0x01A5.bit.b2
#define     IFR_LEUART_TX               _0x01A5.bit.b1
#define     IFR_LEUART_RX               _0x01A5.bit.b0 

//==========================
//          IFR6
//==========================
#define     IFR6                        _0x01A6.byte
#define     IFR_UART1_TX                _0x01A6.bit.b7
#define     IFR_UART1_RX                _0x01A6.bit.b6
#define     IFR_SHA                     _0x01A6.bit.b5
#define     IFR_AES                     _0x01A6.bit.b4
#define     IFR_STM1                    _0x01A6.bit.b3
#define     IFR_STM0                    _0x01A6.bit.b2
#define     IFR_TCA1                    _0x01A6.bit.b1
#define     IFR_TCA0                    _0x01A6.bit.b0
                                        
//==========================
//          IFR7
//==========================
#define     IFR7                        _0x01A7.byte
#define     IFR_TCA2                    _0x01A7.bit.b4
#define     IFR_UART2_TX                _0x01A7.bit.b3
#define     IFR_UART2_RX                _0x01A7.bit.b2
#define     IFR_SPI1                    _0x01A7.bit.b1
#define     IFR_I2C1                    _0x01A7.bit.b0
                                        

//==========================
//          IER0
//==========================
#define     IER0                        _0x01B0.byte
#define     IER_U2A                     _0x01B0.bit.b7
#define     IER_CFD                     _0x01B0.bit.b5
#define     IER_TAMPER                  _0x01B0.bit.b4
                                        
//==========================
//          IER1
//==========================
#define     IER1                        _0x01B1.byte
#define     IER_TBT                     _0x01B1.bit.b7
#define     IER_TMRA21                  _0x01B1.bit.b6
#define     IER_TMRA20                  _0x01B1.bit.b5
#define     IER_TMRA11                  _0x01B1.bit.b4
#define     IER_TMRA10                  _0x01B1.bit.b3
#define     IER_TMRA01                  _0x01B1.bit.b2
#define     IER_TMRA00                  _0x01B1.bit.b1
#define     IER_RTC                     _0x01B1.bit.b0
                                        
//==========================
//          IER2
//==========================
#define     IER2                        _0x01B2.byte
#define     IER_EXT3                    _0x01B2.bit.b7
#define     IER_EXT2                    _0x01B2.bit.b6
#define     IER_EXT1                    _0x01B2.bit.b5
#define     IER_EXT0                    _0x01B2.bit.b4
#define     IER_SPI0                    _0x01B2.bit.b3
#define     IER_I2C0                    _0x01B2.bit.b2
#define     IER_UART0_TX                _0x01B2.bit.b1
#define     IER_UART0_RX                _0x01B2.bit.b0

//==========================
//          IER3
//==========================
#define     IER3                        _0x01B3.byte
#define     IER_DMACH1                  _0x01B3.bit.b7
#define     IER_DMACH0                  _0x01B3.bit.b6
#define     IER_FMC                     _0x01B3.bit.b5
#define     IER_LVD1                    _0x01B3.bit.b2
#define     IER_LVD0                    _0x01B3.bit.b1
#define     IER_ADC                     _0x01B3.bit.b0
                                        
//==========================
//          IER4
//==========================
#define     IER4                        _0x01B4.byte
#define     IER_DIC                     _0x01B4.bit.b7
#define     IER_DMACH3                  _0x01B4.bit.b1
#define     IER_DMACH2                  _0x01B4.bit.b0

//==========================
//          IER5
//==========================
#define     IER5                        _0x01B5.byte
#define     IER_EEMC                    _0x01B5.bit.b7
#define     IER_EXT7                    _0x01B5.bit.b6
#define     IER_EXT6                    _0x01B5.bit.b5
#define     IER_EXT5                    _0x01B5.bit.b4
#define     IER_EXT4                    _0x01B5.bit.b3
#define     IER_TRNG                    _0x01B5.bit.b2
#define     IER_LEUART_TX               _0x01B5.bit.b1
#define     IER_LEUART_RX               _0x01B5.bit.b0
                                        
//==========================
//          IER6
//==========================
#define     IER6                        _0x01B6.byte
#define     IER_UART1_TX                _0x01B6.bit.b7
#define     IER_UART1_RX                _0x01B6.bit.b6
#define     IER_SHA                     _0x01B6.bit.b5
#define     IER_AES                     _0x01B6.bit.b4
#define     IER_STM1                    _0x01B6.bit.b3
#define     IER_STM0                    _0x01B6.bit.b2
#define     IER_TCA1                    _0x01B6.bit.b1
#define     IER_TCA0                    _0x01B6.bit.b0
                                        
//==========================
//          IER7
//==========================
#define     IER7                        _0x01B7.byte
#define     IER_TCA2                    _0x01B7.bit.b4
#define     IER_UART2_TX                _0x01B7.bit.b3
#define     IER_UART2_RX                _0x01B7.bit.b2
#define     IER_SPI1                    _0x01B7.bit.b1
#define     IER_I2C1                    _0x01B7.bit.b0


//==========================
//          IPR0
//==========================
#define     IPR0                        _0x01C0.byte

//==========================
//          IPR1
//==========================
#define     IPR1                        _0x01C1.byte
#define     IPR_U2A                     _0x01C1.b7_6.b7_6
#define     IPR_CFD                     _0x01C1.b3_2.b3_2
#define     IPR_TAMPER                  _0x01C1.b1_0.b1_0
                                        
//==========================
//          IPR2
//==========================
#define     IPR2                        _0x01C2.byte
#define     IPR_TMRA10                  _0x01C2.b7_6.b7_6
#define     IPR_TMRA01                  _0x01C2.b5_4.b5_4
#define     IPR_TMRA00                  _0x01C2.b3_2.b3_2
#define     IPR_RTC                     _0x01C2.b1_0.b1_0                                        

//==========================
//          IPR3
//==========================
#define     IPR3                        _0x01C3.byte
#define     IPR_TBT                     _0x01C3.b7_6.b7_6
#define     IPR_TMRA21                  _0x01C3.b5_4.b5_4
#define     IPR_TMRA20                  _0x01C3.b3_2.b3_2
#define     IPR_TMRA11                  _0x01C3.b1_0.b1_0 

//==========================
//          IPR4
//==========================
#define     IPR4                        _0x01C4.byte
#define     IPR_SPI0                    _0x01C4.b7_6.b7_6
#define     IPR_I2C0                    _0x01C4.b5_4.b5_4
#define     IPR_UART0_TX                _0x01C4.b3_2.b3_2
#define     IPR_UART0_RX                _0x01C4.b1_0.b1_0

//==========================
//          IPR5
//==========================
#define     IPR5                        _0x01C5.byte
#define     IPR_EXT3                    _0x01C5.b7_6.b7_6
#define     IPR_EXT2                    _0x01C5.b5_4.b5_4
#define     IPR_EXT1                    _0x01C5.b3_2.b3_2
#define     IPR_EXT0                    _0x01C5.b1_0.b1_0
                                        
//==========================
//          IPR6
//==========================
#define     IPR6                        _0x01C6.byte
#define     IPR_LVD1                    _0x01C6.b5_4.b5_4
#define     IPR_LVD0                    _0x01C6.b3_2.b3_2
#define     IPR_ADC                     _0x01C6.b1_0.b1_0
                                        
//==========================
//          IPR7
//==========================
#define     IPR7                        _0x01C7.byte
#define     IPR_DMACH1                  _0x01C7.b7_6.b7_6
#define     IPR_DMACH0                  _0x01C7.b5_4.b5_4
#define     IPR_FMC                     _0x01C7.b3_2.b3_2
                                      
//==========================
//          IPR8
//==========================
#define     IPR8                        _0x01C8.byte
#define     IPR_DMACH3                  _0x01C8.b3_2.b3_2
#define     IPR_DMACH2                  _0x01C8.b1_0.b1_0

//==========================
//          IPR9
//==========================
#define     IPR9                        _0x01C9.byte
#define     IPR_DIC                     _0x01C9.b7_6.b7_6

//==========================
//          IPR10
//==========================
#define     IPR10                       _0x01CA.byte
#define     IPR_EXT4                    _0x01CA.b7_6.b7_6
#define     IPR_TRNG                    _0x01CA.b5_4.b5_4
#define     IPR_LEUART_TX               _0x01CA.b3_2.b3_2
#define     IPR_LEUART_RX               _0x01CA.b1_0.b1_0
                                        
//==========================
//          IPR11
//==========================
#define     IPR11                       _0x01CB.byte
#define     IPR_EEMC                    _0x01CB.b7_6.b7_6
#define     IPR_EXT7                    _0x01CB.b5_4.b5_4
#define     IPR_EXT6                    _0x01CB.b3_2.b3_2
#define     IPR_EXT5                    _0x01CB.b1_0.b1_0

//==========================
//          IPR12
//==========================
#define     IPR12                       _0x01CC.byte
#define     IPR_STM1                    _0x01CC.b7_6.b7_6
#define     IPR_STM0                    _0x01CC.b5_4.b5_4
#define     IPR_TCA1                    _0x01CC.b3_2.b3_2
#define     IPR_TCA0                    _0x01CC.b1_0.b1_0
                                        
//==========================
//          IPR13
//==========================
#define     IPR13                       _0x01CD.byte
#define     IPR_UART1_TX                _0x01CD.b7_6.b7_6
#define     IPR_UART1_RX                _0x01CD.b5_4.b5_4
#define     IPR_SHA                     _0x01CD.b3_2.b3_2
#define     IPR_AES                     _0x01CD.b1_0.b1_0

//==========================
//          IPR14
//==========================
#define     IPR14                       _0x01CE.byte
#define     IPR_UART2_TX                _0x01CE.b7_6.b7_6
#define     IPR_UART2_RX                _0x01CE.b5_4.b5_4
#define     IPR_SPI1                    _0x01CE.b3_2.b3_2
#define     IPR_I2C1                    _0x01CE.b1_0.b1_0
                                        
//==========================
//          IPR15
//==========================
#define     IPR15                       _0x01CF.byte
#define     IPR_TCA2                    _0x01CF.b1_0.b1_0


//==========================
// LEUARTCR1
//==========================
#define     LEUARTCR1                  _0x0200.byte
#define     LEUARTCR1_TXE              _0x0200.bit.b7
#define     LEUARTCR1_RXE              _0x0200.bit.b6
#define     LEUARTCR1_STOPBT           _0x0200.bit.b5
#define     LEUARTCR1_EVEN             _0x0200.bit.b4
#define     LEUARTCR1_PE               _0x0200.bit.b3
#define     LEUARTCR1_IRDASEL          _0x0200.bit.b2
#define     LEUARTCR1_CLKSEL           _0x0200.bit.b1
#define     LEUARTCR1_WKMODE           _0x0200.bit.b0
                                       
                                       
//==========================           
// LEUARTCR2                          
//==========================           
#define     LEUARTCR2                  _0x0201.byte
#define     LEUARTCR2_DV               _0x0201.b7_6.b7_6
#define     LEUARTCR2_RTSEL            _0x0201.b5_3.b5_3
#define     LEUARTCR2_RXDNC            _0x0201.b2_1.b2_1
#define     LEUARTCR2_STOPBR           _0x0201.bit.b0
                                       
                                       
//==========================           
// LEUARTDR                           
//==========================           
#define     LEUARTDR                   _0x0202.byte
                                       
//==========================           
// LEUARTIER                          
//==========================           
#define     LEUARTIER                  _0x0203.byte
#define     LEUARTIER_TXEPTIEN         _0x0203.bit.b6
#define     LEUARTIER_TXUTHIEN         _0x0203.bit.b5
#define     LEUARTIER_TXBYTEIEN        _0x0203.bit.b4
#define     LEUARTIER_RXERRIEN         _0x0203.bit.b3
#define     LEUARTIER_RXFULLIEN        _0x0203.bit.b2
#define     LEUARTIER_RXOTHIEN         _0x0203.bit.b1
#define     LEUARTIER_RXBYTEIEN        _0x0203.bit.b0
//==========================           
// LEUARTRXST                         
//==========================           
#define     LEUARTRXST                 _0x0204.byte
#define     LEUARTRXST_RXPERR          _0x0204.bit.b7
#define     LEUARTRXST_RXFERR          _0x0204.bit.b6
#define     LEUARTRXST_RXOVRUN         _0x0204.bit.b5
#define     LEUARTRXST_RXBUSY          _0x0204.bit.b3
#define     LEUARTRXST_RXFULL          _0x0204.bit.b2
#define     LEUARTRXST_RXOTHR          _0x0204.bit.b1
#define     LEUARTRXST_RXEMPTY         _0x0204.bit.b0
                                       
//==========================           
// LEUARTTXST                         
//==========================           
#define     LEUARTTXST                 _0x0205.byte
#define     LEUARTTXST_TXBUSY          _0x0205.bit.b3
#define     LEUARTTXST_TXFULL          _0x0205.bit.b2
#define     LEUARTTXST_TXOTHR          _0x0205.bit.b1
#define     LEUARTTXST_TXEMPTY         _0x0205.bit.b0
                                       
                                       
//==========================           
// LEUARTFIFOCR                       
//==========================           
#define     LEUARTFIFOCR               _0x0206.byte
#define     LEUARTFIFOCR_TXTHR         _0x0206.b7_5.b7_5
#define     LEUARTFIFOCR_TXFLUSH       _0x0206.bit.b4
#define     LEUARTFIFOCR_RXTHR         _0x0206.b3_1.b3_1
#define     LEUARTFIFOCR_RXFLUSH       _0x0206.bit.b0
                                       
//==========================           
// LEUARTWKCMP                        
//==========================           
#define     LEUARTWKCMP                _0x0207.byte
#define     LEUARTWKCMP_WKCMPDAT       _0x0207.b7_0.b7_0
                                       
//==========================           
// LEUARTBUF                          
//==========================           
#define     LEUARTBUF                  _0x0208.byte

//==========================
//          SPI0CR
//==========================            
#define SPI0CR                          _0x0240.byte
#define SPI0CR_MODE                     _0x0240.b6_4.b6_4
#define SPI0CR_LSB                      _0x0240.bit.b3
#define SPI0CR_CPOL                     _0x0240.bit.b2
#define SPI0CR_CPHA                     _0x0240.bit.b1
#define SPI0CR_SPIEN                    _0x0240.bit.b0
                                        
//==========================            
//          SPI0CFG                     
//==========================            
#define SPI0CFG                         _0x0241.byte
#define SPI0CFG_CSSEL                   _0x0241.bit.b7
#define SPI0CFG_CRCIV                   _0x0241.bit.b6
#define SPI0CFG_CRCEN                   _0x0241.bit.b5
#define SPI0CFG_TXEMP                   _0x0241.bit.b4
#define SPI0CFG_TXUIG                   _0x0241.bit.b3
#define SPI0CFG_ETXFIE                  _0x0241.bit.b1
#define SPI0CFG_MSTR                    _0x0241.bit.b0
                                        
//==========================            
//          SPI0SR                      
//==========================            
#define SPI0SR                          _0x0242.byte
#define SPI0SR_BUSY                     _0x0242.bit.b7
#define SPI0SR_CSERR                    _0x0242.bit.b6
#define SPI0SR_RXCRC                    _0x0242.bit.b5
#define SPI0SR_RXERR                    _0x0242.bit.b1
#define SPI0SR_ETXFI                    _0x0242.bit.b0
                                        
//==========================            
//          SPI0TXFSR                   
//==========================            
#define SPI0TXFSR                       _0x0243.byte
#define SPI0TXFSR_RXEMP                 _0x0243.bit.b7
#define SPI0TXFSR_RXUDF                 _0x0243.bit.b6
#define SPI0TXFSR_RXOVF                 _0x0243.bit.b5
#define SPI0TXFSR_RXF                   _0x0243.bit.b4
#define SPI0TXFSR_TXFUL                 _0x0243.bit.b3
#define SPI0TXFSR_TXUDF                 _0x0243.bit.b2
#define SPI0TXFSR_TXOVF                 _0x0243.bit.b1
#define SPI0TXFSR_TXF                   _0x0243.bit.b0
                                        
//==========================            
//          SPI0RXCR                    
//==========================            
#define SPI0RXCR                        _0x0244.byte
#define SPI0RXCR_RXFLSH                 _0x0244.bit.b7
#define SPI0RXCR_RXUDIE                 _0x0244.bit.b5
#define SPI0RXCR_RXOVIE                 _0x0244.bit.b4
#define SPI0RXCR_RXIE                   _0x0244.bit.b3
#define SPI0RXCR_RXTHR                  _0x0244.b2_0.b2_0
                                        
//==========================            
//          SPI0TXCR                    
//==========================            
#define SPI0TXCR                        _0x0245.byte
#define SPI0TXCR_TXFLSH                 _0x0245.bit.b7
#define SPI0TXCR_TXUDIE                 _0x0245.bit.b5
#define SPI0TXCR_TXOVIE                 _0x0245.bit.b4
#define SPI0TXCR_TXIE                   _0x0245.bit.b3
#define SPI0TXCR_TXTHR                  _0x0245.b2_0.b2_0
                                        
                                        
                                        
//==========================            
//          SPI0RX                      
//==========================            
#define SPI0RX                          _0x0246.byte
                                        
//==========================            
//          SPI0TX                      
//==========================            
#define SPI0TX                          _0x0247.byte
                                        
//==========================            
//          SPI0RXCNT                   
//==========================            
#define SPI0RXCNT                       _0x0248.byte
                                        
//==========================            
//          SPI0TXCNT                   
//==========================            
#define SPI0TXCNT                       _0x0249.byte
                                        
//==========================            
//          SPI0OFFSET                  
//==========================            
#define SPI0OFFSET                      _0x024A.byte
                                        
                                        
//==========================            
//          SPI0CNT                     
//==========================            
#define SPI0CNT                         _0x024B.byte
                                        
                                        
//==========================            
//          SPI0MCR                     
//==========================            
#define SPI0MCR                         _0x024C.byte
#define SPI0MCR_CSERRIE                 _0x024C.bit.b1
#define SPI0MCR_STOP                    _0x024C.bit.b0
                                        
//==========================            
//          SPI0MCNT                    
//==========================            
#define SPI0MCNT                        _0x024D.byte
                                        
//==========================            
//          SPI0CKD                     
//==========================            
#define SPI0CKD                         _0x024E.byte
                                        
//==========================            
//          SPI0CSTIM                   
//==========================            
#define SPI0CSTIM                       _0x024F.byte
#define SPI0CSTIM_HOLD                  _0x024F.b7_4.b7_4
#define SPI0CSTIM_SETUP                 _0x024F.b3_0.b3_0
                                        
                                        
//==========================            
//          SPI1CR                      
//==========================            
#define SPI1CR                          _0x0250.byte
#define SPI1CR_MODE                     _0x0250.b6_4.b6_4
#define SPI1CR_LSB                      _0x0250.bit.b3
#define SPI1CR_CPOL                     _0x0250.bit.b2
#define SPI1CR_CPHA                     _0x0250.bit.b1
#define SPI1CR_SPIEN                    _0x0250.bit.b0
                                        
//==========================            
//          SPI1CFG                     
//==========================            
#define SPI1CFG                         _0x0251.byte
#define SPI1CFG_CSSEL                   _0x0251.bit.b7
#define SPI1CFG_CRCIV                   _0x0251.bit.b6
#define SPI1CFG_CRCEN                   _0x0251.bit.b5
#define SPI1CFG_TXEMP                   _0x0251.bit.b4
#define SPI1CFG_TXUIG                   _0x0251.bit.b3
#define SPI1CFG_ETXFIE                  _0x0251.bit.b1
#define SPI1CFG_MSTR                    _0x0251.bit.b0
                                        
//==========================            
//          SPI1SR                      
//==========================            
#define SPI1SR                          _0x0252.byte
#define SPI1SR_BUSY                     _0x0252.bit.b7
#define SPI1SR_CSERR                    _0x0252.bit.b6
#define SPI1SR_RXCRC                    _0x0252.bit.b5
#define SPI1SR_RXERR                    _0x0252.bit.b1
#define SPI1SR_ETXFI                    _0x0252.bit.b0
                                       
//==========================            
//          SPI1TXFSR                   
//==========================            
#define SPI1TXFSR                       _0x0253.byte
#define SPI1TXFSR_RXEMP                 _0x0253.bit.b7
#define SPI1TXFSR_RXUDF                 _0x0253.bit.b6
#define SPI1TXFSR_RXOVF                 _0x0253.bit.b5
#define SPI1TXFSR_RXF                   _0x0253.bit.b4
#define SPI1TXFSR_TXFUL                 _0x0253.bit.b3
#define SPI1TXFSR_TXUDF                 _0x0253.bit.b2
#define SPI1TXFSR_TXOVF                 _0x0253.bit.b1
#define SPI1TXFSR_TXF                   _0x0253.bit.b0

 
//==========================            
//          SPI1RXCR                    
//==========================            
#define SPI1RXCR                        _0x0254.byte
#define SPI1RXCR_RXFLSH                 _0x0254.bit.b7
#define SPI1RXCR_RXUDIE                 _0x0254.bit.b5
#define SPI1RXCR_RXOVIE                 _0x0254.bit.b4
#define SPI1RXCR_RXIE                   _0x0254.bit.b3
#define SPI1RXCR_RXTHR                  _0x0254.b2_0.b2_0
                                        
//==========================            
//          SPI1TXCR                    
//==========================            
#define SPI1TXCR                        _0x0255.byte
#define SPI1TXCR_TXFLSH                 _0x0255.bit.b7
#define SPI1TXCR_TXUDIE                 _0x0255.bit.b5
#define SPI1TXCR_TXOVIE                 _0x0255.bit.b4
#define SPI1TXCR_TXIE                   _0x0255.bit.b3
#define SPI1TXCR_TXTHR                  _0x0255.b2_0.b2_0
                                        
                                                                              
//==========================            
//          SPI1RX                      
//==========================            
#define SPI1RX                          _0x0256.byte
                                        
//==========================            
//          SPI1TX                      
//==========================            
#define SPI1TX                          _0x0257.byte
                                        
//==========================            
//          SPI1RXCNT                   
//==========================            
#define SPI1RXCNT                       _0x0258.byte
                                        
//==========================            
//          SPI1TXCNT                   
//==========================            
#define SPI1TXCNT                       _0x0259.byte
                                        
//==========================            
//          SPI1OFFSET                  
//==========================            
#define SPI1OFFSET                      _0x025A.byte
                                                                                
//==========================            
//          SPI1CNT                     
//==========================            
#define SPI1CNT                         _0x025B.byte
                                                                                
//==========================            
//          SPI1MCR                     
//==========================            
#define SPI1MCR                         _0x025C.byte
#define SPI1MCR_CSERRIE                 _0x025C.bit.b1
#define SPI1MCR_STOP                    _0x025C.bit.b0
                                        
//==========================            
//          SPI1MCNT                    
//==========================            
#define SPI1MCNT                        _0x025D.byte
                                        
//==========================            
//          SPI1CKD                     
//==========================            
#define SPI1CKD                         _0x025E.byte
                                        
//==========================            
//          SPI1CSTIM                   
//==========================            
#define SPI1CSTIM                       _0x025F.byte
#define SPI1CSTIM_HOLD                  _0x025F.b7_4.b7_4
#define SPI1CSTIM_SETUP                 _0x025F.b3_0.b3_0

//==========================
//          STM0CR
//==========================
#define     STM0CR                      _0x0280.byte
#define     STM0CR_STMCKD               _0x0280.b5_4.b5_4
#define     STM0CR_DSLP                 _0x0280.bit.b3
#define     STM0CR_STMIEN               _0x0280.bit.b2
#define     STM0CR_STMCKS               _0x0280.bit.b1
#define     STM0CR_STMEN                _0x0280.bit.b0

//==========================
//          STM0SR
//==========================
#define     STM0SR                      _0x0281.byte
#define     STM0SR_STMI                 _0x0281.bit.b1
#define     STM0SR_STMS                 _0x0281.bit.b0
                                        
//==========================
//          STM0V
//==========================
#define     STM0V                       _0x0284.word
#define     STM0VL                      _0x0284.byte[0]
#define     STM0V_STMVL                 _0x0284.byte[0]
#define     STM0VH                      _0x0284.byte[1]
#define     STM0V_STMVH                 _0x0284.byte[1]
                                        
//==========================
//          STM0DR
//==========================
#define     STM0DR                      _0x0286.word
#define     STM0DRL                     _0x0286.byte[0]
#define     STM0DR_STMDRL               _0x0286.byte[0]
#define     STM0DRH                     _0x0286.byte[1]
#define     STM0DR_STMDRH               _0x0286.byte[1]
                                        
//==========================
//          STM1CR
//==========================
#define     STM1CR                      _0x0288.byte
#define     STM1CR_STMCKD               _0x0288.b5_4.b5_4
#define     STM1CR_DSLP                 _0x0288.bit.b3
#define     STM1CR_STMIEN               _0x0288.bit.b2
#define     STM1CR_STMCKS               _0x0288.bit.b1
#define     STM1CR_STMEN                _0x0288.bit.b0
                                        
//==========================
//          STM1SR
//==========================
#define     STM1SR                      _0x0289.byte
#define     STM1SR_STMI                 _0x0289.bit.b1
#define     STM1SR_STMS                 _0x0289.bit.b0
                                  
//==========================
//          STM1V
//==========================
#define     STM1V                       _0x028C.word     
#define     STM1VL                      _0x028C.byte[0]
#define     STM1V_STMVL                 _0x028C.byte[0]
#define     STM1VH                      _0x028C.byte[1]
#define     STM1V_STMVH                 _0x028C.byte[1]
                                        
//==========================
//          STM1DR
//==========================
#define     STM1DR                      _0x028E.word
#define     STM1DRL                     _0x028E.byte[0]
#define     STM1DR_STMDRL               _0x028E.byte[0]
#define     STM1DRH                     _0x028E.byte[1]
#define     STM1DR_STMDRH               _0x028E.byte[1]

//==========================
//          ADCCR0
//==========================
#define     ADCCR0                      _0x0300.byte
#define     ADCCR0_AMD                  _0x0300.b7_6.b7_6
#define     ADCCR0_AUTOPD               _0x0300.bit.b5
#define     ADCCR0_INTLV                _0x0300.bit.b4
#define     ADCCR0_INTEN                _0x0300.bit.b3
#define     ADCCR0_IRFEN                _0x0300.b2_1.b2_1
#define     ADCCR0_ADEN                 _0x0300.bit.b0

//==========================
//          ADCCR1
//==========================
#define     ADCCR1                      _0x0301.byte
#define     ADCCR1_EVSEL                _0x0301.b7_4.b7_4
                                        
//==========================
//          ADCCR2
//==========================
#define     ADCCR2                      _0x0302.byte
#define     ADCCR2_LVINTEN              _0x0302.bit.b0
                                        
//==========================
//          ADCCKDIV
//==========================
#define     ADCCKDIV                    _0x0304.byte
#define     ADCCKDIV_ADCKDIV            _0x0304.b3_0.b3_0
                                
//==========================
//          ADCLV
//==========================
#define     ADCLV                       _0x0306.byte
#define     ADCLV_LVCMP                 _0x0306.b7_6.b7_6
#define     ADCLV_LVINTVL               _0x0306.bit.b5
#define     ADCLV_LVSEL                 _0x0306.b4_0.b4_0                                    

//==========================
//          ADCSCAN0
//==========================
#define     ADCSCAN0                    _0x0307.byte
#define     ADCSCAN0_ADCSCAN            _0x0307.byte
                                        
//==========================
//          ADCSCAN1
//==========================
#define     ADCSCAN1                    _0x0308.byte
#define     ADCSCAN1_ADCSCAN            _0x0308.byte
                                                                                
//==========================
//          ADCSR
//==========================
#define     ADCSR                       _0x030A.byte
#define     ADCSR_EOCF                  _0x030A.bit.b7
#define     ADCSR_ADBF                  _0x030A.bit.b6
#define     ADCSR_ADCRDY                _0x030A.bit.b5
#define     ADCSR_BUFOVR                _0x030A.bit.b3
#define     ADCSR_UNLCK                 _0x030A.bit.b2
#define     ADCSR_LVDET                 _0x030A.bit.b1
#define     ADCSR_ADRS                  _0x030A.bit.b0

//==========================
//          ADCCHRDY
//==========================
#define     ADCCHRDY                    _0x030B.byte
#define     ADCCHRDY_CHRDY              _0x030B.b4_0.b4_0
                                        
//==========================
//          ADCCHSEL
//==========================
#define     ADCCHSEL                    _0x030C.byte
#define     ADCCHSEL_CHSEL              _0x030C.b4_0.b4_0
                                        
//==========================
//          ADCDR  
//==========================
#define     ADCDR                       _0x0310.word
#define     ADCDRL                      _0x0310.byte[0]
#define     ADCDR_ADCDRL                _0x0310.byte[0]
#define     ADCDRH                      _0x0310.byte[1]
#define     ADCDR_ADCDRH                _0x0310.blst8_byte[1].b3_0.b3_0
                                        
//==========================
//          ADCLLV
//==========================
#define     ADCLLV                      _0x0312.word
#define     ADCLLVL                     _0x0312.byte[0]
#define     ADCLLV_ADCLLVL              _0x0312.byte[0]
#define     ADCLLVH                     _0x0312.byte[1]
#define     ADCLLV_ADCLLVH              _0x0312.blst8_byte[1].b3_0.b3_0         
            
//==========================
//          ADCHLV
//==========================
#define     ADCHLV                      _0x0314.word
#define     ADCHLVL                     _0x0314.byte[0]
#define     ADCHLV_ADCHLVL              _0x0314.byte[0]
#define     ADCHLVH                     _0x0314.byte[1]
#define     ADCHLV_ADCHLVH              _0x0314.blst8_byte[1].b3_0.b3_0

// ----- DMA -----                                                                      
//==========================
//          SDCR
//==========================
#define     SDCR                        _0x0800.byte
#define     SDCR_CH3EN                  _0x0800.bit.b7
#define     SDCR_CH2EN                  _0x0800.bit.b6
#define     SDCR_CH1EN                  _0x0800.bit.b5
#define     SDCR_CH0EN                  _0x0800.bit.b4
                                        
//==========================
//          SDCINT
//==========================
#define     SDCINT                      _0x0801.byte
#define     SDCINT_CH3INT               _0x0801.bit.b7
#define     SDCINT_CH2INT               _0x0801.bit.b6
#define     SDCINT_CH1INT               _0x0801.bit.b5
#define     SDCINT_CH0INT               _0x0801.bit.b4
#define     SDCINT_CH3IE                _0x0801.bit.b3
#define     SDCINT_CH2IE                _0x0801.bit.b2
#define     SDCINT_CH1IE                _0x0801.bit.b1
#define     SDCINT_CH0IE                _0x0801.bit.b0

//==========================
//          SDCSR0
//==========================
#define     SDCSR0                      _0x0802.byte
#define     SDCSR0_CH3ACT               _0x0802.bit.b3
#define     SDCSR0_CH2ACT               _0x0802.bit.b2
#define     SDCSR0_CH1ACT               _0x0802.bit.b1
#define     SDCSR0_CH0ACT               _0x0802.bit.b0
                                        
//==========================
//          SDCSR1
//==========================
#define     SDCSR1                      _0x0803.byte
#define     SDCSR1_CH3ST                _0x0803.b7_6.b7_6
#define     SDCSR1_CH2ST                _0x0803.b5_4.b5_4
#define     SDCSR1_CH1ST                _0x0803.b3_2.b3_2
#define     SDCSR1_CH0ST                _0x0803.b1_0.b1_0
                                        

//==========================
//          SDCSSZ
//==========================
#define     SDCSSZ                      _0x0805.byte
#define     SDCSSZ_CH3SSZ               _0x0805.b7_6.b7_6
#define     SDCSSZ_CH2SSZ               _0x0805.b5_4.b5_4
#define     SDCSSZ_CH1SSZ               _0x0805.b3_2.b3_2
#define     SDCSSZ_CH0SSZ               _0x0805.b1_0.b1_0
                                        
//==========================
//          SDCDSZ
//==========================
#define     SDCDSZ                      _0x0806.byte
#define     SDCDSZ_CH3DSZ               _0x0806.b7_6.b7_6
#define     SDCDSZ_CH2DSZ               _0x0806.b5_4.b5_4
#define     SDCDSZ_CH1DSZ               _0x0806.b3_2.b3_2
#define     SDCDSZ_CH0DSZ               _0x0806.b1_0.b1_0

//==========================
//          SDCREQ
//==========================
#define     SDCREQ                      _0x0807.byte
#define     SDCREQ_CH3REQ               _0x0807.b7_6.b7_6
#define     SDCREQ_CH2REQ               _0x0807.b5_4.b5_4
#define     SDCREQ_CH1REQ               _0x0807.b3_2.b3_2
#define     SDCREQ_CH0REQ               _0x0807.b1_0.b1_0

//==========================
//          CH0SCFG
//==========================
#define     CH0SCFG                     _0x0808.byte
#define     CH0SCFG_RELOAD              _0x0808.bit.b7
#define     CH0SCFG_INCEN               _0x0808.bit.b5
#define     CH0SCFG_SRCSEL              _0x0808.b4_0.b4_0
                                        
//==========================
//          CH0DCFG
//==========================
#define     CH0DCFG                     _0x0809.byte
#define     CH0DCFG_RELOAD              _0x0809.bit.b7
#define     CH0DCFG_INCEN               _0x0809.bit.b5
#define     CH0DCFG_DSTSEL              _0x0809.b4_0.b4_0
                                        
//==========================
//          CH0CNT0, CH0CNT1
//==========================
#define     CH0CNT                      _0x080A.word
#define     CH0CNT0                     _0x080A.byte[0]
#define     CH0CNT0_CHCNT               _0x080A.byte[0]
#define     CH0CNT1                     _0x080A.byte[1]
#define     CH0CNT1_CHCNT               _0x080A.byte[1]

//==========================            
//          CH0SA0, CH0SA1
//==========================
#define     CH0SA                       _0x080C.word
#define     CH0SA0                      _0x080C.byte[0]
#define     CH0SA0_CHSA                 _0x080C.byte[0]
#define     CH0SA1                      _0x080C.byte[1]
#define     CH0SA1_CHSA                 _0x080C.byte[1]

//==========================
//          CH0SA2
//==========================
#define     CH0SA2                      _0x080E.byte
#define     CH0SA2_MEMORY_SEL           _0x080E.bit.b0

//==========================
//          CH0DA0, CH0DA1
//==========================
#define     CH0DA                       _0x0810.word
#define     CH0DA0                      _0x0810.byte[0]
#define     CH0DA0_CHDA                 _0x0810.byte[0]
#define     CH0DA1                      _0x0810.byte[1]
#define     CH0DA1_CHDA                 _0x0810.byte[1]


//==========================            
//          CH0DA2
//==========================
#define     CH0DA2                      _0x0812.byte
#define     CH0DA2_MEMORY_SEL           _0x0812.bit.b0

//==========================
//          CH1SCFG
//==========================
#define     CH1SCFG                     _0x0818.byte
#define     CH1SCFG_RELOAD              _0x0818.bit.b7
#define     CH1SCFG_INCEN               _0x0818.bit.b5
#define     CH1SCFG_SRCSEL              _0x0818.b4_0.b4_0
                                        
//==========================
//          CH1DCFG
//==========================
#define     CH1DCFG                     _0x0819.byte
#define     CH1DCFG_RELOAD              _0x0819.bit.b7
#define     CH1DCFG_INCEN               _0x0819.bit.b5
#define     CH1DCFG_DSTSEL              _0x0819.b4_0.b4_0
                                        
//==========================
//          CH1CNT0, CH1CN1
//==========================
#define     CH1CNT                      _0x081A.word
#define     CH1CNT0                     _0x081A.byte[0]
#define     CH1CNT0_CHCNT               _0x081A.byte[0]
#define     CH1CNT1                     _0x081A.byte[1]
#define     CH1CNT1_CHCNT               _0x081A.byte[1]
                                        
//==========================
//          CH1SA0, CH1SA1
//==========================
#define     CH1SA                       _0x081C.word
#define     CH1SA0                      _0x081C.byte[0]
#define     CH1SA0_CHSA                 _0x081C.byte[0]
#define     CH1SA1                      _0x081C.byte[1]
#define     CH1SA1_CHSA                 _0x081C.byte[1]
                                        
//==========================
//          CH1SA2
//==========================
#define     CH1SA2                      _0x081E.byte
#define     CH1SA2_MEMORY_SEL           _0x081E.bit.b0

//==========================
//          CH1DA0, CH1DA1
//==========================
#define     CH1DA                       _0x0820.word
#define     CH1DA0                      _0x0820.byte[0]
#define     CH1DA0_CHDA                 _0x0820.byte[0]
#define     CH1DA1                      _0x0820.byte[1]
#define     CH1DA1_CHDA                 _0x0820.byte[1]

//==========================            
//          CH1DA2
//==========================
#define     CH1DA2                      _0x0822.byte
#define     CH1DA2_MEMORY_SEL           _0x0822.bit.b0

//==========================
//          CH2SCFG
//==========================
#define     CH2SCFG                     _0x0828.byte
#define     CH2SCFG_RELOAD              _0x0828.bit.b7
#define     CH2SCFG_INCEN               _0x0828.bit.b5
#define     CH2SCFG_SRCSEL              _0x0828.b4_0.b4_0
                                        
//==========================
//          CH2DCFG
//==========================
#define     CH2DCFG                     _0x0829.byte
#define     CH2DCFG_RELOAD              _0x0829.bit.b7
#define     CH2DCFG_INCEN               _0x0829.bit.b5
#define     CH2DCFG_DSTSEL              _0x0829.b4_0.b4_0
                                        
//==========================
//          CH2CNT0, CH2CNT1
//==========================
#define     CH2CNT                      _0x082A.word
#define     CH2CNT0                     _0x082A.byte[0]
#define     CH2CNT0_CHCNT               _0x082A.byte[0]
#define     CH2CNT1                     _0x082A.byte[1]
#define     CH2CNT1_CHCNT               _0x082A.byte[1]
                                        
//==========================
//          CH2SA0, CH2SA1
//==========================
#define     CH2SA                       _0x082C.word
#define     CH2SA0                      _0x082C.byte[0]
#define     CH2SA0_CHSA                 _0x082C.byte[0]
#define     CH2SA1                      _0x082C.byte[1]
#define     CH2SA1_CHSA                 _0x082C.byte[1]

//==========================            
//          CH2SA2
//==========================
#define     CH2SA2                      _0x082E.byte
#define     CH2SA2_MEMORY_SEL           _0x082E.bit.b0

//==========================
//          CH2DA0, CH2DA1
//==========================
#define     CH2DA                       _0x0830.word
#define     CH2DA0                      _0x0830.byte[0]
#define     CH2DA0_CHDA                 _0x0830.byte[0]
#define     CH2DA1                      _0x0830.byte[1]
#define     CH2DA1_CHDA                 _0x0830.byte[1]

//==========================            
//          CH2DA2
//==========================
#define     CH2DA2                      _0x0832.byte
#define     CH2DA2_MEMORY_SEL           _0x0832.bit.b0

//==========================
//          CH3SCFG
//==========================
#define     CH3SCFG                     _0x0838.byte
#define     CH3SCFG_RELOAD              _0x0838.bit.b7
#define     CH3SCFG_INCEN               _0x0838.bit.b5
#define     CH3SCFG_SRCSEL              _0x0838.b4_0.b4_0
                                        
//==========================
//          CH3DCFG
//==========================
#define     CH3DCFG                     _0x0839.byte
#define     CH3DCFG_RELOAD              _0x0839.bit.b7
#define     CH3DCFG_INCEN               _0x0839.bit.b5
#define     CH3DCFG_DSTSEL              _0x0839.b4_0.b4_0
                                        
//==========================
//          CH3CNT0, CH3CNT1
//==========================
#define     CH3CNT                      _0x083A.word
#define     CH3CNT0                     _0x083A.byte[0]
#define     CH3CNT0_CHCNT               _0x083A.byte[0]
#define     CH3CNT1                     _0x083A.byte[1]
#define     CH3CNT1_CHCNT               _0x083A.byte[1]
                                        
//==========================
//          CH3SA0, CH3SA1
//==========================
#define     CH3SA                       _0x083C.word
#define     CH3SA0                      _0x083C.byte[0]
#define     CH3SA0_CHSA                 _0x083C.byte[0]
#define     CH3SA1                      _0x083C.byte[1]
#define     CH3SA1_CHSA                 _0x083C.byte[1]

//==========================            
//          CH3SA2
//==========================
#define     CH3SA2                      _0x083E.byte
#define     CH3SA2_MEMORY_SEL           _0x083E.bit.b0

//==========================
//          CH3DA0, CH3DA1
//==========================
#define     CH3DA                       _0x0840.word
#define     CH3DA0                      _0x0840.byte[0]
#define     CH3DA0_CHDA                 _0x0840.byte[0]
#define     CH3DA1                      _0x0840.byte[1]
#define     CH3DA1_CHDA                 _0x0840.byte[1]

//==========================
//          CH3DA2
//==========================
#define     CH3DA2                      _0x0842.byte
#define     CH3DA2_MEMORY_SEL           _0x0842.bit.b0

//==========================
//          CRCCR
//==========================
#define     CRCCR                       _0x0850.byte
#define     CRCCR_SETONE                _0x0850.bit.b1
#define     CRCCR_CRCEN                 _0x0850.bit.b0

//==========================
//          CRCDI
//==========================
#define     CRCDI                       _0x0852.byte

//==========================
//          CRCDO0
//==========================
#define     CRCDO0                      _0x0854.byte

//==========================
//          CRCDO1
//==========================
#define     CRCDO1                      _0x0855.byte

//==========================
//          DICCR
//==========================
#define     DICCR                       _0x0858.byte
#define     DICCR_BUSY                  _0x0858.bit.b7
#define     DICCR_DICIE                 _0x0858.bit.b1
#define     DICCR_DICEN                 _0x0858.bit.b0

//==========================
//          DICSR
//==========================
#define     DICSR                       _0x0859.byte
#define     DICSR_ERR_OVER              _0x0859.bit.b1
#define     DICSR_ERR_ADDR              _0x0859.bit.b0

//==========================
//          DICCNT0
//==========================
#define     DICCNT0                     _0x085A.byte

//==========================
//          DICCNT1
//==========================
#define     DICCNT1                     _0x085B.byte

//==========================
//          DICADR0
//==========================
#define     DICADR0                     _0x085C.byte

//==========================
//          DICADR1
//==========================
#define     DICADR1                     _0x085D.byte

//==========================
//          DICADR2
//==========================
#define     DICADR2                     _0x085E.byte
#define     DICADR2_AREA                _0x085E.b4_0.b4_0

//==========================
//          AESCR
//==========================
#define     AESCR                       _0x0860.byte
#define     AESCR_CLKDIV                _0x0860.b7_6.b7_6
#define     AESCR_CLKSEL                _0x0860.bit.b5
#define     AESCR_AESIE                 _0x0860.bit.b3
#define     AESCR_KEYSZ                 _0x0860.b2_1.b2_1
#define     AESCR_AESEN                 _0x0860.bit.b0
                                    
//==========================
//          AESMD
//==========================
#define     AESMD                       _0x0861.byte

//==========================
//          AESSR
//==========================
#define     AESSR                       _0x0862.byte
#define     AESSR_BUSY                  _0x0862.bit.b7
#define     AESSR_AESERR                _0x0862.b3_0.b3_0
                                    
//==========================
//          AESIN
//==========================
#define     AESIN                       _0x0864.byte

//==========================
//          AESOUT
//==========================
#define     AESOUT                      _0x0865.byte

//==========================
//          TRNGCR
//==========================
#define     TRNGCR                      _0x08C8.byte
#define     TRNGCR_TRNGIF               _0x08C8.bit.b3
#define     TRNGCR_TRNGIE               _0x08C8.bit.b2
#define     TRNGCR_TRNGRDY              _0x08C8.bit.b1
#define     TRNGCR_TRNGEN               _0x08C8.bit.b0


//==========================
//          TRNGCFG
//==========================
#define     TRNGCFG                     _0x08C9.byte
#define     TRNGCFG_RTMR                _0x08C9.b5_4.b5_4
#define     TRNGCFG_CAPM                _0x08C9.bit.b3
#define     TRNGCFG_TRNGMD              _0x08C9.b2_1.b2_1
#define     TRNGCFG_MDRE                _0x08C9.bit.b0

//==========================
//          TRNGDR0
//==========================
#define     TRNGDR0                     _0x08CC.byte

//==========================
//          TRNGDR1
//==========================
#define     TRNGDR1                     _0x08CD.byte

//==========================
//          TRNGDR2
//==========================
#define     TRNGDR2                     _0x08CE.byte

//==========================
//          TRNGDR3
//==========================
#define     TRNGDR3                     _0x08CF.byte

//==========================
//          TAMPERCR
//==========================
#define     TAMPERCR                    _0x08D0.byte
#define     TAMPERCR_TAMPERIE           _0x08D0.bit.b7
#define     TAMPERCR_HVDEN              _0x08D0.bit.b3
#define     TAMPERCR_MTOEN              _0x08D0.bit.b1
#define     TAMPERCR_MTSEN              _0x08D0.bit.b0
                                        
//==========================
//          TAMPERRSP
//==========================
#define     TAMPERRSP                   _0x08D1.byte
#define     TAMPERRSP_HVDRSP            _0x08D1.b3_2.b3_2
#define     TAMPERRSP_MTPRS             _0x08D1.b1_0.b1_0
                                        
//==========================
//          TAMPERDR
//==========================
#define     TAMPERDR                    _0x08D2.byte

//==========================            
//          TAMPERSR
//==========================
#define     TAMPERSR                    _0x08D3.byte
#define     TAMPERSR_TPIN1              _0x08D3.bit.b7
#define     TAMPERSR_TPIN0              _0x08D3.bit.b6
#define     TAMPERSR_HVD                _0x08D3.bit.b3
#define     TAMPERSR_MTO                _0x08D3.bit.b1
#define     TAMPERSR_MTS                _0x08D3.bit.b0
 
//==========================
//          TAMPERRSP1
//==========================
#define     TAMPERRSP1                  _0x08D4.byte
#define     TAMPERRSP1_TPIN1RSP         _0x08D4.b3_2.b3_2
#define     TAMPERRSP1_TPIN0RSP         _0x08D4.b1_0.b1_0

 
//==========================
//          SHACR0
//==========================
#define     SHACR0                      _0x08E0.byte
#define     SHACR0_CONTI                _0x08E0.bit.b5
#define     SHACR0_AUTO                 _0x08E0.bit.b3
#define     SHACR0_PAD_EN               _0x08E0.bit.b2
#define     SHACR0_IE                   _0x08E0.bit.b1
#define     SHACR0_START                _0x08E0.bit.b0
                                        
//==========================
//          SHACR1
//==========================
#define     SHACR1                      _0x08E1.byte
#define     SHACR1_BUSY                 _0x08E1.bit.b7
#define     SHACR1_FULL                 _0x08E1.bit.b5
#define     SHACR1_PAD_DONE             _0x08E1.bit.b1
#define     SHACR1_BLOCK_DONE           _0x08E1.bit.b0
                                  
//==========================
//          SHABSZ0
//==========================
#define     SHABSZ0                     _0x08E4.byte

//==========================
//          SHABSZ1
//==========================
#define     SHABSZ1                     _0x08E5.byte

//==========================
//          SHABSZ2
//==========================
#define     SHABSZ2                     _0x08E6.byte

//==========================
//          SHABSZ3
//==========================
#define     SHABSZ3                     _0x08E7.byte

//==========================
//          SHAADR0
//==========================
#define     SHAADR0                     _0x08E8.byte

//==========================
//          SHAADR1
//==========================
#define     SHAADR1                     _0x08E9.byte

//==========================
//          SHAADR2
//==========================
#define     SHAADR2                     _0x08EA.byte

//==========================
//          SHADO
//==========================
#define     SHADO                       _0x08EC.byte

//==========================
//          SHADI
//==========================
#define     SHADI                       _0x08EE.byte


#endif

