//******************************************************************************
// file         : SQ7705_SFR_addr.h
// version      : V1.3 (2025/03/13)
// description  : 1. define the architecture of the continuous bit combination of special registers
//                2. declare the image address of the special function register
// note         : 
//******************************************************************************
#ifndef _SQ7705_SFR_ADDR_H_
#define _SQ7705_SFR_ADDR_H_

/* This definition is for I/O variable and extern definition */
/* So please do not use the name "IO_MEM".*/
#ifdef IO_MEM
#define EXTERN
#else
#define EXTERN extern
#endif

//****************************************************
#ifndef uchar
#define uchar unsigned char
#endif
#ifndef uint
#define uint  unsigned int
#endif
#ifndef ulong
#define ulong unsigned long
#endif
//****************************************************

//****************************************************
//  1. define the architecture of the continuous bit combination of special registers **************
//****************************************************

//****************************************************
//=== combination of single bit ======
typedef struct
{
    uchar   b7:1;
    uchar   b6:1;
    uchar   b5:1;
    uchar   b4:1;
    uchar   b3:1;
    uchar   b2:1;
    uchar   b1:1;
    uchar   b0:1;
} BIT8_LIST;
typedef struct
{
    uint    b15:1;
    uint    b14:1;
    uint    b13:1;
    uint    b12:1;
    uint    b11:1;
    uint    b10:1;
    uint    b9:1;
    uint    b8:1;
    uint    b7:1;
    uint    b6:1;
    uint    b5:1;
    uint    b4:1;
    uint    b3:1;
    uint    b2:1;
    uint    b1:1;
    uint    b0:1;
} BIT16_LIST;

//****************************************************
//=== combination of multiple bits ======
typedef struct {                uchar b7_6:2;   uchar bd:6; } BIT8_7_6;
typedef struct {                uchar b7_5:3;   uchar bd:5; } BIT8_7_5;
typedef struct {                uchar b7_4:4;   uchar bd:4; } BIT8_7_4;
typedef struct {                uchar b7_3:5;   uchar bd:3; } BIT8_7_3;
typedef struct {                uchar b7_2:6;   uchar bd:2; } BIT8_7_2;
typedef struct {                uchar b7_1:7;   uchar bd:1; } BIT8_7_1;

typedef struct { uchar bu:1;    uchar b6_5:2;   uchar bd:5; } BIT8_6_5;
typedef struct { uchar bu:1;    uchar b6_4:3;   uchar bd:4; } BIT8_6_4;
typedef struct { uchar bu:1;    uchar b6_3:4;   uchar bd:3; } BIT8_6_3;
typedef struct { uchar bu:1;    uchar b6_2:5;   uchar bd:2; } BIT8_6_2;
typedef struct { uchar bu:1;    uchar b6_1:6;   uchar bd:1; } BIT8_6_1;
typedef struct { uchar bu:1;    uchar b6_0:7;               } BIT8_6_0;

typedef struct { uchar bu:2;    uchar b5_4:2;   uchar bd:4; } BIT8_5_4;
typedef struct { uchar bu:2;    uchar b5_3:3;   uchar bd:3; } BIT8_5_3;
typedef struct { uchar bu:2;    uchar b5_2:4;   uchar bd:2; } BIT8_5_2;
typedef struct { uchar bu:2;    uchar b5_1:5;   uchar bd:1; } BIT8_5_1;
typedef struct { uchar bu:2;    uchar b5_0:6;               } BIT8_5_0;

typedef struct { uchar bu:3;    uchar b4_3:2;   uchar bd:3; } BIT8_4_3;
typedef struct { uchar bu:3;    uchar b4_2:3;   uchar bd:2; } BIT8_4_2;
typedef struct { uchar bu:3;    uchar b4_1:4;   uchar bd:1; } BIT8_4_1;
typedef struct { uchar bu:3;    uchar b4_0:5;               } BIT8_4_0;

typedef struct { uchar bu:4;    uchar b3_2:2;   uchar bd:2; } BIT8_3_2;
typedef struct { uchar bu:4;    uchar b3_1:3;   uchar bd:1; } BIT8_3_1;
typedef struct { uchar bu:4;    uchar b3_0:4;               } BIT8_3_0;

typedef struct { uchar bu:5;    uchar b2_1:2;   uchar bd:1; } BIT8_2_1;
typedef struct { uchar bu:5;    uchar b2_0:3;               } BIT8_2_0;

typedef struct { uchar bu:6;    uchar b1_0:2;               } BIT8_1_0;

//****************************************************
//=== multiple combination definition of BIT_LIST_8 ======
typedef union
{
    uchar       byte;
    BIT8_LIST   bit;
    BIT8_7_6    b7_6;
    BIT8_7_5    b7_5;
    BIT8_7_4    b7_4;
    BIT8_7_3    b7_3;
    BIT8_7_2    b7_2;
    BIT8_7_1    b7_1;
    BIT8_6_5    b6_5;
    BIT8_6_4    b6_4;
    BIT8_6_3    b6_3;
    BIT8_6_2    b6_2;
    BIT8_6_1    b6_1;
    BIT8_6_0    b6_0;
    BIT8_5_4    b5_4;
    BIT8_5_3    b5_3;
    BIT8_5_2    b5_2;
    BIT8_5_1    b5_1;
    BIT8_5_0    b5_0;
    BIT8_4_3    b4_3;
    BIT8_4_2    b4_2;
    BIT8_4_1    b4_1;
    BIT8_4_0    b4_0;
    BIT8_3_2    b3_2;
    BIT8_3_1    b3_1;
    BIT8_3_0    b3_0;
    BIT8_2_1    b2_1;
    BIT8_2_0    b2_0;
    BIT8_1_0    b1_0;
} BIT_LIST_8;

//****************************************************
//=== multiple combination definition of BIT_LIST_16 ======
typedef union
{
    uint        word;
    uchar       byte[2];
    BIT16_LIST  bit;
} BIT_LIST_16;

//****************************************************
//=== ADC multiple combination definition of BIT_LIST_16 ======
typedef union
{
    uint        word;
    uchar       byte[2];
    BIT_LIST_8  blst8_byte[2];
    BIT16_LIST  bit;
} BIT_LIST_16_ADC;

//****************************************************
//  end of --> define the architecture of the continuous bit combination of special registers ********
//****************************************************


//****************************************************
//  2. declare the image address of the special function register ******************
//****************************************************
//***[SFR] *******************************************
volatile EXTERN BIT_LIST_8              __io(0x0006)    _0x0006;
volatile EXTERN BIT_LIST_8              __io(0x0007)    _0x0007;
volatile EXTERN BIT_LIST_8              __io(0x0008)    _0x0008;

volatile EXTERN BIT_LIST_8              __io(0x000A)    _0x000A;
volatile EXTERN BIT_LIST_8              __io(0x000B)    _0x000B;
volatile EXTERN BIT_LIST_8              __io(0x000C)    _0x000C;
volatile EXTERN BIT_LIST_8              __io(0x000D)    _0x000D;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0010)    _0x0010;
volatile EXTERN BIT_LIST_8              __io(0x0011)    _0x0011;
volatile EXTERN BIT_LIST_8              __io(0x0012)    _0x0012;
volatile EXTERN BIT_LIST_8              __io(0x0013)    _0x0013;
volatile EXTERN BIT_LIST_8              __io(0x0014)    _0x0014;
volatile EXTERN BIT_LIST_8              __io(0x0015)    _0x0015;
volatile EXTERN BIT_LIST_8              __io(0x0016)    _0x0016;
volatile EXTERN BIT_LIST_8              __io(0x0017)    _0x0017;
volatile EXTERN BIT_LIST_8              __io(0x0018)    _0x0018;
volatile EXTERN BIT_LIST_8              __io(0x0019)    _0x0019;
volatile EXTERN BIT_LIST_8              __io(0x001A)    _0x001A;
volatile EXTERN BIT_LIST_8              __io(0x001B)    _0x001B;
volatile EXTERN BIT_LIST_8              __io(0x001C)    _0x001C;
volatile EXTERN BIT_LIST_8              __io(0x001D)    _0x001D;
volatile EXTERN BIT_LIST_8              __io(0x001E)    _0x001E;
volatile EXTERN BIT_LIST_8              __io(0x001F)    _0x001F;
//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0020)    _0x0020;
volatile EXTERN BIT_LIST_8              __io(0x0021)    _0x0021;
volatile EXTERN BIT_LIST_8              __io(0x0022)    _0x0022;
volatile EXTERN BIT_LIST_8              __io(0x0023)    _0x0023;
volatile EXTERN BIT_LIST_8              __io(0x0024)    _0x0024;
volatile EXTERN BIT_LIST_8              __io(0x0025)    _0x0025;
volatile EXTERN BIT_LIST_8              __io(0x0026)    _0x0026;
volatile EXTERN BIT_LIST_8              __io(0x0027)    _0x0027;
volatile EXTERN BIT_LIST_8              __io(0x0028)    _0x0028;
volatile EXTERN BIT_LIST_8              __io(0x0029)    _0x0029;
volatile EXTERN BIT_LIST_8              __io(0x002A)    _0x002A;
volatile EXTERN BIT_LIST_8              __io(0x002B)    _0x002B;
volatile EXTERN BIT_LIST_8              __io(0x002E)    _0x002E;
volatile EXTERN BIT_LIST_8              __io(0x002F)    _0x002F;
//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0030)    _0x0030;
volatile EXTERN BIT_LIST_8              __io(0x0031)    _0x0031;
volatile EXTERN BIT_LIST_8              __io(0x0032)    _0x0032;
volatile EXTERN BIT_LIST_8              __io(0x0035)    _0x0035;
volatile EXTERN BIT_LIST_8              __io(0x0036)    _0x0036;

volatile EXTERN BIT_LIST_8              __io(0x0038)    _0x0038;
volatile EXTERN BIT_LIST_8              __io(0x0039)    _0x0039;
volatile EXTERN BIT_LIST_8              __io(0x003A)    _0x003A;
volatile EXTERN BIT_LIST_8              __io(0x003B)    _0x003B;

volatile EXTERN BIT_LIST_8              __io(0x003E)    _0x003E;
volatile EXTERN BIT_LIST_8              __io(0x003F)    _0x003F;
//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0040)    _0x0040;
volatile EXTERN BIT_LIST_8              __io(0x0041)    _0x0041;
volatile EXTERN BIT_LIST_8              __io(0x0042)    _0x0042;
volatile EXTERN BIT_LIST_8              __io(0x0043)    _0x0043;
volatile EXTERN BIT_LIST_8              __io(0x0044)    _0x0044;
volatile EXTERN BIT_LIST_8              __io(0x0048)    _0x0048;
volatile EXTERN BIT_LIST_8              __io(0x0049)    _0x0049;
volatile EXTERN BIT_LIST_8              __io(0x004A)    _0x004A;
volatile EXTERN BIT_LIST_8              __io(0x004B)    _0x004B;
volatile EXTERN BIT_LIST_8              __io(0x004C)    _0x004C;
//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0050)    _0x0050;
volatile EXTERN BIT_LIST_8              __io(0x0051)    _0x0051;
volatile EXTERN BIT_LIST_8              __io(0x0052)    _0x0052;
volatile EXTERN BIT_LIST_8              __io(0x0053)    _0x0053;
volatile EXTERN BIT_LIST_8              __io(0x0054)    _0x0054;
volatile EXTERN BIT_LIST_8              __io(0x0055)    _0x0055;
volatile EXTERN BIT_LIST_8              __io(0x0056)    _0x0056;
volatile EXTERN BIT_LIST_8              __io(0x0057)    _0x0057;
volatile EXTERN BIT_LIST_8              __io(0x0058)    _0x0058;
volatile EXTERN BIT_LIST_8              __io(0x0059)    _0x0059;
volatile EXTERN BIT_LIST_8              __io(0x005A)    _0x005A;
volatile EXTERN BIT_LIST_8              __io(0x005B)    _0x005B;
volatile EXTERN BIT_LIST_8              __io(0x005C)    _0x005C;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0060)    _0x0060;
volatile EXTERN BIT_LIST_8              __io(0x0061)    _0x0061;
volatile EXTERN BIT_LIST_8              __io(0x0062)    _0x0062;
volatile EXTERN BIT_LIST_8              __io(0x0063)    _0x0063;
volatile EXTERN BIT_LIST_8              __io(0x0064)    _0x0064;
volatile EXTERN BIT_LIST_8              __io(0x0065)    _0x0065;
volatile EXTERN BIT_LIST_8              __io(0x0066)    _0x0066;
volatile EXTERN BIT_LIST_8              __io(0x0067)    _0x0067;
volatile EXTERN BIT_LIST_8              __io(0x0068)    _0x0068;
volatile EXTERN BIT_LIST_8              __io(0x0069)    _0x0069;
volatile EXTERN BIT_LIST_8              __io(0x006A)    _0x006A;
volatile EXTERN BIT_LIST_8              __io(0x006B)    _0x006B;
volatile EXTERN BIT_LIST_8              __io(0x006C)    _0x006C;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0070)    _0x0070;
volatile EXTERN BIT_LIST_8              __io(0x0071)    _0x0071;
volatile EXTERN BIT_LIST_8              __io(0x0072)    _0x0072;
volatile EXTERN BIT_LIST_8              __io(0x0073)    _0x0073;
volatile EXTERN BIT_LIST_8              __io(0x0074)    _0x0074;
volatile EXTERN BIT_LIST_8              __io(0x0075)    _0x0075;
volatile EXTERN BIT_LIST_8              __io(0x0076)    _0x0076;
volatile EXTERN BIT_LIST_8              __io(0x0077)    _0x0077;
volatile EXTERN BIT_LIST_8              __io(0x0078)    _0x0078;
volatile EXTERN BIT_LIST_8              __io(0x0079)    _0x0079;
volatile EXTERN BIT_LIST_8              __io(0x007A)    _0x007A;
volatile EXTERN BIT_LIST_8              __io(0x007B)    _0x007B;
volatile EXTERN BIT_LIST_8              __io(0x007C)    _0x007C;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0080)    _0x0080;
volatile EXTERN BIT_LIST_8              __io(0x0081)    _0x0081;
volatile EXTERN BIT_LIST_8              __io(0x0082)    _0x0082;

volatile EXTERN BIT_LIST_16             __io(0x0084)    _0x0084;
//volatile EXTERN BIT_LIST_8              __io(0x0085)    _0x0085;
volatile EXTERN BIT_LIST_16             __io(0x0086)    _0x0086;
//volatile EXTERN BIT_LIST_8              __io(0x0087)    _0x0087;
volatile EXTERN BIT_LIST_8              __io(0x0088)    _0x0088;
volatile EXTERN BIT_LIST_8              __io(0x0089)    _0x0089;
volatile EXTERN BIT_LIST_8              __io(0x008A)    _0x008A;

volatile EXTERN BIT_LIST_16             __io(0x008C)    _0x008C;
//volatile EXTERN BIT_LIST_8              __io(0x008D)    _0x008D;
volatile EXTERN BIT_LIST_16             __io(0x008E)    _0x008E;
//volatile EXTERN BIT_LIST_8              __io(0x008F)    _0x008F;
//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0090)    _0x0090;
volatile EXTERN BIT_LIST_8              __io(0x0091)    _0x0091;
volatile EXTERN BIT_LIST_8              __io(0x0092)    _0x0092;

volatile EXTERN BIT_LIST_16             __io(0x0094)    _0x0094;
//volatile EXTERN BIT_LIST_8              __io(0x0095)    _0x0095;
volatile EXTERN BIT_LIST_16             __io(0x0096)    _0x0096;
//volatile EXTERN BIT_LIST_8              __io(0x0097)    _0x0097;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x00A0)    _0x00A0;
volatile EXTERN BIT_LIST_8              __io(0x00A1)    _0x00A1;
volatile EXTERN BIT_LIST_8              __io(0x00A2)    _0x00A2;
volatile EXTERN BIT_LIST_8              __io(0x00A3)    _0x00A3;
volatile EXTERN BIT_LIST_8              __io(0x00A4)    _0x00A4;
volatile EXTERN BIT_LIST_8              __io(0x00A5)    _0x00A5;
volatile EXTERN BIT_LIST_8              __io(0x00A6)    _0x00A6;
volatile EXTERN BIT_LIST_8              __io(0x00A7)    _0x00A7;
volatile EXTERN BIT_LIST_8              __io(0x00A8)    _0x00A8;
volatile EXTERN BIT_LIST_8              __io(0x00A9)    _0x00A9;
volatile EXTERN BIT_LIST_8              __io(0x00AA)    _0x00AA;
volatile EXTERN BIT_LIST_8              __io(0x00AB)    _0x00AB;
volatile EXTERN BIT_LIST_8              __io(0x00AC)    _0x00AC;
volatile EXTERN BIT_LIST_8              __io(0x00AD)    _0x00AD;
volatile EXTERN BIT_LIST_8              __io(0x00AE)    _0x00AE;
volatile EXTERN BIT_LIST_8              __io(0x00AF)    _0x00AF;
//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x00B0)    _0x00B0;
volatile EXTERN BIT_LIST_8              __io(0x00B1)    _0x00B1;

volatile EXTERN BIT_LIST_8              __io(0x00B8)    _0x00B8;
volatile EXTERN BIT_LIST_8              __io(0x00B9)    _0x00B9;
volatile EXTERN BIT_LIST_8              __io(0x00BA)    _0x00BA;
volatile EXTERN BIT_LIST_8              __io(0x00BB)    _0x00BB;
volatile EXTERN BIT_LIST_8              __io(0x00BC)    _0x00BC;
volatile EXTERN BIT_LIST_8              __io(0x00BD)    _0x00BD;
volatile EXTERN BIT_LIST_8              __io(0x00BE)    _0x00BE;
volatile EXTERN BIT_LIST_8              __io(0x00BF)    _0x00BF;
volatile EXTERN BIT_LIST_8              __io(0x00C0)    _0x00C0;
volatile EXTERN BIT_LIST_8              __io(0x00C1)    _0x00C1;
//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x00E0)    _0x00E0;
volatile EXTERN BIT_LIST_8              __io(0x00E1)    _0x00E1;
volatile EXTERN BIT_LIST_8              __io(0x00E2)    _0x00E2;
volatile EXTERN BIT_LIST_8              __io(0x00E3)    _0x00E3;
volatile EXTERN BIT_LIST_8              __io(0x00E4)    _0x00E4;
volatile EXTERN BIT_LIST_8              __io(0x00E5)    _0x00E5;
volatile EXTERN BIT_LIST_8              __io(0x00E6)    _0x00E6;
volatile EXTERN BIT_LIST_8              __io(0x00E7)    _0x00E7;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x00F0)    _0x00F0;
volatile EXTERN BIT_LIST_8              __io(0x00F1)    _0x00F1;
volatile EXTERN BIT_LIST_8              __io(0x00F2)    _0x00F2;
volatile EXTERN BIT_LIST_8              __io(0x00F3)    _0x00F3;
volatile EXTERN BIT_LIST_8              __io(0x00F4)    _0x00F4;
volatile EXTERN BIT_LIST_8              __io(0x00F5)    _0x00F5;
volatile EXTERN BIT_LIST_8              __io(0x00F6)    _0x00F6;
volatile EXTERN BIT_LIST_8              __io(0x00F7)    _0x00F7;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0100)    _0x0100;
volatile EXTERN BIT_LIST_8              __io(0x0101)    _0x0101;
volatile EXTERN BIT_LIST_8              __io(0x0102)    _0x0102;
volatile EXTERN BIT_LIST_8              __io(0x0103)    _0x0103;
volatile EXTERN BIT_LIST_8              __io(0x0104)    _0x0104;
volatile EXTERN BIT_LIST_8              __io(0x0105)    _0x0105;
volatile EXTERN BIT_LIST_8              __io(0x0106)    _0x0106;
volatile EXTERN BIT_LIST_8              __io(0x0107)    _0x0107;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0110)    _0x0110;
volatile EXTERN BIT_LIST_8              __io(0x0111)    _0x0111;
volatile EXTERN BIT_LIST_8              __io(0x0112)    _0x0112;
volatile EXTERN BIT_LIST_8              __io(0x0113)    _0x0113;
volatile EXTERN BIT_LIST_8              __io(0x0114)    _0x0114;
volatile EXTERN BIT_LIST_8              __io(0x0115)    _0x0115;
volatile EXTERN BIT_LIST_8              __io(0x0116)    _0x0116;
volatile EXTERN BIT_LIST_8              __io(0x0117)    _0x0117;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0120)    _0x0120;
volatile EXTERN BIT_LIST_8              __io(0x0121)    _0x0121;
volatile EXTERN BIT_LIST_8              __io(0x0122)    _0x0122;
volatile EXTERN BIT_LIST_8              __io(0x0123)    _0x0123;
volatile EXTERN BIT_LIST_8              __io(0x0124)    _0x0124;
volatile EXTERN BIT_LIST_8              __io(0x0125)    _0x0125;
volatile EXTERN BIT_LIST_8              __io(0x0126)    _0x0126;
volatile EXTERN BIT_LIST_8              __io(0x0127)    _0x0127;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0130)    _0x0130;
volatile EXTERN BIT_LIST_8              __io(0x0131)    _0x0131;
volatile EXTERN BIT_LIST_8              __io(0x0132)    _0x0132;
volatile EXTERN BIT_LIST_8              __io(0x0133)    _0x0133;
volatile EXTERN BIT_LIST_8              __io(0x0134)    _0x0134;
volatile EXTERN BIT_LIST_8              __io(0x0135)    _0x0135;
volatile EXTERN BIT_LIST_8              __io(0x0136)    _0x0136;
volatile EXTERN BIT_LIST_8              __io(0x0137)    _0x0137;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0140)    _0x0140;
volatile EXTERN BIT_LIST_8              __io(0x0141)    _0x0141;
volatile EXTERN BIT_LIST_8              __io(0x0142)    _0x0142;
volatile EXTERN BIT_LIST_8              __io(0x0143)    _0x0143;
volatile EXTERN BIT_LIST_8              __io(0x0144)    _0x0144;
volatile EXTERN BIT_LIST_8              __io(0x0145)    _0x0145;
volatile EXTERN BIT_LIST_8              __io(0x0146)    _0x0146;
volatile EXTERN BIT_LIST_8              __io(0x0147)    _0x0147;
volatile EXTERN BIT_LIST_8              __io(0x0148)    _0x0148;
volatile EXTERN BIT_LIST_8              __io(0x0149)    _0x0149;
volatile EXTERN BIT_LIST_8              __io(0x014A)    _0x014A;
volatile EXTERN BIT_LIST_8              __io(0x014B)    _0x014B;
volatile EXTERN BIT_LIST_8              __io(0x014C)    _0x014C;
volatile EXTERN BIT_LIST_8              __io(0x014D)    _0x014D;
volatile EXTERN BIT_LIST_8              __io(0x014E)    _0x014E;
volatile EXTERN BIT_LIST_8              __io(0x014F)    _0x014F;
//--------------------------------------------------------------
//~0x0150~0x0160 reserver
//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0170)    _0x0170;
volatile EXTERN BIT_LIST_8              __io(0x0171)    _0x0171;


volatile EXTERN BIT_LIST_8              __io(0x0178)    _0x0178;
volatile EXTERN BIT_LIST_8              __io(0x0179)    _0x0179;
volatile EXTERN BIT_LIST_8              __io(0x017A)    _0x017A;
volatile EXTERN BIT_LIST_8              __io(0x017B)    _0x017B;
volatile EXTERN BIT_LIST_8              __io(0x017C)    _0x017C;
volatile EXTERN BIT_LIST_8              __io(0x017D)    _0x017D;
//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0180)    _0x0180;
volatile EXTERN BIT_LIST_8              __io(0x0181)    _0x0181;
volatile EXTERN BIT_LIST_8              __io(0x0182)    _0x0182;
volatile EXTERN BIT_LIST_8              __io(0x0183)    _0x0183;
volatile EXTERN BIT_LIST_8              __io(0x0184)    _0x0184;
volatile EXTERN BIT_LIST_8              __io(0x0185)    _0x0185;

volatile EXTERN BIT_LIST_8              __io(0x0188)    _0x0188;
volatile EXTERN BIT_LIST_8              __io(0x0189)    _0x0189;
volatile EXTERN BIT_LIST_8              __io(0x018A)    _0x018A;
volatile EXTERN BIT_LIST_8              __io(0x018B)    _0x018B;
volatile EXTERN BIT_LIST_8              __io(0x018C)    _0x018C;
volatile EXTERN BIT_LIST_8              __io(0x018D)    _0x018D;
volatile EXTERN BIT_LIST_8              __io(0x018E)    _0x018E;
volatile EXTERN BIT_LIST_8              __io(0x018F)    _0x018F;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0190)    _0x0190;
volatile EXTERN BIT_LIST_8              __io(0x0191)    _0x0191;
volatile EXTERN BIT_LIST_8              __io(0x0192)    _0x0192;
volatile EXTERN BIT_LIST_8              __io(0x0193)    _0x0193;
volatile EXTERN BIT_LIST_8              __io(0x0194)    _0x0194;
volatile EXTERN BIT_LIST_8              __io(0x0195)    _0x0195;
volatile EXTERN BIT_LIST_8              __io(0x0196)    _0x0196;
volatile EXTERN BIT_LIST_8              __io(0x0197)    _0x0197;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x01A0)    _0x01A0;
volatile EXTERN BIT_LIST_8              __io(0x01A1)    _0x01A1;
volatile EXTERN BIT_LIST_8              __io(0x01A2)    _0x01A2;
volatile EXTERN BIT_LIST_8              __io(0x01A3)    _0x01A3;
volatile EXTERN BIT_LIST_8              __io(0x01A4)    _0x01A4;
volatile EXTERN BIT_LIST_8              __io(0x01A5)    _0x01A5;
volatile EXTERN BIT_LIST_8              __io(0x01A6)    _0x01A6;
volatile EXTERN BIT_LIST_8              __io(0x01A7)    _0x01A7;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x01B0)    _0x01B0;
volatile EXTERN BIT_LIST_8              __io(0x01B1)    _0x01B1;
volatile EXTERN BIT_LIST_8              __io(0x01B2)    _0x01B2;
volatile EXTERN BIT_LIST_8              __io(0x01B3)    _0x01B3;
volatile EXTERN BIT_LIST_8              __io(0x01B4)    _0x01B4;
volatile EXTERN BIT_LIST_8              __io(0x01B5)    _0x01B5;
volatile EXTERN BIT_LIST_8              __io(0x01B6)    _0x01B6;
volatile EXTERN BIT_LIST_8              __io(0x01B7)    _0x01B7;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x01C0)    _0x01C0;
volatile EXTERN BIT_LIST_8              __io(0x01C1)    _0x01C1;
volatile EXTERN BIT_LIST_8              __io(0x01C2)    _0x01C2;
volatile EXTERN BIT_LIST_8              __io(0x01C3)    _0x01C3;
volatile EXTERN BIT_LIST_8              __io(0x01C4)    _0x01C4;
volatile EXTERN BIT_LIST_8              __io(0x01C5)    _0x01C5;
volatile EXTERN BIT_LIST_8              __io(0x01C6)    _0x01C6;
volatile EXTERN BIT_LIST_8              __io(0x01C7)    _0x01C7;
volatile EXTERN BIT_LIST_8              __io(0x01C8)    _0x01C8;
volatile EXTERN BIT_LIST_8              __io(0x01C9)    _0x01C9;
volatile EXTERN BIT_LIST_8              __io(0x01CA)    _0x01CA;
volatile EXTERN BIT_LIST_8              __io(0x01CB)    _0x01CB;
volatile EXTERN BIT_LIST_8              __io(0x01CC)    _0x01CC;
volatile EXTERN BIT_LIST_8              __io(0x01CD)    _0x01CD;
volatile EXTERN BIT_LIST_8              __io(0x01CE)    _0x01CE;
volatile EXTERN BIT_LIST_8              __io(0x01CF)    _0x01CF;
//--------------------------------------------------------------
//~0x01E0~0x01F0 reserver
//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0200)    _0x0200;
volatile EXTERN BIT_LIST_8              __io(0x0201)    _0x0201;
volatile EXTERN BIT_LIST_8              __io(0x0202)    _0x0202;
volatile EXTERN BIT_LIST_8              __io(0x0203)    _0x0203;
volatile EXTERN BIT_LIST_8              __io(0x0204)    _0x0204;
volatile EXTERN BIT_LIST_8              __io(0x0205)    _0x0205;
volatile EXTERN BIT_LIST_8              __io(0x0206)    _0x0206;
volatile EXTERN BIT_LIST_8              __io(0x0207)    _0x0207;
volatile EXTERN BIT_LIST_8              __io(0x0208)    _0x0208;

//--------------------------------------------------------------

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0240)    _0x0240;
volatile EXTERN BIT_LIST_8              __io(0x0241)    _0x0241;
volatile EXTERN BIT_LIST_8              __io(0x0242)    _0x0242;
volatile EXTERN BIT_LIST_8              __io(0x0243)    _0x0243;
volatile EXTERN BIT_LIST_8              __io(0x0244)    _0x0244;
volatile EXTERN BIT_LIST_8              __io(0x0245)    _0x0245;
volatile EXTERN BIT_LIST_8              __io(0x0246)    _0x0246;
volatile EXTERN BIT_LIST_8              __io(0x0247)    _0x0247;
volatile EXTERN BIT_LIST_8              __io(0x0248)    _0x0248;
volatile EXTERN BIT_LIST_8              __io(0x0249)    _0x0249;
volatile EXTERN BIT_LIST_8              __io(0x024A)    _0x024A;
volatile EXTERN BIT_LIST_8              __io(0x024B)    _0x024B;
volatile EXTERN BIT_LIST_8              __io(0x024C)    _0x024C;
volatile EXTERN BIT_LIST_8              __io(0x024D)    _0x024D;
volatile EXTERN BIT_LIST_8              __io(0x024E)    _0x024E;
volatile EXTERN BIT_LIST_8              __io(0x024F)    _0x024F;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0250)    _0x0250;
volatile EXTERN BIT_LIST_8              __io(0x0251)    _0x0251;
volatile EXTERN BIT_LIST_8              __io(0x0252)    _0x0252;
volatile EXTERN BIT_LIST_8              __io(0x0253)    _0x0253;
volatile EXTERN BIT_LIST_8              __io(0x0254)    _0x0254;
volatile EXTERN BIT_LIST_8              __io(0x0255)    _0x0255;
volatile EXTERN BIT_LIST_8              __io(0x0256)    _0x0256;
volatile EXTERN BIT_LIST_8              __io(0x0257)    _0x0257;
volatile EXTERN BIT_LIST_8              __io(0x0258)    _0x0258;
volatile EXTERN BIT_LIST_8              __io(0x0259)    _0x0259;
volatile EXTERN BIT_LIST_8              __io(0x025A)    _0x025A;
volatile EXTERN BIT_LIST_8              __io(0x025B)    _0x025B;
volatile EXTERN BIT_LIST_8              __io(0x025C)    _0x025C;
volatile EXTERN BIT_LIST_8              __io(0x025D)    _0x025D;
volatile EXTERN BIT_LIST_8              __io(0x025E)    _0x025E;
volatile EXTERN BIT_LIST_8              __io(0x025F)    _0x025F;


//--------------------------------------------------------------
//Reserver
//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0280)    _0x0280;
volatile EXTERN BIT_LIST_8              __io(0x0281)    _0x0281;

volatile EXTERN BIT_LIST_16             __io(0x0284)    _0x0284;
//volatile EXTERN BIT_LIST_8              __io(0x0285)    _0x0285;
volatile EXTERN BIT_LIST_16             __io(0x0286)    _0x0286;
//volatile EXTERN BIT_LIST_8              __io(0x0287)    _0x0287;
volatile EXTERN BIT_LIST_8              __io(0x0288)    _0x0288;
volatile EXTERN BIT_LIST_8              __io(0x0289)    _0x0289;

volatile EXTERN BIT_LIST_16             __io(0x028C)    _0x028C;
//volatile EXTERN BIT_LIST_8              __io(0x028D)    _0x028D;
volatile EXTERN BIT_LIST_16             __io(0x028E)    _0x028E;
//volatile EXTERN BIT_LIST_8              __io(0x028F)    _0x028F;
//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0300)    _0x0300;
volatile EXTERN BIT_LIST_8              __io(0x0301)    _0x0301;
volatile EXTERN BIT_LIST_8              __io(0x0302)    _0x0302;
volatile EXTERN BIT_LIST_8              __io(0x0304)    _0x0304;

volatile EXTERN BIT_LIST_8              __io(0x0306)    _0x0306;
volatile EXTERN BIT_LIST_8              __io(0x0307)    _0x0307;
volatile EXTERN BIT_LIST_8              __io(0x0308)    _0x0308;

volatile EXTERN BIT_LIST_8              __io(0x030A)    _0x030A;
volatile EXTERN BIT_LIST_8              __io(0x030B)    _0x030B;
volatile EXTERN BIT_LIST_8              __io(0x030C)    _0x030C;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_16_ADC         __io(0x0310)    _0x0310;
//volatile EXTERN BIT_LIST_8              __io(0x0311)    _0x0311;
volatile EXTERN BIT_LIST_16_ADC         __io(0x0312)    _0x0312;
//volatile EXTERN BIT_LIST_8              __io(0x0313)    _0x0313;
volatile EXTERN BIT_LIST_16_ADC         __io(0x0314)    _0x0314;
//volatile EXTERN BIT_LIST_8              __io(0x0315)    _0x0315;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0800)    _0x0800;
volatile EXTERN BIT_LIST_8              __io(0x0801)    _0x0801;
volatile EXTERN BIT_LIST_8              __io(0x0802)    _0x0802;
volatile EXTERN BIT_LIST_8              __io(0x0803)    _0x0803;

volatile EXTERN BIT_LIST_8              __io(0x0805)    _0x0805;
volatile EXTERN BIT_LIST_8              __io(0x0806)    _0x0806;
volatile EXTERN BIT_LIST_8              __io(0x0807)    _0x0807;
volatile EXTERN BIT_LIST_8              __io(0x0808)    _0x0808;
volatile EXTERN BIT_LIST_8              __io(0x0809)    _0x0809;
volatile EXTERN BIT_LIST_16             __io(0x080A)    _0x080A;
//volatile EXTERN BIT_LIST_8              __io(0x080B)    _0x080B;
volatile EXTERN BIT_LIST_16             __io(0x080C)   _0x080C;
//volatile EXTERN BIT_LIST_8              __io(0x080D)    _0x080D;
volatile EXTERN BIT_LIST_8              __io(0x080E)    _0x080E;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_16             __io(0x0810)    _0x0810;
//volatile EXTERN BIT_LIST_8              __io(0x0811)    _0x0811;
volatile EXTERN BIT_LIST_8              __io(0x0812)    _0x0812;


volatile EXTERN BIT_LIST_8              __io(0x0818)    _0x0818;
volatile EXTERN BIT_LIST_8              __io(0x0819)    _0x0819;
volatile EXTERN BIT_LIST_16              __io(0x081A)    _0x081A;
//volatile EXTERN BIT_LIST_8              __io(0x081B)    _0x081B;
volatile EXTERN BIT_LIST_16             __io(0x081C)    _0x081C;
//volatile EXTERN BIT_LIST_8              __io(0x081D)    _0x081D;
volatile EXTERN BIT_LIST_8              __io(0x081E)    _0x081E;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_16             __io(0x0820)    _0x0820;
//volatile EXTERN BIT_LIST_8              __io(0x0821)    _0x0821;
volatile EXTERN BIT_LIST_8              __io(0x0822)    _0x0822;

volatile EXTERN BIT_LIST_8              __io(0x0828)    _0x0828;
volatile EXTERN BIT_LIST_8              __io(0x0829)    _0x0829;
volatile EXTERN BIT_LIST_16             __io(0x082A)    _0x082A;
//volatile EXTERN BIT_LIST_8              __io(0x082B)    _0x082B;
volatile EXTERN BIT_LIST_16             __io(0x082C)    _0x082C;
//volatile EXTERN BIT_LIST_8              __io(0x082D)    _0x082D;
volatile EXTERN BIT_LIST_8              __io(0x082E)    _0x082E;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_16             __io(0x0830)    _0x0830;
//volatile EXTERN BIT_LIST_8              __io(0x0831)    _0x0831;
volatile EXTERN BIT_LIST_8              __io(0x0832)    _0x0832;

volatile EXTERN BIT_LIST_8              __io(0x0838)    _0x0838;
volatile EXTERN BIT_LIST_8              __io(0x0839)    _0x0839;
volatile EXTERN BIT_LIST_16             __io(0x083A)    _0x083A;
//volatile EXTERN BIT_LIST_8              __io(0x083B)    _0x083B;
volatile EXTERN BIT_LIST_16              __io(0x083C)    _0x083C;
//volatile EXTERN BIT_LIST_8              __io(0x083D)    _0x083D;
volatile EXTERN BIT_LIST_8              __io(0x083E)    _0x083E;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_16             __io(0x0840)    _0x0840;
//volatile EXTERN BIT_LIST_8              __io(0x0841)    _0x0841;
volatile EXTERN BIT_LIST_8              __io(0x0842)    _0x0842;


//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0850)    _0x0850;
volatile EXTERN BIT_LIST_8              __io(0x0852)    _0x0852;

volatile EXTERN BIT_LIST_8              __io(0x0854)    _0x0854;
volatile EXTERN BIT_LIST_8              __io(0x0855)    _0x0855;

volatile EXTERN BIT_LIST_8              __io(0x0858)    _0x0858;
volatile EXTERN BIT_LIST_8              __io(0x0859)    _0x0859;
volatile EXTERN BIT_LIST_8              __io(0x085A)    _0x085A;
volatile EXTERN BIT_LIST_8              __io(0x085B)    _0x085B;
volatile EXTERN BIT_LIST_8              __io(0x085C)    _0x085C;
volatile EXTERN BIT_LIST_8              __io(0x085D)    _0x085D;
volatile EXTERN BIT_LIST_8              __io(0x085E)    _0x085E;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x0860)    _0x0860;
volatile EXTERN BIT_LIST_8              __io(0x0861)    _0x0861;
volatile EXTERN BIT_LIST_8              __io(0x0862)    _0x0862;

volatile EXTERN BIT_LIST_8              __io(0x0864)    _0x0864;
volatile EXTERN BIT_LIST_8              __io(0x0865)    _0x0865;

//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x08C0)    _0x08C0;
volatile EXTERN BIT_LIST_8              __io(0x08C1)    _0x08C1;
volatile EXTERN BIT_LIST_8              __io(0x08C2)    _0x08C2;
volatile EXTERN BIT_LIST_8              __io(0x08C3)    _0x08C3;
volatile EXTERN BIT_LIST_8              __io(0x08C4)    _0x08C4;

volatile EXTERN BIT_LIST_8              __io(0x08C8)    _0x08C8;
volatile EXTERN BIT_LIST_8              __io(0x08C9)    _0x08C9;

volatile EXTERN BIT_LIST_8              __io(0x08CC)    _0x08CC;
volatile EXTERN BIT_LIST_8              __io(0x08CD)    _0x08CD;
volatile EXTERN BIT_LIST_8              __io(0x08CE)    _0x08CE;
volatile EXTERN BIT_LIST_8              __io(0x08CF)    _0x08CF;
//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x08D0)    _0x08D0;
volatile EXTERN BIT_LIST_8              __io(0x08D1)    _0x08D1;
volatile EXTERN BIT_LIST_8              __io(0x08D2)    _0x08D2;
volatile EXTERN BIT_LIST_8              __io(0x08D3)    _0x08D3;
volatile EXTERN BIT_LIST_8              __io(0x08D4)    _0x08D4;
//--------------------------------------------------------------
volatile EXTERN BIT_LIST_8              __io(0x08E0)    _0x08E0;
volatile EXTERN BIT_LIST_8              __io(0x08E1)    _0x08E1;

volatile EXTERN BIT_LIST_8              __io(0x08E4)    _0x08E4;
volatile EXTERN BIT_LIST_8              __io(0x08E5)    _0x08E5;
volatile EXTERN BIT_LIST_8              __io(0x08E6)    _0x08E6;
volatile EXTERN BIT_LIST_8              __io(0x08E7)    _0x08E7;
volatile EXTERN BIT_LIST_8              __io(0x08E8)    _0x08E8;
volatile EXTERN BIT_LIST_8              __io(0x08E9)    _0x08E9;
volatile EXTERN BIT_LIST_8              __io(0x08EA)    _0x08EA;
volatile EXTERN BIT_LIST_8              __io(0x08EB)    _0x08EB;
volatile EXTERN BIT_LIST_8              __io(0x08EC)    _0x08EC;
volatile EXTERN BIT_LIST_8              __io(0x08EE)    _0x08EE;

//****************************************************
//  end of --> declare the image address of the special function register ************
//****************************************************

#endif

