//******************************************************************************
// file         : DRV_SQ7705_UART.h
// version      : V1.3 (2025/03/13)
// description  : UART header file
// note         : 
//******************************************************************************
#ifndef _DRV_SQ7705_UART_H__
#define _DRV_SQ7705_UART_H__

#include "TypeDefs.h"
#include "SQ7705_SFR.h"

#define PARITY_NONE      0x00     // no parity
#define PARITY_ODD       0x08     // odd parity
#define PARITY_EVEN      0x18     // even parity
#define PARITY_MASK      0x18

#define STOP_1BIT        0x00     // stop bit length is 1 bit
#define STOP_2BIT        0x01     // stop bit length is 2 bits

// TX function selection
#define TX_OUTPUT_UART   0x00     // UART output
#define TX_OUTPUT_IRDA   0x01     // IrDA output

#define TX               0x00     // transmission
#define RX               0x01     // receiver
#define TRX              0x02     // transmission & receiver

// UART dividing frequency selection
#define DIV_BY1          0x00     // fsysclk/1
#define DIV_BY2          0x01     // fsysclk/2
#define DIV_BY4          0x02     // fsysclk/4
#define DIV_BY8          0x03     // fsysclk/8

#ifndef UART_BAUD_RATE_SET
#define UART_BAUD_RATE_SET
// UART_Operating_Frequency@24MHZ
#define Operat24M_Baud128000   0x0A04       // (DR = 0x0A, RT = 0x4).
#define Operat24M_Baud115200   0x0C00       // (DR = 0x0C, RT = 0x0).
#define Operat24M_Baud76800    0x1201       // (DR = 0x12, RT = 0x01).
#define Operat24M_Baud62500    0x1700       // (DR = 0x17, RT = 0x00).
#define Operat24M_Baud57600    0x1900       // (DR = 0x19, RT = 0x00).
#define Operat24M_Baud38400    0x2600       // (DR = 0x26, RT = 0x0).
#define Operat24M_Baud19200    0x4D00       // (DR = 0x4D, RT = 0x0).
#define Operat24M_Baud9600     0x9204       // (DR = 0x92, RT = 0x4).

// UART_Operating_Frequency@16MHZ
#define Operat16M_Baud128000   0x0703       // (DR = 0x07, RT = 0x3)
#define Operat16M_Baud115200   0x0803       // (DR = 0x08, RT = 0x3)
#define Operat16M_Baud76800    0x0C00       // (DR = 0x0C, RT = 0x0)
#define Operat16M_Baud62500    0x0F00       // (DR = 0x0F, RT = 0x0)
#define Operat16M_Baud57600    0x1103       // (DR = 0x11, RT = 0x3)
#define Operat16M_Baud38400    0x1900       // (DR = 0x19, RT = 0x0)
#define Operat16M_Baud19200    0x3004       // (DR = 0x30, RT = 0x4)
#define Operat16M_Baud9600     0x6401       // (DR = 0x64, RT = 0x1)
#define Operat16M_Baud4800     0xC901       // (DR = 0xC9, RT = 0x1)

// UART_Operating_Frequency@12MHZ
#define Operat12M_Baud128000   0x0503       // (DR = 0x05, RT = 0x3)
#define Operat12M_Baud115200   0x0602       // (DR = 0x06, RT = 0x2)
#define Operat12M_Baud76800    0x0903       // (DR = 0x09, RT = 0x3)
#define Operat12M_Baud62500    0x0B00       // (DR = 0x0B, RT = 0x0)
#define Operat12M_Baud57600    0x0C00       // (DR = 0x0C, RT = 0x0)
#define Operat12M_Baud38400    0x1201       // (DR = 0x12, RT = 0x1)
#define Operat12M_Baud19200    0x2600       // (DR = 0x26, RT = 0x0)
#define Operat12M_Baud9600     0x4D00       // (DR = 0x4D, RT = 0x0)
#define Operat12M_Baud4800     0x9204       // (DR = 0x92, RT = 0x4)

// UART_Operating_Frequency@8MHZ
#define Operat8M_Baud128000    0x0303       // (DR = 0x03, RT = 0x3)
#define Operat8M_Baud76800     0x0602       // (DR = 0x06, RT = 0x2)
#define Operat8M_Baud62500     0x0700       // (DR = 0x07, RT = 0x0)
#define Operat8M_Baud57600     0x0803       // (DR = 0x08, RT = 0x3)
#define Operat8M_Baud38400     0x0C00       // (DR = 0x0C, RT = 0x0)
#define Operat8M_Baud19200     0x1900       // (DR = 0x19, RT = 0x0)
#define Operat8M_Baud9600      0x3004       // (DR = 0x30, RT = 0x4)
#define Operat8M_Baud4800      0x6401       // (DR = 0x64, RT = 0x1)
#define Operat8M_Baud2400      0xC901       // (DR = 0xC9, RT = 0x1)

// UART_Operating_Frequency@4MHZ
#define Operat4M_Baud128000    0x0103       // (DR = 0x01, RT = 0x3)
#define Operat4M_Baud62500     0x0300       // (DR = 0x03, RT = 0x0)
#define Operat4M_Baud38400     0x0602       // (DR = 0x06, RT = 0x2)
#define Operat4M_Baud19200     0x0C00       // (DR = 0x0C, RT = 0x0)
#define Operat4M_Baud9600      0x1900       // (DR = 0x19, RT = 0x0)
#define Operat4M_Baud4800      0x3004       // (DR = 0x30, RT = 0x4)
#define Operat4M_Baud2400      0x6401       // (DR = 0x64, RT = 0x1)
#define Operat4M_Baud1200      0xC901       // (DR = 0xC9, RT = 0x1)

// UART_Operating_Frequency@2MHZ
#define Operat2M_Baud128000    0x0003       // (DR = 0x00, RT = 0x3)
#define Operat2M_Baud62500     0x0100       // (DR = 0x01, RT = 0x0)
#define Operat2M_Baud19200     0x0602       // (DR = 0x06, RT = 0x2)
#define Operat2M_Baud9600      0x0C00       // (DR = 0x0C, RT = 0x0)
#define Operat2M_Baud4800      0x1900       // (DR = 0x19, RT = 0x0)
#define Operat2M_Baud2400      0x3004       // (DR = 0x30, RT = 0x4)
#define Operat2M_Baud1200      0x6401       // (DR = 0x64, RT = 0x1)

// UART_Operating_Frequency@1MHZ
#define Operat1M_Baud62500     0x0000       // (DR = 0x00, RT = 0x0)
#define Operat1M_Baud9600      0x0602       // (DR = 0x06, RT = 0x2)
#define Operat1M_Baud4800      0x0C00       // (DR = 0x0C, RT = 0x0)
#define Operat1M_Baud2400      0x1900       // (DR = 0x19, RT = 0x0)
#define Operat1M_Baud1200      0x3004       // (DR = 0x30, RT = 0x4)

// UART_Operating_Frequency@1MHZ
#define Operat1M_Baud62500     0x0000       // (DR = 0x00, RT = 0x0)
#define Operat1M_Baud9600      0x0602       // (DR = 0x06, RT = 0x2)
#define Operat1M_Baud4800      0x0C00       // (DR = 0x0C, RT = 0x0)
#define Operat1M_Baud2400      0x1900       // (DR = 0x19, RT = 0x0)
#define Operat1M_Baud1200      0x3004       // (DR = 0x30, RT = 0x4)
#endif

// UART selection
#define UART0         (0x0)
#define UART1         (0x1)
#define UART2         (0x2)

#define PERR          (UART1SR_PERR = 1)    // parity error
#define FERR          (UART1SR_FERR = 1)    // framing error
#define OERR          (UART1SR_OERR = 1)    // overrun error

#define RBSY          (UART1SR_RBSY = 1)    // on receiving
#define TBSY          (UART1SR_TBSY = 1)    // on transmitting
#define RBFL          (UART1SR_RBFL = 1)    // receive buffer full
#define TBFL          (UART1SR_TBFL = 1)    // transmit buffer full (Transmit data writing is completed)

#define UART_INT_EN_TX      0x00        // Enable UARTx TX interrupt only.
#define UART_INT_EN_RX      0x01        // Enable UARTx RX interrupt only.
#define UART_INT_EN_TX_RX   0x02        // Enable UARTx TX & RX interrupt.

#define UART_RX_PIN_NONE    0x00        // not assign UART RX. 
#define UART_TX_PIN_NONE    0x00        // not assign UART TX. 

#define UART0_RX_PIN_P00    0x01        // P00 = UART0_RX.
#define UART0_RX_PIN_P60    0x02        // P60 = UART0_RX.
#define UART0_RX_PIN_P65    0x03        // P65 = UART0_RX.

#define UART0_TX_PIN_P01    0x01        // P01 = UART0_TX.
#define UART0_TX_PIN_P61    0x02        // P61 = UART0_TX.
#define UART0_TX_PIN_P66    0x03        // P66 = UART0_TX.

#define UART1_RX_PIN_P07    0x01        // P07 = UART1_RX.
#define UART1_RX_PIN_P10    0x02        // P10 = UART1_RX.
#define UART1_RX_PIN_P50    0x03        // P50 = UART1_RX.
 
#define UART1_TX_PIN_P11    0x01        // P11 = UART1_TX.
#define UART1_TX_PIN_P34    0x02        // P34 = UART1_TX.
#define UART1_TX_PIN_P51    0x03        // P51 = UART1_TX.

#define UART2_RX_PIN_P36    0x01        // P36 = UART2_RX.
#define UART2_RX_PIN_P74    0x02        // P74 = UART2_RX.

#define UART2_TX_PIN_P37    0x01        // P37 = UART2_TX.
#define UART2_TX_PIN_P75    0x02        // P75 = UART2_TX.

//------------------------------------------------------------------------------
// function return value list
// 0 : successful, others : error
//------------------------------------------------------------------------------
#define DRV_UART_RET_SUCCESS                (0)      // Execution success.
#define DRV_UART_RET_FAILURE                (-1)     // Error.
#define DRV_UART_RET_INVALID_PARAM          (-2)     // Invalid input parameters.
#define DRV_UART_RET_TIMEOUT                (-3)     // Execution timeout.

typedef void (* UART_CALLBACK) (void);  // type define of UART callback function pointer

// function prototype
int8_t DRV_UART0_Init(uint8_t rxPin, uint8_t txPin, uint8_t parityCheck, uint8_t stopBits);
int8_t DRV_UART0_DeInit(void);
int8_t DRV_UART0_INT(uint8_t enFlag, uint8_t selection, UART_CALLBACK rxCB, UART_CALLBACK txCB);

int8_t DRV_UART1_Init(uint8_t rxPin, uint8_t txPin, uint8_t parityCheck, uint8_t stopBits);
void DRV_UART1_DeInit(void);
int8_t DRV_UART1_INT(uint8_t enFlag, uint8_t selection, UART_CALLBACK rxCB, UART_CALLBACK txCB);

int8_t DRV_UART2_Init(uint8_t rxPin, uint8_t txPin, uint8_t parityCheck, uint8_t stopBits);
void DRV_UART2_DeInit(void);
int8_t DRV_UART2_INT(uint8_t enFlag, uint8_t selection, UART_CALLBACK rxCB, UART_CALLBACK txCB);

void DRV_UART_Start(uint8_t uartSel);
void DRV_UART_Stop(uint8_t uartSel);
void DRV_UART_SetBaudRate(uint8_t uartSel, uint16_t baudSel);
void DRV_UART_Send_OneByte(uint8_t uartSel, uint8_t data);
void DRV_UART_Send_Bytes(uint8_t uartSel, uint8_t* sentBuf, uint8_t len);
uint8_t DRV_UART_Recv_OneByte(uint8_t uartSel);

void __interrupt DRV_RX0_IRQ(void);
void __interrupt DRV_TX0_IRQ(void);
void __interrupt DRV_RX1_IRQ(void);
void __interrupt DRV_TX1_IRQ(void);
void __interrupt DRV_RX2_IRQ(void);
void __interrupt DRV_TX2_IRQ(void);

#endif  // _DRV_SQ7705_UART_H__.
