//******************************************************************************
// file         : main.c
// version      : V1.3  2023/11/20
// description  : main program 
// note         : 
//******************************************************************************
#ifndef IO_MEM
#define IO_MEM
#endif
#include "USR_main.h"

/* --------------------------- global variables ----------------------------- */
extern struct CO_AREA  ca;
uint16_t cnt = 0;                  // variables for delayed loop

/* ---------------------------- main program -------------------------------- */
void USR_Main()
{
    while (TRUE) {
        ca.fid = FID_LED_ON;
        usrRequestAdm();           // Jump to Admin U2A IRQ

        ca.fid = FID_DELAYLOOP;
        ca.para = 1000;
        usrRequestAdm();           // Jump to Admin U2A IRQ

        ca.fid = FID_LED_OFF;
        usrRequestAdm();           // Jump to Admin U2A IRQ

        ca.fid = FID_DELAYLOOP;
        ca.para = 500;
        usrRequestAdm();           // Jump to Admin U2A IRQ
    }
}

/* ----------------------- interrupt service routine ------------------------ */
void __interrupt OnlyReti(void)
{
    __ASM("NOP");                              // no operation
}

void __interrupt_n OnlyRetn(void)
{
    __ASM("NOP");                              // no operation
}

void __interrupt_n WDT_IRQ(void)
{
    __ASM("NOP");                              // no operation
}

void __interrupt_n SWI_IRQ(void)               // software reset interrupt service routine
{
//    SWRST = 0x5a;
//    SWRST = 0xa5;
//    SWRST = 0xc3;
//    SWRST = 0x3c;
}

//******************************************************************************
// name         : usrRequestAdm()
// description  : Jump to Admin U2A IRQ
// input param  : 
// output param : 
// retval       : 
// note         : 
//******************************************************************************
static void usrRequestAdm(void)
{
    MODEEXC = 0x5A;
    MODEEXC = 0x33;
    MODEEXC = 0x69;
    MODEEXC = 0xF3;
}

/* ---------------------- end of interrupt service routine ------------------ */


/* ----------------------- SQ7705 interrupt vector -------------------------- */
#pragma section const USR_INT_VECTOR 0xff86
void * const IntTbl1[] = {
    OnlyReti,                /* 0xff86 : TCA2_IRQ            */    //interrupt source:TCA2 16-bit timer
    OnlyReti,                /* 0xff88 : TX2_IRQ             */    //interrupt source:UART2 TX2
    OnlyReti,                /* 0xff8a : RX2_IRQ             */    //interrupt source:UART2 RX2
    OnlyReti,                /* 0xff8c : SPI1_IRQ            */    //interrupt source:SPI1
    OnlyReti,                /* 0xff8e : I2C1_IRQ            */    //interrupt source:I2C1
    OnlyReti,                /* 0xff90 : TX1_IRQ             */    //interrupt source:UART1 TX1
    OnlyReti,                /* 0xff92 : RX1_IRQ             */    //interrupt source:UART1 RX1
    OnlyReti,                /* 0xff94 : SHA_IRQ             */
    OnlyReti,                /* 0xff96 : AES_IRQ             */
    OnlyReti,                /* 0xff98 : STM1_IRQ            */
    OnlyReti,                /* 0xff9a : STM0_IRQ            */
    OnlyReti,                /* 0xff9c : TCA1_IRQ            */    //interrupt source:TCA1 16-bit timer
    OnlyReti,                /* 0xff9e : TCA0_IRQ            */    //interrupt source:TCA0 16-bit timer
    OnlyReti,                /* 0xffa0 : EEMC_IRQ            */    //interrupt source:EEPROM controller
    OnlyReti,                /* 0xffa2 : EXT7_IRQ            */    //external interrupt7
    OnlyReti,                /* 0xffa4 : EXT6_IRQ            */    //external interrupt6
    OnlyReti,                /* 0xffa6 : EXT5_IRQ            */    //external interrupt5
    OnlyReti,                /* 0xffa8 : EXT4_IRQ            */    //external interrupt4
    OnlyReti,                /* 0xffaa : TRNG_IRQ            */
    OnlyReti,                /* 0xffac : LEUART_TX_IRQ       */
    OnlyReti,                /* 0xffae : LEUART_RX_IRQ       */
    OnlyReti,                /* 0xffb0 : DIC_IRQ             */    //interrupt source:DIC
    OnlyReti,                /* 0xffb2 : Reserved            */
    OnlyReti,                /* 0xffb4 : Reserved            */
    OnlyReti,                /* 0xffb6 : Reserved            */
    OnlyReti,                /* 0xffb8 : Reserved            */
    OnlyReti,                /* 0xffba : Reserved            */
    OnlyReti,                /* 0xffbc : DMACH3_IRQ          */
    OnlyReti,                /* 0xffbe : DMACH2_IRQ          */
    OnlyReti,                /* 0xffc0 : DMACH1_IRQ          */
    OnlyReti,                /* 0xffc2 : DMACH0_IRQ          */
    OnlyReti,                /* 0xffc4 : FMC_IRQ             */    //interrupt source:flash memory controller
    OnlyReti,                /* 0xffc6 : Reserved            */
    OnlyReti,                /* 0xffc8 : Reserved            */
    OnlyReti,                /* 0xffca : LVD1_IRQ            */
    OnlyReti,                /* 0xffcc : LVD0_IRQ            */
    OnlyReti,                /* 0xffce : ADC_IRQ             */    //interrupt source:ADC
    OnlyReti,                /* 0xffd0 : EXT3_IRQ            */    //external interrupt3
    OnlyReti,                /* 0xffd2 : EXT2_IRQ            */    //external interrupt2
    OnlyReti,                /* 0xffd4 : EXT1_IRQ            */    //external interrupt1
    OnlyReti,                /* 0xffd6 : EXT0_IRQ            */    //external interrupt0
    OnlyReti,                /* 0xffd8 : SPI0_IRQ            */    //interrupt source:SPI0
    OnlyReti,                /* 0xffda : I2C0_IRQ            */    //interrupt source:I2C0
    OnlyReti,                /* 0xffdc : TX0_IRQ             */    //interrupt source:UART0 TX0
    OnlyReti,                /* 0xffde : RX0_IRQ             */    //interrupt source:UART0 RX0
    OnlyReti,                /* 0xffe0 : TBT_IRQ             */
    OnlyReti,                /* 0xffe2 : TMRA21_IRQ          */
    OnlyReti,                /* 0xffe4 : TMRA20_IRQ          */
    OnlyReti,                /* 0xffe6 : TMRA11_IRQ          */    //interrupt source:TMRA11 8-bit timer
    OnlyReti,                /* 0xffe8 : TMRA10_IRQ          */    //interrupt source:TMRA10 8-bit timer
    OnlyReti,                /* 0xffea : TMRA01_IRQ          */    //interrupt source:TMRA01 8-bit timer
    OnlyReti,                /* 0xffec : TMRA00_IRQ          */    //interrupt source:TMRA00 8-bit timer
    OnlyReti,                /* 0xffee : RTC_IRQ             */    //interrupt source:real-time clock timer
    OnlyReti,                /* 0xfff0 : U2A_IRQ/IntADM_Req  */    //interrupt source:user mode to admin mode
    OnlyReti,                /* 0xfff2 : HVD_IRQ             */
    OnlyReti,                /* 0xfff4 : CFD_IRQ             */    //interrupt source:clock fail detection
    OnlyReti,                /* 0xfff6 : TAMPER_IRQ          */    //interrupt source:tamper detection
    WDT_IRQ,                 /* 0xfff8 : WDT_IRQ             */    //non-maskable interrupt source:watchdog timer
    (void *)0xffff,          /* 0xfffa : Reserved            */
    SWI_IRQ,                 /* 0xfffc : SWI_IRQ/INTUNDEF    */    //non-maskable
    USR_STARTUP              /* 0xfffe : RESET               */    //non-maskable
};
#pragma section const
/* -------------------- end of SQ7705 interrupt vector ---------------------- */

