//******************************************************************************
// file         : SQ7705_USR_64PinPackage_startup.c
// version      : V1.2 2023/08/15
// description  : startup program
// note         : 
//******************************************************************************

/* ---------------------- reference header files ---------------------------- */
#include <stdlib.h>
#include "SQ7705_SFR.h"


/* ---------------------- external symbol declaration ----------------------- */
// (External Symbol Declaration) //
// symbols are initialized and defined in SQ7705.lcf (link command file)
 
extern unsigned int  _BaseSP;           // the starting address of the stacking pointer is generally defined as the the last address of the SRAM
extern unsigned int  _RAM_Top0;         // the first address of SRAM0
extern unsigned int  _RAM_End0;         // the last address of the SRAM0
extern unsigned int  _RAM_Top1;         // the first address of SRAM1
extern unsigned int  _RAM_End1;         // the last address of the SRAM1

extern unsigned char _NDataAddr0[];     /* for near_data initialize, defined in link command file  */
extern unsigned char _NDataOrg0[];      /* for near_data initialize, defined in link command file  */
extern unsigned int  _NDataSize0;       /* for near_data initialize, defined in link command file  */
extern unsigned char _NDataAddr1[];     /* for near_data initialize, defined in link command file  */
extern unsigned char _NDataOrg1[];      /* for near_data initialize, defined in link command file  */
extern unsigned int  _NDataSize1;       /* for near_data initialize, defined in link command file  */


/*
 ******************************************************************************
 * NAME             : startup routine
 *-----------------------------------------------------------------------------
 * DESCRIPTION      : startup routine
 * PARAMETER        : -
 *
 * RETURN VALUE     : -
 *
 ******************************************************************************
 */

void USR_STARTUP( void )
{
//============================================
// Memory Mapping 
//============================================	
    DMCFG  = 0x50;    // Code :0x8000~0xFFFF Map to Data: 0x8000~0xFFFF    

//============================================
// Disable Interrupt
//============================================
    __DI();                         // disable all maskable interrupts 

//============================================
// Enable cache
//============================================    
    CACHECR_CLEAR = 1;
    while(CACHECR_CLEAR!=0){}
    CACHECR_ICACHEEN = 1;
    
//============================================
// Initial Registers
//============================================
    __WA = 0x00;
    __BC = 0x00;
    __DE = 0x00;
    __HL = 0x00;
    __IX = 0x00;
    __IY = 0x00;

//============================================
// Initialize Stack Pointer
//============================================
    __asm(" LD SP,__BaseSP");

//============================================
// Reset PSW 
//============================================
    __asm(" LD PSW,0x00");          // Clear status word

//============================================
// Clear SRAM0
//============================================
    __asm(" LD HL,__RAM_Top0");
    __asm(" LD BC,__RAM_End0 - __RAM_Top0");
    __asm(" LD A,0x00");
    __asm("CLR_SRAM0:");
    __asm(" LD (HL),A");
    __asm(" INC HL");
    __asm(" DEC BC");
    __asm(" JRS F,CLR_SRAM0");      /* Clear the SRAM0 */

//============================================
// Clear SRAM1
//============================================
    __asm(" LD HL,__RAM_Top1");
    __asm(" LD BC,__RAM_End1 - __RAM_Top1 + 1");
    __asm(" LD A,0x00");
    __asm("CLR_SRAM1:");
    __asm(" LD (HL),A");
    __asm(" INC HL");
    __asm(" DEC BC");
    __asm(" JRS F,CLR_SRAM1");      /* Clear the SRAM1 */

//=============================================================================
// initialize of near_data0 section
//=============================================================================
    __asm("	LD	IX,__NDataOrg0");
    __asm("	LD	IY,__NDataAddr0");
    __asm("	LD	WA,__NDataSize0");
    __asm("	DEC	WA");
    __asm("	J	T,non_n_data0");
    __asm("move_n_data0:");
    __asm("	LD	C,(IX)");
    __asm("	LD	(IY),C");
    __asm("	INC	IX");
    __asm("	INC	IY");
    __asm("	DEC	WA");
    __asm("	J	F,move_n_data0");
    __asm("non_n_data0:");


//=============================================================================
// initialize of near_data1 section
//=============================================================================
    __asm("	LD	IX,__NDataOrg1");
    __asm("	LD	IY,__NDataAddr1");
    __asm("	LD	WA,__NDataSize1");
    __asm("	DEC	WA");
    __asm("	J	T,non_n_data1");
    __asm("move_n_data1:");
    __asm("	LD	C,(IX)");
    __asm("	LD	(IY),C");
    __asm("	INC	IX");
    __asm("	INC	IY");
    __asm("	DEC	WA");
    __asm("	J	F,move_n_data1");
    __asm("non_n_data1:");


//============================================
// Jump to main
//============================================
    USR_Main();
    for (;;) {
        ;
    }
}

