//******************************************************************************
// file         : DRV_SQ7705_DelayLoop.h
// version      : V1.2 2023/08/31
// description  : DelayLoop header file
// note         : 
//******************************************************************************
#ifndef _DRV_SQ7705_DELAY_LOOP_H__
#define _DRV_SQ7705_DELAY_LOOP_H__

#include "TypeDefs.h"
#include "SQ7705_SFR.h"

extern volatile uint16_t delay_base_ms;
extern volatile uint16_t delay_base_100us;

#define PLL           1

#define PLL_24M       0x01      // fsysclk/2  (48M/2 = 24MHz) 
#define PLL_12M       0x02      // fsysclk/4  (48M/4 = 12MHz) 
#define PLL_6M        0x03      // fsysclk/8  (48M/8 = 6MHz) 

// delay loop count of system clock
#define f24m_1ms_t    (1500)    // delay 1ms only for PLL 24MHz
#define f12m_1ms_t    (1500/2)
#define f06m_1ms_t    (1500/4)

// the number of loops required for the 100us Delay Loop function corresponding to each system frequency is defined here
#define f24m_100us_t  (149)     // delay 100us only for PLL 24MHz


//******************************************************************************
// name         : DRV_Delay_Loop_Init()
// description  : initialize the delay loop
// input param  : 
// output param : 
// retval       : 
// note         : the number of times required to switch the minimum unit of the 
//                Delay Loop function based on the system frequency
//******************************************************************************
void DRV_Delay_Loop_Init();

//******************************************************************************
// name         : DRV_Delay_ms()
// description  : delay function in unit of ms
// input param  : x is a multiplier, x > 0
// output param : 
// retval       : 
// note         : it is only applicable when the system clock source is PLL and 
//                the system main frequency is 24MHz, 12MHz and 6MHz
//                for example,
//                delay_ms(1);           // delay 1 ms
//                delay_ms(30);          // delay 30 ms
//                delay_ms(500);         // delay 500 ms
//******************************************************************************
void DRV_Delay_ms(uint16_t x);

//******************************************************************************
// name         : DRV_Delay_100us()
// description  : delay function in unit of 100 us
// input param  : y is a multiplier, y > 0, y is suggested to be 1 to 10
// output param : 
// retval       : 
// note         : it is only applicable when the system clock source is PLL and the system main frequency is 24MHz
//                there is an error because the while loop used to delay the loop,
//                for precise delay application, please use timer for delay function
//                for example,
//                delay_100us(1);        // delay 100 us = 0.1 ms
//                delay_100us(10);       // delay 1000 us = 1 ms
//******************************************************************************
void DRV_Delay_100us(uint8_t y);

#endif


