//******************************************************************************
// file         : DRV_SQ7705_Tamper.h
// version      : V1.3 2025/03/13
// description  : Tamper related header file
// note         :
//******************************************************************************
#ifndef _DRV_SQ7705_TAMPER_H_
#define _DRV_SQ7705_TAMPER_H_

#include "TypeDefs.h"
#include "SQ7705_SFR.h"

extern uint8_t tamperPin0;
extern uint8_t tamperPin1;
extern uint8_t tamperHvd;
extern uint8_t tamperMo;
extern uint8_t tamperMts;

typedef enum {
    TAMPER_HVD,  // High voltage
    TAMPER_MTO,  // Circuit open
    TAMPER_MTS   // Circuit short
} TAMPER_TYPE;

typedef enum {
    TAMPERPIN0,  // Tamper PIN 0
    TAMPERPIN1   // Tamper PIN 1
} TAMPER_PIN;

#define TAMPPIN0_P00  TAMPERPIN0,0
#define TAMPPIN0_P10  TAMPERPIN0,1
#define TAMPPIN0_P20  TAMPERPIN0,2
#define TAMPPIN0_P50  TAMPERPIN0,5
#define TAMPPIN0_P60  TAMPERPIN0,6
#define TAMPPIN0_P70  TAMPERPIN0,7
#define TAMPPIN1_P04  TAMPERPIN1,0

#define TAMPPIN1_P14  TAMPERPIN1,1
#define TAMPPIN1_P24  TAMPERPIN1,2
#define TAMPPIN1_P44  TAMPERPIN1,4
#define TAMPPIN1_P54  TAMPERPIN1,5
#define TAMPPIN1_P64  TAMPERPIN1,6
#define TAMPPIN1_P74  TAMPERPIN1,7

/*
selects the interrupt request generating condition
RISING_TRIGGER = 0, an interrupt request is generated at the rising edge
FALLING_TRIGGER = 1, an interrupt request is generated at the falling edge
RIS_FAL_TRIGGER = 2, an interrupt request is generated at the both edges
*/
typedef enum {
    RISING_TRIGGER = 0,
    FALLING_TRIGGER,
    RIS_FAL_TRIGGER
} TAMPER_TRIGGER;

/* The noise canceller sampling interval */
typedef enum {
    SAMPLE_FSYSCLK_DIV1 = 0,
    SAMPLE_FSYSCLK_DIV4,
    SAMPLE_FSYSCLK_DIV8,
    SAMPLE_FSYSCLKDIV16
} TAMPER_NC_SAMPLE;

/* Tamper response action */
typedef enum {
    TAMPER_RSP_ACT_NONE = 0,
    TAMPER_RSP_ACT_RESERVE = 1,     // Same with NONE
    TAMPER_RSP_ACT_INT = 2,         // Interrupt
    TAMPER_RSP_ACT_CLEAR_MSG = 3    // Clear senstive message, this option may make SQ7705 can not reboot again
} TAMPER_RSP_ACT;

//******************************************************************************
// name         : DRV_TamperPinInit()
// description  : TAMPERPIN initialization
// input param  : - tPin : TAMPIN1 or TIMPIN0
//                - selGPIO : GPIO for this pin
//                - trigger : selects the interrupt request generating condition
//                  RISING_TRIGGER = 0, an interrupt request is generated at the rising edge
//                  FALLING_TRIGGER = 1, an interrupt request is generated at the falling edgee
//                  RIS_FAL_TRIGGER = 2, an interrupt request is generated at the both edges
//                - sample : sets the noise canceller sampling interval
//                - act : action when tamper happen
// output param : 
// retval       : 
// note         : Valid tPin, selGPIO, parameter
//                example : TAMPPIN0_P00 means  tamper PIN0 usage GPIO P0,0
//                #define TAMPPIN0_P00  TAMPERPIN0,0
//                #define TAMPPIN0_P10  TAMPERPIN0,1
//                #define TAMPPIN0_P20  TAMPERPIN0,2
//                #define TAMPPIN0_P50  TAMPERPIN0,5
//                #define TAMPPIN0_P60  TAMPERPIN0,6
//                #define TAMPPIN0_P70  TAMPERPIN0,7
//                #define TAMPPIN1_P04  TAMPERPIN1,0
//                #define TAMPPIN1_P14  TAMPERPIN1,1
//                #define TAMPPIN1_P24  TAMPERPIN1,2
//                #define TAMPPIN1_P44  TAMPERPIN1,4
//                #define TAMPPIN1_P54  TAMPERPIN1,5
//                #define TAMPPIN1_P64  TAMPERPIN1,6
//                #define TAMPPIN1_P74  TAMPERPIN1,7
//******************************************************************************
void DRV_TamperPinInit(TAMPER_PIN tPin, uint8_t selGPIO, TAMPER_TRIGGER trigger, TAMPER_NC_SAMPLE sample, TAMPER_RSP_ACT act);

//******************************************************************************
// name         : DRV_TamperPinDeInit()
// description  : Deinit TAMPERPIN
// input param  : - tPin : tamper pin
// output param :
// retval       :
// note         :
//******************************************************************************
void DRV_TamperPinDeInit(TAMPER_PIN tPin);

//******************************************************************************
// name         : DRV_TamperMonitorInit()
// description  : Tamper monitor init
// input param  : - type : tamper type
//                - act  : action when tamper happen
// output param :
// retval       :
// note         :
//******************************************************************************
void DRV_TamperMonitorInit(TAMPER_TYPE type, TAMPER_RSP_ACT act);

//******************************************************************************
// name         : DRV_TamperMonitorDeInit()
// description  : Deinit tamper monitor
// input param  : - type : tamper type
// output param :
// retval       :
// note         :
//******************************************************************************
void DRV_TamperMonitorDeInit(TAMPER_TYPE type);

//******************************************************************************
// name         : DRV_TamperEnable()
// description  : Enable Tamper
// input param  :
// output param :
// retval       :
// note         :
//******************************************************************************
void DRV_TamperEnable();

//******************************************************************************
// name         : DRV_TamperDisable()
// description  : Disable Tamper
// input param  :
// output param :
// retval       :
// note         :
//******************************************************************************
void DRV_TamperDisable();

//******************************************************************************
// name         : DRV_TAMPER_IRQ()
// description  : Tamper interrupt service routine
// input param  :
// retval       : 
// note         :
//******************************************************************************
void __interrupt DRV_TAMPER_IRQ(void);

#endif