//******************************************************************************
// file         : DRV_SQ7705_SYSCLK.h
// version      : V1.2 2023/09/07
// description  : SYSCLK header file
// note         : 
//******************************************************************************  
#ifndef _SQ7705_SYS_CLK_H_
#define _SQ7705_SYS_CLK_H_

#include "TypeDefs.h"
#include "SQ7705_SFR.h"

enum Clk_Source {
    Clk_Source_SYS,
    Clk_Source_LIRC,
    Clk_Source_HXTAL,
    Clk_Source_LXTAL
};

void DRV_Clock_Init(enum Clk_Source clk_src, uint8_t sckpsc);
void DRV_Clock_WUP(enum Clk_Source clk_src, uint8_t wup_counter);
void DRV_PLL_REF(uint8_t ref_select);
void DRV_CM_Enable(uint8_t clkcr2);
void DRV_CMCR_Set(uint8_t cmcr);
uint8_t DRV_CMSR_Get();

#endif
