//******************************************************************************
// file         : TypeDefs.h
// version      : V1.2 2023/08/15
// description  : Type define and common definition
// note         : 
//******************************************************************************
#ifndef _TYPEDEFS_H__
#define _TYPEDEFS_H__

/* ---------------------- user type defined --------------------------------- */
#ifndef int8_t
typedef signed char     int8_t;
#endif 

#ifndef int16_t
typedef signed short    int16_t;
#endif 

#ifndef int32_t
typedef signed long     int32_t;
#endif 

#ifndef uint8_t
typedef unsigned char   uint8_t;
#endif 

#ifndef uint16_t
typedef unsigned short  uint16_t;
#endif 

#ifndef uint32_t
typedef unsigned long  uint32_t;
#endif 

/* ---------------------- user-defined macros ------------------------------- */
#define FALSE       (0)
#define TRUE        (1)

#define DISABLE     (0) 
#define ENABLE      (1)

#define SET_BIT(x,bit)                 ( x |= ( 1 << bit ) )
#define CLR_BIT(x,bit)                 ( x &= ~( 1 << bit ) )
#define GET_BIT(x,bit)                 ((x & (1<<bit))>>bit)

#define LOW_BYTE(a)     (unsigned char)((a >> 0) & 0xFF)
#define HIGH_BYTE(a)    (unsigned char)((a >> 8) & 0xFF)

#define BYTE_TO_WORD(a) ((((unsigned short)a[0]) << 0) | (((unsigned short)a[1]) << 8))

//------------------------------------------------------------------------------
#endif //#ifndef _TYPEDEFS_H__