//******************************************************************************
// file         : DRV_SQ7705_STM.h
// version      : V1.2 2023/08/22
// description  : STM header file
// note         : 
//******************************************************************************
#ifndef _DRV_SQ7705_STM_H__
#define _DRV_SQ7705_STM_H__

#include "TypeDefs.h"
#include "SQ7705_SFR.h"

extern uint8_t STM0_Int_Flag;   // flag for STM0 interrupt
extern uint8_t STM1_Int_Flag;   // flag for STM1 interrupt

typedef enum{
    STMSEL_STM0 = 0,            // STM0
    STMSEL_STM1 = 1             // STM1
} STM_SEL;

typedef enum{
    STMCKS_LIRC = 0,            // STM clock source: LIRC
    STMCKS_1MHZ = 1             // STM clock source: 1MHz(internal clock)
} STM_CLK_SOURCE;

typedef enum{
    DSLP_DISABLE = 0,           // not operate in deep sleep mode
    DSLP_ENABLE = 1             // can operate in deep sleep mode
} STM_DEEP_SLEEP;

typedef enum{                   // clock divider
    STMCKD_DIV1 = 0,            // STM source clock/1
    STMCKD_DIV2 = 1,            // STM source clock/2
    STMCKD_DIV4 = 2,            // STM source clock/4
    STMCKD_DIV8 = 3             // STM source clock/8
} STM_CLK_DIV;

typedef struct{                 // STM parameter struct
    STM_SEL stmSEL;             // STM Select STM0 ~ STM1
    STM_CLK_SOURCE stmCKS;      // STM clock source
    STM_DEEP_SLEEP stmDSLP;     // operate in deep sleep mode or not
    STM_CLK_DIV stmCKD;         // clock divider
    uint16_t count; 
    uint16_t period;
} STM_REG;

//******************************************************************************
// name         : DRV_STM_Init()
// description  : STM initialization
// input param  : - stmReg : STM initialization data structure
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_STM_Init(STM_REG stmReg);

//******************************************************************************
// name         : DRV_STM_Deinit()
// description  : STM deinitialization
// input param  : - stmSel : STM selection : STM0 ~ STM1
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_STM_Deinit(STM_SEL stmSel);

//******************************************************************************
// name         : DRV_STM_Start()
// description  : Start STM
// input param  : - stmSel : STM selection : STM0 ~ STM1
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_STM_Start(STM_SEL stmSel);

//******************************************************************************
// name         : DRV_STM_Stop()
// description  : Stop STM
// input param  : - stmSel : STM selection : STM0 ~ STM1
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_STM_Stop(STM_SEL stmSel);

//******************************************************************************
// name         : DRV_STM0_IRQ()
// description  : STM0 interrupt service routine
// input param  : 
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void __interrupt DRV_STM0_IRQ(void);

//******************************************************************************
// name         : DRV_STM1_IRQ()
// description  : STM1 interrupt service routine
// input param  : 
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void __interrupt DRV_STM1_IRQ(void);

#endif
