//******************************************************************************
// file         : DRV_SQ7705_SPI.h
// version      : V1.2 2023/08/31
// description  : SPI header file
// note         : 
//******************************************************************************
#ifndef _DRV_SQ7705_SPI_H__
#define _DRV_SQ7705_SPI_H__

#include "TypeDefs.h"
#include "SQ7705_SFR.h"

#define SPI0 0
#define SPI1 1

typedef enum{
    SPI0_MOSI_P00,
    SPI0_MOSI_P04,
    SPI0_MOSI_P14,
    SPI0_MOSI_P36
}SPI0_MOSI_LIST;

typedef enum{
    SPI0_MISO_P01,
    SPI0_MISO_P05,
    SPI0_MISO_P15,
    SPI0_MISO_P37
}SPI0_MISO_LIST;

typedef enum{
    SPI0_SCK_P02,
    SPI0_SCK_P06,
    SPI0_SCK_P16,
    SPI0_SCK_P60
}SPI0_SCK_LIST;

typedef enum{
    SPI0_CS_P03,
    SPI0_CS_P07,
    SPI0_CS_P17,
    SPI0_CS_P61
}SPI0_CS_LIST;

typedef enum{
    SPI1_MOSI_P20,
    SPI1_MOSI_P54
}SPI1_MOSI_LIST;

typedef enum{
    SPI1_MISO_P21,
    SPI1_MISO_P55
}SPI1_MISO_LIST;

typedef enum{
    SPI1_SCK_P22,
    SPI1_SCK_P56
}SPI1_SCK_LIST;

typedef enum{
    SPI1_CS_P23,
    SPI1_CS_P57,
    SPI1_CS_P70
}SPI1_CS_LIST;

typedef enum{
    SPI_MODE_0 = 0,
    SPI_MODE_1 = 2,
    SPI_MODE_2 = 4,
    SPI_MODE_3 = 6
}SPI_MODE_LIST;

typedef enum{
    SPI_SLAVE,
    SPI_MASTER
}SPI_MSTR_LIST;

typedef struct{
    SPI0_MOSI_LIST mosi;
    SPI0_MISO_LIST miso;
    SPI0_SCK_LIST  sck;
    SPI0_CS_LIST   cs;
    SPI_MODE_LIST  mode;
    SPI_MSTR_LIST  mstr;
}SPI0_INIT_STRUCT;

typedef struct{
    SPI1_MOSI_LIST mosi;
    SPI1_MISO_LIST miso;
    SPI1_SCK_LIST  sck;
    SPI1_CS_LIST   cs;
    SPI_MODE_LIST  mode;
    SPI_MSTR_LIST  mstr;
}SPI1_INIT_STRUCT;

void DRV_SPI0_Init(SPI0_INIT_STRUCT *initDef);
void DRV_SPI0_MOSI_Init(SPI0_MOSI_LIST mosi);
void DRV_SPI0_MISO_Init(SPI0_MISO_LIST miso);
void DRV_SPI0_SCK_Init(SPI0_SCK_LIST sck);
void DRV_SPI0_CS_Init(SPI0_CS_LIST cs);

void DRV_SPI1_Init(SPI1_INIT_STRUCT *initDef);
void DRV_SPI1_MOSI_Init(SPI1_MOSI_LIST mosi);
void DRV_SPI1_MISO_Init(SPI1_MISO_LIST miso);
void DRV_SPI1_SCK_Init(SPI1_SCK_LIST sck);
void DRV_SPI1_CS_Init(SPI1_CS_LIST cs);

void DRV_SPIx_SendBytes(uint8_t spi, uint8_t *data, uint8_t length);
void DRV_SPIx_ReceiveBytes(uint8_t spi,uint8_t *data, uint8_t length);

void DRV_SPIx_MasterTxLength(uint8_t spi, uint8_t cnt);
void DRV_SPIx_SlaveRxLength(uint8_t spi, uint8_t cnt);
void DRV_SPIx_TxInit(uint8_t spi);
void DRV_SPIx_ClrTxFlag(uint8_t spi);
void DRV_SPIx_ClrRxFlag(uint8_t spi);
void DRV_SPIxSlaveRxInit(uint8_t spi);
void DRV_SPIxMasterRxInit(uint8_t spi);
void DRV_SPIx_Start(uint8_t spi);
void DRV_SPIx_Stop(uint8_t spi);
void __interrupt DRV_SPI0_IRQ(void);
void __interrupt DRV_SPI1_IRQ(void);

#endif