//******************************************************************************
// file         : DRV_SQ7705_SHA.h
// version      : V1.3 2025/03/13
// description  : SHA header file
// note         : 
//******************************************************************************
#ifndef _DRV_SQ7705_SHA_H_
#define _DRV_SQ7705_SHA_H_

#include "TypeDefs.h"
#include "SQ7705_SFR.h"

typedef enum{
    SHA_OK    =    0,
    SHA_Err,
    SHA_Err_Not_Initialized = 0xE0,
    SHA_Err_Mem_Type,
    SHA_Err_Mem_Addr,
    SHA_Err_Mem_Size,
    SHA_Err_Mem_Wrong_Size,
    SHA_Err_Mem_Size_Negative,
    SHA_Err_Mem_Size_Not_4_Multiple,
    SHA_Err_Mem_Size_Not_64,
    SHA_Err_Not_Process,
    SHA_Err_Interrupt_Init,
    SHA_Err_Enable,
    SHA_Err_Pad,
    SHA_Err_Auto,
    SHA_Err_Bit_Mode,
    SHA_Err_Conti,
    SHA_Err_SHADI
}SHA_Status;

#define SRAM    0
#define EEPROM  1
#define FLASH   2

uint8_t DRV_SHA_Init(uint8_t sync, uint8_t padding);
void DRV_SHA_Deinit(void);
uint8_t DRV_SHA_Size(uint8_t shaSize);
uint8_t DRV_SHA_Process(const uint8_t memType, const uint8_t *input, uint16_t length, uint8_t autoMode, uint8_t conti);
uint8_t DRV_SHA_Process_DataIn(const uint8_t *input, uint16_t length, uint8_t autoMode, uint8_t conti);
uint8_t DRV_SHA_Process_EEPROM(const uint16_t startAddress, uint16_t length, uint8_t autoMode, uint8_t conti);
uint8_t DRV_SHA_Process_FLASH(const uint16_t startAddress, uint16_t length, uint8_t autoMode, uint8_t conti);
uint8_t DRV_SHA_Process_End(uint8_t *output);
uint8_t DRV_HAL_SHA_ClockEnable(uint8_t enable);
uint8_t DRV_SHA_Interrupt_Init(uint8_t shaInterruptEnable);
uint8_t DRV_SHA_Message_Load(uint8_t memType, uint8_t *msg, uint16_t msgSize);
uint8_t DRV_SHA_Load_SRAM_Message(uint8_t *msg, uint16_t msgSize);
uint8_t DRV_SHA_Load_Flash_Message(uint16_t msg, uint16_t msgSize);
uint8_t DRV_SHA_Load_EEPROM_Message(uint16_t msg, uint16_t msgSize);
uint8_t DRV_SHA_Message_Memory(uint8_t memType);
uint8_t DRV_SHA_Messgage_Address(uint8_t *msg);
uint8_t DRV_SHA_Message_Size(uint16_t size);
uint8_t DRV_SHA_Auto_Enable(uint8_t enable);
uint8_t DRV_SHA_Pad_Done_Check(uint16_t digestSize);
uint8_t DRV_SHACR0_Check(uint8_t shaInterruptEnable, uint8_t autoMode, uint8_t contiMode, uint8_t padEnable);
void DRV_SHA_Start_with_Polling(void);
void DRV_SHA_Start_with_Interrupt(void);
void DRV_SHA_Load_Digest(uint8_t* digest);
uint8_t DRV_SHA_Conti_Enable(uint8_t enable);
uint8_t DRV_SHA_Pad_Enable(uint8_t enable);
uint8_t Check_4_Multiples(uint16_t size);
uint8_t Check_64(uint16_t size);
uint8_t DRV_SHADI_Input(uint8_t* msg, uint16_t msgSize);
void DRV_SHA_ContiStart();
uint8_t DRV_SHA_ContiUpdate(uint8_t memType, uint8_t *msmAddr);
uint8_t DRV_SHA_ContiFinal(uint8_t memType, uint8_t *msmAddr, uint8_t memSize ,uint8_t *digest);
#endif