//******************************************************************************
// file         : DRV_SQ7705_TBT.h
// version      : V1.2 2023/08/21
// description  : TBT header file
// note         : 
//******************************************************************************
#ifndef _DRV_SQ7705_TBT_H__
#define _DRV_SQ7705_TBT_H__

#include "TypeDefs.h"
#include "SQ7705_SFR.h"

extern uint8_t TBT_Int_Flag;   // flag for TBT interrupt

typedef enum{
    DV9CK_FSYSCLK = 0,    // selects the input clock to stage 9 of the divider: fsysclk/2^9
    DV9CK_FLCLK = 1       // selects the input clock to stage 9 of the divider: flclk    
} TBT_DV9CK;

typedef enum{             // selects the time base timer interrupt frequency (Hz)
                          // Normal/Sleep Mode, PLL/HXTAL       |  Normal/Sleep Mode, LIRC/LXTAL
                          // TBTCR<DV9CK>=0  |  TBTCR<DV9CK>=1  |  
                          // ---------------------------------------------------------------------------
    TBTCK_0000 = 0x00,    // fsysclk/2^30    |  flclk/2^23      |  flclk/2^23  
    TBTCK_0001 = 0x01,    // fsysclk/2^29    |  flclk/2^22      |  flclk/2^22
    TBTCK_0010 = 0x02,    // fsysclk/2^28    |  flclk/2^21      |  flclk/2^21
    TBTCK_0011 = 0x03,    // fsysclk/2^27    |  flclk/2^20      |  flclk/2^20
    TBTCK_0100 = 0x04,    // fsysclk/2^26    |  flclk/2^19      |  flclk/2^19 
    TBTCK_0101 = 0x05,    // fsysclk/2^25    |  flclk/2^18      |  flclk/2^18
    TBTCK_0110 = 0x06,    // fsysclk/2^24    |  flclk/2^17      |  flclk/2^17
    TBTCK_0111 = 0x07,    // fsysclk/2^23    |  flclk/2^16      |  flclk/2^16
    TBTCK_1000 = 0x08,    // fsysclk/2^22    |  flclk/2^15      |  flclk/2^15 
    TBTCK_1001 = 0x09,    // fsysclk/2^20    |  flclk/2^13      |  flclk/2^13
    TBTCK_1010 = 0x0A,    // fsysclk/2^15    |  flclk/2^8       |  Reserved
    TBTCK_1011 = 0x0B,    // fsysclk/2^13    |  flclk/2^6       |  Reserved
    TBTCK_1100 = 0x0C,    // fsysclk/2^12    |  flclk/2^5       |  Reserved 
    TBTCK_1101 = 0x0D,    // fsysclk/2^11    |  flclk/2^4       |  Reserved
    TBTCK_1110 = 0x0E,    // fsysclk/2^10    |  flclk/2^3       |  Reserved
    TBTCK_1111 = 0x0F     // fsysclk/2^8     |  Reserved        |  Reserved
    
} TBT_TBTCK;

typedef struct{
    TBT_DV9CK tbtDV9CK;   // selects the input clock to stage 9 of the divider
    TBT_TBTCK tbtTBTCK;   // selects the time base timer interrupt frequency (Hz)
} TBT_REG;


//******************************************************************************
// name         : DRV_TBT_Init()
// description  : TBT initialization
// input param  : - tbtReg : TBT initialization data structure
// output param :
// retval       : 
// note         : 
//******************************************************************************
void DRV_TBT_Init(TBT_REG tbtReg);

//******************************************************************************
// name         : DRV_TBT_Start()
// description  : Start TBT
// input param  : 
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_TBT_Start(void);

//******************************************************************************
// name         : DRV_TBT_Stop()
// description  : Stop TBT
// input param  : 
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_TBT_Stop(void);

//******************************************************************************
// name         : DRV_TBT_IRQ()
// description  : TBT interrupt service routine
// input param  : 
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void __interrupt DRV_TBT_IRQ(void);

#endif

