//******************************************************************************
// file         : DRV_SQ7705_TBT.c
// version      : V1.2 2023/08/21
// description  : TBT related functions
// note         : TBT related functions are gathered in this subroutine
//******************************************************************************
#include "DRV_SQ7705_TBT.h"

uint8_t TBT_Int_Flag;                   // flag for TBT interrupt

//******************************************************************************
// name         : DRV_TBT_Init()
// description  : TBT initialization
// input param  : - tbtReg : TBT initialization data structure
// output param :
// retval       : 
// note         : 
//******************************************************************************
void DRV_TBT_Init(TBT_REG tbtReg)
{
    TBTCR_DV9CK = tbtReg.tbtDV9CK;      // selects the input clock to stage 9 of the divider
    TBTCR_TBTCK = tbtReg.tbtTBTCK;      // selects the time base timer interrupt frequency
                                        // Example:  if fcgck = 24MHz, TBT interrupt frequency = 5.722Hz
                                        // (fcgck / 2^22 = 5.722Hz) ; T = 1 / 5.722 = 0.174764s
    
    __ASM("DI");                        // disable all maskable interrupts
    IER_TBT = 1;                        // enable TBT interrupt
    __ASM("EI");                        // enable all maskable interrupts
}

//******************************************************************************
// name         : DRV_TBT_Start()
// description  : Start TBT
// input param  : 
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_TBT_Start()
{
    TBTCR_TBTEN = 1;                    // enable TBT
}

//******************************************************************************
// name         : DRV_TBT_Stop()
// description  : Stop TBT
// input param  : 
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_TBT_Stop()
{
    TBTCR_TBTEN = 0;                    // disable TBT
}

//******************************************************************************
// name         : DRV_TBT_IRQ()
// description  : TBT interrupt service routine
// input param  : 
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void __interrupt DRV_TBT_IRQ(void)
{
    TBT_Int_Flag = 1;                   // flag for TBT interrupt
}

