//******************************************************************************
// file         : DRV_SQ7705_LVD.h
// version      : V1.2 2024/01/05
// description  : LVD header file
// note         : 
//******************************************************************************
#ifndef _DRV_SQ7705_LVD_H__
#define _DRV_SQ7705_LVD_H__

#include "TypeDefs.h"
#include "SQ7705_SFR.h"

extern uint8_t LVD_Int_Flag;

typedef enum {
    LVD_2V_TO_3V = 0,
    LVD_3V_TO_4V
} LVD_TYPE;

typedef enum {
    LVD_2_00_V = 0,
    LVD_2_35_V = 1,
    LVD_2_65_V = 2,
    LVD_2_85_V = 3,
    LVD_3_15_V = 4,
    LVD_3_98_V = 5,
    LVD_4_2_V = 6,
    LVD_4_5_V = 7
} LVD_CFG;

typedef enum {
    ACT_INERRUPT = 0,
    ACT_RESET
} LVD_REACTION;

//******************************************************************************
// name         : DRV_LVD_Init()
// description  : initialize LVD
// input param  : - lvdCfg : select voltage detection level
//                      LVD_2_00_V  2.00V detection level
//                      LVD_2_35_V  2.35V detection level
//                      LVD_2_65_V  2.65V detection level
//                      LVD_2_85_V  2.85V detection level
//                      LVD_3_15_V  3.15V detection level
//                      LVD_3_98_V  3.98V detection level
//                      LVD_4_2_V   4.2V  detection level
//                      LVD_4_5_V   4.5V  detection level
//                - act : action when low voltage is detected
//                        ACT_INERRUPT : LVD interrupt is generated
//                        ACT_REST     : reset
// retval       : none (all parameters can only use the defined values, otherwise the function will be disabled)
// note         : 
//******************************************************************************
void DRV_LVD_Init(LVD_CFG lvdCfg, LVD_REACTION act);

//******************************************************************************
// name         : DRV_LVD_DeInit()
// description  : Deinitialize LVD0 or LVD1
// input param  : - lvdType : LVD level type
//                      LVD_2V_TO_3V for LVD_2_00_V ~ LVD_2_85_V
//                      LVD_3V_TO_4V for LVD_3_15_V ~ LVD_4_5_V
// retval       : none (all parameters can only use the defined values, otherwise the function will be disabled)
// note         : 
//******************************************************************************
void DRV_LVD_DeInit(LVD_TYPE lvdType);

//******************************************************************************
// name         : DRV_LVD_Start()
// description  : start LVD0 or LVD1
// input param  : - lvdType : LVD level type
//                      LVD_2V_TO_3V for LVD_2_00_V ~ LVD_2_85_V
//                      LVD_3V_TO_4V for LVD_3_15_V ~ LVD_4_5_V
// retval       : none (all parameters can only use the defined values, otherwise the function will be disabled)
// note         : 
//******************************************************************************
void DRV_LVD_Start(LVD_TYPE lvdType);

//******************************************************************************
// name         : DRV_LVD_Stop()
// description  : stop LVD0 or LVD1
// input param  : - lvdType : LVD level type
//                      LVD_2V_TO_3V for LVD_2_00_V ~ LVD_2_85_V
//                      LVD_3V_TO_4V for LVD_3_15_V ~ LVD_4_5_V
// retval       : none (all parameters can only use the defined values, otherwise the function will be disabled)
// note         : 
//******************************************************************************
void DRV_LVD_Stop(LVD_TYPE lvdType);

//******************************************************************************
// name         : DRV_LVD0_IRQ()
// description  : LVD0 interrupt service routine
// retval       : none
// note         : 
//******************************************************************************
void __interrupt DRV_LVD0_IRQ(void);

//******************************************************************************
// name         : DRV_LVD1_IRQ()
// description  : LVD1 interrupt service routine
// retval       : none
// note         : 
//******************************************************************************
void __interrupt DRV_LVD1_IRQ(void);

#endif