//******************************************************************************
// file         : DRV_SQ7705_XTAL.c
// version      : V1.2 (2023/08/24)
// description  : XTAL functions
// note         :
//******************************************************************************
#include "DRV_SQ7705_XTAL.h"

//******************************************************************************
// name         : DRV_LXTAL_Init
// description  : Initialize low speed external 32.768kHz XTAL 
// input param  : ---
// retval       : ---
// note         : ---
//******************************************************************************
void DRV_LXTAL_Init(void)
{
    P4CFGCR = 0x80 | 0x60 | 0x07;      // P4.6 LXIN
    P4CFGCR = 0x80 | 0x50 | 0x07;      // P4.5 is LXOUT 
 
    CLKCR2_SCKLF = 1;                  // Low speed clock select -- 1:LXTAL
    CLKCR1_LXEN = 1;                   // enable low speed clock
    while(CLKST_LXRDY == 0);           // wait clock ready
}

//******************************************************************************
// name         : DRV_HXTAL_Init
// description  : Initialize high speed external 16Mhz XTAL 
// input param  : ---
// retval       : ---
// note         : ---
//******************************************************************************
void DRV_HXTAL_Init(void)
{
    P4CFGCR =  0x80 | 0x40 | 0x07;     // P4.4 HXIN
    P4CFGCR =  0x80 | 0x30 | 0x07;     // P4.3 HXOUT
    
    CLKCR1_HXEN = 1;                   // enable high speed external XTAL 1~16 MHz
    while (CLKST_HXRDY == 0);          // wait HXTAL clock ready
}
