//******************************************************************************
// file         : DRV_SQ7705_LEUART.h
// version      : V1.3 (2025/03/13)
// description  : LEUART header file
// note         : 
//******************************************************************************
#ifndef _DRV_SQ7705_LEUART_H_
#define _DRV_SQ7705_LEUART_H_

#include "TypeDefs.h"
#include "SQ7705_SFR.h"

extern uint8_t rxIntFlag;        // 0:init value.  1:Rx interrupt occurs
extern uint8_t rxRecvData;       // RX received 1-byte data

#ifndef UART_BAUD_RATE_SET
#define UART_BAUD_RATE_SET

// UART_Operating_Frequency@24MHZ.
#define Operat24M_Baud128000   0x0A04   // (DR = 0x0A, RT = 0x4).
#define Operat24M_Baud115200   0x0C00   // (DR = 0x0C, RT = 0x0).
#define Operat24M_Baud76800    0x1201   // (DR = 0x12, RT = 0x1).
#define Operat24M_Baud62500    0x1700   // (DR = 0x17, RT = 0x0).
#define Operat24M_Baud57600    0x1900   // (DR = 0x19, RT = 0x0).
#define Operat24M_Baud38400    0x2600   // (DR = 0x26, RT = 0x0).
#define Operat24M_Baud19200    0x4D00   // (DR = 0x4D, RT = 0x0).
#define Operat24M_Baud9600     0x9204   // (DR = 0x92, RT = 0x4).

// UART_Operating_Frequency@16MHZ.
#define Operat16M_Baud128000   0x0703   // (DR = 0x07, RT = 0x3).
#define Operat16M_Baud115200   0x0803   // (DR = 0x08, RT = 0x3).
#define Operat16M_Baud76800    0x0C00   // (DR = 0x0C, RT = 0x0).
#define Operat16M_Baud62500    0x0F00   // (DR = 0x0F, RT = 0x0).
#define Operat16M_Baud57600    0x1103   // (DR = 0x11, RT = 0x3).
#define Operat16M_Baud38400    0x1900   // (DR = 0x19, RT = 0x0).
#define Operat16M_Baud19200    0x3004   // (DR = 0x30, RT = 0x4).
#define Operat16M_Baud9600     0x6401   // (DR = 0x64, RT = 0x1).
#define Operat16M_Baud4800     0xC901   // (DR = 0xC9, RT = 0x1).

// UART_Operating_Frequency@12MHZ.
#define Operat12M_Baud128000   0x0503   // (DR = 0x05, RT = 0x3).
#define Operat12M_Baud115200   0x0602   // (DR = 0x06, RT = 0x2).
#define Operat12M_Baud76800    0x0903   // (DR = 0x09, RT = 0x3).
#define Operat12M_Baud62500    0x0B00   // (DR = 0x0B, RT = 0x0).
#define Operat12M_Baud57600    0x0C00   // (DR = 0x0C, RT = 0x0).
#define Operat12M_Baud38400    0x1201   // (DR = 0x12, RT = 0x1).
#define Operat12M_Baud19200    0x2600   // (DR = 0x26, RT = 0x0).
#define Operat12M_Baud9600     0x4D00   // (DR = 0x4D, RT = 0x0).
#define Operat12M_Baud4800     0x9200   // (DR = 0x92, RT = 0x4).

// UART_Operating_Frequency@8MHZ.
#define Operat8M_Baud128000    0x0303   // (DR = 0x03, RT = 0x3).
#define Operat8M_Baud76800     0x0602   // (DR = 0x06, RT = 0x2).
#define Operat8M_Baud62500     0x0700   // (DR = 0x07, RT = 0x0).
#define Operat8M_Baud57600     0x0803   // (DR = 0x08, RT = 0x3).
#define Operat8M_Baud38400     0x0C00   // (DR = 0x0C, RT = 0x0).
#define Operat8M_Baud19200     0x1900   // (DR = 0x19, RT = 0x0).
#define Operat8M_Baud9600      0x3004   // (DR = 0x30, RT = 0x4).
#define Operat8M_Baud4800      0x6401   // (DR = 0x64, RT = 0x1).
#define Operat8M_Baud2400      0xC901   // (DR = 0xC9, RT = 0x1).

// UART_Operating_Frequency@4MHZ.
#define Operat4M_Baud128000    0x0103   // (DR = 0x01, RT = 0x3).
#define Operat4M_Baud62500     0x0300   // (DR = 0x03, RT = 0x0).
#define Operat4M_Baud38400     0x0602   // (DR = 0x06, RT = 0x2).
#define Operat4M_Baud19200     0x0C00   // (DR = 0x0C, RT = 0x0).
#define Operat4M_Baud9600      0x1900   // (DR = 0x19, RT = 0x0).
#define Operat4M_Baud4800      0x3004   // (DR = 0x30, RT = 0x4).
#define Operat4M_Baud2400      0x6401   // (DR = 0x64, RT = 0x1).
#define Operat4M_Baud1200      0xC901   // (DR = 0xC9, RT = 0x1).

// UART_Operating_Frequency@2MHZ.
#define Operat2M_Baud128000    0x0003   // (DR = 0x00, RT = 0x3).
#define Operat2M_Baud62500     0x0100   // (DR = 0x01, RT = 0x0).
#define Operat2M_Baud19200     0x0602   // (DR = 0x06, RT = 0x2).
#define Operat2M_Baud9600      0x0C00   // (DR = 0x0C, RT = 0x0).
#define Operat2M_Baud4800      0x1900   // (DR = 0x19, RT = 0x0).
#define Operat2M_Baud2400      0x3004   // (DR = 0x30, RT = 0x4).
#define Operat2M_Baud1200      0x6401   // (DR = 0x64, RT = 0x1).

// UART_Operating_Frequency@1MHZ.
#define Operat1M_Baud62500     0x0000   // (DR = 0x00, RT = 0x0).
#define Operat1M_Baud9600      0x0602   // (DR = 0x06, RT = 0x2).
#define Operat1M_Baud4800      0x0C00   // (DR = 0x0C, RT = 0x0).
#define Operat1M_Baud2400      0x1900   // (DR = 0x19, RT = 0x0).
#define Operat1M_Baud1200      0x3004   // (DR = 0x30, RT = 0x4).

#define OperatLSCLK_Baud9600    0x00
#define OperatLSCLK_Baud4800    0x01
#define OperatLSCLK_Baud14400   0x02
#define OperatLSCLK_Baud19200   0x03
#define OperatLSCLK_Baud28800   0x04
#define OperatLSCLK_Baud57600   0x05

#endif

typedef void (*LEUART_CALLBACK) (void);  // type define of LEUART callback function pointer

typedef enum{
    LEUART_RX_P05_TX_P06 = 0,            // LEUART must this pair
    LEUART_RX_P12_TX_P13,
    LEUART_RX_P24_TX_P25
}LEUART_IO_LIST;

typedef enum{
    LEUART_FSCLK_DIV_1 = 0,
    LEUART_FSCLK_DIV_2,
    LEUART_FSCLK_DIV_4,
    LEUART_FSCLK_DIV_8
}LEUART_SYSTEM_CLOCK_DIV_LIST;

typedef enum{
    LEAURT_Use_SystmeClock = 0,
    LEAURT_Use_ExternalLowSpeedClock
}LEUART_CLOCK_SOURCE_LIST;

typedef enum{
    LEUART_TXIRQ_TXEPTUEN  = 0x40,   // Enable TX FIFO empty interrupt 
    LEUART_TXIRQ_TXUTHIEN  = 0x20,   // Enable FIFO under threshold interrupt
    LEUART_TXIRQ_TXBYTEIEN = 0x10    // Enable TX send 1-byte interrupt
}LEUART_TXIRQEN_LIST;

typedef enum{
    LEUART_RXIRQ_RXERRIEN  = 0x08,   // Enable RX receive error interrupt
    LEUART_RXIRQ_RXFULLIEN = 0x04,   // Enable RX FIFO full interrupt
    LEUART_RXIRQ_RXOTHIEN  = 0x02,   // Enable RX FIFO over threshold interrupt
    LEUART_RXIRQ_RXBYTEIEN = 0x01    // Enable RX receive 1-byte interrupt
}LEUART_RXIRQEN_LIST;

void DRV_LEUART_Init(LEUART_IO_LIST ioSel);
void DRV_LEUART_BaudRate(LEUART_CLOCK_SOURCE_LIST clockSel, uint16_t baudrate);
void DRV_LEUART_DeInit(LEUART_IO_LIST ioSel);
void DRV_LEUART_TX_IRQ_Init(LEUART_TXIRQEN_LIST irq, LEUART_CALLBACK txCB);
void DRV_LEUART_RX_IRQ_Init(LEUART_RXIRQEN_LIST irq, LEUART_CALLBACK rxCB);
void DRV_LEUART_Start();
void DRV_LEUART_Stop();
void DRV_LEUART_SendBytes(uint8_t *buf, uint16_t length);
void DRV_LEUART_SendByte(uint8_t data);
void __interrupt DRV_LEUART_RX_IRQ(void);
void __interrupt DRV_LEUART_TX_IRQ(void);

#endif