//******************************************************************************
// file         : DRV_SQ7705_KWU.h
// version      : V1.2 2023/09/06
// description  : KWU header file
// note         : 
//******************************************************************************
#ifndef _DRV_SQ7705_KWU_H__
#define _DRV_SQ7705_KWU_H__

#include "TypeDefs.h"
#include "SQ7705_SFR.h"

typedef enum{
    KWU0_P00 = 0x000,
    KWU0_P10 = 0x001,
    KWU0_P20 = 0x002,
    
    KWU1_P01 = 0x100,
    KWU1_P11 = 0x104,
    KWU1_P21 = 0x108,
    
    KWU2_P02 = 0x200,
    KWU2_P12 = 0x210,
    KWU2_P22 = 0x220,
    KWU2_P32 = 0x230,
    
    KWU3_P03 = 0x300,
    KWU3_P13 = 0x340,
    KWU3_P23 = 0x380,
    KWU3_P33 = 0x3C0,
    
    KWU4_P04 = 0x400,
    KWU4_P14 = 0x401,
    KWU4_P24 = 0x402,
    KWU4_P34 = 0x403,
    
    KWU5_P05 = 0x500,
    KWU5_P15 = 0x504,
    KWU5_P25 = 0x508,
    KWU5_P35 = 0x50C,

    KWU6_P06 = 0x600,
    KWU6_P16 = 0x610,
    KWU6_P26 = 0x620,
    KWU6_P36 = 0x630,
    
    KWU7_P07 = 0x700,
    KWU7_P17 = 0x740,
    
    KWU7_P37 = 0x7C0,
    
    KWU8_P50 = 0x801,
    KWU8_P60 = 0x802,
    KWU8_P70 = 0x803,
    
    KWU9_P51 = 0x904,
    KWU9_P61 = 0x908,
    KWU9_P71 = 0x90C,
    
    KWU10_P42 = 0xA00,
    KWU10_P52 = 0xA10,
    KWU10_P62 = 0xA20,
    KWU10_P72 = 0xA30,
    
    KWU11_P43 = 0xB00,
    KWU11_P53 = 0xB40,
    KWU11_P63 = 0xB80,
    
    KWU12_P44 = 0xC00,
    KWU12_P54 = 0xC01,
    KWU12_P64 = 0xC02,
    KWU12_P74 = 0xC03,
    
    KWU13_P45 = 0xD00,
    KWU13_P55 = 0xD04,
    KWU13_P65 = 0xD08,
    KWU13_P75 = 0xD0C,
    
    KWU14_P46 = 0xE00,
    KWU14_P56 = 0xE10,
    KWU14_P66 = 0xE20,
    
    KWU15_P47 = 0xF00,
    KWU15_P57 = 0xF40
}KWU_PIN_LIST;

typedef enum{
    KWU_WAKE_USE_LOW_LV,
    KWU_WAKE_USE_HIGH_LV
}KWU_WAKE_UP_SET_LIST;

void DRV_KWU_Init(KWU_PIN_LIST pin, KWU_WAKE_UP_SET_LIST level);
void DRV_KWU_DeInit(KWU_PIN_LIST pin);

#endif