//******************************************************************************
// file         : DRV_SQ7705_KWU.c
// version      : V1.2 2023/09/06  
// description  : KWU related functions
// note         : KWU related functions are gathered in this subroutine
//******************************************************************************
#include "DRV_SQ7705_KWU.h"

uint16_t *p_specialReg;
uint16_t *p_controlReg;

//******************************************************************************
// name         : DRV_KWU_Init()
// description  : KWU initialization
// input param  : pin : KWU_PIN_LIST wakeup pin enumeration
//                level : wakeup level
// output param :
// retval       :
// note         :
//******************************************************************************
void DRV_KWU_Init(KWU_PIN_LIST pin, KWU_WAKE_UP_SET_LIST level)
{
    uint8_t sr = (uint8_t)(pin >> 8);
    uint8_t st = pin;
    
    p_specialReg = (uint16_t *)(0x018C + (sr/4));
    *p_specialReg &= ~( 3  << ( (sr % 4) * 2 ));      // Claer KWUSRx_KWUx
    *p_specialReg |= (uint16_t)st;                    // Set KWUSRx_KWUx
    
    p_controlReg = (uint16_t *)(0x0188 + (sr / 4));
    *p_controlReg |= ( ( ( level << 1 ) &  3 ) |  1 ) << ( (sr % 4) * 2 );
}

//******************************************************************************
// name         : DRV_KWU_DeInit()
// description  : Deinitialize KWU
// input param  : pin : KWU_PIN_LIST wakeup pin enumeration
// output param : 
// retval       : 
// note         :
//******************************************************************************
void DRV_KWU_DeInit(KWU_PIN_LIST pin)
{
    uint8_t sr = pin >> 8;
    uint8_t st = pin;

    p_specialReg = (uint16_t *)(0x018C + (sr / 4));
    *p_specialReg &= ~( 3  << ( (sr % 4) * 2 ));
    p_controlReg = (uint16_t *)(0x0188 + (sr / 4));
    *p_controlReg &= ~( 3  << ( (sr % 4) * 2 ));
}
