//******************************************************************************
// file         : DRV_SQ7705_TRNG.c
// version      : V1.2 2024/01/05
// description  : TRNG related functions
// note         : TRNG related functions are gathered in this subroutine
//******************************************************************************
#include "DRV_SQ7705_TRNG.h"

//******************************************************************************
// name         : DRV_TRNG_Init()
// description  : TRNG initialization
// input param  : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_TRNG_Init()
{
    PCKEN4_TRNG = 1 ;              // enable TRNG
    //====== parameter setting ======
    // TRNGCFG_RTMR    // Rotate timer 00: 128 ms, 01: 256 ms, 10: 512 ms, 11: 1 second
    // TRNGCFG_CAPM    // 0: 32bits for 32 clock cycles, 1: 32bits for 1 clock cycle
    // TRNGCFG_TRNGMD  // Mode select
    //                 // 00: Mode 0 - TRNG (normal user mode)
    //                 // 01: Mode 1 - CASR (Cellular Automata Shift Register)
    //                 // 10: Mode 2 - MPSR (Multi-stage Shift Register)
    //                 // 11: Mode 3 - CASR+MPSR
    // TRNGCFG_MORE    // Mode rartation Enable, 0: Forbidden, 1:Enable(Mode0->Mode3->Mode0...)
    TRNGCFG_RTMR = 0x00;           // once for 128ms
    TRNGCFG_CAPM = 0;              // 32bits for 32 cycles
    TRNGCFG_TRNGMD = 0x00;         // Set TRNG Mode
    TRNGCFG_MDRE = 0;
    // __ASM("DI");
    // IER_TRNG = 1;               // enable TRNG interrupt
    // TRNGCR_TRNGEN = 1;          // start TRNG
    // __ASM("EI");
    while(!TRNGCR_TRNGRDY);        // wait for true random number generating ready 
}

//******************************************************************************
// name         : DRV_TRNG_DeInit()
// description  : Deinitialize TRNG
// input param  : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_TRNG_DeInit()
{
    __ASM("DI");
    PCKEN4_TRNG = 0 ;              // disable TRNG 
    // IER_TRNG  = 0;              // disable TRNG interrupt
    // TRNGCR_TRNGEN = 0;          // stop TRNG
    __ASM("EI");
}

//******************************************************************************
// name         : DRV_TRNG_Generate()
// description  : generate a 32-bit true random number
// output param : - outputTRNG : 32-bit true random number
// retval       : 
// note         : 
//******************************************************************************
void DRV_TRNG_Generate(uint8_t* outputTRNG)
{
    // afer read 4th byte, then automatically generate another true random number
    outputTRNG[0]=TRNGDR0;
    outputTRNG[1]=TRNGDR1;
    outputTRNG[2]=TRNGDR2;
    outputTRNG[3]=TRNGDR3;
    while(!TRNGCR_TRNGRDY);        // wait for true random number generating ready      
}
