//******************************************************************************
// file         : DRV_SQ7705_HASHDRBG.h
// version      : V1.2 2023/10/11
// description  : HashDRBG header file
// note         : Must include DRV_SQ7705_SHA and DRV_SQ7705_TRNG
//******************************************************************************
#ifndef _DRV_SQ7705_HASHDRBG_H_
#define _DRV_SQ7705_HASHDRBG_H_

#include <stdlib.h>
#include "TypeDefs.h"
#include "DRV_SQ7705_SHA.h"
#include "DRV_SQ7705_TRNG.h"

#define MAX_ENTROPY_LEN     64
#define MAX_NONCE_LEN       32
#define MAX_PERS_LEN        64

#define SEED_MATERIAL_LEN  (MAX_ENTROPY_LEN+MAX_NONCE_LEN+MAX_PERS_LEN)
#define HASHDRBG_SEED_LEN   55
#define HASHDRBG_OUT_LEN    32


//******************************************************************************
// name         : DRV_HASHDRBG_Instantiate()
// description  : Acquire entropy input, nonce, personalization string
//                Create seed and initial internal states
// input param  : - entropyInput : entropy data
//                - entropyLength : entropy data length
//                - nonce : nonce data
//                - nonceLength : nonce data length
//                - persString : personalization String
//                - persLength : personalization String length
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_HASHDRBG_Instantiate(uint8_t* entropyInput, uint8_t entropyLength,
uint8_t* nonce, uint8_t nonceLength, uint8_t* persString, uint8_t persLength);

//******************************************************************************
// name         : DRV_HASHDRBG_Reseed()
// description  : Acquire new entropy input, Create new seed and internal states
// input param  : - entropyInput : entropy data
//                - entropyLength : entropy data length
//                - additionalInput : additional data
//                - addLength : additional data length
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_HASHDRBG_Reseed(uint8_t* entropyInput, uint8_t entropyLength,
uint8_t* additionalInput, uint8_t addLength);

//******************************************************************************
// name         : DRV_HASHDRBG_Generate()
// description  : Produce pseudorandom bits, Update Internal states
// input param  : - additionalInput : additional data
//                - addLength : additional data length
//                - entropyPRInput : entropy prediction data
//                - entropyPRLength : entropy prediction data length
//                - returnedBytes : returned data
//                - requestedLength : returned data length
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_HASHDRBG_Generate(uint8_t* additionalInput, uint8_t addLength, 
uint8_t* entropyPRInput, uint8_t entropyPRLength, uint8_t* returnedBytes, uint8_t requestedLength);

//******************************************************************************
// name         : DRV_HASHDRBG_GetRandomNumber()
// description  : generate 32-byte random numbers using HashDRBG 
// output param : - outputDRBG : 32-byte random numbers
// retval       : 
// note         : 
//******************************************************************************
void DRV_HASHDRBG_GetRandomNumber(uint8_t* outputDRBG);
#endif