//******************************************************************************
// file         : DRV_SQ7705_HMAC.h
// version      : V1.2 2023/10/02
// description  : EEPROM header file
// note         : 
//****************************************************************************** 
#ifndef _DRV_SQ7705_HMAC_H__
#define _DRV_SQ7705_HMAC_H__

#include "TypeDefs.h"
#include "SQ7705_SFR.h"
#define SHA256_BLOCK_LEN  64
#define SHA256_DIGESTLEN 32
#define HMAC_DIGEST_LEN 32 
#define HMAC_KEY_LEN HMAC_DIGEST_LEN
#define HMAC_OK 0
#define HMAC_LEN_ERR 1

typedef struct 
{       	    
    uint8_t keyOpad[SHA256_BLOCK_LEN];    //key XOR opad
    uint8_t keyInpad[SHA256_BLOCK_LEN];   //key XOR Inpad 
    uint8_t digestInnerHash[SHA256_DIGESTLEN];
    uint8_t mac[SHA256_DIGESTLEN];    	
} HMAC_SHA256_INFO;
void DRV_HMAC_Init(HMAC_SHA256_INFO *hmac,uint8_t *key);
void DRV_HMAC_Update(HMAC_SHA256_INFO *hmac, uint8_t memType, uint8_t *msgAddress);
uint8_t DRV_HMAC_Final(HMAC_SHA256_INFO *hmac, uint8_t memType, uint8_t *msgAddress, uint8_t msgLen);

#endif