//******************************************************************************
// file         : main.c
// version      : V1.3  2023/11/20
// description  : main program, after initialization HMAC, perform HAMC
//                if get the correct result, light on LED1
//
// note         : [LED Configuration] LED1 (P2.0)
// online HMAC https://www.liavaag.org/English/SHA-Generator/HMAC/
//******************************************************************************
#ifndef IO_MEM
#define IO_MEM
#endif
#include "ADM_main.h"
#include "DRV_SQ7705_GPIO.h"
#include "DRV_SQ7705_SHA.h"
#include "DRV_SQ7705_SYSCLK.h"
#include "DRV_SQ7705_HMAC.h"

uint8_t hmacKey1[32] = {
    0x4d, 0xab, 0x03, 0x9a, 0x26, 0x36, 0x62, 0x2f, 0xea, 0x19, 0xd9, 0x62, 0x4c, 0x35, 0x07, 0x55,
    0x95, 0x69, 0xf5, 0xfa, 0x16, 0x14, 0xe9, 0x2f, 0x6b, 0x99, 0xac, 0x57, 0x24, 0x1b, 0x5f, 0xb9
};

uint8_t hmacMsg1[64] = {
    0x5A, 0x86, 0xB7, 0x37, 0xEA, 0xEA, 0x8E, 0xE9, 0x76, 0xA0, 0xA2, 0x4D, 0xA6, 0x3E, 0x7E, 0xD7,
    0xEE, 0xFA, 0xD1, 0x8A, 0x10, 0x1C, 0x12, 0x11, 0xE2, 0xB3, 0x65, 0x0C, 0x51, 0x87, 0xC2, 0xA8,
    0xA6, 0x50, 0x54, 0x72, 0x08, 0x25, 0x1F, 0x6D, 0x42, 0x37, 0xE6, 0x61, 0xC7, 0xBF, 0x4C, 0x77,
    0xF3, 0x35, 0x39, 0x03, 0x94, 0xC3, 0x7F, 0xA1, 0xA9, 0xF9, 0xBE, 0x83, 0x6A, 0xC2, 0x85, 0x09
};

uint8_t hmacMsg2[64] = {
    0xAA, 0xBB, 0xB7, 0x37, 0xEA, 0xEA, 0x8E, 0xE9, 0x76, 0xA0, 0xA2, 0x4D, 0xA6, 0x3E, 0x7E, 0xD7,
    0xEE, 0xFA, 0xD1, 0x8A, 0x10, 0x1C, 0x12, 0x11, 0xE2, 0xB3, 0x65, 0x0C, 0x51, 0x87, 0xC2, 0xA8,
    0xA6, 0x50, 0x54, 0x72, 0x08, 0x25, 0x1F, 0x6D, 0x42, 0x37, 0xE6, 0x61, 0xC7, 0xBF, 0x4C, 0x77,
    0xF3, 0x35, 0x39, 0x03, 0x94, 0xC3, 0x7F, 0xA1, 0xA9, 0xF9, 0xBE, 0x83, 0x6A, 0xC2, 0xAA, 0xBB
};

uint8_t hmacMsg3[32] = {
    0x5A, 0x86, 0xB7, 0x37, 0xEA, 0xEA, 0x8E, 0xE9, 0x76, 0xA0, 0xA2, 0x4D, 0xA6, 0x3E, 0x7E, 0xD7,
    0xEE, 0xFA, 0xD1, 0x8A, 0x10, 0x1C, 0x12, 0x11, 0xE2, 0xB3, 0x65, 0x0C, 0x51, 0x87, 0xC2, 0xA8,
};

uint8_t hmacAns1[32] = {
    0XCC, 0X0E, 0XCF, 0X08, 0X18, 0X64, 0X44, 0X13, 0XAD, 0X95, 0XA8, 0XB3, 0X62, 0XFD, 0XA6, 0XFC,
    0X1D, 0X47, 0X7B, 0XD1, 0X1A, 0X0C, 0X7F, 0XC8, 0X76, 0XF7, 0X62, 0XAE, 0X0E, 0X03, 0X3D, 0X9E
};

uint8_t hmacAns2[32] = {
    0XC5, 0XC6, 0XAA, 0XC3, 0X57, 0XA4, 0XDE, 0XBC, 0XFE, 0XF9, 0XCC, 0X0A, 0XE4, 0X90, 0X8F, 0X0C,
    0X17, 0X56, 0X7F, 0X0B, 0XC7, 0X39, 0XD3, 0XAF, 0X1D, 0XD9, 0XAC, 0XC5, 0XB3, 0X79, 0X86, 0XCE
};

uint8_t hmacAns3[32] = {
    0X5E, 0X57, 0XCA, 0X85, 0X74, 0XAD, 0XAF, 0XE6, 0X69, 0X13, 0X6E, 0XB3, 0X6D, 0X02, 0XDF, 0X88,
    0X2D, 0X71, 0X42, 0X6A, 0X62, 0X18, 0X08, 0XDF, 0XB2, 0XFB, 0XDA, 0X05, 0XE5, 0XB9, 0XAE, 0XCF
};
uint8_t isCorrect;
HMAC_SHA256_INFO hmac;


/*----------------------------------------------------------------------------*/
void ADM_Main()
{
    uint8_t  demoCase = 1;
    uint8_t i = 2, idx = 0;
    DIS_WDT;                                                 // Disable watch dog timer.

    DRV_Clock_Init(Clk_Source_SYS, 1);                       // PLL 24MHz Initial system clock.    
    DRV_GPIO_Init(GPIO_P20, GPIO_OUTPUT, GPIO_PULL_UP);      // set P2.0 as output pin

    for ( i = 0; i < 3; i++) {
        switch (i) {
            case 0:                                          //message length 1~64
                DRV_HMAC_Init(&hmac, hmacKey1);
                DRV_HMAC_Final(&hmac, SRAM, hmacMsg1, 64);
                isCorrect = TRUE;
                for (idx = 0; idx < 32; idx++) {
                    if (hmac.mac[idx] != hmacAns1[idx]) {
                        isCorrect = FALSE;
                        break;
                    }
                }
                break;

            case 1:                                          //message length > 64 
                DRV_HMAC_Init(&hmac, hmacKey1);
                DRV_HMAC_Update(&hmac, SRAM, hmacMsg1);
                DRV_HMAC_Final(&hmac, SRAM, hmacMsg3, 17);
                isCorrect = TRUE;
                for (idx = 0; idx < 32; idx++) {
                    if (hmac.mac[idx] != hmacAns2[idx]) {
                        isCorrect = FALSE;
                        break;
                    }
                }
                break;

            case 2:                                           //message length > 64
                DRV_HMAC_Init(&hmac, hmacKey1);
                DRV_HMAC_Update(&hmac, SRAM, hmacMsg1);
                DRV_HMAC_Update(&hmac, SRAM, hmacMsg2);
                DRV_HMAC_Final(&hmac, SRAM, hmacMsg3, 17);
                isCorrect = TRUE;
                for (idx = 0; idx < 32; idx++) {
                    if (hmac.mac[idx] != hmacAns3[idx]) {
                        isCorrect = FALSE;
                        break;
                    }
                }
                break;

            default:
                break;
        }

        if (isCorrect == FALSE)                               //Failed
            break;
    }

    LED1_off;

    while (1) {
        if (isCorrect == TRUE) {
            LED1_on;                                          // light on LED1
        } else {
            LED1_off;                                         // light off LED1
        }
    }
}




/* ----------------------- interrupt service routine ------------------------ */
void __interrupt OnlyReti(void)
{
    __ASM("NOP");                                             // no operation
}

void __interrupt_n OnlyRetn(void)
{
    __ASM("NOP");                                             // no operation
}

void __interrupt_n WDT_IRQ(void)
{
    __ASM("NOP");                                             // no operation
}

void __interrupt_n SWI_IRQ(void)                              // software reset interrupt service routine
{
    SWRST = 0x5a;
    SWRST = 0xa5;
    SWRST = 0xc3;
    SWRST = 0x3c;
}

void __interrupt IntADM_Req(void)
{

}

/* ---------------------- end of interrupt service routine ------------------ */


/* ----------------------- SQ7705 interrupt vector -------------------------- */
#pragma section const ADM_INT_VECTOR
void *const IntTbl1[] = {
    ADM_STARTUP,             /* 0x0000 : RESET               */    //non-maskable
    SWI_IRQ,                 /* 0x0002 : SWI_IRQ/INTUNDEF    */    //non-maskable
    (void *)0xffff,          /* 0x0004 : Reserved            */
    WDT_IRQ,                 /* 0x0006 : WDT_IRQ             */    //non-maskable interrupt source:watchdog timer
    OnlyReti,                /* 0x0008 : TAMPER_IRQ          */    //interrupt source:tamper detection
    OnlyReti,                /* 0x000A : CFD_IRQ             */    //interrupt source:clock faildetection
    OnlyReti,                /* 0x000C : HVD_IRQ             */
    IntADM_Req,              /* 0x000E : U2A_IRQ/IntADM_Req  */    //interrupt source:user mode to admin mode
    OnlyReti,                /* 0x0010 : RTC_IRQ             */    //interrupt source:real-time clock timer
    OnlyReti,                /* 0x0012 : TMRA00_IRQ          */    //interrupt source:TMRA00 8-bit timer
    OnlyReti,                /* 0x0014 : TMRA01_IRQ          */    //interrupt source:TMRA01 8-bit timer
    OnlyReti,                /* 0x0016 : TMRA10_IRQ          */    //interrupt source:TMRA10 8-bit timer
    OnlyReti,                /* 0x0018 : TMRA11_IRQ          */    //interrupt source:TMRA11 8-bit timer
    OnlyReti,                /* 0x001A : TMRA20_IRQ          */
    OnlyReti,                /* 0x001C : TMRA21_IRQ          */
    OnlyReti,                /* 0x001E : TBT_IRQ             */
    OnlyReti,                /* 0x0020 : RX0_IRQ             */    //interrupt source:UART0 RX0
    OnlyReti,                /* 0x0022 : TX0_IRQ             */    //interrupt source:UART0 TX0
    OnlyReti,                /* 0x0024 : I2C0_IRQ            */    //interrupt source:I2C0
    OnlyReti,                /* 0x0026 : SPI0_IRQ            */    //interrupt source:SPI0
    OnlyReti,                /* 0x0028 : EXT0_IRQ            */    //external interrupt0
    OnlyReti,                /* 0x002A : EXT1_IRQ            */    //external interrupt1
    OnlyReti,                /* 0x002C : EXT2_IRQ            */    //external interrupt2
    OnlyReti,                /* 0x002E : EXT3_IRQ            */    //external interrupt3
    OnlyReti,                /* 0x0030 : ADC_IRQ             */    //interrupt source:ADC
    OnlyReti,                /* 0x0032 : LVD0_IRQ            */
    OnlyReti,                /* 0x0034 : LVD1_IRQ            */
    OnlyReti,                /* 0x0036 : Reserved            */
    OnlyReti,                /* 0x0038 : Reserved            */
    OnlyReti,                /* 0x003A : FMC_IRQ             */    //interrupt source:flash memory controller
    OnlyReti,                /* 0x003C : DMACH0_IRQ          */
    OnlyReti,                /* 0x003E : DMACH1_IRQ          */
    OnlyReti,                /* 0x0040 : DMACH2_IRQ          */
    OnlyReti,                /* 0x0042 : DMACH3_IRQ          */
    OnlyReti,                /* 0x0044 : Reserved            */
    OnlyReti,                /* 0x0046 : Reserved            */
    OnlyReti,                /* 0x0048 : Reserved            */
    OnlyReti,                /* 0x004A : Reserved            */
    OnlyReti,                /* 0x004C : Reserved            */
    OnlyReti,                /* 0x004E : DIC_IRQ             */    //interrupt source:DIC
    OnlyReti,                /* 0x0050 : LEUART_RX_IRQ       */
    OnlyReti,                /* 0x0052 : LEUART_TX_IRQ       */
    OnlyReti,                /* 0x0054 : TRNG_IRQ            */
    OnlyReti,                /* 0x0056 : EXT4_IRQ            */    //external interrupt4
    OnlyReti,                /* 0x0058 : EXT5_IRQ            */    //external interrupt5
    OnlyReti,                /* 0x005A : EXT6_IRQ            */    //external interrupt6
    OnlyReti,                /* 0x005C : EXT7_IRQ            */    //external interrupt7
    OnlyReti,                /* 0x005E : EEMC_IRQ            */    //interrupt source:EEPROM controller
    OnlyReti,                /* 0x0060 : TCA0_IRQ            */    //interrupt source:TCA0 16-bit timer
    OnlyReti,                /* 0x0062 : TCA1_IRQ            */    //interrupt source:TCA1 16-bit timer
    OnlyReti,                /* 0x0064 : STM0_IRQ            */
    OnlyReti,                /* 0x0066 : STM1_IRQ            */
    OnlyReti,                /* 0x0068 : AES_IRQ             */
    OnlyReti,                /* 0x006A : SHA_IRQ             */
    OnlyReti,                /* 0x006C : RX1_IRQ             */    //interrupt source:UART1 RX1
    OnlyReti,                /* 0x006E : TX1_IRQ             */    //interrupt source:UART1 TX1
    OnlyReti,                /* 0x0070 : I2C1_IRQ            */    //interrupt source:I2C1
    OnlyReti,                /* 0x0072 : SPI1_IRQ            */    //interrupt source:SPI1
    OnlyReti,                /* 0x0074 : RX2_IRQ             */    //interrupt source:UART2 RX2
    OnlyReti,                /* 0x0076 : TX2_IRQ             */    //interrupt source:UART2 TX2
    OnlyReti                 /* 0x0078 : TCA2_IRQ            */    //interrupt source:TCA2 16-bit timer
};
#pragma section const
/* -------------------- end of SQ7705 interrupt vector ---------------------- */

