//******************************************************************************
// file         : DRV_SQ7705_FLASH.h
// version      : V1.2 2023/08/31
// description  : Flash header file
// note         : 
//****************************************************************************** 
#ifndef _DRV_SQ7705_FLASH_H__
#define _DRV_SQ7705_FLASH_H__

#include "TypeDefs.h"
#include "SQ7705_SFR.h"

//******************************************************************************
// name         : DRV_FLASH_Init()
// description  : initialize flash clock(FCKDIV)
// input param  : 
// output param : 
// retval       : 
// note         : sysclk : System clock frequency in MHz
//******************************************************************************
void DRV_FLASH_Init(uint8_t sysclk);

//******************************************************************************
// name         : DRV_FLASH_EraseSector()
// description  : sector erase of flash memory
// input param  : - address : start address to erase
// output param : 
// retval       : - 0 : erase successful
//                - 1 : erase fail
// note         : erase 32 bytes
//******************************************************************************
uint8_t DRV_FLASH_EraseSector(uint16_t address);

//******************************************************************************
// name         : DRV_FLASH_WriteByte()
// description  : program one byte data in the flash memory
// input param  : - address : program address
//                - data : program data
// output param : 
// retval       : - 0 : program successful
//                - 1 : program fail
// note         : 
//******************************************************************************
uint8_t DRV_FLASH_WriteByte(uint16_t address, uint8_t data);

//******************************************************************************
// name         : DRV_FLASH_ReadByte()
// description  : read one byte data in the flash memory
// input param  : - address : read address
// output param : - data : data in the flash memory
// retval       : 
// note         : 
//******************************************************************************
void DRV_FLASH_ReadByte(uint16_t address, uint8_t *data);

//******************************************************************************
// name         : DRV_FERR_CLEAR()
// description  : clear error status
// input param  : 
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_FERR_CLEAR();
#endif
