//******************************************************************************
// file         : DRV_SQ7705_EEPROM.h
// version      : V1.2 2023/09/04
// description  : EEPROM header file
// note         : 
//****************************************************************************** 
#ifndef _DRV_SQ7705_EEPROM_H__
#define _DRV_SQ7705_EEPROM_H__

#include "TypeDefs.h"
#include "SQ7705_SFR.h"

//******************************************************************************
// name         : DRV_EEPROM_Init()
// description  : initialize eeprom clock(FCKDIV)
// input param  : 
// output param : 
// retval       : 
// note         : sysclk : System clock frequency in MHz
//******************************************************************************
void DRV_EEPROM_Init(uint8_t sysclk);

//******************************************************************************
// name         : DRV_EEPROM_EraseSector()
// description  : sector erase of EEPROM
// input param  : - address : start address to erase
// output param : 
// retval       : - 0 : erase successful
//                - 1 : erase fail
// note         : erase 32 bytes
//******************************************************************************
uint8_t DRV_EEPROM_EraseSector(uint16_t address);

//******************************************************************************
// name         : DRV_EEPROM_EraseBlock()
// description  : block erase of EEPROM
// input param  : - address : start address to erase
// output param : 
// retval       : - 0 : erase successful
//                - 1 : erase fail
// note         : erase 512 bytes
//******************************************************************************
uint8_t DRV_EEPROM_EraseBlock(uint16_t address);

//******************************************************************************
// name         : DRV_EEPROM_EraseAll()
// description  : device erase of EEPROM
// input param  : 
// output param : 
// retval       : - 0 : erase successful
//                - 1 : erase fail
// note         : 
//******************************************************************************
uint8_t DRV_EEPROM_EraseAll(void);

//******************************************************************************
// name         : DRV_EEPROM_WriteByte()
// description  : program one byte data in the eeprom
// input param  : - address : program address
//                - data : program data
// output param : 
// retval       : - 0 : program successful
//                - 1 : program fail
// note         : 
//******************************************************************************
uint8_t DRV_EEPROM_WriteByte(uint16_t address, uint8_t data);

//******************************************************************************
// name         : DRV_EEPROM_ReadByte()
// description  : read one byte data in the eeprom
// input param  : - address : read address
// output param : - data : data in the eeprom
// retval       : 
// note         : 
//******************************************************************************
void DRV_EEPROM_ReadByte(uint16_t address, uint8_t *data);

//******************************************************************************
// name         : DRV_EEERR_CLEAR()
// description  : clear error status
// input param  : 
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_EEERR_CLEAR();

#endif