//******************************************************************************
// file         : DRV_SQ7705_DVO.h
// version      : V1.2 2023/08/30
// description  : DVO header file
// note         : 
//******************************************************************************
#ifndef _DRV_SQ7705_DVO_H__
#define _DRV_SQ7705_DVO_H__

#include "TypeDefs.h"
#include "SQ7705_SFR.h"

// output pin
#define DVO_OUTPUT_P62    0
#define DVO_OUTPUT_P56    1
#define DVO_OUTPUT_56_62  2

// frequency prescaler setting fsysclk/2^n  output frequency will depend on system clock    
// DVOCR_DVOCK,TBTCR_DV9CK 
#define OUTPUT_CLOCK_FSYSCLK_DIV_2_POW_12 0,0
#define OUTPUT_CLOCK_FSYSCLK_DIV_2_POW_11 1,0
#define OUTPUT_CLOCK_FSYSCLK_DIV_2_POW_10 2,0
#define OUTPUT_CLOCK_FSYSCLK_DIV_2_POW_9  3,0
#define OUTPUT_CLOCK_FSYSCLK_DIV_2_POW_5  0,1
#define OUTPUT_CLOCK_FSYSCLK_DIV_2_POW_4  1,1
#define OUTPUT_CLOCK_FSYSCLK_DIV_2_POW_3  2,1

//******************************************************************************
// name         : DRV_DVO_Init()
// description  : DVO initialization
// input param  : - dvock : TBTCR_DV9CK frequency divider parameter 1
//                - tbtcr : DVOCR_DVOCK frequency divider parameter and frequency 
//                          divider parameter determine the DVO output frequency 
//                - outpoutPin : DVO outpin  
//                #define DVO_OUTPUT_P62    0  P62
//                #define DVO_OUTPUT_P56    1  P56
//                #define DVO_OUTPUT_56_62  2  P62+P56
// retval       : none (all parameters can only use the defined values, otherwise the function will be disabled)
// note         : 
//******************************************************************************
void DRV_DVO_Init(uint8_t dvock,uint8_t tbtcr, uint8_t outpoutPin);

//******************************************************************************
// name         : DRV_DVO_Start()
// description  : start DVO
// input param  : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_DVO_Start();

//******************************************************************************
// name         : DRV_DVO_Stop()
// description  : stop DVO
// input param  : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_DVO_Stop();

#endif


