//******************************************************************************
// file         : DRV_SQ7705_DVO.c
// version      : V1.2 2023/08/30
// description  : DVO driver function
// note         : 
//******************************************************************************
#include "DRV_SQ7705_DVO.h"

//******************************************************************************
// name         : DRV_DVO_Init()
// description  : DVO initialization
// input param  : - dvock : TBTCR_DV9CK frequency divider parameter 1
//                - tbtcr : DVOCR_DVOCK frequency divider parameter and frequency 
//                          divider parameter determine the DVO output frequency 
//                - outpoutPin : DVO outpin  
//                #define DVO_OUTPUT_P62    0  P62
//                #define DVO_OUTPUT_P56    1  P56
//                #define DVO_OUTPUT_56_62  2  P62+P56
// retval       : none (all parameters can only use the defined values, otherwise the function will be disabled)
// note         : 
//******************************************************************************
void DRV_DVO_Init(uint8_t dvock, uint8_t tbtcr, uint8_t outpoutPin)
{
    TBTCR_DV9CK = tbtcr;
    DVOCR_DVOCK = dvock;

    //====== parameter setting, DVO output pin =====
    switch (outpoutPin) {
        case DVO_OUTPUT_P62:
            P6CFGCR = 0xA3;
            P6OE_P2 = 1;
            break;

        case DVO_OUTPUT_P56:
            P5CFGCR = 0xE3;
            P5OE_P6 = 1;
            break;

        case DVO_OUTPUT_56_62:
            P5CFGCR = 0xE3;
            P5OE_P6 = 1;
            P6CFGCR = 0xA3;
            P6OE_P2 = 1;
            break;

        default:
            break;
    }
}

//******************************************************************************
// name         : DRV_DVO_Start()
// description  : start DVO
// input param  : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_DVO_Start()
{
    DVOCR_DVOEN = 1;                     // DVO Enable
}

//******************************************************************************
// name         : DRV_DVO_Stop()
// description  : stop DVO
// input param  : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_DVO_Stop()
{
    DVOCR_DVOEN = 0;                     // DVO Disable
}
