//******************************************************************************
// file         : DRV_SQ7705_DMA.h
// version      : V1.2 (2023/08/31)
// description  : DMA header file
// note         : 
//******************************************************************************
#ifndef __DRV_SQ7705_DMA_H__
#define __DRV_SQ7705_DMA_H__

#include "TypeDefs.h"
#include "SQ7705_SFR.h"

/* ---------------------- extern global variables --------------------------- */
#ifndef __DRV_SQ7705_DMA_C__
extern unsigned char IntDMA0_CH_Flag;
extern unsigned char IntDMA1_CH_Flag;
extern unsigned char IntDMA2_CH_Flag;
extern unsigned char IntDMA3_CH_Flag;
#endif // __DRV_SQ7705_DMA_C__.

/* ---------------------- user-defined macros ------------------------------- */

#define DMA_CH0                     0x10
#define DMA_CH1                     0x11
#define DMA_CH2                     0x12
#define DMA_CH3                     0x13

//source/data Size          
#define DMA_BYTE                    0x00
#define DMA_HALF_WORD               0x01
#define DMA_WORD                    0x02

//------------------------------------------------------------------------------
// source/destination Select.
//------------------------------------------------------------------------------
#define DMA_MEMORY                  0x00
#define DMA_UART0_RX                0x01
#define DMA_UART0_TX                0x02
#define DMA_UART1_RX                0x03
#define DMA_UART1_TX                0x04
#define DMA_UART2_RX                0x05
#define DMA_UART2_TX                0x06
#define DMA_LEUART0_RX              0x07
#define DMA_LEUART0_TX              0x08
#define DMA_SPI0_RX                 0x09
#define DMA_SPI0_TX                 0x0A
#define DMA_SPI1_RX                 0x0B
#define DMA_SPI1_TX                 0x0C
#define DMA_AESSRC                  0x14
#define DMA_AESDST                  0x15

//------------------------------------------------------------------------------
// Address increment
//------------------------------------------------------------------------------
#define NO_INCDEC                   0x00
#define INCREMENT                   0x01

//------------------------------------------------------------------------------
// DMA Active Flag.
//------------------------------------------------------------------------------
#define DMA_InActive                0x00    // inactive
#define DMA_Active                  0x01    // active

//------------------------------------------------------------------------------
// DMA Error Flag.
//------------------------------------------------------------------------------
#define DMA_NoError                 0x00    // no error
#define DMA_SW_Error                0x02    // software active error
#define DMA_BUS_Error               0x03    // bus error

//------------------------------------------------------------------------------
// DMA memory selection.
//------------------------------------------------------------------------------
#define DMA_SFR_RAM                 0x00
#define DMA_FLASH                   0x01


/* ------------------- function prototype declaration ----------------------- */
void DRV_DMA_Init(unsigned char     dmaChannel,
                  unsigned char     sourceSelect,
                  unsigned char     sourceIncrement,
                  unsigned char     destinationSelect,
                  unsigned char     destinationIncrement,
                  unsigned short    sourceAddr,
                  unsigned short    destinationAddr);

void DRV_DMA_Size(unsigned char dmaChannel,
                  unsigned char sourceSize,
                  unsigned char destinationSize);
 
void DRV_DMA_Int(unsigned char dmaChannel , unsigned char enable);

unsigned char DRV_DMA_ReadActive(unsigned char dmaChannel);
unsigned char DRV_DMA_ReadState(unsigned char dmaChannel);
void DRV_DMA_Start(unsigned char dmaChannel, unsigned short dmacount);
void DRV_DMA_Stop(unsigned char dmaChannel);
void DRV_DMA_WaitComplet(unsigned char dmaChannel);

void __interrupt IntDMA0_CH(void);
void __interrupt IntDMA1_CH(void);
void __interrupt IntDMA2_CH(void);
void __interrupt IntDMA3_CH(void);

#endif  // __DRV_SQ7705_DMA_H__.


