//******************************************************************************
// file         : DRV_SQ7705_CTRDRBG.h
// version      : V1.2 2023/10/11
// description  : CtrDRBG header file
// note         : Must include DRV_SQ7705_AES and DRV_SQ7705_TRNG
//******************************************************************************
#ifndef _DRV_SQ7705_CTRDRBG_H_
#define _DRV_SQ7705_CTRDRBG_H_

#include <stdlib.h>
#include "TypeDefs.h"
#include "DRV_SQ7705_AES.h"
#include "DRV_SQ7705_TRNG.h"

#define CTRDRBG_TYPE_AES128    0
#define CTRDRBG_TYPE_AES256    1

#define CTRDRBG_SEED_LEN       48
#define CTRDRBG_OUT_LEN        16


//******************************************************************************
// name         : DRV_CTRDRBG_Instantiate()
// description  : Acquire entropy input, nonce, personalization string
//                Create seed and initial internal states
// input param  : - entropyInput : entropy data
//                - entropyLength : entropy data length
//                - nonce : nonce data
//                - nonceLength : nonce data length
//                - persString : personalization String
//                - persLength : personalization String length
//                - type : DRBG algorithm to use (AES128 or AES256)
//                - df : use derivation function or not
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_CTRDRBG_Instantiate(uint8_t* entropyInput, uint8_t entropyLength, uint8_t* nonce,
uint8_t nonceLength, uint8_t* persString, uint8_t persLength, uint8_t type, uint8_t df);

//******************************************************************************
// name         : DRV_CTRDRBG_Reseed()
// description  : Acquire new entropy input, Create new seed and internal states
// input param  : - entropyInput : entropy data
//                - entropyLength : entropy data length
//                - additionalInput : additional data
//                - addLength : additional data length
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_CTRDRBG_Reseed(uint8_t* entropyInput, uint8_t entropyLength, uint8_t* additionalInput, uint8_t addLength);

//******************************************************************************
// name         : DRV_CTRDRBG_Generate()
// description  : Produce pseudorandom bits, Update Internal states
// input param  : - additionalInput : additional data
//                - addLength : additional data length
//                - entropyPRInput : entropy prediction data
//                - entropyPRLength : entropy prediction data length
//                - returnedBytes : returned data
//                - requestedLength : returned data length
// output param : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_CTRDRBG_Generate(uint8_t* additionalInput, uint8_t addLength, uint8_t* entropyPRInput,
uint8_t entropyPRLength, uint8_t* returnedBytes, uint8_t requestedLength); 

//******************************************************************************
// name         : DRV_CTRDRBG_GetRandomNumber()
// description  : generate 32-byte random numbers using CtrDRBG 
// output param : - outputDRBG : 32-byte random numbers
// retval       : 
// note         : 
//******************************************************************************
void DRV_CTRDRBG_GetRandomNumber(uint8_t* outputDRBG);
#endif