//******************************************************************************
// file         : DRV_SQ7705_CRC.h
// version      : V1.3 2025/3/13
// description  : CRC header file
// note         : CRC polynomial CRC-16-CCITT (CRC-16-XMODE) : "X^16+X^12+X^5+1"
//******************************************************************************
#ifndef _DRV_SQ7705_CRC_H_
#define _DRV_SQ7705_CRC_H_

#include "TypeDefs.h"
#include "SQ7705_SFR.h"

//DIC Area DICADR2
typedef enum {
    SRC_FLASH_ARRAY = 0,   // accroding to DMCFG
    SRC_SRAM = 8,          // 0x1000~0x2FFF
    SRC_EEPROM_ARRAY = 16  // 0x3000~0x4DFF
} CRC_DIC_SRC;

#define SRC_FLASH_ARRAY_ADDR 0x0000
#define SRC_SRAM_START_ADDR 0x1000
#define SRC_EEPROM_ARRAY_ADDR 0x3000

//******************************************************************************
// name         : DRV_CRC_SrcInputData_Init()
// description  : CRC initialization
// input param  : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_CRC_SrcInputData_Init(void);

//******************************************************************************
// name         : DRV_CRC_SrcInputData_DeInit()
// description  : deinitialize CRC
// input param  : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_CRC_SrcInputData_DeInit(void);

//******************************************************************************
// name         : DRV_CRC_SrcInputData_Start()
// description  : start CRC
// input param  : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_CRC_SrcInputData_Start(void);

//******************************************************************************
// name         : DRV_CRC_SrcInputData_Stop()
// description  : stop CRC and clear result
// input param  : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_CRC_SrcInputData_Stop(void);

//******************************************************************************
// name         : DRV_CRC_SrcInputData_Calculate()
// description  : calculate CRC, data from user-defined array
// input param  : - inputLen : the length of input data
//                - inputData : input data
// output param : - crcResult : 2-byte CRC result
// retval       : 
// note         : 
//******************************************************************************
void DRV_CRC_SrcInputData_Calculate(uint8_t inputLen, uint8_t *inputData, uint8_t *crcResult);

//******************************************************************************
// name         : DRV_CRC_DIC_Init()
// description  : DIC initialization
// input param  : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_CRC_DIC_Init(void);

//******************************************************************************
// name         : DRV_CRC_DIC_Calculate()
// description  : calculate CRC, data from sram, flash or eeprom
// input param  : - dataSrc : data source
//                      typedef enum{
//                         SRC_FLAH_ARRAY=0,
//                         SRC_SRAM=8,          //0x1000~0x2FFF
//                         SRC_EEPROM_ARRAY=16  //0x3000~0x4DFF
//                      }CRC_DIC_SRC;
//                - address :
//                      #define SRC_FLASH_ARRAY_ADDR 0x0000
//                      #define SRC_SRAM_START_ADDR 0x1000
//                      #define SRC_EEPROM_ARRAY_ADDR 0x3000
//                - size : data size , if size = 0, euqal to 65536 bytes
// output param : - crcResult : 2-byte CRC result
// retval       : 
// note         : source, start address and size of data must consistent with system settings, or it won't response anything
//******************************************************************************
void DRV_CRC_DIC_Calculate(CRC_DIC_SRC dataSrc, uint16_t address, uint16_t size, uint8_t *crcResult);

//******************************************************************************
// name         : DRV_CRC_DIC_DeInit()
// description  : deinitialize DIC
// input param  : 
// retval       : 
// note         : 
//******************************************************************************
void DRV_CRC_DIC_DeInit(void);

//******************************************************************************
// name         : DRV_CRC_Check()
// description  : check if the calculated CRC value is correct
// input param  : - crc_ref : CRC comparison value
// retval       : 0 correct result ,1 fail result
// note         : 
//******************************************************************************
uint8_t  DRV_CRC_Check(uint8_t *crc_ref);

#endif

