//******************************************************************************
// file         : DRV_SQ7705_AES.h
// version      : V1.2 2024/01/23
// description  : AES header file
// note         : 
//******************************************************************************
#ifndef _DRV_SQ7705_AES_ECB_H_
#define _DRV_SQ7705_AES_ECB_H_

#include "TypeDefs.h"
#include "SQ7705_SFR.h"

extern uint16_t adm_IntAES_Flag;
extern uint8_t CMD_Tmp;

typedef enum {
    AES_Action_Encryption = 0,
    AES_Action_Decryption = 1
}AES_Action;

typedef enum {
    AES_OK = 0,
    AES_Err_Not_Initialized = 0xE0,
    AES_Err_Key_Not_Loaded,
    AES_Err_IV_Not_Loaded,
    AES_Err_Key_Not_Programmed,
    AES_Err_Block_Size_Error,
    AES_Err_Wrong_Mode,
    AES_Err_Invalid_Length,
    AES_Err_Mode_Action_NotInit
}AES_Status;

//AES Clock DIV
#define AES_CLKDIV_CRYPTO_DIV1    0x00
#define AES_CLKDIV_CRYPTO_DIV2    0x40
#define AES_CLKDIV_CRYPTO_DIV4    0x80
#define AES_CLKDIV_CRYPTO_DIV8    0xC0

//AES Clock Select
#define AES_CLKSEL_SYSCLK   0x00
#define AES_CLKSEL_CRYPTO   0x20

//AES Interrupt Enable / Disable
#define AES_IE_EN           0x08
#define AES_IE_DIS          0x00

//Key bit 128/256
#define AES_KEYSZ_128       0x00  // 16bytes
#define AES_KEYSZ_256       0x02  // 32bytes

//AES Enable / Disable
#define AES_EN              0x01
#define AES_DIS             0x00

#define Key_128bit          16
#define Key_256bit          32
#define AES_BLOCK_SIZE      16

//AES Mode
#define ECB                 0
#define CBC                 1
#define CFB                 2
#define OFB                 3
#define CTR                 4 

//Where...
#define AES_IN              0
#define Input_Buffer        1
#define Output_Buffer       2
#define IV                  3
#define Internal_Key        4 
#define Random_Number       5

//AES Operation
#define Encryption          0x00
#define Decryption          0x10
#define Load_Key            0x20
#define Program_Key         0x30
#define Load_IV             0x40
#define Load_Input_Buffer   0x50
#define Load_Output_Buffer  0x60

#define XOR                 0x80
#define Reset               0xE0
#define Abort               0xF0

void DRV_AES_Init(uint8_t aesKeySize);
void DRV_AES_Deinit(void);
void DRV_AES_Key_Size(uint8_t aesKeySize);
uint8_t DRV_AES_Load_Key_Fm_AESIN(const uint8_t *keyData, const uint8_t keyLength);
uint8_t DRV_AES_Load_Key_Fm_InternalKey(const uint8_t keyNum);
uint8_t DRV_AES_Load_Key_Fm_RandomNumber(void);
uint8_t DRV_AES_Load_Key_Fm_InputBuffer(void);
uint8_t DRV_AES_Load_Key_Fm_OutputBuffer(void);
uint8_t DRV_AES_Load_Key_Fm_IV(void);
uint8_t DRV_AES_Program_Key(const uint8_t keyNumber);
uint8_t DRV_AES_Load_Program_Key(const uint8_t aesLoadKeyMode, const uint8_t *keyData, const uint8_t aesKeySize, const uint8_t keyNumber);
uint8_t DRV_AES_Mode_Action(const uint8_t mode, const AES_Action enc);
uint8_t DRV_AES_Process_Data(const uint8_t *input, uint8_t *output);
uint8_t DRV_AES_Crypt(const uint8_t mode, const AES_Action aesAction, const uint8_t *input, uint8_t *output, uint16_t inputLength, uint8_t *iv);
uint8_t DRV_AES_ECB_Crypt(const AES_Action enc, const uint8_t *input, uint8_t *output,uint16_t inputLength);
uint8_t DRV_AES_CBC_Crypt(const AES_Action enc, const uint8_t *input, uint8_t *output,uint16_t inputLength,uint8_t *iv);
uint8_t DRV_AES_OFB_Crypt(const AES_Action enc, const uint8_t *input, uint8_t *output,uint16_t inputLength,uint8_t *iv);
uint8_t DRV_AES_CTR_Crypt(const AES_Action enc, const uint8_t *input, uint8_t *output,uint16_t inputLength,uint8_t *iv);
uint8_t DRV_AES_CFB_Crypt(const AES_Action enc, const uint8_t *input, uint8_t *output,uint16_t inputLength,uint8_t *iv);
void DRV_AES_Encryption(uint8_t aesEncryptionMode);
void DRV_AES_Decryption(uint8_t aesDecryptionMode);
uint8_t DRV_AES_Load_Key(const uint8_t aesLoadKeyMode);
void DRV_AES_Load_IV(const uint8_t aesLoadIV_Mode, uint8_t *IV_Data, const uint8_t IV_length);
void DRV_AES_Load_Input_Buffer(const uint8_t aesLoadInputBufferMode, const uint8_t *inputBufferData, const uint8_t inputBufferLength);
void DRV_AES_Load_Output_Buffer(const uint8_t aesLoadOutputBufferMode, const uint8_t *outputBufferData, const uint8_t outputBufferLength);
void DRV_AES_Peripheral_circuit_Reset(void);
void DRV_AES_Reset(void);
void DRV_AES_Abort(void);
void DRV_AES_Out_Data(uint8_t *outData, const uint8_t length);
void DRV_AES_XOR(const uint8_t aesLoadXOR_Mode, const uint8_t *inputXOR_Data, const uint8_t inputXOR_Length);
void __interrupt IntAES(void);

#endif
