//*************************************************************************************
// file			: SQ7653_UID.c
// version		: V1.0 2020/07/17
// brief		: UID related functions
// note			: 1. read the unique identification number (UID) set internally by the IC 
//				: 2. the number of UID bytes is 16
//				: 3. read UID from LSB to MSB
//**************************************************************************************
#include "main.h"
	

//*********************************************************************
// name			: UID_Read()
// brief		: read the unique identification number (UID) set internally by the IC
// note			:
//*********************************************************************
void UID_Read(unsigned char *DID){
    unsigned char i;
	unsigned char  temp;
    *(volatile unsigned char*)(0x000C) = 0x00;              //Reset UID pointer by writing to it.
	
	for(i=0; i<16; i++)
	{
		temp = (*((volatile unsigned char*) 0x000C));		//read 16 bytes of UID.
		DID[i] = temp;
		__asm("NOP");
	}
	
}




