//******************************************
// file			: SQ7653_SFR.h
// version		: V1.1 06/04/2020
// brief		: declare the detailed name of each the special function register
// note			: 
//****************************************************
#ifndef _SQ7653_SFR_H_
#define _SQ7653_SFR_H_

#include "SQ7653_SFR_addr.h"

//****************************************************
//******
#define NOP                     __asm("NOP")                        // no operation
//******
#define DI                      __asm("DI")                         // enable all maskable interrupts // EIRL_IMF=0
#define EI                      __asm("EI")                         // enable all maskable interrupts // EIRL_IMF=1
//******
#define CLR_WDT                 WDCDR_WDTCR=0x4e                    // clear the watchdog timer 
//******
#define DIS_WDT                 WDCTR_WDTEN=0; WDCDR_WDTCR=0xb1     // disable the watchdog timer operation and clear the 8-bit up counter
//******
//****************************************************
//===================================================
//===================================================
//==========================
//        SYSCR0
//==========================                               
#define SYSCR0           			_0x0008.byte
#define SYSCR0_XRSTDIS   			_0x0008.bit.b3
#define SYSCR0_OCDDIS    			_0x0008.bit.b2
#define SYSCR0_ROMST     			_0x0008.bit.b1

//==========================
//        PMR
//========================== 
#define PMR              			_0x000A.byte
#define PMR_LDOON            		_0x000A.bit.b4
#define PMR_DSM                		_0x000A.bit.b3
#define PMR_PMODE              		_0x000A.b2_0.b2_0
		
//==========================		
//        RSTFLG 		
//==========================		 
#define RSTFLG           			_0x000B.byte
#define RSTFLG_CLR       			_0x000B.bit.b7
#define RSTFLG_LVDRST1       		_0x000B.bit.b6
#define RSTFLG_LVDRST0       		_0x000B.bit.b5
#define RSTFLG_BRRST     			_0x000B.bit.b4
#define RSTFLG_BLMRST    			_0x000B.bit.b3
#define RSTFLG_WDTF     			_0x000B.bit.b2
#define RSTFLG_PRRST     			_0x000B.bit.b1
#define RSTFLG_EXRST     			_0x000B.bit.b0
			
//==========================		
//        UID		
//==========================		 
#define UID              			_0x000C.byte
#define UID_UIDn         			_0x000C.byte

//==========================		
//        SWRST		
//==========================		 
#define SWRST              			_0x000D.byte
						
//==========================
//        CLKCR0
//==========================                 
#define CLKCR0           			_0x0020.byte

#define CLKCR0_SCKPSC    			_0x0020.b5_3.b5_3
#define CLKCR0_SCKSEL    			_0x0020.b2_0.b2_0
			
//==========================
//        CLKCR1
//==========================    
#define CLKCR1           			_0x0021.byte

#define CLKCR1_LXEN      			_0x0021.bit.b3
#define CLKCR1_HXEN      			_0x0021.bit.b2
#define CLKCR1_LIRCEN    			_0x0021.bit.b1
			
//==========================
//        CLKCR2
//==========================  
#define CLKCR2           			_0x0022.byte
#define CLKCR2_SCKLF     			_0x0022.bit.b0    //0:LIRC, 1:LXTAL
			
//==========================
//        CLKST
//==========================
#define CLKST           			_0x0023.byte
#define CLKST_SCKSRC    			_0x0023.b7_5.b7_5
#define CLKST_SCKRDY    			_0x0023.bit.b4
#define CLKST_LXRDY     			_0x0023.bit.b3
#define CLKST_HXRDY     			_0x0023.bit.b2
#define CLKST_LIRCRDY   			_0x0023.bit.b1
			
//==========================
//        PLLCR0
//==========================
#define PLLCR0           			_0x0024.byte
#define PLLCR0_PLLWUP               _0x0024.b6_4.b6_4
#define PLLCR0_PLLREF    			_0x0024.b3_2.b3_2
#define PLLCR0_PLLRDY    			_0x0024.bit.b1
#define PLLCR0_PLLEN     			_0x0024.bit.b0
			
//==========================
//        CLKWUP
//==========================
#define CLKWUP           			_0x0026.byte
#define CLKWUP_LXWUP    			_0x0026.b6_4.b6_4
#define CLKWUP_HXWUP    			_0x0026.b2_0.b2_0

//==========================
//        FCKDIV
//==========================                         
#define FCKDIV           			_0x0027.byte

//-----------                   
//==========================
//			WDCTR
//==========================
#define WDCTR      					_0x0028.byte
#define WDCTR_WDTEN					_0x0028.bit.b5
#define WDCTR_WDTW					_0x0028.b4_3.b4_3
#define WDCTR_WDTT					_0x0028.b2_1.b2_1
#define WDCTR_WDTOUT				_0x0028.bit.b0
			
//==========================
//			WDCDR
//==========================
#define WDCDR     	 				_0x0029.byte
#define WDCDR_WDTCR			        _0x0029.byte
			
//==========================
//			WDCNT
//==========================
#define WDCNT      					_0x002A.byte
			
//==========================
//			WDST
//==========================
#define WDST       					_0x002B.byte
#define WDST_WINTST2				_0x002B.bit.b2
#define WDST_WINTST1				_0x002B.bit.b1
#define WDST_WDTST					_0x002B.bit.b0
			
//==========================
//			WUCCR
//==========================
#define WUCCR           			_0x002C.byte 
#define WUCCR_WUCRST				_0x002C.bit.b7
#define WUCCR_WUCDIV				_0x002C.b3_2.b3_2
#define WUCCR_WUCSEL				_0x002C.bit.b1

//==========================
//			WUCDR
//==========================
#define WUCDR           			_0x002D.byte
			
//==========================
//			TBTCR
//==========================
#define TBTCR      					_0x002E.byte
#define TBTCR_DV9CK					_0x002E.bit.b5
#define TBTCR_TBTEN					_0x002E.bit.b4
#define TBTCR_TBTCK					_0x002E.b3_0.b3_0
			
//==========================
//        LVDCR0 
//==========================  
#define LVDCR0            			_0x0031.byte
#define LVDCR0_LVDLP      			_0x0031.bit.b7
#define LVDCR0_LVDCFG     			_0x0031.b6_4.b6_4
#define LVDCR0_LVDF       			_0x0031.bit.b2
#define LVDCR0_LVDIEN     			_0x0031.bit.b1
#define LVDCR0_LVDEN      			_0x0031.bit.b0

//==========================
//        PONCR
//========================== 
#define PONCR            			_0x0034.byte
#define PONCR_BROREN     			_0x0034.bit.b0

//==========================
//        LVDCR1
//========================== 
#define LVDCR1             			_0x0036.byte
#define LVDCR1_LVDLP     			_0x0036.bit.b7
#define LVDCR1_LVDCFG     			_0x0036.b6_4.b6_4
#define LVDCR1_LVDRSTEN    			_0x0036.bit.b3
#define LVDCR1_LVDF      			_0x0036.bit.b2
#define LVDCR1_LVDIEN     			_0x0036.bit.b1
#define LVDCR1_LVDEN     			_0x0036.bit.b0
			
//==========================
//        PMCFG
//==========================                    
#define PMCFG            			_0x0038.byte

//==========================
//        DMCFG
//========================== 
#define DMCFG            			_0x0039.byte
	
//==========================
//        MIFR
//==========================
#define MIFR              			_0x003A.byte
#define MIFR_IMF          			_0x003A.bit.b0
			
//==========================
//			PSW
//==========================
#define PSW        					_0x003F.byte
#define PSW_JF						_0x003F.bit.b7
#define PSW_ZF						_0x003F.bit.b6
#define PSW_CF						_0x003F.bit.b5
#define PSW_HF						_0x003F.bit.b4
#define PSW_SF						_0x003F.bit.b3
#define PSW_VF						_0x003F.bit.b2
#define PSW_RBS						_0x003F.bit.b1
			
//==========================
//         FCR
//==========================                
#define FCR	         			    _0x0040.byte
#define FCR_AREA	         		_0x0040.b7_5.b7_5
#define FCR_FCMD	         		_0x0040.b4_0.b4_0
		
//==========================
//         FSR
//========================== 
#define FSR	                 	    _0x0041.byte
#define FSR_BUSY	         		_0x0041.bit.b7
#define FSR_FERR	         		_0x0041.b2_0.b2_0
		

//==========================
//        FADDR0
//========================== 
#define FADDR0	         			_0x0042.byte

//==========================
//        FADDR1
//========================== 
#define FADDR1	         			_0x0043.byte

//==========================
//        FDATA0
//==========================
#define FDATA0	         			_0x0044.byte

//==========================
//        FDATA1
//==========================
#define FDATA1	         			_0x0045.byte

//==========================
//        FDATA2
//==========================
#define FDATA2	         			_0x0046.byte

//==========================
//        FDATA3
//==========================
#define FDATA3	         			_0x0047.byte
                           
//-----------  
//==========================
//        EECR 
//==========================                  
#define EECR	         			_0x0048.byte
#define EECR_AREA	         		_0x0048.b7_5.b7_5
#define EECR_EECMD	         		_0x0048.b4_0.b4_0
		
//==========================
//       EESR
//========================== 
#define EESR	         			_0x0049.byte
#define EESR_BUSY	         		_0x0049.bit.b7
#define EESR_EEERR	     			_0x0049.b2_0.b2_0

//==========================
//        EEADDR0
//========================== 
#define EEADDR0	         			_0x004A.byte
#define EEADDR0_FADDR0	         	_0x004A.byte

//==========================
//        EEADDR1
//========================== 
#define EEADDR1	         			_0x004B.byte
#define EEADDR1_FADDR1	         	_0x004B.byte

//==========================
//        EEDATA0
//========================== 
#define EEDATA0	         			_0x004C.byte
#define EEDATA0_FDATA0	         	_0x004C.byte

//==========================
//        EEDATA1
//========================== 
#define EEDATA1	         			_0x004D.byte
#define EEDATA1_FDATA1	         	_0x004D.byte

//==========================
//        EEDATA2
//========================== 
#define EEDATA2	         			_0x004E.byte
#define EEDATA2_FDATA2	        	_0x004E.byte

//==========================
//        EEDATA3
//========================== 
#define EEDATA3	         			_0x004F.byte
#define EEDATA3_FDATA3	         	_0x004F.byte

//-----------0x0050 
//==========================
//        TMRA0CFG
//==========================                   
#define TMRA0CFG	     			_0x0050.byte
#define TMRA0CFG_TCFG	     		_0x0050.b2_0.b2_0
		
//==========================
//        TMRA0SR
//==========================
#define TMRA0SR	                   	_0x0051.byte
#define TMRA0SR_TMROVI1	           	_0x0051.bit.b3
#define TMRA0SR_TMROVI0	           	_0x0051.bit.b2
#define TMRA0SR_EDGEI1	           	_0x0051.bit.b1
#define TMRA0SR_EDGEI0	           	_0x0051.bit.b0
									
//==========================       	
//        TMRA0CR0                 	
//==========================       	
#define TMRA0CR0	               	_0x0052.byte
#define TMRA0CR0_TMROVIE	       	_0x0052.bit.b7
#define TMRA0CR0_EDGEIE	           	_0x0052.bit.b6
#define TMRA0CR0_OE	               	_0x0052.bit.b4
#define TMRA0CR0_EDGE	           	_0x0052.b3_1.b3_1
#define TMRA0CR0_RUN	           	_0x0052.bit.b0
									
//==========================       	
//        TMRA0CR1                 	
//==========================       	
#define TMRA0CR1	     		   	_0x0053.byte
#define TMRA0CR1_TMROVIE	       	_0x0053.bit.b7
#define TMRA0CR1_EDGEIE	           	_0x0053.bit.b6
#define TMRA0CR1_OE	               	_0x0053.bit.b4
#define TMRA0CR1_EDGE	           	_0x0053.b3_1.b3_1
#define TMRA0CR1_RUN	           	_0x0053.bit.b0
									
//==========================       	
//        TMRA0MD0                 	
//==========================       	
#define TMRA0MD0	     		   	_0x0054.byte
#define TMRA0MD0_TFF	     	   	_0x0054.bit.b7
#define TMRA0MD0_DBE	     	   	_0x0054.bit.b6
#define TMRA0MD0_TCK	     	   	_0x0054.b5_3.b5_3
#define TMRA0MD0_TCM	     	   	_0x0054.b2_0.b2_0
									
//==========================       	
//        TMRA0MD1                 	
//==========================       	
#define TMRA0MD1	     		   	_0x0055.byte
#define TMRA0MD1_TFF	     	   	_0x0055.bit.b7
#define TMRA0MD1_DBE	     	   	_0x0055.bit.b6
#define TMRA0MD1_TCK	     	   	_0x0055.b5_3.b5_3
#define TMRA0MD1_TCM	     	   	_0x0055.b2_0.b2_0
									
//==========================       	
//        TMRA0CPL                 	
//==========================       	
#define TMRA0CPL	         	   	_0x0056.byte
#define TMRA0CPL_FLTIF	     	   	_0x0056.bit.b7
#define TMRA0CPL_FLTIE	     	   	_0x0056.bit.b6
#define TMRA0CPL_FLTMD	     	   	_0x0056.b5_4.b5_4
#define TMRA0CPL_CPLMD	     	   	_0x0056.b1_0.b1_0
									
//==========================       	
//        TMRA0DTM                 	
//==========================       	
#define TMRA0DTM	               	_0x0057.byte
#define TMRA0DTM_DTMPSC	           	_0x0057.b7_6.b7_6 
#define TMRA0DTM_DTM	           	_0x0057.b5_0.b5_0  
									
//==========================       	
//        TMRA0DR0                 	
//==========================       	          
#define TMRA0DR0	               	_0x0058.byte
#define TMRA0DR0_TMRADR0        	_0x0058.byte
//==========================
//        TMRA0DR1
//==========================
#define TMRA0DR1	     			_0x0059.byte
#define TMRA0DR1_TMRADR1  			_0x0059.byte
//==========================
//        TMRA0PWM0
//==========================
#define TMRA0PWM0	     			_0x005A.byte
#define TMRA0PWM0_TMRAPWM0   	    _0x005A.byte
//==========================
//        TMRA0PWM1
//==========================
#define TMRA0PWM1		 			_0x005B.byte
#define TMRA0PWM1_TMRAPWM1    	    _0x005B.byte
                              
//----------0x0060 
//==========================
//        TMRA1CFG
//==========================                    
#define TMRA1CFG	     			_0x0060.byte
#define TMRA1CFG_TCFG	     		_0x0060.b2_0.b2_0

//==========================
//        TMRA1SR
//==========================
#define TMRA1SR	         		 	_0x0061.byte
#define TMRA1SR_TMROVI1	         	_0x0061.bit.b3
#define TMRA1SR_TMROVI0	         	_0x0061.bit.b2
#define TMRA1SR_EDGEI1	         	_0x0061.bit.b1
#define TMRA1SR_EDGEI0	         	_0x0061.bit.b0

//==========================
//        TMRA1CR0
//==========================
#define TMRA1CR0	     		    _0x0062.byte
#define TMRA1CR0_TMROVIE	        _0x0062.bit.b7
#define TMRA1CR0_EDGEIE	            _0x0062.bit.b6
#define TMRA1CR0_OE	                _0x0062.bit.b4
#define TMRA1CR0_EDGE	            _0x0062.b3_1.b3_1
#define TMRA1CR0_RUN	            _0x0062.bit.b0
                                    
//==========================
//        TMRA1CR1
//==========================
#define TMRA1CR1	     			 _0x0063.byte
#define TMRA1CR1_TMROVIE	         _0x0063.bit.b7
#define TMRA1CR1_EDGEIE	             _0x0063.bit.b6
#define TMRA1CR1_OE	                 _0x0063.bit.b4
#define TMRA1CR1_EDGE	             _0x0063.b3_1.b3_1
#define TMRA1CR1_RUN	             _0x0063.bit.b0
                                     
//==========================
//        TMRA1MD0
//==========================
#define TMRA1MD0	                 _0x0064.byte
#define TMRA1MD0_TFF	             _0x0064.bit.b7
#define TMRA1MD0_DBE	             _0x0064.bit.b6
#define TMRA1MD0_TCK	             _0x0064.b5_3.b5_3
#define TMRA1MD0_TCM	             _0x0064.b2_0.b2_0
                                     
//==========================         
//        TMRA1MD1                   
//==========================         
#define TMRA1MD1	                 _0x0065.byte
#define TMRA1MD1_TFF	             _0x0065.bit.b7
#define TMRA1MD1_DBE	             _0x0065.bit.b6
#define TMRA1MD1_TCK	             _0x0065.b5_3.b5_3
#define TMRA1MD1_TCM	             _0x0065.b2_0.b2_0
                                     
//==========================         
//        TMRA1CPL                   
//==========================         
#define TMRA1CPL	                 _0x0066.byte
#define TMRA1CPL_FLTIF	             _0x0066.bit.b7
#define TMRA1CPL_FLTIE	             _0x0066.bit.b6
#define TMRA1CPL_FLTMD	             _0x0066.b5_4.b5_4
#define TMRA1CPL_CPLMD	             _0x0066.b1_0.b1_0
                                     
//==========================
//        TMRA1DTM
//==========================
#define TMRA1DTM                     _0x0067.byte 
#define TMRA1DTM_DTMPSC	             _0x0067.b7_6.b7_6 
#define TMRA1DTM_DTM	             _0x0067.b5_0.b5_0  
                                     
//==========================
//        TMRA1DR0
//==========================
#define TMRA1DR0	                 _0x0068.byte
#define TMRA1DR0_TMRADR0	         _0x0068.byte
//==========================
//        TMRA1DR1
//==========================
#define TMRA1DR1	                 _0x0069.byte
#define TMRA1DR1_TMRADR1  			 _0x0069.byte
//==========================
//        TMRA1PWM0
//==========================
#define TMRA1PWM0	                 _0x006A.byte
#define TMRA1PWM0_TMRAPWM0   	     _0x006A.byte
//==========================
//        TMRA1PWM1
//==========================
#define TMRA1PWM1                    _0x006B.byte
#define TMRA1PWM1_TMRAPWM1   	     _0x006B.byte
                                
//----------0x0070  
//==========================
//        TMRA2CFG
//==========================                   
#define TMRA2CFG	                 _0x0070.byte
#define TMRA2CFG_TCFG	             _0x0070.b2_0.b2_0

//==========================
//        TMRA2SR
//==========================
#define TMRA2SR	                     _0x0071.byte
#define TMRA2SR_TMROVI1	             _0x0071.bit.b3
#define TMRA2SR_TMROVI0	             _0x0071.bit.b2
#define TMRA2SR_EDGEI1	             _0x0071.bit.b1
#define TMRA2SR_EDGEI0	             _0x0071.bit.b0

//==========================
//        TMRA2CR0
//==========================
#define TMRA2CR0	     		 	 _0x0072.byte
#define TMRA2CR0_TMROVIE	     	 _0x0072.bit.b7
#define TMRA2CR0_EDGEIE	         	 _0x0072.bit.b6
#define TMRA2CR0_OE	             	 _0x0072.bit.b4
#define TMRA2CR0_EDGE	         	 _0x0072.b3_1.b3_1
#define TMRA2CR0_RUN	         	 _0x0072.bit.b0
	                                 
//==========================
//        TMRA2CR1
//==========================
#define TMRA2CR1	             	 _0x0073.byte
#define TMRA2CR1_TMROVIE	         _0x0073.bit.b7
#define TMRA2CR1_EDGEIE	             _0x0073.bit.b6
#define TMRA2CR1_OE	                 _0x0073.bit.b4
#define TMRA2CR1_EDGE	             _0x0073.b3_1.b3_1
#define TMRA2CR1_RUN	             _0x0073.bit.b0
                                     
//==========================
//        TMRA2MD0
//==========================
#define TMRA2MD0	                 _0x0074.byte
#define TMRA2MD0_TFF	             _0x0074.bit.b7
#define TMRA2MD0_DBE	             _0x0074.bit.b6
#define TMRA2MD0_TCK	             _0x0074.b5_3.b5_3
#define TMRA2MD0_TCM	             _0x0074.b2_0.b2_0

//==========================
//        TMRA2MD1
//==========================
#define TMRA2MD1	         		 _0x0075.byte
#define TMRA2MD1_TFF	     		 _0x0075.bit.b7
#define TMRA2MD1_DBE	     		 _0x0075.bit.b6
#define TMRA2MD1_TCK	     		 _0x0075.b5_3.b5_3
#define TMRA2MD1_TCM	     		 _0x0075.b2_0.b2_0
		 
//==========================
//        TMRA2CPL
//==========================
#define TMRA2CPL	                 _0x0076.byte
#define TMRA2CPL_FLTIF	             _0x0076.bit.b7
#define TMRA2CPL_FLTIE	             _0x0076.bit.b6
#define TMRA2CPL_FLTMD	             _0x0076.b5_4.b5_4
#define TMRA2CPL_CPLMD	             _0x0076.b1_0.b1_0
                                     
//==========================
//        TMRA2DTM
//==========================
#define TMRA2DTM	                 _0x0077.byte
#define TMRA2DTM_DTMPSC	             _0x0077.b7_6.b7_6 
#define TMRA2DTM_DTM	             _0x0077.b5_0.b5_0  
                                     
//==========================
//        TMRA2DR0
//==========================                     
#define TMRA2DR0	                 _0x0078.byte
#define TMRA2DR0_TMRADR0             _0x0078.byte
//==========================
//        TMRA2DR1
//==========================
#define TMRA2DR1	                 _0x0079.byte
#define TMRA2DR1_TMRADR1             _0x0079.byte
//==========================
//        TMRA2PWM0
//==========================
#define TMRA2PWM0	                 _0x007A.byte
#define TMRA2PWM0_TMRAPWM0   	     _0x007A.byte
//==========================
//        TMRA2PWM1
//==========================
#define TMRA2PWM1                    _0x007B.byte
#define TMRA2PWM1_TMRAPWM1   	     _0x007B.byte

                                
//----------0x0080  
//==========================
//        TMRA3CFG
//==========================                   
#define TMRA3CFG             		 _0x0080.byte
#define TMRA3CFG_TCFG	     		 _0x0080.b2_0.b2_0
		                             
//==========================
//        TMRA3SR
//==========================	
#define TMRA3SR	                     _0x0081.byte
#define TMRA3SR_TMROVI1	             _0x0081.bit.b3
#define TMRA3SR_TMROVI0	             _0x0081.bit.b2
#define TMRA3SR_EDGEI1	             _0x0081.bit.b1
#define TMRA3SR_EDGEI0	             _0x0081.bit.b0

//==========================
//        TMRA3CR0
//==========================
#define TMRA3CR0	                 _0x0082.byte
#define TMRA3CR0_TMROVIE	         _0x0082.bit.b7
#define TMRA3CR0_EDGEIE	             _0x0082.bit.b6
#define TMRA3CR0_OE	                 _0x0082.bit.b4
#define TMRA3CR0_EDGE	             _0x0082.b3_1.b3_1
#define TMRA3CR0_RUN	             _0x0082.bit.b0
                                     
//==========================
//        TMRA3CR1
//==========================
#define TMRA3CR1	                 _0x0083.byte
#define TMRA3CR1_TMROVIE	         _0x0083.bit.b7
#define TMRA3CR1_EDGEIE	             _0x0083.bit.b6
#define TMRA3CR1_OE	                 _0x0083.bit.b4
#define TMRA3CR1_EDGE	             _0x0083.b3_1.b3_1
#define TMRA3CR1_RUN	             _0x0083.bit.b0
                                     
//==========================
//        TMRA3MD0
//==========================
#define TMRA3MD0	                 _0x0084.byte
#define TMRA3MD0_TFF	             _0x0084.bit.b7
#define TMRA3MD0_DBE	             _0x0084.bit.b6
#define TMRA3MD0_TCK	             _0x0084.b5_3.b5_3
#define TMRA3MD0_TCM	             _0x0084.b2_0.b2_0
                                     
//==========================
//        TMRA3MD1
//==========================
#define TMRA3MD1	                 _0x0085.byte
#define TMRA3MD1_TFF	             _0x0085.bit.b7
#define TMRA3MD1_DBE	             _0x0085.bit.b6
#define TMRA3MD1_TCK	             _0x0085.b5_3.b5_3
#define TMRA3MD1_TCM	             _0x0085.b2_0.b2_0
                                     
//==========================
//        TMRA3CPL
//==========================
#define TMRA3CPL	                 _0x0086.byte
#define TMRA3CPL_FLTIF	             _0x0086.bit.b7
#define TMRA3CPL_FLTIE	             _0x0086.bit.b6
#define TMRA3CPL_FLTMD	             _0x0086.b5_4.b5_4
#define TMRA3CPL_CPLMD	             _0x0086.b1_0.b1_0

//==========================
//        TMRA3DTM
//==========================
#define TMRA3DTM                     _0x0087.byte
#define TMRA3DTM_DTMPSC	             _0x0087.b7_6.b7_6 
#define TMRA3DTM_DTM	             _0x0087.b5_0.b5_0  
                                     
//==========================
//        TMRA3DR0
//==========================                    
#define TMRA3DR0                     _0x0088.byte
#define TMRA3DR0_TMRADR0             _0x0088.byte  
//==========================
//        TMRA3DR1
//==========================	
#define TMRA3DR1	                 _0x0089.byte
#define TMRA3DR1_TMRADR1             _0x0089.byte
//==========================
//        TMRA3PWM0
//==========================
#define TMRA3PWM0	                 _0x008A.byte
#define TMRA3PWM0_TMRAPWM0           _0x008A.byte

//==========================
//        TMRA3PWM1
//==========================
#define TMRA3PWM1	                 _0x008B.byte
#define TMRA3PWM1_TMRAPWM1           _0x008B.byte
                              
//---------0x0090  
//==========================
//        TMRA4CFG
//==========================
#define TMRA4CFG                     _0x0090.byte
#define TMRA4CFG_TCFG	             _0x0090.b2_0.b2_0

//==========================
//        TMRA4SR
//==========================
#define TMRA4SR	                     _0x0091.byte
#define TMRA4SR_TMROVI1	             _0x0091.bit.b3
#define TMRA4SR_TMROVI0	             _0x0091.bit.b2
#define TMRA4SR_EDGEI1	             _0x0091.bit.b1
#define TMRA4SR_EDGEI0	             _0x0091.bit.b0
                                     
//==========================
//        TMRA4CR0
//==========================
#define TMRA4CR0	                 _0x0092.byte
#define TMRA4CR0_TMROVIE	         _0x0092.bit.b7
#define TMRA4CR0_EDGEIE	             _0x0092.bit.b6
#define TMRA4CR0_OE	                 _0x0092.bit.b4
#define TMRA4CR0_EDGE	             _0x0092.b3_1.b3_1
#define TMRA4CR0_RUN	             _0x0092.bit.b0
                                     
//==========================
//        TMRA4CR1
//==========================
#define TMRA4CR1	                 _0x0093.byte
#define TMRA4CR1_TMROVIE	         _0x0093.bit.b7
#define TMRA4CR1_EDGEIE	             _0x0093.bit.b6
#define TMRA4CR1_OE	                 _0x0093.bit.b4
#define TMRA4CR1_EDGE	             _0x0093.b3_1.b3_1
#define TMRA4CR1_RUN	             _0x0093.bit.b0
                                     
//==========================
//        TMRA4MD0
//==========================
#define TMRA4MD0	                 _0x0094.byte
#define TMRA4MD0_TFF	             _0x0094.bit.b7
#define TMRA4MD0_DBE	             _0x0094.bit.b6
#define TMRA4MD0_TCK	             _0x0094.b5_3.b5_3
#define TMRA4MD0_TCM	             _0x0094.b2_0.b2_0
                                     
//==========================
//        TMRA4MD1
//==========================
#define TMRA4MD1	                 _0x0095.byte
#define TMRA4MD1_TFF	             _0x0095.bit.b7
#define TMRA4MD1_DBE	             _0x0095.bit.b6
#define TMRA4MD1_TCK	             _0x0095.b5_3.b5_3
#define TMRA4MD1_TCM	             _0x0095.b2_0.b2_0
                                     
//==========================         
//        TMRA4CPL                   
//==========================         
#define TMRA4CPL	                 _0x0096.byte
#define TMRA4CPL_FLTIF	             _0x0096.bit.b7
#define TMRA4CPL_FLTIE	             _0x0096.bit.b6
#define TMRA4CPL_FLTMD	             _0x0096.b5_4.b5_4
#define TMRA4CPL_CPLMD	             _0x0096.b1_0.b1_0
                                     
//==========================
//        TMRA4DTM
//==========================
#define TMRA4DTM                     _0x0097.byte
#define TMRA4DTM_DTMPSC	             _0x0097.b7_6.b7_6 
#define TMRA4DTM_DTM	             _0x0097.b5_0.b5_0  
                                     
//==========================
//        TMRA4DR0
//==========================               
#define TMRA4DR0	                 _0x0098.byte
#define TMRA4DR0_TMRADR0             _0x0098.byte

//==========================
//        TMRA4DR1
//==========================
#define TMRA4DR1	                 _0x0099.byte
#define TMRA4DR1_TMRADR1             _0x0099.byte
//==========================
//        TMRA4PWM0
//==========================
#define TMRA4PWM0	                 _0x009A.byte
#define TMRA4PWM0_TMRAPWM0           _0x009A.byte

//==========================
//        TMRA4PWM1
//==========================
#define TMRA4PWM1                    _0x009B.byte
#define TMRA4PWM1_TMRAPWM1           _0x009B.byte
                                
//----------	                
//==========================
//			UART0CR1
//==========================
#define UART0CR1   			   		 _0x00A0.byte
#define UART0CR1_TXE		   		 _0x00A0.bit.b7
#define UART0CR1_RXE		   		 _0x00A0.bit.b6
#define UART0CR1_STOPBT		   		 _0x00A0.bit.b5
#define UART0CR1_EVEN		   		 _0x00A0.bit.b4
#define UART0CR1_PE			   		 _0x00A0.bit.b3
#define UART0CR1_IRDASEL	   		 _0x00A0.bit.b2
#define UART0CR1_BRG		   		 _0x00A0.bit.b1
		                             
//==========================   		
//			UART0CR2		   
//==========================   		
#define UART0CR2   			   		 _0x00A1.byte
#define UART0CR2_DV			   		 _0x00A1.b7_6.b7_6
#define UART0CR2_RTSEL		   		 _0x00A1.b5_3.b5_3
#define UART0CR2_RXDNC		   		 _0x00A1.b2_1.b2_1
#define UART0CR2_STOPBR		   		 _0x00A1.bit.b0
		                             
//==========================   		
//			UART0DR		       
//==========================   		
#define UART0DR    			   		 _0x00A2.byte
#define UART0DR_UART0DR7	   		 _0x00A2.bit.b7
#define UART0DR_UART0DR6	   		 _0x00A2.bit.b6
#define UART0DR_UART0DR5	   		 _0x00A2.bit.b5
#define UART0DR_UART0DR4	   		 _0x00A2.bit.b4
#define UART0DR_UART0DR3	   		 _0x00A2.bit.b3
#define UART0DR_UART0DR2	   		 _0x00A2.bit.b2
#define UART0DR_UART0DR1	   		 _0x00A2.bit.b1
#define UART0DR_UART0DR0	   		 _0x00A2.bit.b0
                                     
//==========================
//			UART0SR
//==========================
#define UART0SR    			         _0x00A3.byte
#define UART0SR_PERR		         _0x00A3.bit.b7
#define UART0SR_FERR		         _0x00A3.bit.b6
#define UART0SR_OERR		         _0x00A3.bit.b5
#define UART0SR_RBSY		         _0x00A3.bit.b3
#define UART0SR_RBFL		         _0x00A3.bit.b2
#define UART0SR_TBSY		         _0x00A3.bit.b1
#define UART0SR_TBFL		         _0x00A3.bit.b0
                                     
//==========================
//			RD0BUF
//==========================
#define RD0BUF	                     _0x00A4.byte

//==========================
//			TD0BUF
//==========================
#define TD0BUF	                     _0x00A5.byte

//==========================
//			UART1CR1
//==========================
#define UART1CR1   			     	 _0x00A6.byte
#define UART1CR1_TXE		     	 _0x00A6.bit.b7
#define UART1CR1_RXE		     	 _0x00A6.bit.b6
#define UART1CR1_STOPBT		     	 _0x00A6.bit.b5
#define UART1CR1_EVEN		     	 _0x00A6.bit.b4
#define UART1CR1_PE			     	 _0x00A6.bit.b3
#define UART1CR1_IRDASEL	     	 _0x00A6.bit.b2
#define UART1CR1_BRG		     	 _0x00A6.bit.b1
									 
//==========================
//			UART1CR2
//==========================
#define UART1CR2   			         _0x00A7.byte
#define UART1CR2_DV			         _0x00A7.b7_6.b7_6
#define UART1CR2_RTSEL		         _0x00A7.b5_3.b5_3
#define UART1CR2_RXDNC		         _0x00A7.b2_1.b2_1
#define UART1CR2_STOPBR		         _0x00A7.bit.b0
                                     
//==========================
//			UART1DR
//==========================
#define UART1DR    					 _0x00A8.byte
#define UART1DR_UART1DR7			 _0x00A8.bit.b7
#define UART1DR_UART1DR6			 _0x00A8.bit.b6
#define UART1DR_UART1DR5			 _0x00A8.bit.b5
#define UART1DR_UART1DR4			 _0x00A8.bit.b4
#define UART1DR_UART1DR3			 _0x00A8.bit.b3
#define UART1DR_UART1DR2			 _0x00A8.bit.b2
#define UART1DR_UART1DR1			 _0x00A8.bit.b1
#define UART1DR_UART1DR0			 _0x00A8.bit.b0

//==========================
//			UART1SR
//==========================
#define UART1SR    					 _0x00A9.byte
#define UART1SR_PERR				 _0x00A9.bit.b7
#define UART1SR_FERR				 _0x00A9.bit.b6
#define UART1SR_OERR				 _0x00A9.bit.b5
#define UART1SR_RBSY				 _0x00A9.bit.b3
#define UART1SR_RBFL				 _0x00A9.bit.b2
#define UART1SR_TBSY				 _0x00A9.bit.b1
#define UART1SR_TBFL				 _0x00A9.bit.b0
		                             
//==========================
//			RD1BUF
//==========================
#define RD1BUF	         			 _0x00AA.byte

//==========================
//			TD1BUF
//==========================
#define TD1BUF	         			 _0x00AB.byte

//==========================
//			UART2CR1
//==========================
#define UART2CR1   			     	 _0x00AC.byte
#define UART2CR1_TXE		     	 _0x00AC.bit.b7
#define UART2CR1_RXE		     	 _0x00AC.bit.b6
#define UART2CR1_STOPBT		     	 _0x00AC.bit.b5
#define UART2CR1_EVEN		     	 _0x00AC.bit.b4
#define UART2CR1_PE			     	 _0x00AC.bit.b3
#define UART2CR1_IRDASEL	     	 _0x00AC.bit.b2
#define UART2CR1_BRG		     	 _0x00AC.bit.b1
									 
//==========================
//			UART2CR2
//==========================
#define UART2CR2   					 _0x00AD.byte
#define UART2CR2_DV 				 _0x00AD.b7_6.b7_6
#define UART2CR2_RTSEL				 _0x00AD.b5_3.b5_3
#define UART2CR2_RXDNC				 _0x00AD.b2_1.b2_1
#define UART2CR2_STOPBR				 _0x00AD.bit.b0
		 
//==========================
//			UART2DR
//==========================
#define UART2DR    			 		 _0x00AE.byte
#define UART2DR_UART2DR7	 		 _0x00AE.bit.b7
#define UART2DR_UART2DR6	 		 _0x00AE.bit.b6
#define UART2DR_UART2DR5	 		 _0x00AE.bit.b5
#define UART2DR_UART2DR4	 		 _0x00AE.bit.b4
#define UART2DR_UART2DR3	 		 _0x00AE.bit.b3
#define UART2DR_UART2DR2	 		 _0x00AE.bit.b2
#define UART2DR_UART2DR1	 		 _0x00AE.bit.b1
#define UART2DR_UART2DR0	 		 _0x00AE.bit.b0
									 
//==========================
//			UART2SR
//==========================
#define UART2SR    					 _0x00AF.byte
#define UART2SR_PERR				 _0x00AF.bit.b7
#define UART2SR_FERR				 _0x00AF.bit.b6
#define UART2SR_OERR				 _0x00AF.bit.b5
#define UART2SR_RBSY				 _0x00AF.bit.b3
#define UART2SR_RBFL				 _0x00AF.bit.b2
#define UART2SR_TBSY				 _0x00AF.bit.b1
#define UART2SR_TBFL				 _0x00AF.bit.b0

//---------- 
//==========================
//			RD2BUF
//==========================                   
#define RD2BUF	         			 _0x00B0.byte

//==========================
//			TD2BUF
//==========================
#define TD2BUF			      	     _0x00B1.byte

//==========================
//			SBI0CR1
//==========================
#define SBI0CR1    					 _0x00B8.byte
#define SBI0CR1_BC					 _0x00B8.b7_5.b7_5
#define SBI0CR1_ACK					 _0x00B8.bit.b4
#define SBI0CR1_NOACK				 _0x00B8.bit.b3
#define SBI0CR1_SCK					 _0x00B8.b2_0.b2_0
		                             
//==========================
//			SBI0CR2
//==========================
#define SBI0CR2    					 _0x00B9.byte
#define SBI0CR2_MST					 _0x00B9.bit.b7
#define SBI0CR2_TRX					 _0x00B9.bit.b6
#define SBI0CR2_BB					 _0x00B9.bit.b5
#define SBI0CR2_PIN					 _0x00B9.bit.b4
#define SBI0CR2_SBIM				 _0x00B9.bit.b3
#define SBI0CR2_SWRST				 _0x00B9.b1_0.b1_0
		                             
//==========================
//			SBI0SR
//==========================
#define SBI0SR    					 _0x00BA.byte
#define SBI0SR_MST					 _0x00BA.bit.b7
#define SBI0SR_TRX					 _0x00BA.bit.b6
#define SBI0SR_BB					 _0x00BA.bit.b5
#define SBI0SR_PIN					 _0x00BA.bit.b4
#define SBI0SR_AL					 _0x00BA.bit.b3
#define SBI0SR_AAS					 _0x00BA.bit.b2
#define SBI0SR_AD0					 _0x00BA.bit.b1
#define SBI0SR_LRB					 _0x00BA.bit.b0
		                             
//==========================
//			I2C0AR
//==========================
#define I2C0AR    					 _0x00BB.byte //SBI0AR
#define I2C0AR_SA					 _0x00BB.b7_1.b7_1
#define I2C0AR_ALS					 _0x00BB.bit.b0

//==========================
//			SBI0DBR
//==========================
#define SBI0DBR    			         _0x00BC.byte
                                         
//==========================
//			SIO0CR1
//==========================
#define SIO0CR1    			         _0x00D0.byte
#define SIO0CR1_SIOEDG		         _0x00D0.bit.b7
#define SIO0CR1_SIOCKS		         _0x00D0.b6_4.b6_4
#define SIO0CR1_SIODIR		         _0x00D0.bit.b3
#define SIO0CR1_SIOS		         _0x00D0.bit.b2
#define SIO0CR1_SIOM		         _0x00D0.b1_0.b1_0 
                                     
//==========================         
//			SIO0CR2                  
//==========================         
#define SIO0CR2    			         _0x00D1.byte
#define SIO0CR2_SIOEN		         _0x00D1.bit.b0
                                     
//==========================         
//			SIO0SR                   
//==========================         
#define SIO0SR     			         _0x00D2.byte
#define SIO0SR_SIOF			         _0x00D2.bit.b7
#define SIO0SR_SEF			         _0x00D2.bit.b6
#define SIO0SR_OERR			         _0x00D2.bit.b5
#define SIO0SR_RENDB		         _0x00D2.bit.b4
#define SIO0SR_UERR			         _0x00D2.bit.b3
#define SIO0SR_TBFL			         _0x00D2.bit.b2


//==========================
//			SIO0BUF
//==========================
#define SIO0BUF    		             _0x00D3.byte
                               
//----------0x00E0             
//==========================
//			P0DO
//==========================
#define P0DO       					 _0x00E0.byte
#define P0DO_P7 					 _0x00E0.bit.b7
#define P0DO_P6 					 _0x00E0.bit.b6
#define P0DO_P5 					 _0x00E0.bit.b5
#define P0DO_P4 					 _0x00E0.bit.b4
#define P0DO_P3 					 _0x00E0.bit.b3
#define P0DO_P2 					 _0x00E0.bit.b2
#define P0DO_P1 					 _0x00E0.bit.b1
#define P0DO_P0 					 _0x00E0.bit.b0
		                             
//==========================
//			P1DO
//==========================
#define P1DO            			 _0x00E1.byte
#define P1DO_P7 					 _0x00E1.bit.b7
#define P1DO_P6 					 _0x00E1.bit.b6
#define P1DO_P5 					 _0x00E1.bit.b5
#define P1DO_P4 					 _0x00E1.bit.b4
#define P1DO_P3 					 _0x00E1.bit.b3
#define P1DO_P2 					 _0x00E1.bit.b2
#define P1DO_P1 					 _0x00E1.bit.b1
#define P1DO_P0 					 _0x00E1.bit.b0
		                             
//==========================
//			P2DO
//==========================
#define P2DO       					 _0x00E2.byte
#define P2DO_P7 					 _0x00E2.bit.b7
#define P2DO_P6 					 _0x00E2.bit.b6
#define P2DO_P5 					 _0x00E2.bit.b5
#define P2DO_P4 					 _0x00E2.bit.b4
#define P2DO_P3 					 _0x00E2.bit.b3
#define P2DO_P2 					 _0x00E2.bit.b2
#define P2DO_P1 					 _0x00E2.bit.b1
#define P2DO_P0 					 _0x00E2.bit.b0
		                             
//==========================
//			P3DO
//==========================
#define P3DO       					 _0x00E3.byte
#define P3DO_P7 					 _0x00E3.bit.b7
#define P3DO_P6 					 _0x00E3.bit.b6
#define P3DO_P5 					 _0x00E3.bit.b5
#define P3DO_P4 					 _0x00E3.bit.b4
#define P3DO_P3 					 _0x00E3.bit.b3
#define P3DO_P2 					 _0x00E3.bit.b2
#define P3DO_P1 					 _0x00E3.bit.b1
#define P3DO_P0 					 _0x00E3.bit.b0
		                             
//==========================
//			P4DO
//==========================
#define P4DO      					 _0x00E4.byte
#define P4DO_P7 					 _0x00E4.bit.b7
#define P4DO_P6 					 _0x00E4.bit.b6
#define P4DO_P5 					 _0x00E4.bit.b5
#define P4DO_P4 					 _0x00E4.bit.b4
#define P4DO_P3 					 _0x00E4.bit.b3
#define P4DO_P2 					 _0x00E4.bit.b2
#define P4DO_P1 					 _0x00E4.bit.b1
#define P4DO_P0 					 _0x00E4.bit.b0
									 	 
//----------0x00F0              
//==========================
//			P0DI
//==========================
#define P0DI       					 _0x00F0.byte
#define P0DI_P7 					 _0x00F0.bit.b7
#define P0DI_P6 					 _0x00F0.bit.b6
#define P0DI_P5 					 _0x00F0.bit.b5
#define P0DI_P4 					 _0x00F0.bit.b4
#define P0DI_P3 					 _0x00F0.bit.b3
#define P0DI_P2 					 _0x00F0.bit.b2
#define P0DI_P1 					 _0x00F0.bit.b1
#define P0DI_P0 					 _0x00F0.bit.b0
		                             
//==========================
//			P1DI
//==========================
#define P1DI       			         _0x00F1.byte
#define P1DI_P7 			         _0x00F1.bit.b7
#define P1DI_P6 			         _0x00F1.bit.b6
#define P1DI_P5 			         _0x00F1.bit.b5
#define P1DI_P4 			         _0x00F1.bit.b4
#define P1DI_P3 			         _0x00F1.bit.b3
#define P1DI_P2 			         _0x00F1.bit.b2
#define P1DI_P1 			         _0x00F1.bit.b1
#define P1DI_P0 			         _0x00F1.bit.b0
                                     
//==========================
//			P2DI
//==========================
#define P2DI       					 _0x00F2.byte
#define P2DI_P7 					 _0x00F2.bit.b7
#define P2DI_P6 					 _0x00F2.bit.b6
#define P2DI_P5 					 _0x00F2.bit.b5
#define P2DI_P4 					 _0x00F2.bit.b4
#define P2DI_P3 					 _0x00F2.bit.b3
#define P2DI_P2 					 _0x00F2.bit.b2
#define P2DI_P1 					 _0x00F2.bit.b1
#define P2DI_P0 					 _0x00F2.bit.b0
		                             
//==========================
//			P3DI
//==========================
#define P3DI       					 _0x00F3.byte
#define P3DI_P7 					 _0x00F3.bit.b7
#define P3DI_P6 					 _0x00F3.bit.b6
#define P3DI_P5 					 _0x00F3.bit.b5
#define P3DI_P4 					 _0x00F3.bit.b4
#define P3DI_P3 					 _0x00F3.bit.b3
#define P3DI_P2 					 _0x00F3.bit.b2
#define P3DI_P1 					 _0x00F3.bit.b1
#define P3DI_P0 					 _0x00F3.bit.b0
		                             
//==========================
//			P4DI
//==========================
#define P4DI       					 _0x00F4.byte
#define P4DI_P7 					 _0x00F4.bit.b7
#define P4DI_P6 					 _0x00F4.bit.b6
#define P4DI_P5 					 _0x00F4.bit.b5
#define P4DI_P4 					 _0x00F4.bit.b4
#define P4DI_P3 					 _0x00F4.bit.b3
#define P4DI_P2 					 _0x00F4.bit.b2
#define P4DI_P1 					 _0x00F4.bit.b1
#define P4DI_P0 					 _0x00F4.bit.b0
									  	
//---------0x0100           		      
//==========================		  
//			P0OE		              
//==========================		  
#define P0OE       					 _0x0100.byte
#define P0OE_P7 					 _0x0100.bit.b7
#define P0OE_P6 					 _0x0100.bit.b6
#define P0OE_P5 					 _0x0100.bit.b5
#define P0OE_P4 					 _0x0100.bit.b4
#define P0OE_P3 					 _0x0100.bit.b3
#define P0OE_P2 					 _0x0100.bit.b2
#define P0OE_P1 					 _0x0100.bit.b1
#define P0OE_P0 					 _0x0100.bit.b0
										
//==========================
//			P1OE
//==========================
#define P1OE       				     _0x0101.byte
#define P1OE_P7 				     _0x0101.bit.b7
#define P1OE_P6 				     _0x0101.bit.b6
#define P1OE_P5 				     _0x0101.bit.b5
#define P1OE_P4 				     _0x0101.bit.b4
#define P1OE_P3 				     _0x0101.bit.b3
#define P1OE_P2 				     _0x0101.bit.b2
#define P1OE_P1 				     _0x0101.bit.b1
#define P1OE_P0 				     _0x0101.bit.b0
	                                 
//==========================
//			P2OE
//==========================
#define P2OE       					 _0x0102.byte
#define P2OE_P7 					 _0x0102.bit.b7
#define P2OE_P6 					 _0x0102.bit.b6
#define P2OE_P5 					 _0x0102.bit.b5
#define P2OE_P4  					 _0x0102.bit.b4
#define P2OE_P3 					 _0x0102.bit.b3
#define P2OE_P2 					 _0x0102.bit.b2
#define P2OE_P1 					 _0x0102.bit.b1
#define P2OE_P0 					 _0x0102.bit.b0
		                              
//==========================
//			P3OE
//==========================
#define P3OE       				     _0x0103.byte
#define P3OE_P7 				     _0x0103.bit.b7
#define P3OE_P6 				     _0x0103.bit.b6
#define P3OE_P5 				     _0x0103.bit.b5
#define P3OE_P4 				     _0x0103.bit.b4
#define P3OE_P3 				     _0x0103.bit.b3
#define P3OE_P2 				     _0x0103.bit.b2
#define P3OE_P1 				     _0x0103.bit.b1
#define P3OE_P0 				     _0x0103.bit.b0
									  
//==========================
//			P4OE
//==========================
#define P4OE       					 _0x0104.byte
#define P4OE_P7 					 _0x0104.bit.b7
#define P4OE_P6 					 _0x0104.bit.b6
#define P4OE_P5 					 _0x0104.bit.b5
#define P4OE_P4 					 _0x0104.bit.b4
#define P4OE_P3 					 _0x0104.bit.b3
#define P4OE_P2 					 _0x0104.bit.b2
#define P4OE_P1 					 _0x0104.bit.b1
#define P4OE_P0 					 _0x0104.bit.b0
									 	
//---------0x0110               
//==========================
//			P0PU
//==========================
#define P0PU       					 _0x0110.byte
#define P0PU_P7 					 _0x0110.bit.b7
#define P0PU_P6 					 _0x0110.bit.b6
#define P0PU_P5 					 _0x0110.bit.b5
#define P0PU_P4 					 _0x0110.bit.b4
#define P0PU_P3 					 _0x0110.bit.b3
#define P0PU_P2 					 _0x0110.bit.b2
#define P0PU_P1 					 _0x0110.bit.b1
#define P0PU_P0 					 _0x0110.bit.b0
		                             
//==========================
//			P1PU
//==========================
#define P1PU      					 _0x0111.byte
#define P1PU_P7 					 _0x0111.bit.b7
#define P1PU_P6 					 _0x0111.bit.b6
#define P1PU_P5 					 _0x0111.bit.b5
#define P1PU_P4 					 _0x0111.bit.b4
#define P1PU_P3 					 _0x0111.bit.b3
#define P1PU_P2 					 _0x0111.bit.b2
#define P1PU_P1 					 _0x0111.bit.b1
#define P1PU_P0 					 _0x0111.bit.b0
		                             
//==========================
//			P2PU
//==========================
#define P2PU       					 _0x0112.byte
#define P2PU_P7 					 _0x0112.bit.b7
#define P2PU_P6 					 _0x0112.bit.b6
#define P2PU_P5 					 _0x0112.bit.b5
#define P2PU_P4 					 _0x0112.bit.b4
#define P2PU_P3 					 _0x0112.bit.b3
#define P2PU_P2 					 _0x0112.bit.b2
#define P2PU_P1 					 _0x0112.bit.b1
#define P2PU_P0 					 _0x0112.bit.b0
		                             
//==========================
//			P3PU
//==========================
#define P3PU       					 _0x0113.byte
#define P3PU_P7 					 _0x0113.bit.b7
#define P3PU_P6 					 _0x0113.bit.b6
#define P3PU_P5 					 _0x0113.bit.b5
#define P3PU_P4 					 _0x0113.bit.b4
#define P3PU_P3 					 _0x0113.bit.b3
#define P3PU_P2 					 _0x0113.bit.b2
#define P3PU_P1 					 _0x0113.bit.b1
#define P3PU_P0 					 _0x0113.bit.b0
									 
//==========================
//			P4PU
//==========================
#define P4PU       					 _0x0114.byte
#define P4PU_P7 					 _0x0114.bit.b7
#define P4PU_P6 					 _0x0114.bit.b6
#define P4PU_P5 					 _0x0114.bit.b5
#define P4PU_P4 					 _0x0114.bit.b4
#define P4PU_P3 					 _0x0114.bit.b3
#define P4PU_P2 					 _0x0114.bit.b2
#define P4PU_P1 					 _0x0114.bit.b1
#define P4PU_P0 					 _0x0114.bit.b0
		                             
//---------0x0120               
//==========================
//			P0PD
//==========================
#define P0PD       					 _0x0120.byte
#define P0PD_P7 					 _0x0120.bit.b7
#define P0PD_P6 					 _0x0120.bit.b6
#define P0PD_P5 					 _0x0120.bit.b5
#define P0PD_P4 					 _0x0120.bit.b4
#define P0PD_P3 					 _0x0120.bit.b3
#define P0PD_P2 					 _0x0120.bit.b2
#define P0PD_P1 					 _0x0120.bit.b1
#define P0PD_P0 					 _0x0120.bit.b0

//==========================
//			P1PD
//==========================
#define P1PD       				  	 _0x0121.byte
#define P1PD_P7 				  	 _0x0121.bit.b7
#define P1PD_P6 				  	 _0x0121.bit.b6
#define P1PD_P5 				  	 _0x0121.bit.b5
#define P1PD_P4 				  	 _0x0121.bit.b4
#define P1PD_P3 				  	 _0x0121.bit.b3
#define P1PD_P2 				  	 _0x0121.bit.b2
#define P1PD_P1 				  	 _0x0121.bit.b1
#define P1PD_P0 				  	 _0x0121.bit.b0
									  
//==========================
//			P2PD
//==========================
#define P2PD       					 _0x0122.byte
#define P2PD_P7 					 _0x0122.bit.b7
#define P2PD_P6 					 _0x0122.bit.b6
#define P2PD_P5 					 _0x0122.bit.b5
#define P2PD_P4 					 _0x0122.bit.b4
#define P2PD_P3 					 _0x0122.bit.b3
#define P2PD_P2 					 _0x0122.bit.b2
#define P2PD_P1 					 _0x0122.bit.b1
#define P2PD_P0 					 _0x0122.bit.b0
			                         
//==========================
//			P3PD
//==========================			
#define P3PD       					 _0x0123.byte
#define P3PD_P7 					 _0x0123.bit.b7
#define P3PD_P6 					 _0x0123.bit.b6
#define P3PD_P5 					 _0x0123.bit.b5
#define P3PD_P4 					 _0x0123.bit.b4
#define P3PD_P3 					 _0x0123.bit.b3
#define P3PD_P2 					 _0x0123.bit.b2
#define P3PD_P1 					 _0x0123.bit.b1
#define P3PD_P0 					 _0x0123.bit.b0
			                         
//==========================
//			P4PD            
//==========================
#define P4PD       					 _0x0124.byte
#define P4PD_P7 					 _0x0124.bit.b7
#define P4PD_P6 					 _0x0124.bit.b6
#define P4PD_P5 					 _0x0124.bit.b5
#define P4PD_P4 					 _0x0124.bit.b4
#define P4PD_P3 					 _0x0124.bit.b3
#define P4PD_P2 					 _0x0124.bit.b2
#define P4PD_P1 					 _0x0124.bit.b1
#define P4PD_P0 					 _0x0124.bit.b0
											
//---------0x0130               
//==========================
//			P0DSEL
//==========================
#define P0DSEL     					 _0x0130.byte
#define P0DSEL_P7					 _0x0130.bit.b7
#define P0DSEL_P6					 _0x0130.bit.b6
#define P0DSEL_P5					 _0x0130.bit.b5
#define P0DSEL_P4					 _0x0130.bit.b4
#define P0DSEL_P3					 _0x0130.bit.b3
#define P0DSEL_P2					 _0x0130.bit.b2
#define P0DSEL_P1					 _0x0130.bit.b1
#define P0DSEL_P0					 _0x0130.bit.b0
			                         
//==========================         
//			P1DSEL                   
//==========================         
#define P1DSEL     					 _0x0131.byte
#define P1DSEL_P7					 _0x0131.bit.b7
#define P1DSEL_P6					 _0x0131.bit.b6
#define P1DSEL_P5					 _0x0131.bit.b5
#define P1DSEL_P4					 _0x0131.bit.b4
#define P1DSEL_P3					 _0x0131.bit.b3
#define P1DSEL_P2					 _0x0131.bit.b2
#define P1DSEL_P1					 _0x0131.bit.b1
#define P1DSEL_P0					 _0x0131.bit.b0
			                         
//==========================
//			P2DSEL
//==========================
#define P2DSEL     					 _0x0132.byte
#define P2DSEL_P7					 _0x0132.bit.b7
#define P2DSEL_P6					 _0x0132.bit.b6
#define P2DSEL_P5					 _0x0132.bit.b5
#define P2DSEL_P4					 _0x0132.bit.b4
#define P2DSEL_P3					 _0x0132.bit.b3
#define P2DSEL_P2					 _0x0132.bit.b2
#define P2DSEL_P1					 _0x0132.bit.b1
#define P2DSEL_P0					 _0x0132.bit.b0

//==========================
//			P3DSEL
//==========================
#define P3DSEL     					 _0x0133.byte
#define P3DSEL_P7					 _0x0133.bit.b7
#define P3DSEL_P6					 _0x0133.bit.b6
#define P3DSEL_P5					 _0x0133.bit.b5
#define P3DSEL_P4					 _0x0133.bit.b4
#define P3DSEL_P3					 _0x0133.bit.b3
#define P3DSEL_P2					 _0x0133.bit.b2
#define P3DSEL_P1					 _0x0133.bit.b1
#define P3DSEL_P0					 _0x0133.bit.b0
			
//==========================
//			P4DSEL
//==========================
#define P4DSEL     					 _0x0134.byte
#define P4DSEL_P7					 _0x0134.bit.b7
#define P4DSEL_P6					 _0x0134.bit.b6
#define P4DSEL_P5					 _0x0134.bit.b5
#define P4DSEL_P4					 _0x0134.bit.b4
#define P4DSEL_P3					 _0x0134.bit.b3
#define P4DSEL_P2					 _0x0134.bit.b2
#define P4DSEL_P1					 _0x0134.bit.b1
#define P4DSEL_P0					 _0x0134.bit.b0
									 
//--------0x0140                
//==========================
//			P0CFGCR
//==========================
#define P0CFGCR      				 _0x0140.byte
#define P0CFGCR_PCFGW				 _0x0140.bit.b7
#define P0CFGCR_PSEL				 _0x0140.b6_4.b6_4
#define P0CFGCR_PCFG				 _0x0140.b3_0.b3_0
			
//==========================
//			P0CFGV
//==========================
#define P0CFGV      				 _0x0141.byte
#define P0CFGV_PCFGV				 _0x0141.b3_0.b3_0

//==========================
//			P1CFGCR
//==========================
#define P1CFGCR      				 _0x0142.byte
#define P1CFGCR_PCFGW				 _0x0142.bit.b7
#define P1CFGCR_PSEL				 _0x0142.b6_4.b6_4
#define P1CFGCR_PCFG				 _0x0142.b3_0.b3_0
                                     
			                         
                                     
//==========================         
//			P1CFGV                   
//==========================         
#define P1CFGV						 _0x0143.byte
#define P1CFGV_PCFGV				 _0x0143.b3_0.b3_0
                                     
                                     
//==========================         
//			P2CFGCR                  
//==========================         
#define P2CFGCR      				 _0x0144.byte
#define P2CFGCR_PCFGW				 _0x0144.bit.b7
#define P2CFGCR_PSEL				 _0x0144.b6_4.b6_4
#define P2CFGCR_PCFG				 _0x0144.b3_0.b3_0
                                     
//==========================         
//			P2CFGV	                 
//==========================         
#define P2CFGV						 _0x0145.byte
#define P2CFGV_PCFGV				 _0x0145.b3_0.b3_0
                                           
		                             
//==========================         
//			P3CFGCR                  
//==========================         
#define P3CFGCR      				 _0x0146.byte
#define P3CFGCR_PCFGW				 _0x0146.bit.b7
#define P3CFGCR_PSEL				 _0x0146.b6_4.b6_4
#define P3CFGCR_PCFG				 _0x0146.b3_0.b3_0
                                     
                                     
//==========================         
//			P3CFGV                   
//==========================         
#define P3CFGV      				 _0x0147.byte
#define P3CFGV_PCFGV				 _0x0147.b3_0.b3_0
                                     
                                     
//==========================         
//			P4CFGCR                  
//==========================         
#define P4CFGCR      				 _0x0148.byte
#define P4CFGCR_PCFGW				 _0x0148.bit.b7
#define P4CFGCR_PSEL				 _0x0148.b6_4.b6_4
#define P4CFGCR_PCFG				 _0x0148.b3_0.b3_0
                                     
//==========================
//			P4CFGV
//==========================
#define P4CFGV      				 _0x0149.byte
#define P4CFGV_PCFGV				 _0x0149.b3_0.b3_0
                                     
//==========================         
//			P5CFGCR                  
//==========================         
#define P5CFGCR      				 _0x014A.byte
#define P5CFGCR_PCFGW				 _0x014A.bit.b7
#define P5CFGCR_PSEL				 _0x014A.b6_4.b6_4
#define P5CFGCR_PCFG				 _0x014A.b3_0.b3_0
                                     
//==========================         
//			P4CFGV                   
//==========================         
#define P5CFGV      				 _0x014B.byte
#define P5CFGV_PCFGV				 _0x014B.b3_0.b3_0
                                     
									 
//==========================
//			P6CFGCR
//==========================
#define P6CFGCR      				 _0x014C.byte
#define P6CFGCR_PCFGW				 _0x014C.bit.b7
#define P6CFGCR_PSEL				 _0x014C.b6_4.b6_4
#define P6CFGCR_PCFG				 _0x014C.b3_0.b3_0
                                     
//==========================         
//			P6CFGV                   
//==========================         
#define P6CFGV      				 _0x014D.byte
#define P6CFGV_PCFGV				 _0x014D.b3_0.b3_0
                                     
//==========================         
//			P7CFGCR                  
//==========================         
#define P7CFGCR      				 _0x014E.byte
#define P7CFGCR_PCFGW				 _0x014E.bit.b7
#define P7CFGCR_PSEL				 _0x014E.b6_4.b6_4
#define P7CFGCR_PCFG				 _0x014E.b3_0.b3_0
                                     
//==========================
//			P7CFGV
//==========================
#define P7CFGV      				 _0x014F.byte
#define P7CFGV_PCFGV				 _0x014F.b3_0.b3_0

                                          
//--------0x0170
//==========================
//        PCKEN0
//==========================                               
#define PCKEN0	         			 _0x0178.byte
#define PCKEN0_TMRA4	 			 _0x0178.bit.b7
#define PCKEN0_TMRA3	 			 _0x0178.bit.b6
#define PCKEN0_TMRA2	 			 _0x0178.bit.b5
#define PCKEN0_TMRA1	 			 _0x0178.bit.b4
#define PCKEN0_TMRA0	 			 _0x0178.bit.b3
				                     
//==========================         
//        PCKEN1                     
//==========================         
#define PCKEN1	         			 _0x0179.byte
#define PCKEN1_UART2	 			 _0x0179.bit.b6
#define PCKEN1_UART1	 			 _0x0179.bit.b5
#define PCKEN1_UART0	 			 _0x0179.bit.b4
				                     
//==========================         
//        PCKEN2                     
//==========================         
#define PCKEN2	         			 _0x017A.byte
#define PCKEN2_SIO0	     			 _0x017A.bit.b4
#define PCKEN2_I2C0	     			 _0x017A.bit.b0
				                     
                                     
//==========================         
//        PCKEN3                     
//==========================         
#define PCKEN3	         			 _0x017B.byte
#define PCKEN3_EINT7	 			 _0x017B.bit.b7
#define PCKEN3_EINT6	 			 _0x017B.bit.b6
#define PCKEN3_EINT5	 			 _0x017B.bit.b5
#define PCKEN3_EINT4	 			 _0x017B.bit.b4
#define PCKEN3_EINT3	 			 _0x017B.bit.b3
#define PCKEN3_EINT2	 			 _0x017B.bit.b2
#define PCKEN3_EINT1	 			 _0x017B.bit.b1
#define PCKEN3_EINT0	 			 _0x017B.bit.b0
				                     
                                     
#define PCKEN4	         			 _0x017C.byte
#define PCKEN4_EINT9	 			 _0x017C.bit.b1
#define PCKEN4_EINT8	 			 _0x017C.bit.b0
                                     
                                     
#define PCKEN5	         			 _0x017D.byte
				                     
//==========================         
//        PCKEN6                     
//==========================         
#define PCKEN6	         			 _0x017E.byte
#define PCKEN6_CMP	     			 _0x017E.bit.b2
#define PCKEN6_ADC	     			 _0x017E.bit.b0
				                     
//==========================         
//        PCKEN7                     
//==========================         
#define PCKEN7	         			 _0x017F.byte
#define PCKEN7_CRC	     			 _0x017F.bit.b0
                                     
//==========================         
//        PRSTR0                     
//==========================             
#define PRSTR0	         			 _0x0180.byte
#define PRSTR0_TMRA4	 			 _0x0180.bit.b7
#define PRSTR0_TMRA3	 			 _0x0180.bit.b6
#define PRSTR0_TMRA2	 			 _0x0180.bit.b5
#define PRSTR0_TMRA1	 			 _0x0180.bit.b4
#define PRSTR0_TMRA0	 			 _0x0180.bit.b3
#define PRSTR0_Reset2	 			 _0x0180.bit.b2
#define PRSTR0_Reset1	 			 _0x0180.bit.b1
#define PRSTR0_Reset	 			 _0x0180.bit.b0
				                     
//==========================         
//        PRSTR1                     
//==========================         
#define PRSTR1	         			 _0x0181.byte
#define PRSTR1_UART2	 			 _0x0181.bit.b6
#define PRSTR1_UART1	 			 _0x0181.bit.b5
#define PRSTR1_UART0	 			 _0x0181.bit.b4
				                     
//==========================         
//        PRSTR2                     
//==========================         
#define PRSTR2	         			 _0x0182.byte
#define PRSTR2_SIO0	     			 _0x0182.bit.b4
#define PRSTR2_I2C0	     			 _0x0182.bit.b0
				                     
//==========================         
//        PRSTR3                     
//==========================         
#define PRSTR3	         			 _0x0183.byte
#define PRSTR3_EINT7	         	 _0x0183.bit.b7
#define PRSTR3_EINT6	         	 _0x0183.bit.b6
#define PRSTR3_EINT5	         	 _0x0183.bit.b5
#define PRSTR3_EINT4	         	 _0x0183.bit.b4
#define PRSTR3_EINT3	         	 _0x0183.bit.b3
#define PRSTR3_EINT2	         	 _0x0183.bit.b2
#define PRSTR3_EINT1	         	 _0x0183.bit.b1
#define PRSTR3_EINT0	         	 _0x0183.bit.b0
				                     
//==========================         
//        PRSTR4                     
//==========================		 	
#define PRSTR4	         			 _0x0184.byte
#define PRSTR4_EINT9	         	 _0x0184.bit.b1
#define PRSTR4_EINT8	         	 _0x0184.bit.b0
                                     
#define PRSTR5	         			 _0x0185.byte
				                     
//==========================         
//        PRSTR6                     
//==========================         
#define PRSTR6	         			 _0x0186.byte
#define PRSTR6_CMP	     			 _0x0186.bit.b2
#define PRSTR6_ADC	     			 _0x0186.bit.b0
				                     
//==========================         
//        PRSTR7                     
//==========================         
#define PRSTR7           			 _0x0187.byte
#define PRSTR7_CRC      			 _0x0187.bit.b0
#define PRSTR7_DIC      			 _0x0187.bit.b0
                                     
//==========================         
//			KWUCR0                   
//==========================         
#define KWUCR0     					 _0x0188.byte
#define KWUCR0_KW3LE    			 _0x0188.bit.b7
#define KWUCR0_KW3EN    			 _0x0188.bit.b6
#define KWUCR0_KW2LE    			 _0x0188.bit.b5
#define KWUCR0_KW2EN    			 _0x0188.bit.b4
#define KWUCR0_KW1LE    			 _0x0188.bit.b3
#define KWUCR0_KW1EN    			 _0x0188.bit.b2
#define KWUCR0_KW0LE    			 _0x0188.bit.b1
#define KWUCR0_KW0EN    			 _0x0188.bit.b0
				                     
//==========================         
//			KWUCR1                   
//==========================         
#define KWUCR1     					 _0x0189.byte
#define KWUCR1_KW7LE    			 _0x0189.bit.b7                        
#define KWUCR1_KW7EN    			 _0x0189.bit.b6
#define KWUCR1_KW6LE    			 _0x0189.bit.b5                        
#define KWUCR1_KW6EN    			 _0x0189.bit.b4
#define KWUCR1_KW5LE    			 _0x0189.bit.b3                       
#define KWUCR1_KW5EN    			 _0x0189.bit.b2
#define KWUCR1_KW4LE    			 _0x0189.bit.b1                        
#define KWUCR1_KW4EN    			 _0x0189.bit.b0
                                     
//==========================         
//			KWUCR2                   
//==========================         
#define KWUCR2     					 _0x018A.byte
#define KWUCR2_KW9LE    			 _0x018A.bit.b3                       
#define KWUCR2_KW9EN    			 _0x018A.bit.b2
#define KWUCR2_KW8LE    			 _0x018A.bit.b1                        
#define KWUCR2_KW8EN    			 _0x018A.bit.b0
                                     
				                     
//==========================         
//			KWUSR0                   
//==========================         
#define KWUSR0   					 _0x018C.byte
#define KWUSR0_KWU3     			 _0x018C.b7_6.b7_6
#define KWUSR0_KWU2     			 _0x018C.b5_4.b5_4
#define KWUSR0_KWU1     			 _0x018C.b3_2.b3_2
#define KWUSR0_KWU0     			 _0x018C.b1_0.b1_0
				                     
//==========================         
//			KWUSR1                   
//==========================         
#define KWUSR1   					 _0x018D.byte
#define KWUSR1_KWU7     			 _0x018D.b7_6.b7_6
#define KWUSR1_KWU6     			 _0x018D.b5_4.b5_4
#define KWUSR1_KWU5     			 _0x018D.b3_2.b3_2
#define KWUSR1_KWU4     			 _0x018D.b1_0.b1_0
                                     
//==========================         
//			KWUSR2                   
//==========================         
#define KWUSR2   					 _0x018E.byte
#define KWUSR2_KWU9     			 _0x018E.b3_2.b3_2
#define KWUSR2_KWU8     			 _0x018E.b1_0.b1_0
									 
//--------0x0190                     
//==========================         
//			EINTCR0                  
//==========================         
#define EINTCR0    					 _0x0190.byte
#define EINTCR0_INTLVL				 _0x0190.bit.b4
#define EINTCR0_INTES				 _0x0190.b3_2.b3_2
#define EINTCR0_INTINC				 _0x0190.b1_0.b1_0
			                         
//==========================         
//			EINTCR1                  
//==========================         
#define EINTCR1    					 _0x0191.byte
#define EINTCR1_INTLVL				 _0x0191.bit.b4
#define EINTCR1_INTES				 _0x0191.b3_2.b3_2
#define EINTCR1_INTINC				 _0x0191.b1_0.b1_0
                                     
//==========================         
//			EINTCR2                  
//==========================         
#define EINTCR2    					 _0x0192.byte
#define EINTCR2_INTLVL				 _0x0192.bit.b4
#define EINTCR2_INTES				 _0x0192.b3_2.b3_2
#define EINTCR2_INTINC				 _0x0192.b1_0.b1_0
                                     
//==========================         
//			EINTCR3                  
//==========================         
#define EINTCR3    					 _0x0193.byte
#define EINTCR3_INTLVL				 _0x0193.bit.b4
#define EINTCR3_INTES				 _0x0193.b3_2.b3_2
#define EINTCR3_INTINC				 _0x0193.b1_0.b1_0
                                     
//==========================         
//			EINTCR4                  
//==========================         
#define EINTCR4    					 _0x0194.byte
#define EINTCR4_INTLVL				 _0x0194.bit.b4
#define EINTCR4_INTES				 _0x0194.b3_2.b3_2
#define EINTCR4_INTINC				 _0x0194.b1_0.b1_0
                                     
//==========================         
//			EINTCR5                  
//==========================         
#define EINTCR5    					 _0x0195.byte
#define EINTCR5_INTLVL				 _0x0195.bit.b4
#define EINTCR5_INTES				 _0x0195.b3_2.b3_2
#define EINTCR5_INTINC				 _0x0195.b1_0.b1_0
                                     
//==========================         
//			EINTCR6                  
//==========================         
#define EINTCR6    					 _0x0196.byte
#define EINTCR6_INTLVL				 _0x0196.bit.b4
#define EINTCR6_INTES				 _0x0196.b3_2.b3_2
#define EINTCR6_INTINC				 _0x0196.b1_0.b1_0
                                     
//==========================         
//			EINTCR7                  
//==========================         
#define EINTCR7    					 _0x0197.byte
#define EINTCR7_INTLVL				 _0x0197.bit.b4
#define EINTCR7_INTES				 _0x0197.b3_2.b3_2
#define EINTCR7_INTINC				 _0x0197.b1_0.b1_0
                                     
//==========================         
//			EINTCR8                  
//==========================         
#define EINTCR8    					 _0x0198.byte
#define EINTCR8_INTLVL				 _0x0198.bit.b4
#define EINTCR8_INTES				 _0x0198.b3_2.b3_2
#define EINTCR8_INTINC				 _0x0198.b1_0.b1_0		
                                     
//==========================         
//			EINTCR9                  
//==========================         
#define EINTCR9    					 _0x0199.byte
#define EINTCR9_INTLVL				 _0x0199.bit.b4
#define EINTCR9_INTES				 _0x0199.b3_2.b3_2
#define EINTCR9_INTINC				 _0x0199.b1_0.b1_0	
								     
//==========================         
//        IFR0                       
//==========================          
#define IFR0             		 	 _0x01A0.byte
#define IFR0_INT           		 	 _0x01A0.byte
#define IFR_TBT_IRQ             	 _0x01A0.bit.b7
#define IFR_LVD0_IRQ             	 _0x01A0.bit.b4
#define IFR_WDT_IRQ             	 _0x01A0.bit.b3
                                     
//==========================         
//        IFR1                       
//========================== 	     
#define IFR1	         		 	 _0x01A1.byte
#define IFR1_INT         		 	 _0x01A1.byte
#define IFR_TMRA21_IRQ	         	 _0x01A1.bit.b6
#define IFR_TMRA20_IRQ	         	 _0x01A1.bit.b5
#define IFR_TMRA11_IRQ	         	 _0x01A1.bit.b4
#define IFR_TMRA10_IRQ	         	 _0x01A1.bit.b3
#define IFR_TMRA01_IRQ	         	 _0x01A1.bit.b2
#define IFR_TMRA00_IRQ	         	 _0x01A1.bit.b1
#define IFR_LVD1_IRQ	         	 _0x01A1.bit.b0
                                     
//==========================         
//        IFR2                       
//==========================         
#define IFR2	                 	 _0x01A2.byte
#define IFR2_INT                 	 _0x01A2.byte
#define IFR_EXT3_IRQ	         	 _0x01A2.bit.b7
#define IFR_EXT2_IRQ	         	 _0x01A2.bit.b6
#define IFR_EXT1_IRQ	         	 _0x01A2.bit.b5
#define IFR_EXT0_IRQ	         	 _0x01A2.bit.b4
#define IFR_SIO0_IRQ	         	 _0x01A2.bit.b3
#define IFR_I2C0_IRQ	         	 _0x01A2.bit.b2
#define IFR_TX0_IRQ	         		 _0x01A2.bit.b1
#define IFR_RX0_IRQ	         		 _0x01A2.bit.b0
                                     
//==========================         
//        IFR3                       
//==========================         
#define IFR3	                 	 _0x01A3.byte
#define IFR_FMC_IRQ	         		 _0x01A3.bit.b5
#define IFR_CMP_IRQ	         		 _0x01A3.bit.b3
#define IFR_ADC_IRQ	         		 _0x01A3.bit.b0
                                    
//==========================         
//        IFR4                       
//==========================         
#define IFR4	         		 	 _0x01A4.byte
#define IFR_DIC_IRQ	         		 _0x01A4.bit.b7
#define IFR_CRC_IRQ	         		 _0x01A4.bit.b6
                                        
//==========================         
//        IFR5                       
//==========================         
#define IFR5	                 	 _0x01A5.byte
#define IFR_EE_IRQ	             	 _0x01A5.bit.b7
#define IFR_EXT7_IRQ	         	 _0x01A5.bit.b6
#define IFR_EXT6_IRQ	         	 _0x01A5.bit.b5
#define IFR_EXT5_IRQ	         	 _0x01A5.bit.b4
#define IFR_EXT4_IRQ	         	 _0x01A5.bit.b3
                                     
//==========================         
//        IFR6                       
//==========================         
#define IFR6	                 	 _0x01A6.byte
#define IFR_TX1_IRQ	         		 _0x01A6.bit.b7
#define IFR_RX1_IRQ	         		 _0x01A6.bit.b6
#define IFR_TMRA41_IRQ	         	 _0x01A6.bit.b3
#define IFR_TMRA40_IRQ	         	 _0x01A6.bit.b2
#define IFR_TMRA31_IRQ	         	 _0x01A6.bit.b1
#define IFR_TMRA30_IRQ	         	 _0x01A6.bit.b0
		                             
//==========================         
//        IFR7                       
//==========================         
#define IFR7             		  	 _0x01A7.byte
#define IFR_EXT9_IRQ             	 _0x01A7.bit.b6
#define IFR_EXT8_IRQ             	 _0x01A7.bit.b5
                                     
#define IFR8	                     _0x01A8.byte
//==========================         
//        IFR9                       
//==========================         
#define IFR9	                 	 _0x01A9.byte
#define IFR_TX2_IRQ	         		 _0x01A9.bit.b1
#define IFR_RX2_IRQ	         		 _0x01A9.bit.b0
		                                
                                     
#define IFR10	         			 _0x01AA.byte
#define IFR11	         			 _0x01AB.byte
#define IFR12	         			 _0x01AC.byte
#define IFR13	         			 _0x01AD.byte
#define IFR14	         			 _0x01AE.byte
#define IFR15            			 _0x01AF.byte
//--------0x01B0				     
//==========================         
//        IER0                       
//==========================         
#define IER0             			 _0x01B0.byte
#define IER0_IER           			 _0x01B0.byte
#define IER_TBT_IRQ      			 _0x01B0.bit.b7
#define IER_LVD0_IRQ      			 _0x01B0.bit.b4
				                     
//==========================         
//        IER1                       
//==========================         
#define IER1	                 	 _0x01B1.byte
#define IER1_IER                 	 _0x01B1.byte
#define IER_TMRA21_IRQ	         	 _0x01B1.bit.b6
#define IER_TMRA20_IRQ	         	 _0x01B1.bit.b5
#define IER_TMRA11_IRQ	         	 _0x01B1.bit.b4
#define IER_TMRA10_IRQ	         	 _0x01B1.bit.b3
#define IER_TMRA01_IRQ	         	 _0x01B1.bit.b2
#define IER_TMRA00_IRQ	         	 _0x01B1.bit.b1
#define IER_LVD1_IRQ	         	 _0x01B1.bit.b0		
//==========================         
//        IER2                       
//==========================         
#define IER2	         		 	 _0x01B2.byte
#define IER2_IER         		 	 _0x01B2.byte
#define IER_EXT3_IRQ	         	 _0x01B2.bit.b7
#define IER_EXT2_IRQ	         	 _0x01B2.bit.b6
#define IER_EXT1_IRQ	         	 _0x01B2.bit.b5
#define IER_EXT0_IRQ	         	 _0x01B2.bit.b4
#define IER_SIO0_IRQ	         	 _0x01B2.bit.b3
#define IER_I2C0_IRQ	         	 _0x01B2.bit.b2
#define IER_TX0_IRQ	         		 _0x01B2.bit.b1
#define IER_RX0_IRQ	         		 _0x01B2.bit.b0
                                        
//==========================         
//        IER3                       
//==========================         
#define IER3	         		 	 _0x01B3.byte
#define IER_FMC_IRQ	         		 _0x01B3.bit.b5
#define IER_CMP_IRQ	         		 _0x01B3.bit.b3
#define IER_ADC_IRQ	         		 _0x01B3.bit.b0
//==========================         
//        IER4                       
//==========================         
#define IER4	         		 	 _0x01B4.byte
#define IER_DIC_IRQ	         		 _0x01B4.bit.b7
#define IER_CRC_IRQ	         		 _0x01B4.bit.b6
                                     
//==========================         
//        IER5                       
//==========================         
#define IER5	         		 	 _0x01B5.byte
#define IER_EE_IRQ	             	 _0x01B5.bit.b7
#define IER_EXT7_IRQ	         	 _0x01B5.bit.b6
#define IER_EXT6_IRQ	         	 _0x01B5.bit.b5
#define IER_EXT5_IRQ	         	 _0x01B5.bit.b4
#define IER_EXT4_IRQ	         	 _0x01B5.bit.b3
                                     
//==========================         
//        IER6                       
//==========================         
#define IER6	         		 	 _0x01B6.byte
#define IER_TX1_IRQ	         		 _0x01B6.bit.b7
#define IER_RX1_IRQ	         		 _0x01B6.bit.b6
#define IER_TMRA41_IRQ	         	 _0x01B6.bit.b3
#define IER_TMRA40_IRQ	         	 _0x01B6.bit.b2
#define IER_TMRA31_IRQ	         	 _0x01B6.bit.b1
#define IER_TMRA30_IRQ	         	 _0x01B6.bit.b0
                                     
//==========================         
//        IER7                       
//==========================         
#define IER7             		  	 _0x01B7.byte
#define IER_EXT9_IRQ             	 _0x01B7.bit.b6
#define IER_EXT8_IRQ             	 _0x01B7.bit.b5
                                     
                                     
#define IER8	         			 _0x01B8.byte
//==========================         
//        IER9                       
//==========================         
#define IER9	         		 	 _0x01B9.byte
#define IER_TX2_IRQ	         		 _0x01B9.bit.b1
#define IER_RX2_IRQ	         		 _0x01B9.bit.b0
                                        
#define IER10	         			 _0x01BA.byte
#define IER11	         			 _0x01BB.byte
#define IER12	         			 _0x01BC.byte
#define IER13	         			 _0x01BD.byte
#define IER14	         			 _0x01BE.byte
#define IER15            			 _0x01BF.byte
//--------0x01C0				     
//==========================         
//        IPR0                       
//==========================         
#define IPR0             			 _0x01C0.byte
                                     
//==========================         
//        IPR1                       
//==========================         
#define IPR1	         		 	 _0x01C1.byte
#define IPR_TBT_IRQ	         		 _0x01C1.b7_6.b7_6
#define IPR_LVD0_IRQ	         	 _0x01C1.b1_0.b1_0
		                             
//==========================         
//        IPR2                       
//==========================         
#define IPR2	                 	 _0x01C2.byte
#define IPR_TMRA10_IRQ	         	 _0x01C2.b7_6.b7_6
#define IPR_TMRA01_IRQ	         	 _0x01C2.b5_4.b5_4
#define IPR_TMRA00_IRQ	         	 _0x01C2.b3_2.b3_2
#define IPR_LVD1_IRQ	         	 _0x01C2.b1_0.b1_0
                                     
//==========================         
//        IPR3                       
//==========================         
#define IPR3	                 	 _0x01C3.byte
#define IPR_TMRA21_IRQ	         	 _0x01C3.b5_4.b5_4
#define IPR_TMRA20_IRQ	         	 _0x01C3.b3_2.b3_2
#define IPR_TMRA11_IRQ	         	 _0x01C3.b1_0.b1_0
		                             
//==========================         
//        IPR4                       
//==========================         
#define IPR4	         		 	 _0x01C4.byte
#define IPR_SIO0_IRQ	         	 _0x01C4.b7_6.b7_6
#define IPR_I2C0_IRQ	         	 _0x01C4.b5_4.b5_4
#define IPR_TX0_IRQ	         		 _0x01C4.b3_2.b3_2
#define IPR_RX0_IRQ	         		 _0x01C4.b1_0.b1_0
                                        
//==========================         
//        IPR5                       
//==========================         
#define IPR5	                 	 _0x01C5.byte9
#define IPR_EXT3_IRQ	         	 _0x01C5.b7_6.b7_6
#define IPR_EXT2_IRQ	         	 _0x01C5.b5_4.b5_4
#define IPR_EXT1_IRQ	         	 _0x01C5.b3_2.b3_2
#define IPR_EXT0_IRQ	         	 _0x01C5.b1_0.b1_0
		                             
//==========================         
//        IPR6                       
//==========================         
#define IPR6	                 	 _0x01C6.byte
#define IPR_CMP_IRQ	         		 _0x01C6.b7_6.b7_6
#define IPR_ADC_IRQ	         		 _0x01C6.b1_0.b1_0
		                                
//==========================         
//        IPR7                       
//==========================         
#define IPR7                     	 _0x01C7.byte
#define IPR_FMC_IRQ             	 _0x01C7.b3_2.b3_2
		                             
#define IPR8	                  	 _0x01C8.byte
//==========================         
//        IPR9                       
//==========================         
#define IPR9	                 	 _0x01C9.byte
#define IPR_DIC_IRQ	         		 _0x01C9.b7_6.b7_6
#define IPR_CRC_IRQ	         		 _0x01C9.b5_4.b5_4
		                                
//==========================         
//        IPR10                      
//==========================         
#define IPR10	                 	 _0x01CA.byte
#define IPR_EXT4_IRQ	         	 _0x01CA.b7_6.b7_6
		                             
//==========================         
//        IPR11                      
//==========================         
#define IPR11	         		 	 _0x01CB.byte
#define IPR_EE_IRQ	         		 _0x01CB.b7_6.b7_6
#define IPR_EXT7_IRQ	         	 _0x01CB.b5_4.b5_4
#define IPR_EXT6_IRQ	         	 _0x01CB.b3_2.b3_2
#define IPR_EXT5_IRQ	         	 _0x01CB.b1_0.b1_0
                                     
//==========================         
//        IPR12                      
//==========================         
#define IPR12	         			 _0x01CC.byte
#define IPR_TMRA41_IRQ	         	 _0x01CC.b7_6.b7_6
#define IPR_TMRA40_IRQ	         	 _0x01CC.b5_4.b5_4
#define IPR_TMRA31_IRQ	         	 _0x01CC.b3_2.b3_2
#define IPR_TMRA30_IRQ	         	 _0x01CC.b1_0.b1_0
                                     
//==========================         
//        IPR13                      
//==========================         
#define IPR13	         		 	 _0x01CD.byte
#define IPR_TX1_IRQ	         		 _0x01CD.b7_6.b7_6
#define IPR_RX1_IRQ	         		 _0x01CD.b5_4.b5_4
		                                
#define IPR14	          		 	 _0x01CE.byte
		                             
//==========================         
//        IPR15                      
//==========================         
#define IPR15            			 _0x01CF.byte
#define IPR_EXT9_IRQ            	 _0x01CF.b5_4.b5_4
#define IPR_EXT8_IRQ            	 _0x01CF.b3_2.b3_2
		                             
//--------0x01D0                     
#define IPR16            			 _0x01D0.byte	
#define IPR17	         			 _0x01D1.byte
                                     
//==========================         
//        IPR18                      
//==========================         
#define IPR18	         		 	 _0x01D2.byte
#define IPR_TX2_IRQ	         		 _0x01D2.b3_2.b3_2
#define IPR_RX2_IRQ	         		 _0x01D2.b1_0.b1_0
		                             
                                     
#define IPR19	         			 _0x01D3.byte
#define IPR20	         			 _0x01D4.byte
#define IPR21	         			 _0x01D5.byte
#define IPR22	         			 _0x01D6.byte
#define IPR23            			 _0x01D7.byte
#define IPR24	         			 _0x01D8.byte
#define IPR25	         			 _0x01D9.byte
#define IPR26	         			 _0x01DA.byte
#define IPR27	         			 _0x01DB.byte
#define IPR28	         			 _0x01DC.byte
#define IPR29	         			 _0x01DD.byte
#define IPR30	         			 _0x01DE.byte
#define IPR31            			 _0x01DF.byte
//=======0x02F0				         
                                     
//========0x0300                     
//==========================         
//			ADCCR0                   
//==========================         
#define ADCCR0				         _0x0300.byte
#define ADCCR0_AMD			         _0x0300.b7_6.b7_6
#define ADCCR0_AUTOPD		         _0x0300.bit.b5
#define ADCCR0_INTLV		         _0x0300.bit.b4
#define ADCCR0_INTEN		         _0x0300.bit.b3
#define ADCCR0_IRFEN		         _0x0300.b2_1.b2_1
#define ADCCR0_ADEN			         _0x0300.bit.b0
                                     
//==========================         
//			ADCCR1                   
//==========================         
#define ADCCR1				         _0x0301.byte
#define ADCCR1_EVSEL		         _0x0301.b7_4.b7_4
                                     
//==========================         
//			ADCCR2                   
//==========================         
#define ADCCR2				         _0x0302.byte
#define ADCCR2_LVINTEN		         _0x0302.bit.b0
                                     
//==========================         
//			ADCCKDIV                 
//==========================         
#define ADCCKDIV			         _0x0304.byte
#define ADCCKDIV_CKDIV		         _0x0304.byte  
#define ADCCKDIV_ADCKDIV	         _0x0304.b3_0.b3_0
//==========================         
//			ADCLV                    
//==========================         
#define ADCLV    			         _0x0306.byte
#define ADCLV_LVCMP			         _0x0306.b7_6.b7_6
#define ADCLV_LVINTVL		         _0x0306.bit.b5
#define ADCLV_LVSEL			         _0x0306.b4_0.b4_0
                                     
//==========================         
//			ADCSCAN0                 
//==========================         
#define ADCSCAN0			         _0x0307.byte
#define ADCSCAN0_ADCSCAN	         _0x0307.byte
                                     

//==========================         
//			ADCSR                    
//==========================         
#define ADCSR				         _0x030A.byte
#define ADCSR_EOCF			         _0x030A.bit.b7
#define ADCSR_ADBF			         _0x030A.bit.b6
#define ADCSR_ADRDY                  _0x030A.bit.b5
#define ADCSR_BUFOVR		         _0x030A.bit.b3
#define ADCSR_UNLCK			         _0x030A.bit.b2
#define ADCSR_LVDET			         _0x030A.bit.b1
#define ADCSR_ADRS			         _0x030A.bit.b0
                                     
//==========================         
//			ADCCHRDY                 
//==========================         
#define ADCCHRDY			         _0x030B.byte
#define ADCCHRDY_CHRDY		         _0x030B.b4_0.b4_0
                                     
//==========================         
//			ADCCHSEL                 
//==========================         
#define ADCCHSEL			         _0x030C.byte
#define ADCCHSEL_CHSEL		         _0x030C.b4_0.b4_0
                                     
//==========================         
//			ADCDR                    
//==========================         
#define ADCDR				         _0x0310.word
#define ADCDRL				         _0x0310.byte[0]
#define ADCDR_ADCDRL		         _0x0310.byte[0]
#define ADCDRH				         _0x0310.byte[1]
#define ADCDR_ADCDRH		         _0x0310.blst8_byte[1].b3_0.b3_0
                                     
//==========================         
//			ADCLLV                   
//==========================         
#define ADCLLV				         _0x0312.word
#define ADCLLVL				         _0x0312.byte[0]
#define ADCLLV_ADCLLVL		         _0x0312.byte[0]
#define ADCLLVH				         _0x0312.byte[1]
#define ADCLLV_ADCLLVH		         _0x0312.blst8_byte[1].b3_0.b3_0
                                     
//==========================         
//			ADCHLV                   
//==========================         
#define ADCHLV 				         _0x0314.word
#define ADCHLVL				         _0x0314.byte[0]
#define ADCHLV_ADCHLVL		         _0x0314.byte[0]
#define ADCHLVH				         _0x0314.byte[1]
#define ADCHLV_ADCHLVH		         _0x0314.blst8_byte[1].b3_0.b3_0
       
                                     
//------0x0320                       
                                     
//==========================         
//        CMPCR                      
//==========================         
#define CMPCR	         	 		 _0x0330.byte
#define CMPCR_CMPIE	         		 _0x0330.bit.b4
#define CMPCR_CMPES	         		 _0x0330.b3_2.b3_2
#define CMPCR_CMPOE	         		 _0x0330.bit.b1
#define CMPCR_CMPEN	         		 _0x0330.bit.b0
			                         
                                     
//==========================         
//        CMPSR                      
//==========================         
#define CMPSR            	   		 _0x0331.byte
#define CMPSR_CMPIF            		 _0x0331.bit.b1
#define CMPSR_CMPO             		 _0x0331.bit.b0
                                     
//--------0x0850                     
//==========================         
//        CRCCR                      
//==========================         
#define CRCCR            			 _0x0850.byte
#define CRCCR_SETONE            	 _0x0850.bit.b1
#define CRCCR_CRCEN             	 _0x0850.bit.b0
                                     
//==========================         
//        CRCSR                      
//==========================         
#define CRCSR            			 _0x0851.byte
#define CRCSR_BUSY              	 _0x0851.bit.b7
                                     
//==========================         
//        CRCDI OR CRCIN             
//==========================         
#define CRCDI            	   		 _0x0852.byte
#define CRCDI_CRCIN            		 _0x0852.byte
                                     
//==========================         
//        CRCDO0 OR CRCOUT0          
//==========================         
#define CRCDO0           		 	 _0x0854.byte
#define CRCDO0_CRCOUT0           	 _0x0854.byte
                                     
//==========================         
//        CRCDO1 OR CRCOUT1          
//==========================         
#define CRCDO1                   	 _0x0855.byte
#define CRCDO1_CRCDO1           	 _0x0855.byte
									 
//-------0x0858                      
//==========================         
//        DICCR                      
//==========================                 
#define DICCR                  		 _0x0858.byte
#define DICCR_BUSY             		 _0x0858.bit.b7
#define DICCR_DICIE            		 _0x0858.bit.b1
#define DICCR_DICEN            		 _0x0858.bit.b0
                                     

//==========================         
//        DICCNT0                    
//==========================         
#define DICCNT0          			 _0x085A.byte
                                     
//==========================         
//        DICCNT1                    
//==========================         
#define DICCNT1          			 _0x085B.byte
                                     
//==========================         
//        DICADR0                    
//==========================         
#define DICADR0          			 _0x085C.byte
                                     
//==========================         
//        DICADR1                    
//==========================         
#define DICADR1          			 _0x085D.byte
                                     
//==========================         
//        DICADR2                    
//==========================         
#define DICADR2          	  		 _0x085E.byte
#define DICADR2_AREA          		 _0x085E.b4_0.b4_0
                                     									 	
#endif


