//*************************************************************************************
// file			: SQ7653_UART.h
// version		: V1.1  2020/9/4
// brief		: UART header file
// note			: 
//**************************************************************************************
#ifndef _SQ7653_UART_H__
#define _SQ7653_UART_H__


/* ---------------------- extern global variables ------------------------- */
extern uchar RT;                             // UARTxCR2_RTSEL setting
extern uchar DR;                             // UARTxDR setting
extern uchar sentBuf[];
extern uchar reciveBuf[];

extern uchar RX0_Int_Flag;					 // IntRX0 interrupt flag
extern uchar RX1_Int_Flag;					 // IntRX1 interrupt flag
extern uchar RX2_Int_Flag;					 // IntRX2 interrupt flag
extern uchar rx1_int_count;	             // number of RX1 interrupts
/* ---------------------- user-defined macros ------------------------------ */


#define DISABLE          0x00     // disable
#define ENABLE           0x01     // enable

#define PARITY_NONE      0x00     // no parity
#define PARITY_ODD       0x08     // odd-numbered parity
#define PARITY_EVEN      0x18     // even-numbered parity

#define STOP_1BIT        0x00     // Transmit stop bit length is 1 bit
#define STOP_2BIT        0x01     // Transmit stop bit length is 2 bits

// TX function selection
#define TX_OUTPUT_UART   0x00     // UART output
#define TX_OUTPUT_IRDA   0x01     // IrDA output

#define TX               0x00     // transmission
#define RX               0x01     // receiver
#define TRX              0x02     // transmission & receiver

// UART dividing frequency selection
#define DIV_BY1          0x00     // fsysclk/1
#define DIV_BY2          0x01     // fsysclk/2
#define DIV_BY4          0x02     // fsysclk/4
#define DIV_BY8          0x03     // fsysclk/8

// UART_Operating_Frequency@24MHZ
#define Operat24M_Baud128000   (DR = 0x0A, RT = 0x4)
#define Operat24M_Baud115200   (DR = 0x0C, RT = 0x0)
#define Operat24M_Baud76800    (DR = 0x12, RT = 0x1)
#define Operat24M_Baud62500    (DR = 0x17, RT = 0x0)
#define Operat24M_Baud57600    (DR = 0x19, RT = 0x0)
#define Operat24M_Baud38400    (DR = 0x26, RT = 0x0)
#define Operat24M_Baud19200    (DR = 0x4D, RT = 0x0)
#define Operat24M_Baud9600	   (DR = 0x92, RT = 0x4)

// UART_Operating_Frequency@16MHZ
#define Operat16M_Baud128000   (DR = 0x07, RT = 0x3)
#define Operat16M_Baud115200   (DR = 0x08, RT = 0x3)
#define Operat16M_Baud76800    (DR = 0x0C, RT = 0x0)
#define Operat16M_Baud62500    (DR = 0x0F, RT = 0x0)
#define Operat16M_Baud57600    (DR = 0x11, RT = 0x3)
#define Operat16M_Baud38400    (DR = 0x19, RT = 0x0)
#define Operat16M_Baud19200    (DR = 0x30, RT = 0x4)
#define Operat16M_Baud9600	   (DR = 0x64, RT = 0x1)
#define Operat16M_Baud4800	   (DR = 0xC9, RT = 0x1)

// UART_Operating_Frequency@12MHZ
#define Operat12M_Baud128000   (DR = 0x05, RT = 0x3)
#define Operat12M_Baud115200   (DR = 0x06, RT = 0x2)
#define Operat12M_Baud76800    (DR = 0x09, RT = 0x3)
#define Operat12M_Baud62500    (DR = 0x0B, RT = 0x0)
#define Operat12M_Baud57600    (DR = 0x0C, RT = 0x0)
#define Operat12M_Baud38400    (DR = 0x12, RT = 0x1)
#define Operat12M_Baud19200    (DR = 0x26, RT = 0x0)
#define Operat12M_Baud9600	   (DR = 0x4D, RT = 0x0)
#define Operat12M_Baud4800	   (DR = 0x92, RT = 0x4)

// UART_Operating_Frequency@8MHZ
#define Operat8M_Baud128000    (DR = 0x03, RT = 0x3)
#define Operat8M_Baud76800     (DR = 0x06, RT = 0x2)
#define Operat8M_Baud62500     (DR = 0x07, RT = 0x0)
#define Operat8M_Baud57600     (DR = 0x08, RT = 0x3)
#define Operat8M_Baud38400     (DR = 0x0C, RT = 0x0)
#define Operat8M_Baud19200     (DR = 0x19, RT = 0x0)
#define Operat8M_Baud9600	   (DR = 0x30, RT = 0x4)
#define Operat8M_Baud4800	   (DR = 0x64, RT = 0x1)
#define Operat8M_Baud2400	   (DR = 0xC9, RT = 0x1)

// UART_Operating_Frequency@4MHZ
#define Operat4M_Baud128000    (DR = 0x01, RT = 0x3)
#define Operat4M_Baud62500     (DR = 0x03, RT = 0x0)
#define Operat4M_Baud38400     (DR = 0x06, RT = 0x2)
#define Operat4M_Baud19200     (DR = 0x0C, RT = 0x0)
#define Operat4M_Baud9600	   (DR = 0x19, RT = 0x0)
#define Operat4M_Baud4800	   (DR = 0x30, RT = 0x4)
#define Operat4M_Baud2400	   (DR = 0x64, RT = 0x1)
#define Operat4M_Baud1200	   (DR = 0xC9, RT = 0x1)

// UART_Operating_Frequency@2MHZ
#define Operat2M_Baud128000    (DR = 0x00, RT = 0x3)
#define Operat2M_Baud62500     (DR = 0x01, RT = 0x0)
#define Operat2M_Baud19200     (DR = 0x06, RT = 0x2)
#define Operat2M_Baud9600	   (DR = 0x0C, RT = 0x0)
#define Operat2M_Baud4800	   (DR = 0x19, RT = 0x0)
#define Operat2M_Baud2400	   (DR = 0x30, RT = 0x4)
#define Operat2M_Baud1200	   (DR = 0x64, RT = 0x1)

// UART_Operating_Frequency@1MHZ
#define Operat1M_Baud62500     (DR = 0x00, RT = 0x0)
#define Operat1M_Baud9600	   (DR = 0x06, RT = 0x2)
#define Operat1M_Baud4800	   (DR = 0x0C, RT = 0x0)
#define Operat1M_Baud2400	   (DR = 0x19, RT = 0x0)
#define Operat1M_Baud1200	   (DR = 0x30, RT = 0x4)

// UARTx selection
#define UART0         (0x0)               
#define UART1         (0x1)               
#define UART2         (0x2)               

#define PERR          (UART1SR_PERR = 1)  // parity error
#define FERR          (UART1SR_FERR = 1)  // framing error
#define OERR          (UART1SR_OERR = 1)  // overrun error

#define RBSY          (UART1SR_RBSY = 1)  // on receiving
#define TBSY          (UART1SR_TBSY = 1)  // on transmitting
#define RBFL          (UART1SR_RBFL = 1)  // receive buffer full
#define TBFL          (UART1SR_TBFL = 1)  // transmit buffer full (Transmit data writing is completed)

//------------------------------------------------------------------

//--- UART initialization UART0/UART1/UART2
void UART0_Init(uchar parityCheck);            
void UART1_Init(uchar parityCheck);
void UART2_Init(uchar parityCheck);

//--- enable/disable UARTx interrupt
void UART0_Int(uchar intEn, uchar trxSelect); 
void UART1_Int(uchar intEn, uchar trxSelect);
void UART2_Int(uchar intEn, uchar trxSelect);

//--- set Baud rate
void UART0_SetBaudRate(uchar baudSel);         
void UART1_SetBaudRate(uchar baudSel);
void UART2_SetBaudRate(uchar baudSel);

//--- enable or disable UART0/UART1/UART2
void UART0_Start();                   
void UART0_Stop();

void UART1_Start();
void UART1_Stop();

void UART2_Start();
void UART2_Stop();

void UART0_TX_OneByte(uchar data);     //--- TX transmits a single byte
void UART1_TX_OneByte(uchar data);
void UART2_TX_OneByte(uchar data);

uchar UART0_RX_OneByte();               //--- RX receives a single byte
uchar UART1_RX_OneByte();
uchar UART2_RX_OneByte();
uchar UART_ReadState(uchar uartSel);    //--- get UART status


void UART_TX_OneByte(uchar uartSel,uchar data);
uchar UART_RX_OneByte(uchar uartSel);

//TX transmits bytes
void  UART_Send_Bytes(uchar uartSel, uchar* buf, uchar len);


void UART_PutByte(uchar uartSel,uchar abyte);

void UART_PutDecNumber(uint value);

//--- transmit line break characters
void UART_PutCrlf(void);

//--- send CString
void UART_SendCString(const char *pstr);

//--- compare the received data, if it is correct then light on the corresponding LED
void Check_Recive_Data_LED();

//--- RX interrupt service routine
void __interrupt RX0_IRQ(void);
void __interrupt RX1_IRQ(void);
void __interrupt RX2_IRQ(void);

//--- TX interrupt service routine
void __interrupt TX0_IRQ(void);
void __interrupt TX1_IRQ(void);
void __interrupt TX2_IRQ(void);

#endif


