//*************************************************************************************
// file			: main.h
// version		: V1.0 2020/07/17
// brief		: header file of this example
// note			: the custom variables used are collected in this document in this header file
//**************************************************************************************
#ifndef _INCLUDES_H__
#define _INCLUDES_H__

/* ---------------------- reference header files ------------------------------ */
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "SQ7653_SFR.h"
#include "SQ7653_TMRA0_Timer.h"

/* ---------------------- user-defined macros ------------------------------ */
// when the system main frequency is 24MHz, TRMA00 is 8-bit timer, and TMRA00 source clock is selected as fsys/2^11=11.71875KHz(85.333us)
#define Count_20_48ms   240   // 240*85.333us=20.48ms
#define Count_10_24ms   120   // 120*85.333us=10.24ms
#define Count_5_12ms     60   //  60*85.333us=5.12ms

#define BTN1_in    P1DI_P0
#define BTN2_in    P1DI_P1
#define BTN3_in    P1DI_P2

#define LED1_out   P0DO_P0
#define LED2_out   P0DO_P1
#define LED3_out   P0DO_P2
#define LED1_to_3_turn_off   P0DO_P0 = 1; P0DO_P1 = 1; P0DO_P2 = 1; // LED1~3ȫص

/* ---------------------- extern global variables ------------------------- */



/* ---------------------- extern functions ------------------------ */
extern void STARTUP(void);

#endif //#ifndef _INCLUDES_H__


