//*************************************************************************************
// file			: SQ7653_TMRA0_Timer.c
// version		: V1.0 2020/07/17
// brief		: TMRA0_Timer related functions
// note			: TMRA0_Timer related functions are gathered in this subroutine
//**************************************************************************************
#include "main.h"

unsigned char TMRA00_Int_Flag;		  	// TMRA00 interrupt flag
unsigned char TMRA01_Int_Flag;		  	// TMRA01 interrupt flag

//*********************************************************************
// name			: TMRA00_8bit_Timer_Init()
// brief		: TMRA00 initialization to 8-bit timer mode
// note			: 
//*********************************************************************
void TMRA00_8bit_Timer_Init(){

//====== enable function ======
	PCKEN0_TMRA0 = 1;                   // enable TMRA0  *this must be enabled first, the relevant staging settings later to be useful

//====== parameter setting ======

	//1.)---operation mode selection->
	TMRA0CFG_TCFG = set_8bit;			// set TMRA0 to 8-bit mode
	TMRA0MD0_TCM  = timer ;				// set TMRA00 to timer mode
    
	TMRA0MD0_DBE  = 1;                	// 1: enable double buffer
    //TMRA0MD0_DBE  = 0;                // 0: disable double buffer
    	
	//2.)---clock source selection->
	// if the system frequency is 24MHz,
	TMRA0MD0_TCK   = 0x00;			    // set TMRA00 source clock to fcgck/(2^11) = 24M/2048 = 11.718kHz => 85.3us
	//TMRA0MD0_TCK = 0x01;				// set TMRA00 source clock to fcgck/(2^10) = 24M/1024 = 23.437kHz => 42.6667us
	
}



//*********************************************************************
// name			: TMRA01_8bit_Timer_Init()
// brief		: TMRA01 initialization to 8-bit timer mode
// note			: 
//*********************************************************************
void TMRA01_8bit_Timer_Init(){

//====== enable function ======
	PCKEN0_TMRA0 = 1;                   // enable TMRA0  *this must be enabled first, the relevant staging settings later to be useful

//====== parameter setting ======

	//1.)---operation mode selection->
	TMRA0CFG_TCFG = set_8bit;			// set TMRA0 to 8-bit mode
	TMRA0MD1_TCM  = timer ;				// set TMRA01 to timer mode
    
	TMRA0MD1_DBE  = 1;                	// 1: enable double buffer
    //TMRA0MD1_DBE  = 0;                // 0: disable double buffer

	//2.)---clock source selection->
	// if the system frequency is 24MHz,
	TMRA0MD1_TCK  = 0x00;			    // set TMRA01 source clock to fcgck/(2^11) = 24M/2048 = 11.718kHz => 85.3us
    //TMRA0MD1_TCK = 0x01;				// set TMRA01 source clock to fcgck/(2^10) = 24M/1024 = 23.437kHz => 42.6667us
	
}



//*********************************************************************
// name			: TMRA0_16bit_Timer_Init()
// brief		: TMRA0 initialization to 16-bit timer mode
// note			: 
//*********************************************************************
void TMRA0_16bit_Timer_Init(){

//====== enable function ======
	PCKEN0_TMRA0 = 1;                   // enable TMRA0  *this must be enabled first, the relevant staging settings later to be useful

//====== parameter setting ======
	//1.)---operation mode selection->
	TMRA0CFG_TCFG = set_16bit;			// set TMRA0 to 16-bit
	TMRA0MD1_TCM  = timer ;				// set TMRA0 to timer mode
	
	TMRA0MD1_DBE  = 1;                	// 1: enable double buffer
    //TMRA0MD1_DBE  = 0;                // 0: disable double buffer

	//2.)---clock source selection->				
	//if the system frequency is 24MHz,
    TMRA0MD1_TCK     = 0x00;		    // set TMRA01 source clock to fcgck/(2^11) = 24M/2048 = 11.718kHz => 85.3us
	//TMRA0MD1_TCK   = 0x01;			// set TMRA01 source clock to fcgck/(2^10) = 24M/1024 = 23.437kHz => 42.6667us

}


//*********************************************************************
// name			: TMRA00_IntEnable()
// brief		: enalbe TMRA00 interrupt
// note			: 
//*********************************************************************
void TMRA00_IntEnable(){
	__ASM("DI");					    // enable all maskable interrupts
	IER_TMRA00_IRQ = 1;                 // enalbe TMRA00 interrupt
	
	TMRA0CR0_TMROVIE = 0;               // generate no TMRA00 interrupt request when the counter overflow occurs
	//TMRA0CR0_TMROVIE = 1;             // generate a TMRA00 interrupt request when the counter overflow occurs
	
	__ASM("EI");						// enable all maskable interrupts
}


//*********************************************************************
// name			: TMRA01_IntEnable()
// brief		: enalbe TMRA01 interrupt
// note			: 
//*********************************************************************
void TMRA01_IntEnable(){
	__ASM("DI");					    // enable all maskable interrupts
	IER_TMRA01_IRQ = 1;                 // enalbe TMRA01 interrupt
	
	TMRA0CR1_TMROVIE = 0;               // generate no TMRA01 interrupt request when the counter overflow occurs
	//TMRA0CR1_TMROVIE = 1;             // generate a TMRA01 interrupt request when the counter overflow occurs
	
	__ASM("EI");						// enable all maskable interrupts
}



//*********************************************************************
// name			: TMRA00_IntDisable()
// brief		: disalbe TMRA00 interrupt
// note			: 
//*********************************************************************
void TMRA00_IntDisable(){
	__ASM("DI");					    // enable all maskable interrupts
	IER_TMRA00_IRQ = 0;                 // disalbe TMRA00 interrupt
	__ASM("EI");						// enable all maskable interrupts
	
}


//*********************************************************************
// name			: TMRA01_IntDisable()
// brief		: disalbe TMRA01 interrupt
// note			: 
//*********************************************************************
void TMRA01_IntDisable(){
	__ASM("DI");					    // enable all maskable interrupts
	IER_TMRA31_IRQ = 0;                 // disalbe TMRA01 interrupt
	__ASM("EI");						// enable all maskable interrupts
	
}



//*********************************************************************
// name			: TMRA00_SetPeriod()
// brief		: set TMRA00 timer counter
// note			: 
//*********************************************************************
void TMRA00_SetPeriod(unsigned int period){	
	TMRA0DR0 = period;              	

}


//*********************************************************************
// name			: TMRA01_SetPeriod()
// brief		: set TMRA01 timer counter
// note			: 
//*********************************************************************
void TMRA01_SetPeriod(unsigned int period){	
	TMRA0DR1 = period;              	

}


//*********************************************************************
// name			: TMRA0_16bit_SetPeriod()
// brief		: set TMRA0 timer counter
// note			: 
//*********************************************************************
void TMRA0_16bit_SetPeriod(unsigned int period){    
    TMRA0DR0 = period & 0x00ff;         // low byte first
    TMRA0DR1 = period>>8;               // then high byte
	
}


//*********************************************************************
// name			: TMRA00_Start()
// brief		: start to run TMRA00
// note			: 
//*********************************************************************
void TMRA00_Start(){
	TMRA0CR0_RUN = 1;                   // start to run TMRA00
	
}


//*********************************************************************
// name			: TMRA01_Start()
// brief		: start to run TMRA01
// note			: 
//*********************************************************************
void TMRA01_Start(){
	TMRA0CR1_RUN = 1;                   // start to run TMRA01
	
}


//*********************************************************************
// name			: TMRA0_16bit_Start()
// brief		: start to run TMRA0
// note			: 
//*********************************************************************
void TMRA0_16bit_Start(){
	TMRA0CR1_RUN = 1;                   // start to run TMRA0
	
}


//*********************************************************************
// name			: TMRA00_Stop()
// brief		: stop and clear TMRA00
// note			: 
//*********************************************************************
void TMRA00_Stop(){
	TMRA0CR0_RUN = 0;                   // stop and clear TMRA00

}


//*********************************************************************
// name			: TMRA01_Stop()
// brief		: stop and clear TMRA01
// note			: 
//*********************************************************************
void TMRA01_Stop(){
	TMRA0CR1_RUN = 0;                   // stop and clear TMRA01

}


//*********************************************************************
// name			: TMRA0_16bit_Stop()
// brief		: stop TMRA0
// note			: 
//*********************************************************************
void TMRA0_16bit_Stop(){
	TMRA0CR1_RUN = 0;                   // stop and clear TMRA0
	
}


//*********************************************************************
// name			: __interrupt TMRA00_IRQ()
// brief		: TMRA00 interrupt service routine
// note			: 
//*********************************************************************
void __interrupt TMRA00_IRQ(void){
	__asm("NOP");						// no operation
	TMRA00_Int_Flag = 1;				// set TMRA00_Int_Flag to 1
	
	
}


//*********************************************************************
// name			: __interrupt TMRA01_IRQ()
// brief		: TMRA01 interrupt service routine
// note			: 
//*********************************************************************
void __interrupt TMRA01_IRQ(void){
	__asm("NOP");						// no operation
	TMRA01_Int_Flag = 1;				// set TMRA01_Int_Flag to 1
	
	
}

