//*************************************************************************************
// file			: main.h
// version		: V1.0 2020/07/17
// brief		: header file of this example
// note			: the custom variables used are collected in this document in this header file
//**************************************************************************************
#ifndef _INCLUDES_H__
#define _INCLUDES_H__

/* ---------------------- reference header files ------------------------------ */
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "SQ7653_SFR.h"
#include "SQ7653_TMRA0_Timer.h"

/* ---------------------- user-defined macros ------------------------------ */
// when the system main frequency is 24MHz, TRMA01 is 8-bit timer, and TMRA0 source clock is selected as fsys/2^11=11.71875KHz(0.0426ms)
#define Count_300ms  7044  // 7044 = 0x1B84 => 7044*0.0426ms=300ms
#define Count_150ms  3522  // 3522 = 0x0DC2 => 3522*0.0426ms=150ms
#define Count_50ms   1174  // 1174 = 0x0496 => 1174*0.0426ms=50ms

#define BTN1_in    P1DI_P0	 // BTN1(P1.0) button 1 input voltage
#define BTN2_in    P1DI_P1	 // BTN1(P1.1) button 1 input voltage
#define BTN3_in    P1DI_P2	 // BTN1(P1.2) button 1 input voltage

#define LED1_out   P0DO_P0	 // LED1(P0.0) output voltage
#define LED2_out   P0DO_P1	 // LED1(P0.1) output voltage
#define LED3_out   P0DO_P2	 // LED1(P0.2) output voltage
#define LED1_to_3_turn_off   P0DO_P0 = 1; P0DO_P1 = 1; P0DO_P2 = 1;

/* ---------------------- extern functions ------------------------ */
extern void STARTUP(void);


#endif //#ifndef _INCLUDES_H__


