//*************************************************************************************
// file			: SQ7653_TMRA4_PulseMeasure.c
// version		: V1.0 2020/07/17
// brief		: TMRA4_PulseMeasurerelated functions
// note			: TMRA4_PulseMeasure related functions are gathered in this subroutine
//**************************************************************************************
#include "main.h"

unsigned char TMRA40_Int_Flag;		    // TMRA40 interrupt flag
unsigned char TMRA41_Int_Flag;		    // TMRA41 interrupt flag

unsigned int  measure_count;
unsigned int  L_pulse_measure_count;      
unsigned int  H_pulse_measure_count;      
unsigned char Data_L  ,Data_H;			
unsigned char Data_PWL,Data_PWH;			

//*********************************************************************
// name			: TMRA40_8bit_PulseMeasure_Init()
// brief		: TMRA40 initialization to pulse width measurement mode
// note			: 
//*********************************************************************
void TMRA40_8bit_PulseMeasure_Init(){
//====== enable function ======
	PCKEN0_TMRA4 = 1;                   	// enable TMRA4 function  *this must be enabled first, the relevant staging settings later to be useful	

//====== parameter setting ======

	//1.)---operation mode selection->
	TMRA4CFG_TCFG = set_8bit;				// set TMRA4 to 8-bit
	TMRA4MD0_TCM  = pulse_measure;    		// set TMRA40 to pulse width measurement mode
	
	TMRA4MD0_DBE  = 1;                	    // 1: enable double buffer
    //TMRA4MD0_DBE  = 0;                    // 0: disable double buffer

	//2.)---clock source selection->
	//if the system frequency is 24MHz,
    //TMRA4MD0_TCK = 0x00;				    // set TMRA40 source clock to fcgck/(2^11) = 24M/2048 = 11.718kHz => 85.3us
    TMRA4MD0_TCK = 0x01;                	// set TMRA40 source clock to fcgck/(2^10) = 24M/1024 = 23.437kHz => 42.6667us

	//3.)---pin configuration initialization->
	//---set pulse width measurement pin to P0.3->
	P0CFGCR = 0xB4;  						

	//4.)---pulse width measurement mode edge selection->
	TMRA4CR0_EDGE = 0x00;					// rising to falling (high pulse)
	//TMRA4CR0_EDGE = 0x01;					// falling to rising (low pulse)
	//TMRA4CR0_EDGE = 0x02;					// rising to rising (period)
	//TMRA4CR0_EDGE = 0x03;					// falling to falling (period)
	//TMRA4CR0_EDGE = 0x04;					// rising to falling (high pulse) / rising to rising (period)

}



//*********************************************************************
// name			: TMRA41_8bit_PulseMeasure_Init()
// brief		: TMRA41 initialization to pulse width measurement mode
// note			: 
//*********************************************************************
void TMRA41_8bit_PulseMeasure_Init(){
//====== enable function ======
	PCKEN0_TMRA4 = 1;                   	// enable TMRA4 function  *this must be enabled first, the relevant staging settings later to be useful	

//====== parameter setting ======

	//1.)---operation mode selection->
	TMRA4CFG_TCFG = set_8bit;				// set TMRA4 to 8-bit
	TMRA4MD1_TCM  = pulse_measure;    		// set TMRA41 to pulse width measurement mode
	
	TMRA4MD1_DBE  = 1;                	    // 1: enable double buffer
    //TMRA4MD1_DBE  = 0;                    // 0: disable double buffer

	//2.)---clock source selection->
    //if the system frequency is 24MHz,
    //TMRA4MD1_TCK = 0x00;				    // set TMRA41 source clock to fcgck/(2^11) = 24M/2048 = 11.718kHz => 85.3us
    TMRA4MD1_TCK = 0x01;                	// set TMRA41 source clock to fcgck/(2^10) = 24M/1024 = 23.437kHz => 42.6667us

	//3.)---pin configuration initialization->
	//---set pulse width measurement pin to P0.3->
	P0CFGCR = 0xB4;  						

	//4.)---pulse width measurement mode edge selection->
	TMRA4CR0_EDGE = 0x00;					// rising to falling (high pulse)
	//TMRA4CR0_EDGE = 0x01;					// falling to rising (low pulse)
	//TMRA4CR0_EDGE = 0x02;					// rising to rising (period)
	//TMRA4CR0_EDGE = 0x03;					// falling to falling (period)
	//TMRA4CR0_EDGE = 0x04;					// rising to falling (high pulse) / rising to rising (period)

}



//*********************************************************************
// name			: TMRA4_16bit_PulseMeasure_Init()
// brief		: TMRA4 initialization to pulse width measurement mode
// note			: 
//*********************************************************************
void TMRA4_16bit_PulseMeasure_Init(){
//====== enable function ======
	PCKEN0_TMRA4 = 1;                   	// enable TMRA4 function  *this must be enabled first, the relevant staging settings later to be useful	

//====== parameter setting ======

	//1.)---operation mode selection->
	TMRA4CFG_TCFG = set_16bit;				// TMRA4 initialization to 16-bit mode
	TMRA4MD1_TCM  = pulse_measure;    		// set TMRA4 to pulse width measurement mode

	TMRA4MD1_DBE  = 1;                	    // 1: enable double buffer
    //TMRA4MD1_DBE  = 0;                    // 0: disable double buffer

	//2.)---clock source selection->				
	// if the system frequency is 24MHz,
    TMRA4MD1_TCK = 0x00;				    // set TMRA4 source clock to fcgck/(2^11) = 24M/2048 = 11.718kHz => 85.3us
    //TMRA4MD1_TCK = 0x01;                	// set TMRA4 source clock to fcgck/(2^10) = 24M/1024 = 23.437kHz => 42.6667us

	//3.)---pin configuration initialization->
	//---set pulse width measurement pin to P0.3->
	P0CFGCR = 0xB4;  						

	//4.)---pulse width measurement mode edge selection->
	TMRA4CR0_EDGE = 0x00;					// rising to falling (high pulse)
	//TMRA4CR0_EDGE = 0x01;					// falling to rising (low pulse)
	//TMRA4CR0_EDGE = 0x02;					// rising to rising (period)
	//TMRA4CR0_EDGE = 0x03;					// falling to falling (period)
	//TMRA4CR0_EDGE = 0x04;					// rising to falling (high pulse) / rising to rising (period)

}



//*********************************************************************
// name			: TMRA40_IntEnable()
// brief		: enable TMRA40 interrupt
// note			: 
//*********************************************************************
void TMRA40_IntEnable(){
	__ASM("DI");					    	// enable all maskable interrupts
	IER_TMRA40_IRQ = 1;                 	// enable TMRA40 interrupt
	
	//---edge detect interrupt setting->
	TMRA4CR0_EDGEIE = 1;					// enable edge detect interrupt
	
	//---counter overflow interrupt setting->
	//TMRA4CR0_TMROVIE = 1;             	// generate no TMRA40 interrupt request when the counter overflow occurs
	
	__ASM("EI");							// enable all maskable interrupts
}


//*********************************************************************
// name			: TMRA41_IntEnable()
// brief		: enable TMRA41 interrupt
// note			: 
//*********************************************************************
void TMRA41_IntEnable(){
	__ASM("DI");					    	// enable all maskable interrupts
	IER_TMRA41_IRQ = 1;                 	// enable TMRA41 interrupt
	
	//---edge detect interrupt setting->
	TMRA4CR1_EDGEIE = 1;					// enable edge detect interrupt
	
	//---counter overflow interrupt setting->
	//TMRA4CR1_TMROVIE = 1;             	// generate no TMRA41 interrupt request when the counter overflow occurs
	
	__ASM("EI");							// enable all maskable interrupts
}



//*********************************************************************
// name			: TMRA40_IntDisable()
// brief		: disable TMRA40 interrupt
// note			: 
//*********************************************************************
void TMRA40_IntDisable(){
	__ASM("DI");					    	// enable all maskable interrupts
	IER_TMRA40_IRQ = 0;                 	// disable TMRA40 interrupt
	
	//---edge detect interrupt setting->
	//TMRA4CR0_EDGEIE = 0;					// disable edge detect interrupt
	
	//---counter overflow interrupt setting->
	//TMRA4CR0_TMROVIE = 0;             	// generate no TMRA40 interrupt request when the counter overflow occurs
	
	__ASM("EI");							// enable all maskable interrupts
}


//*********************************************************************
// name			: TMRA41_IntDisable()
// brief		: disable TMRA41 interrupt
// note			: 
//*********************************************************************
void TMRA41_IntDisable(){
	__ASM("DI");					    	// enable all maskable interrupts
	IER_TMRA41_IRQ = 0;                 	// disable TMRA41 interrupt
	
	//---edge detect interrupt setting->
	//TMRA4CR1_EDGEIE = 0;					// disable edge detect interrupt
	
	//---counter overflow interrupt setting->
	//TMRA4CR1_TMROVIE = 0;             	// generate no TMRA41 interrupt request when the counter overflow occurs
	
	__ASM("EI");							// enable all maskable interrupts
}



//*********************************************************************
// name			: TMRA40_Start()
// brief		: start to run TMRA40
// note			: 
//*********************************************************************
void TMRA40_Start(){
	TMRA4CR0_RUN = 1;                   	
	
}


//*********************************************************************
// name			: TMRA41_Start()
// brief		: start to run TMRA41
// note			: 
//*********************************************************************
void TMRA41_Start(){
	TMRA4CR1_RUN = 1;                   	
	
}


//*********************************************************************
// name			: TMRA4_16bit_Start()
// brief		: start to run TMRA4
// note			: 
//*********************************************************************
void TMRA4_16bit_Start(){
	TMRA4CR1_RUN = 1;                   	
	
}


//*********************************************************************
// name			: TMRA40_Stop()
// brief		: stop and clear TMRA40
// note			: 
//*********************************************************************
void TMRA40_Stop(){
	TMRA4CR0_RUN = 0;                   	// stop TMRA40
	IFR_TMRA40_IRQ = 0;						// clear TMRA40 interrupt flag
}


//*********************************************************************
// name			: TMRA41_Stop()
// brief		: stop and clear TMRA41
// note			: 
//*********************************************************************
void TMRA41_Stop(){
	TMRA4CR1_RUN = 0;                   	// stop TMRA41
	IFR_TMRA41_IRQ = 0;						// clear TMRA41 interrupt flag



}


//*********************************************************************
// name			: TMRA4_16bit_Stop()
// brief		: stop and clear TMRA4
// note			: 
//*********************************************************************
void TMRA4_16bit_Stop(){
	TMRA4CR1_RUN = 0;                   	// stop TMRA4
	IFR_TMRA41_IRQ = 0;						// clear TMRA4 interrupt flag
}


//*********************************************************************
// name			: TMRA4_16bit_Read_Measure_Period()
// brief		: get the counter value of double edge capture mode
// note			: 
//*********************************************************************
unsigned int TMRA4_16bit_Read_Measure_Period(){
	Data_L = TMRA4DR0;						// read low byte first
	Data_H = TMRA4DR1;						
	
	measure_count = ((Data_H<<8) | Data_L); // return 16-bit value
	
}


//*********************************************************************
// name			: TMRA4_16bit_Read_Measure_Pulse_Width()
// brief		: get the counter value of single edge capture mode
// note			: 
//*********************************************************************
unsigned int TMRA4_16bit_Read_Measure_Pulse_Width(){
	Data_PWL = TMRA4PWM0;					// read low byte first
	Data_PWH = TMRA4PWM1;					
	
	H_pulse_measure_count = ((Data_PWH<<8) | Data_PWL); // return 16-bit value
	
}



//*********************************************************************
// name			: __interrupt TMRA40_IRQ()
// brief		: TMRA40 interrupt service routine
// note			: 
//*********************************************************************
void __interrupt TMRA40_IRQ(void){
	__asm("NOP");							// no operation

	
}


//*********************************************************************
// name			: __interrupt TMRA41_IRQ()
// brief		: TMRA41 interrupt service routine
// note			: 
//*********************************************************************
void __interrupt TMRA41_IRQ(void){
	__asm("NOP");							// no operation
	
	if(TMRA4SR_EDGEI1){
		TMRA41_Int_Flag = 1;				// set TMRA41_Int_Flag to 1
		
		TMRA4_16bit_Read_Measure_Pulse_Width();// get the counter value of single edge capture mode
		//TMRA4_16bit_Read_Measure_Period();   // get the counter value of double edge capture mode
		
		IFR_TMRA41_IRQ = 0;					// clear TMRA41 interrupt flag
		
		
	}
	
}


