//SQ7653_TMRA0_16BIT_Timer_TMRA4_16BIT_Capture example
//*************************************************************************************
// file			: main.c
// version		: V1.0 2020/07/17
// brief		: main program
// description	: 1. TMRA0 is set to PPG mode and its output pin is P0.4 with period 8.533ms
//			  2. TMRA4 is set to pulse width measurment mode to measure the frequency from TMRA0 PPG output
//			  3. if TMRA4 capture result is 8.533ms, light on LED1, LED2 and LED3; if not, light off them
 
// note			: 1. TMRA0 frequency output pin is P0.4
//			  2. TMRA4 frequency meaurement pin is P0.3
//			  3. please connect P0.4 to P0.3 for measuring frequency
//			  4.  [LED Configuration] LED 1  (P0.0)
//				  [LED Configuration] LED 2  (P0.1)
//				  [LED Configuration] LED 3  (P0.2)
//**************************************************************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif
#include "main.h"

/* ---------------------- global variables -------------------------- */

long double TMRA41_count_scale= 0.08533;	    // period time
//------------------------------------------------------------

long double Capture_result;					// result
unsigned int j,k; 

/* ----------------------- main program --------------------------- */
void main()
{
/* ---------------------- system initialization ------------------------ */

/* ---------------------- pin configuration initialization ------------------------ */
    P0OE  = 0x07;                        	     // set P0.0, P0.1 and P0.2 as output pins
    P1OE  = 0x80;                        	     // set P1.7 as output pin
	P1PU |= 0x07;                       	     // enable P1.0, P1.1 and P1.2 built-in pull-up resistors
	LED1_out = 1;							     // set LED1 to the light off
	LED2_out = 1;							     // set LED2 to the light off
	LED3_out = 1;							     // set LED3 to the light off
	
	P0OE_P4 = 1;            // set P0.4 to output
	P0DO_P4 = 1;            // set P0.4 output level to high
	
	for(j=0;j<200;j++){     // delayed for a period of time about 31.9ms
		for(k=200;k>0;k--){
		
		}
	}	
	//---------------------------------------------------------------
	
/* -------------------- TMRA4 initialization ----------------------------------- */	
	TMRA4_16bit_Capture_Init();             	 // TMRA4 initialization to 16-bit pulse width measurement mode
	TMRA41_IntEnable();                          // enable TMRA4 interrupt
	TMRA4_16bit_Start();					     // start to run TRMA4
	
/* -------------------- TMRA0 initialization ----------------------------------- */	
	TMRA0_16bit_PPG_Init();					  	 // TMRA0 initialization to 16-bit PPG mode
	TMRA01_IntEnable();
    TMRA0_16bit_SetPeriod(100);	     	 	  	 // set TMRA0 period = 8.531ms
	TMRA0_16bit_SetDuty(30);	     		  	 // set TMRA0 duty cycle = 30%
	TMRA0_16bit_Start();					  	 // start to run TMRA0			

//------------------------------------------------------------------------------

    while(1){

		if(TMRA41_Int_Flag){
			TMRA41_Int_Flag = 0;				 // clear TMRA41_Int_Flag to wait for next interrupt
			
			Capture_result = (((long double)TMRA41_count_scale)*(long double)vRead_value2);
			//----------------------------------------------------------------------
			if(vRead_value2 == 100){           	 // light on LED1, LED2 and LED3
			   LED1_out = 0;
			   LED2_out = 0;
	           LED3_out = 0;			
			}
			else{
			   LED1_to_3_turn_off;				 // light off LED1, LED2 and LED3
			
			}
		}
		
		
	CLR_WDT;	
    }

	
}


/* ---------------------- interrupt service routine ------------------------ */
void __interrupt OnlyReti(void)
{
	__asm("NOP"); 							  // no operation
}

void __interrupt_n OnlyRetn(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n WDT_IRQ(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n SWI_IRQ(void)			  // software reset interrupt service routine
{
	SWRST = 0x5a;
	SWRST = 0xa5;
	SWRST = 0xc3;
	SWRST = 0x3c;	
}
/* ------------------- end of interrupt service routine ---------------------- */


/* -------------------- SQ7653 interrupt vector ------------------ */
#pragma section const INT_VECTOR1 
void * const IntTbl1[] = {
	OnlyReti,				/* 0xff3a : Reserved		  */									
	OnlyReti,				/* 0xff3c : Reserved		  */									
	OnlyReti,				/* 0xff3e : Reserved		  */									
	OnlyReti,				/* 0xff40 : Reserved		  */									
	OnlyReti,				/* 0xff42 : Reserved		  */									
	OnlyReti,				/* 0xff44 : Reserved		  */									
	OnlyReti,				/* 0xff46 : Reserved		  */								
	OnlyReti,				/* 0xff48 : Reserved		  */									
	OnlyReti,				/* 0xff4a : Reserved		  */									
	OnlyReti,				/* 0xff4c : Reserved		  */									
	OnlyReti,				/* 0xff4e : Reserved		  */									
	OnlyReti,				/* 0xff50 : Reserved		  */									
	OnlyReti,				/* 0xff52 : Reserved		  */									
	OnlyReti,				/* 0xff54 : Reserved		  */									
	OnlyReti,				/* 0xff56 : Reserved		  */									
	OnlyReti,				/* 0xff58 : Reserved		  */									
	OnlyReti,				/* 0xff5a : Reserved          */								
	OnlyReti,				/* 0xff5c : Reserved          */									
	OnlyReti,				/* 0xff5e : Reserved          */									
	OnlyReti,				/* 0xff60 : Reserved		  */									
	OnlyReti,				/* 0xff62 : Reserved		  */									
	OnlyReti,				/* 0xff64 : Reserved		  */									
	OnlyReti,				/* 0xff66 : Reserved		  */									
	OnlyReti,				/* 0xff68 : Reserved		  */									
	OnlyReti,				/* 0xff6a : Reserved    	  */
	OnlyReti,				/* 0xff6c : TX2_IRQ			  */	//interrupt source:UART2 TX2								
	OnlyReti,				/* 0xff6e : RX2_IRQ			  */	//interrupt source:UART2 RX2	
	OnlyReti,				/* 0xff70 : Reserved		  */									
	OnlyReti,				/* 0xff72 : Reserved		  */									
	OnlyReti,				/* 0xff74 : Reserved		  */									
	OnlyReti,				/* 0xff76 : Reserved		  */									
	OnlyReti,				/* 0xff78 : Reserved		  */									
	OnlyReti,				/* 0xff7a : Reserved		  */									
	OnlyReti,				/* 0xff7c : Reserved		  */									
	OnlyReti,				/* 0xff7e : Reserved		  */									
	OnlyReti,				/* 0xff80 : Reserved		  */		
	OnlyReti,		    	/* 0xff82 : EXT9_IRQ		  */	//external interrupt9							
	OnlyReti,	    		/* 0xff84 : EXT8_IRQ		  */	//external interrupt8								
	OnlyReti,				/* 0xff86 : Reserved		  */									
	OnlyReti,				/* 0xff88 : Reserved		  */									
	OnlyReti,				/* 0xff8a : Reserved		  */									
	OnlyReti,				/* 0xff8c : Reserved		  */									
	OnlyReti,				/* 0xff8e : Reserved		  */									
	OnlyReti,				/* 0xff90 : TX1_IRQ		      */	//interrupt source:UART1 TX1						
	OnlyReti,				/* 0xff92 : RX1_IRQ		      */	//interrupt source:UART1 RX1								
	OnlyReti,				/* 0xff94 : Reserved		  */									
	OnlyReti,				/* 0xff96 : Reserved		  */									
	TMRA41_IRQ,				/* 0xff98 : TMRA41_IRQ		  */	//interrupt source:counter1 of TMRA4								
	OnlyReti,				/* 0xff9a : TMRA40_IRQ		  */	//interrupt source:counter0 of TMRA4								
	OnlyReti,				/* 0xff9c : TMRA31_IRQ		  */	//interrupt source:counter1 of TMRA3								
	OnlyReti,				/* 0xff9e : TMRA30_IRQ		  */	//interrupt source:counter0 of TMRA3								
	OnlyReti,				/* 0xffa0 : EE_IRQ			  */	//interrupt source:EEPROM						
	OnlyReti,				/* 0xffa2 : EXT7_IRQ		  */	//external interrupt7						
	OnlyReti,				/* 0xffa4 : EXT6_IRQ		  */	//external interrupt6								
	OnlyReti,				/* 0xffa6 : EXT5_IRQ		  */	//external interrupt5								
	OnlyReti,				/* 0xffa8 : EXT4_IRQ		  */	//external interrupt4								
	OnlyReti,				/* 0xffaa : Reserved		  */									
	OnlyReti,				/* 0xffac : Reserved		  */									
	OnlyReti,				/* 0xffae : Reserved		  */									
	OnlyReti,				/* 0xffb0 : DIC_IRQ			  */	//interrupt source:DIC							
	OnlyReti,				/* 0xffb2 : Reserved		  */						
	OnlyReti,				/* 0xffb4 : Reserved		  */			
	OnlyReti,				/* 0xffb6 : Reserved		  */					
	OnlyReti,				/* 0xffb8 : Reserved		  */								
	OnlyReti,				/* 0xffba : Reserved		  */									
	OnlyReti,				/* 0xffbc : Reserved		  */									
	OnlyReti,				/* 0xffbe : Reserved		  */									
	OnlyReti,				/* 0xffc0 : Reserved		  */									
	OnlyReti,				/* 0xffc2 : Reserved		  */									
	OnlyReti,				/* 0xffc4 : FMC_IRQ			  */	//interrupt source:FMC								
	OnlyReti,				/* 0xffc6 : Reserved		  */					
	OnlyReti,				/* 0xffc8 : CMP_IRQ  		  */	//interrupt source:Comparator								
	OnlyReti,				/* 0xffca : Reserved		  */									
	OnlyReti,				/* 0xffcc : Reserved		  */									
	OnlyReti,			    /* 0xffce : ADC_IRQ			  */	//interrupt source:ADC								
	OnlyReti,				/* 0xffd0 : EXT3_IRQ		  */	//external interrupt3								
	OnlyReti,				/* 0xffd2 : EXT2_IRQ		  */	//external interrupt2							
	OnlyReti,				/* 0xffd4 : EXT1_IRQ		  */	//external interrupt1								
	OnlyReti,				/* 0xffd6 : EXT0_IRQ		  */	//external interrupt0								
	OnlyReti,				/* 0xffd8 : SIO0_IRQ		  */	//interrupt source:SIO 0								
	OnlyReti,				/* 0xffda : I2C0_IRQ		  */	//interrupt source:I2C0								
	OnlyReti,				/* 0xffdc : TX0_IRQ			  */	//interrupt source:UART0 TX0								
	OnlyReti,				/* 0xffde : RX0_IRQ			  */	//interrupt source:UART0 RX0								
	OnlyReti,				/* 0xffe0 : Reserved		  */									
	OnlyReti,				/* 0xffe2 : TMRA21_IRQ		  */	//interrupt source:counter1 of TMRA2					
	OnlyReti,				/* 0xffe4 : TMRA20_IRQ		  */	//interrupt source:counter0 of TMRA2								
	OnlyReti,				/* 0xffe6 : TMRA11_IRQ		  */	//interrupt source:counter1 of TMRA1								
	OnlyReti,				/* 0xffe8 : TMRA10_IRQ		  */	//interrupt source:counter0 of TMRA1
	TMRA01_IRQ,				/* 0xffea : TMRA01_IRQ		  */	//interrupt source:counter1 of TMRA0							
	OnlyReti,				/* 0xffec : TMRA00_IRQ		  */	//interrupt source:counter0 of TMRA0								
	OnlyReti,			    /* 0xffee : LVD1_IRQ		  */	//interrupt source:low voltage detection1
	OnlyReti, 			    /* 0xfff0 : TBT_IRQ			  */	//interrupt source:time base timer						
	OnlyReti,				/* 0xfff2 : Reserved		  */
	OnlyReti,				/* 0xfff4 : Reserved		  */
	OnlyReti,				/* 0xfff6 : LVD0_IRQ		  */	//interrupt source:low voltage detection0							
	WDT_IRQ,				/* 0xfff8 : WDT_IRQ			  */	//non-maskable interrupt source:watchdog timer	
	(void *)0xffff,			/* 0xfffa : Reserved		  */		
	SWI_IRQ,				/* 0xfffc : SWI_IRQ/INTUNDEF  */	//non-maskable		
	STARTUP					/* 0xfffe : RESET		      */	//non-maskable			
};
#pragma section const
/* ------------------- end of SQ7653 interrupt vector ---------------------- */

