//*************************************************************************************
// file			: SQ7653_TMRA4_Capture.h
// version		: V1.0 2020/07/17
// brief		: TMRA4_Capture header file 
// note			:        
//**************************************************************************************
#ifndef _SQ7653_TMRA4_CAPTURE_H__
#define _SQ7653_TMRA4_CAPTURE_H__

/* ---------------------- extern global variables ------------------------- */
extern unsigned char TMRA40_Int_Flag;	  	     // TMRA40 interrupt flag
extern unsigned char TMRA41_Int_Flag;	  	     // TMRA41 interrupt flag

extern unsigned char Data_PWL,Data_PWH;		 
extern unsigned int  capture_value;			 
extern unsigned int  vRead_value1;
extern unsigned int  vRead_value2;

/* ---------------------- user-defined macros ------------------------------ */
#define   enable    			  0x01		     // enable 
#define   disable  				  0x00		     // disable
//For t_mod_sel------
#define   set_8bit    			  0x00		     // 8-bit mode
//#define ppg_andlogic            0x01		 	 // timer 0 and 1 outputs AND together to TA01O 
#define   set_16bit  			  0x02		     // 16-bit mode
//#define pre_scale   			  0x04		     // pre-scale mode
//#define complementary   		  0x05		     // complementary mode

//For op_mod_sel------
//#define timer    				  0x00		     // timer mode
//#define event  		          0x01		     // event counter mode 
#define   capture  				  0x03	  	     // capture mode
//#define pwm                     0x04		     // pulse width modulation (PWM) mode
//#define pulse_measure           0x05		     // pulse width measurement mode
//#define ppg					  0x06		     // programmable pulse generate (PPG) mode

void TMRA40_8bit_Capture_Init();     		 	 // TMRA40 initialization to 8-bit capture mode
void TMRA41_8bit_Capture_Init();     		 	 // TMRA41 initialization to 8-bit capture mode
void TMRA4_16bit_Capture_Init();			 	 // TMRA4 initialization to 16-bit capture mode

void TMRA40_IntEnable();					     // enable TMRA40 interrupt
void TMRA41_IntEnable();					     // enable TMRA41 interrupt

void TMRA40_IntDisable();					     // disable TMRA40 interrupt
void TMRA41_IntDisable();					     // disable TMRA41 interrupt

void TMRA40_Start();							 // start to run TMRA40
void TMRA41_Start();							 // start to run TMRA41
void TMRA4_16bit_Start();						 // start to run TMRA4

void TMRA40_Stop();							 	 // stop and clear TMRA40
void TMRA41_Stop();							 	 // stop and clear TMRA41
void TMRA4_16bit_Stop();						 // stop and clear TMRA4
unsigned int TMRA4_16bit_Read_Capture_Value();	 // read TMRA4 capture value


void __interrupt TMRA40_IRQ(void);			  	 // TMRA40 interrupt service routine
void __interrupt TMRA41_IRQ(void);			  	 // TMRA41 interrupt service routine


#endif


