//*************************************************************************************
// file			: SQ7653_TMRA4_Capture.c
// version		: V1.0 2020/07/17
// brief		: TMRA4_Capturerelated functions
// note			: TMRA4_Capture related functions are gathered in this subroutine
//**************************************************************************************
#include "main.h"

unsigned char TMRA40_Int_Flag;		    // TMRA40 interrupt flag
unsigned char TMRA41_Int_Flag;		  	// TMRA41 interrupt flag

unsigned char Data_PWL,Data_PWH;			
unsigned int  capture_value;				
unsigned int  vRead_value1;
unsigned int  vRead_value2;
extern volatile unsigned int TMRA41_Int_count_value = 0;


//*********************************************************************
// name			: TMRA40_8bit_Capture_Init()
// brief		: TMRA40 initialization to 8-bit capture mode
// note			: 
//*********************************************************************
void TMRA40_8bit_Capture_Init(){
//====== enable function ======
	PCKEN0_TMRA4 = 1;                   	// enable TMRA4 function  *this must be enabled first, the relevant staging settings later to be useful	

//====== parameter setting ======

	//1.)---operation mode selection->
	TMRA4CFG_TCFG = set_8bit;				// set TMRA4 to 8-bit mode
	TMRA4MD0_TCM  = capture;    			// set TMRA40 to capture mode
	
	TMRA4MD0_DBE   = 1;						// enable double buffer
	//TMRA4MD0_DBE = 0;						// disable double buffer

	//2.)---clock source selection->				
    // if the system frequency is 24MHz, the input frequency of TMRA40 is 23.437KHz
    TMRA4MD0_TCK = 0x01;                	// set TMRA40 source clock to fcgck/(2^10) = 24M/1024 = 23.437kHz => 42.6667us

	//3.)---pin configuration initialization->
	//---set capture pin to P0.3->
	P0CFGCR = 0xB4;  						

	//4.)---capture mode edge selection->
	TMRA4CR1_EDGE = 0x00;					// rising
	//TMRA4CR1_EDGE = 0x02;					// falling
	//TMRA4CR1_EDGE = 0x03;					// both edges
	
}



//*********************************************************************
// name			: TMRA41_8bit_Capture_Init()
// brief		: TMRA41 initialization to 8-bit capture mode
// note			: 
//*********************************************************************
void TMRA41_8bit_Capture_Init(){
//====== enable function ======
	PCKEN0_TMRA4 = 1;                   	// enable TMRA4 function  *this must be enabled first, the relevant staging settings later to be useful	

//====== parameter setting ======

	//1.)---operation mode selection->
	TMRA4CFG_TCFG = set_8bit;				// set TMRA4 to 8-bit mode
	TMRA4MD1_TCM  = capture;    			// TMRA41 to capture mode
	
	TMRA4MD1_DBE   = 1;						// enable double buffer
	//TMRA4MD1_DBE = 0;						// disable double buffer

	//2.)---clock source selection->				
    // if the system frequency is 24MHz, the input frequency of TMRA41 is 23.437KHz
    TMRA4MD1_TCK = 0x01;                	// set TMRA41 source clock to fcgck/(2^10) = 24M/1024 = 23.437kHz => 42.6667us

	//3.)---pin configuration initialization->
	//---set capture pin to P0.3->
	P0CFGCR = 0xB4;  						

	//4.)---capture mode edge selection->
	TMRA4CR1_EDGE = 0x00;					// rising
	//TMRA4CR1_EDGE = 0x02;					// falling
	//TMRA4CR1_EDGE = 0x03;					// both edges
}



//*********************************************************************
// name			: TMRA4_16bit_Capture_Init()
// brief		: TMRA4 initialization to 16-bit capture mode
// note			: 
//*********************************************************************
void TMRA4_16bit_Capture_Init(){
//====== enable function ======
	PCKEN0_TMRA4 = 1;                   	// enable TMRA4 function  *this must be enabled first, the relevant staging settings later to be useful	

//====== parameter setting ======

	//1.)---operation mode selection->
	TMRA4CFG_TCFG = set_16bit;				// TMRA4 initialization to 16-bit mode
	TMRA4MD1_TCM  = capture;    			// TMRA4 to capture mode

	TMRA4MD1_DBE   = 1;					    // enable double buffer
	//TMRA4MD1_DBE = 0;						// disable double buffer

	//2.)---clock source selection->				
    // if the system frequency is 24MHz, the input frequency of TMRA4 is 23.437KHz
    TMRA4MD0_TCK = 0x00;                	// set TMRA4 source clock to fcgck/(2^11) = 24M/2048 = 11.718kHz => 85.3us

	//3.)---pin configuration initialization->
	//---set capture pin to P0.3->
	P0CFGCR = 0xB4;  						

	//4.)---capture mode edge selection->
	TMRA4CR1_EDGE = 0x00;					// rising
	//TMRA4CR1_EDGE = 0x02;					// falling
	//TMRA4CR1_EDGE = 0x03;					// both edges
	
}



//*********************************************************************
// name			: TMRA40_IntEnable()
// brief		: enable TMRA40 interrupt
// note			: 
//*********************************************************************
void TMRA40_IntEnable(){
	__ASM("DI");					    	// enable all maskable interrupts
	IER_TMRA40_IRQ = 1;                 	// enable TMRA40 interrupt
	
	//---edge detect interrupt setting->
	TMRA4CR0_EDGEIE = 1;					// enable TMRA40 edge detect interrupt
	
	//---counter overflow interrupt setting->
	//TMRA4CR0_TMROVIE = 1;             	// generate no TMRA40 interrupt request when the counter overflow occurs
	
	__ASM("EI");							// enable all maskable interrupts
}


//*********************************************************************
// name			: TMRA41_IntEnable()
// brief		: enable TMRA41 interrupt
// note			: 
//*********************************************************************
void TMRA41_IntEnable(){
	__ASM("DI");					    	// enable all maskable interrupts
	IER_TMRA41_IRQ = 1;                 	// enable TMRA41 interrupt
	
	//---edge detect interrupt setting->
	TMRA4CR1_EDGEIE = 1;					// enable TMRA41 edge detect interrupt
	
	//---counter overflow interrupt setting->
	//TMRA4CR1_TMROVIE = 1;             	// generate no TMRA41 interrupt request when the counter overflow occurs
	
	__ASM("EI");							// enable all maskable interrupts
}



//*********************************************************************
// name			: TMRA40_IntDisable()
// brief		: disable TMRA40 interrupt
// note			: 
//*********************************************************************
void TMRA40_IntDisable(){
	__ASM("DI");					    	// enable all maskable interrupts
	IER_TMRA40_IRQ = 0;                 	// disable TMRA40 interrupt
	
	//---edge detect interrupt setting->
	//TMRA4CR0_EDGEIE = 0;					// disable TMRA40 edge detect interrupt
	
	//---counter overflow interrupt setting->
	//TMRA4CR0_TMROVIE = 0;             	// generate no TMRA40 interrupt request when the counter overflow occurs
	
	__ASM("EI");							// enable all maskable interrupts
}


//*********************************************************************
// name			: TMRA41_IntDisable()
// brief		: disable TMRA41 interrupt
// note			: 
//*********************************************************************
void TMRA41_IntDisable(){
	__ASM("DI");					    	// enable all maskable interrupts
	IER_TMRA41_IRQ = 0;                 	// disable TMRA41 interrupt
	
	//---edge detect interrupt setting->
	//TMRA4CR1_EDGEIE = 0;					// disable TMRA41 edge detect interrupt
	
	//---counter overflow interrupt setting->
	//TMRA4CR1_TMROVIE = 0;             	// generate no TMRA41 interrupt request when the counter overflow occurs
	
	__ASM("EI");							// enable all maskable interrupts
}



//*********************************************************************
// name			: TMRA40_Start()
// brief		: start to run TMRA40
// note			: 
//*********************************************************************
void TMRA40_Start(){
	TMRA4CR0_RUN = 1;                   	
	
}


//*********************************************************************
// name			: TMRA41_Start()
// brief		: start to run TMRA41
// note			: 
//*********************************************************************
void TMRA41_Start(){
	TMRA4CR1_RUN = 1;                   	
	
}


//*********************************************************************
// name			: TMRA4_16bit_Start()
// brief		: start to run TMRA4
// note			: 
//*********************************************************************
void TMRA4_16bit_Start(){
	TMRA4CR1_RUN = 1;                   	
	
}


//*********************************************************************
// name			: TMRA40_Stop()
// brief		: stop and clear TMRA40
// note			: 
//*********************************************************************
void TMRA40_Stop(){
	TMRA4CR0_RUN = 0;                   	// stop and clear TMRA40
	IFR_TMRA40_IRQ = 0;						// clear TMRA40 interrupt flag
}


//*********************************************************************
// name			: TMRA41_Stop()
// brief		: stop and clear TMRA41
// note			: 
//*********************************************************************
void TMRA41_Stop(){
	TMRA4CR1_RUN = 0;                   	// stop and clear TMRA41
	IFR_TMRA41_IRQ = 0;						// clear TMRA41 interrupt flag	



}


//*********************************************************************
// name			: TMRA4_16bit_Stop()
// brief		: stop and clear TMRA4
// note			: 
//*********************************************************************
void TMRA4_16bit_Stop(){
	TMRA4CR1_RUN = 0;                   	// stop and clear TMRA0
	IFR_TMRA41_IRQ = 0;						// clear TMRA41 interrupt flag	
}


//*********************************************************************
// name			: TMRA4_16bit_Read_Capture_Value()
// brief		: read TMRA4 capture value
// note			: 
//*********************************************************************
unsigned int TMRA4_16bit_Read_Capture_Value(){
	Data_PWL = TMRA4PWM0;						// read low byte first
	Data_PWH = TMRA4PWM1;						
	
	capture_value = ((Data_PWH<<8) | Data_PWL); // return 16-bit value
	return capture_value;
}


//*********************************************************************
// name			: __interrupt TMRA40_IRQ()
// brief		: TMRA40 interrupt service routine
// note			:
//*********************************************************************
void __interrupt TMRA40_IRQ(void){
	__asm("NOP");							// no operation

	
}


//*********************************************************************
// name			: __interrupt TMRA41_IRQ()
// brief		: TMRA41 interrupt service routine
// note			:
//*********************************************************************
void __interrupt TMRA41_IRQ(void){
	__asm("NOP");							// no operation
	TMRA41_Int_count_value++;				// increase TMRA41 counting value
	IER_TMRA41_IRQ = 0;						// disable TMRA41 interrupt

	if(TMRA41_Int_count_value==1){
		vRead_value1 = TMRA4_16bit_Read_Capture_Value();	//read capture value to vRead_value1

	}
	else if(TMRA41_Int_count_value==2){	// second time TRMA4 interrupt	
		TMRA41_Int_Flag = 1;				// set TMRA41_Int_Flag to 1
		vRead_value2 = TMRA4_16bit_Read_Capture_Value();	//read capture value to vRead_value2
	
		TMRA41_Int_count_value = 0;			// set TMRA41 counting value to 0
	}
	IFR_TMRA41_IRQ = 0;							// clear TMRA41 interrupt flag	
	IER_TMRA41_IRQ = 1; 						// enable the interrupt


}


