//*************************************************************************************
// file			: SQ7653_TMRA0_PPG.h
// version		: V1.0 2020/07/17
// brief		: TMRA0_PPG header file 
// note			:        
//**************************************************************************************
#ifndef _SQ7653_TMRA0_PPG_H__
#define _SQ7653_TMRA0_PPG_H__

/* ---------------------- extern global variables ------------------------- */
extern unsigned char TMRA00_Int_Flag;	  	     	// TMRA00 interrupt flag
extern unsigned char TMRA01_Int_Flag;	  	     	// TMRA01 interrupt flag
extern unsigned int period;
extern unsigned int duty;

/* ---------------------- user-defined macros ------------------------------ */
#define   enable    			  0x01		        // enable 
#define   disable  				  0x00		        // disable
//For t_mod_sel------
#define   set_8bit    			  0x00		        // 8-bit mode
//#define ppg_andlogic            0x01		 	    // timer 0 and 1 outputs AND together to TA01O 
#define   set_16bit  			  0x02		        // 16-bit mode
//#define pre_scale   			  0x04		        // pre-scale mode
//#define complementary   		  0x05		        // complementary mode


//For op_mod_sel------
//#define timer    				  0x00		        // timer mode
//#define event  		          0x01		        // event counter mode 
//#define capture  				  0x03	  	        // capture mode
//#define pwm                     0x04		        // pulse width modulation (PWM) mode
//#define pulse_measure           0x05		        // pulse width measurement mode
#define ppg					      0x06		        // programmable pulse generate (PPG) mode

void TMRA00_8bit_PPG_Init();						// TMRA00 initialization to 8-bit PPG mode
void TMRA01_8bit_PPG_Init();						// TMRA01 initialization to 8-bit PPG mode
void TMRA0_16bit_PPG_Init();						// TMRA0 initialization to 16-bit PPG mode

void TMRA00_IntEnable();							// enalbe TMRA00 interrupt
void TMRA01_IntEnable();							// enalbe TMRA01 interrupt
void TMRA00_IntDisable();							// disalbe TMRA00 interrupt
void TMRA01_IntDisable();							// disalbe TMRA01 interrupt

void TMRA00_SetPeriod(unsigned int period);		// set TMRA00 timer counter
void TMRA01_SetPeriod(unsigned int period);		// set TMRA01 timer counter
void TMRA0_16bit_SetPeriod(unsigned int period);	// set TMRA0 timer counter

void TMRA00_SetDuty(unsigned int duty);           // set TMRA00 duty cycle
void TMRA01_SetDuty(unsigned int duty);		    // set TMRA01 duty cycle
void TMRA0_16bit_SetDuty(unsigned int duty);	    // set TMRA0 duty cycle

void TMRA00_Start();								// start to run TMRA00
void TMRA01_Start();								// start to run TMRA01
void TMRA0_16bit_Start();							// start to run TMRA0

void TMRA00_Stop();									// stop TMRA00
void TMRA01_Stop();									// stop TMRA01
void TMRA0_16bit_Stop();							// stop TMRA0

void __interrupt TMRA00_IRQ(void);					// TMRA00 interrupt service routine
void __interrupt TMRA01_IRQ(void);					// TMRA01 interrupt service routine


#endif


