//*************************************************************************************
// file			: main.h
// version		: V1.0 2020/07/17
// brief		: header file of this example
// note			: the custom variables used are collected in this document in this header file
//**************************************************************************************
#ifndef _INCLUDES_H__
#define _INCLUDES_H__

/* ---------------------- reference header files ------------------------------ */
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "SQ7653_SFR.h"
#include "SQ7653_TMRA0_PPG.h"

/* ---------------------- user-defined macros ------------------------------ */
#define BTN1_in    P1DI_P0		// BTN1(P1.0) button 1 input voltage
#define BTN2_in    P1DI_P1		// BTN1(P1.1) button 2 input voltage
#define BTN3_in    P1DI_P2		// BTN1(P1.2) button 3 input voltage

#define LED1_out   P0DO_P0		// LED1(P0.0) output voltage
#define LED2_out   P0DO_P1		// LED1(P0.1) output voltage
#define LED3_out   P0DO_P2		// LED1(P0.2) output voltage
#define LED1_to_3_turn_off      P0DO_P0 = 1; P0DO_P1 = 1; P0DO_P2 = 1;  // light off all LEDs
#define LED1_to_3_turn_on       P0DO_P0 = 0; P0DO_P1 = 0; P0DO_P2 = 0;  // light on all LEDs
/* ---------------------- extern functions ------------------------ */
extern void STARTUP(void);


#endif //#ifndef _INCLUDES_H__


