//*************************************************************************************
// file			: SQ7653_TMRA0_PPG.c
// version		: V1.0 2020/07/17
// brief		: TMRA0 PPG related functions
// note			: TMRA0 PPG related functions are gathered in this subroutine
//**************************************************************************************
#include "main.h"

unsigned char TMRA00_Int_Flag;		// TMRA00 interrupt flag
unsigned char TMRA01_Int_Flag;		// TMRA01 interrupt flag


//*********************************************************************
// name			: TMRA00_8bit_PPG_Init()
// brief		: TMRA00 initialization to 8-bit PPG mode
// note			: 
//*********************************************************************
void TMRA00_8bit_PPG_Init(){
	
//====== enable function ======
	PCKEN0_TMRA0 = 1;					// enable TMRA0  *this must be enabled first, the relevant staging settings later to be useful
	
//====== parameter setting ======

	//1.)---operation mode selection->
	TMRA0CFG_TCFG = set_8bit;			// set TMRA0 to 8-bit mode
	TMRA0MD0_TCM  = ppg ;				// set TMRA00 to PPG mode

	TMRA0MD0_DBE = 1;					// enable double buffer
	//TMRA0MD0_DBE = 0;					// disable double buffer

	//2.)---clock source selection->				
	//if the system frequency is 24MHz, the input frequency of TMRA00 is 23.437KHz
	TMRA0MD0_TCK = 0x01;				// set TMRA00 source clock to fcgck/(2^10) = 24M/1024 = 23.437kHz => 42.6667us

	//3.)---pin configuration initialization->
	//---set PPG output pin to P0.5->
	P0CFGCR = 0xD1;  				    
	
	//4.)---PPG output initial state initialization->
	TMRA0MD0_TFF   = 1;					// high level
	//TMRA0MD0_TFF = 0;					// low level
    
}



//*********************************************************************
// name			: TMRA01_8bit_PPG_Init()
// brief		: TMRA01 initialization to 8-bit PPG mode
// note			: 
//*********************************************************************
void TMRA01_8bit_PPG_Init(){
	
//====== enable function ======
	PCKEN0_TMRA0 = 1;                   // enable TMRA0  *this must be enabled first, the relevant staging settings later to be useful

//====== parameter setting ======

	//1.)---operation mode selection->
	TMRA0CFG_TCFG = set_8bit;			// set TMRA0 to 8-bit mode
	TMRA0MD1_TCM  = ppg ;				// set TMRA01 to PPG mode Counter1 (TMRA01)set TMRA0 to PPG mode
	
	TMRA0MD1_DBE = 1;					// enable double buffer
	//TMRA0MD1_DBE = 0;					// disable double buffer	
	
	//2.)---clock source selection->
	//if the system frequency is 24MHz, the input frequency of TMRA01 is 23.437KHz
	TMRA0MD1_TCK = 0x01;				// set TMRA01 source clock to fcgck/(2^10) = 24M/1024 = 23.437kHz => 42.6667us


	//3.)---pin configuration initialization->
	//---set PPG output pin to P0.4->
    P0CFGCR = 0xC1;  				    
	
	//4.)---PPG output initial state initialization->
	TMRA0MD1_TFF   = 1;					// high level
	//TMRA0MD1_TFF = 0;					// low level

}



//*********************************************************************
// name			: TMRA0_16bit_PPG_Init()
// brief		: TMRA0 initialization to 16-bit PPG mode
// note			: 
//*********************************************************************
void TMRA0_16bit_PPG_Init(){

//====== enable function ======
	PCKEN0_TMRA0 = 1;                   // enable TMRA0  *this must be enabled first, the relevant staging settings later to be useful

//====== parameter setting ======
	//1.)---operation mode selection->
	TMRA0CFG_TCFG = set_16bit;			// set TMRA0 to 16-bit mode
	TMRA0MD1_TCM  = ppg ;				// set TMRA01 to PPG mode set TMRA0 to PPG mode
	
	TMRA0MD1_DBE	= 1;				// enable double buffer
	//TMRA0MD1_DBE 	= 0;				// disable double buffer	
	
	//2.)---clock source selection->
	//if the system frequency is 24MHz, the input frequency of TMRA0 is 11.718KHz
	TMRA0MD1_TCK = 0x00;				// set TMRA01 source clock to fcgck/(2^11) = 24M/2048 Hz = 11.718kHz => 85.33us

	//3.)---pin configuration initialization->
	//---set PPG output pin to P0.4->
	P0CFGCR = 0xC1;  				    
	
	//4.)---PPG output initial state initialization->
	TMRA0MD1_TFF   = 1;					// high level
	//TMRA0MD1_TFF = 0;					// low level

}



//*********************************************************************
// name			: TMRA00_TMRA01_8bit_PPG_Logic_AND_Init()
// brief		: initialize timer 0 and 1 outputs AND together to TA01O
// note			: 
//*********************************************************************
void TMRA00_TMRA01_8bit_PPG_Logic_AND_Init(){
	
//====== enable function ======
	PCKEN0_TMRA0 = 1;					// enable TMRA0  *this must be enabled first, the relevant staging settings later to be useful
	
//====== parameter setting ======

	//1.)---operation mode selection->
	TMRA0CFG_TCFG = ppg_andlogic;	    // set TMRA0 to outputs AND together to TA01O
	TMRA0MD0_TCM  = ppg ;				// set TMRA00 to PPG mode
	TMRA0MD1_TCM  = ppg ;				// set TMRA01 to PPG mode

	TMRA0MD0_DBE = 1;					// enable double buffer
	TMRA0MD1_DBE = 1;					// enable double buffer
	
	//TMRA0MD0_DBE = 0;					// disable double buffer
	//TMRA0MD1_DBE = 0;					// disable double buffer

	//2.)---clock source selection->				
	//if the system frequency is 24MHz, the input frequency of TMRA0 is 11.718KHz
	TMRA0MD0_TCK = 0x00;				// set TMRA00 source clock to fcgck/(2^11) = 24M/2048 Hz = 11.718kHz => 85.33us
	TMRA0MD1_TCK = 0x00;				// set TMRA01 source clock to fcgck/(2^11) = 24M/2048 Hz = 11.718kHz => 85.33us

	//3.)---pin configuration initialization->
	//---set PPG output pin to P0.4->
	P0CFGCR = 0xC1;  				    
	
	//4.)----PPG output initial state initialization->
	TMRA0MD0_TFF   = 1;					// high level
	//TMRA0MD0_TFF = 0;					// low level
	
	TMRA0MD1_TFF   = 1;					// high level
	//TMRA0MD1_TFF = 0;					// low level

}


//*********************************************************************
// name			: TMRA00_IntEnable()
// brief		: enalbe TMRA00 interrupt
// note			: 
//*********************************************************************
void TMRA00_IntEnable(){
	__ASM("DI");					    // enable all maskable interrupts
	IER_TMRA00_IRQ = 1;                 // enalbe TMRA00 interrupt

	//TMRA0CR0_TMROVIE = 1;             // generate a TMRA00 interrupt request when the counter overflow occurs
	
	__ASM("EI");						// enable all maskable interrupts
}


//*********************************************************************
// name			: TMRA01_IntEnable()
// brief		: enalbe TMRA01 interrupt
// note			: 
//*********************************************************************
void TMRA01_IntEnable(){
	__ASM("DI");					    // enable all maskable interrupts
	IER_TMRA01_IRQ = 1;                 // enalbe TMRA01 interrupt

	//TMRA0CR1_TMROVIE = 1;             // generate a TMRA01 interrupt request when the counter overflow occurs
	
	__ASM("EI");						// enable all maskable interrupts
}



//*********************************************************************
// name			: TMRA00_IntDisable()
// brief		: disalbe TMRA00 interrupt
// note			: 
//*********************************************************************
void TMRA00_IntDisable(){
	__ASM("DI");					    // enable all maskable interrupts
	IER_TMRA00_IRQ = 0;                 // disalbe TMRA00 interrupt

	//TMRA0CR0_TMROVIE = 0;             // generate no TMRA00 interrupt request when the counter overflow occurs
	
	__ASM("EI");						// enable all maskable interrupts
}


//*********************************************************************
// name			: TMRA01_IntDisable()
// brief		: disalbe TMRA01 interrupt
// note			: 
//*********************************************************************
void TMRA01_IntDisable(){
	__ASM("DI");					    // enable all maskable interrupts
	IER_TMRA01_IRQ = 0;                 // disalbe TMRA01 interrupt
	
	//TMRA0CR1_TMROVIE = 0;             // generate no TMRA01 interrupt request when the counter overflow occurs
	
	__ASM("EI");						// enable all maskable interrupts
}



//*********************************************************************
// name			: TMRA00_SetPeriod()
// brief		: set TMRA00 timer counter
// note			: 
//*********************************************************************
void TMRA00_SetPeriod(unsigned int period){	
	TMRA0DR0 = period;              	

}




//*********************************************************************
// name			: TMRA01_SetPeriod()
// brief		: set TMRA01 timer counter
// note			: 
//*********************************************************************
void TMRA01_SetPeriod(unsigned int period){	
	TMRA0DR1 = period;              	

}



//*********************************************************************
// name			: TMRA0_16bit_SetPeriod()
// brief		: set TMRA0 timer counter
// note			: 
//*********************************************************************
void TMRA0_16bit_SetPeriod(unsigned int period){    
    TMRA0DR0 = period&0xff;             // low byte first
    TMRA0DR1 = period>>8;               // then high byte
	
}



//*********************************************************************
// name			: TMRA00_SetDuty()
// brief		: set TMRA00 duty cycle
// note			: 
//*********************************************************************
void TMRA00_SetDuty(unsigned int duty){	
	TMRA0PWM0 = duty;              		

}




//*********************************************************************
// name			: TMRA01_SetDuty()
// brief		: set TMRA01 duty cycle
// note			: 
//*********************************************************************
void TMRA01_SetDuty(unsigned int duty){	
	TMRA0PWM1 = duty;              		

}



//*********************************************************************
// name			: TMRA0_16bit_SetDuty()
// brief		: set TMRA0 duty cycle
// note			: 
//*********************************************************************
void TMRA0_16bit_SetDuty(unsigned int duty){    
    TMRA0PWM0 = duty&0xff;             	// low byte first
    TMRA0PWM1 = duty>>8;               	// then high byte
	
}





//*********************************************************************
// name			: TMRA00_Start()
// brief		: start to run TMRA00
// note			: 
//*********************************************************************
void TMRA00_Start(){
	TMRA0CR0_RUN = 1;                   
	
}


//*********************************************************************
// name			: TMRA01_Start()
// brief		: start to run TMRA01
// note			: 
//*********************************************************************
void TMRA01_Start(){
	TMRA0CR1_RUN = 1;                   
	
}


//*********************************************************************
// name			: TMRA0_16bit_Start()
// brief		: start to run TMRA0
// note			: 
//*********************************************************************
void TMRA0_16bit_Start(){
	TMRA0CR1_RUN = 1;                   
	
}




//*********************************************************************
// name			: TMRA00_TMRA01_8bit_PPG_Logic_AND_Start()
// brief		: start to run TMRA00 and TMRA01 outputs AND together to TA01O
// note			: 
//*********************************************************************
void TMRA00_TMRA01_8bit_PPG_Logic_AND_Start(){
	TMRA0CR0_RUN = 1;                   
	TMRA0CR1_RUN = 1;                   
	
}



//*********************************************************************
// name			: TMRA00_Stop()
// brief		: stop TMRA00
// note			: 
//*********************************************************************
void TMRA00_Stop(){
	TMRA0CR0_RUN = 0;                   // stop TMRA00
	IFR_TMRA00_IRQ = 0;					// clear TMRA00 interrupt flag
}


//*********************************************************************
// name			: TMRA01_Stop()
// brief		: stop TMRA01
// note			: 
//*********************************************************************
void TMRA01_Stop(){
	TMRA0CR1_RUN = 0;                   // stop TMRA01
	IFR_TMRA01_IRQ = 0;					// clear TMRA01 interrupt flag
}




//*********************************************************************
// name			: TMRA0_16bit_Stop()
// brief		: stop TMRA0
// note			: 
//*********************************************************************
void TMRA0_16bit_Stop(){
	TMRA0CR1_RUN = 0;                   // stop TMRA0
	IFR_TMRA01_IRQ = 0;					// clear TMRA01 interrupt flag
}



//*********************************************************************
// name			: TMRA00_TMRA01_8bit_PPG_Logic_AND_Stop()
// brief		: stop TMRA00 and TMRA01 outputs AND together to TA01O
// note			: 
//*********************************************************************
void TMRA00_TMRA01_8bit_PPG_Logic_AND_Stop(){
	TMRA0CR0_RUN = 0;                   
	TMRA0CR1_RUN = 0;                   
	
}



//*********************************************************************
// name			: __interrupt TMRA00_IRQ()
// brief		: TMRA00 interrupt service routine
// note			:
//*********************************************************************
void __interrupt TMRA00_IRQ(void){
	__asm("NOP");						// no operation
	TMRA00_Int_Flag = 1;				// set TMRA00_Int_Flag to 1

	
}


//*********************************************************************
// name			: __interrupt TMRA01_IRQ()
// brief		: TMRA01 interrupt service routine
// note			:
//*********************************************************************
void __interrupt TMRA01_IRQ(void){
	__asm("NOP");						// no operation
	TMRA01_Int_Flag = 1;				// set TMRA01_Int_Flag to 1

	
}

