//*************************************************************************************
// file			: SQ7653_PLL_System_Init.c
// version		: V1.0 2020/07/17
// brief		: PLL_System_Init related functions
// note			: PLL_System_Init related functions are collected in this subroutine
//**************************************************************************************

#include "main.h"

//*********************************************************************
// name			: PLL_System_Init()
// brief		: PLL initialization
// note			: 
// F_div_sel: PLL_24M	system frequency divided by 1  (24M/1  = 24MHz)
//			  PLL_12M	system frequency divided by 2  (24M/2  = 12MHz)
//            PLL_6M	system frequency divided by 4  (24M/4  = 6MHz)
//			  PLL_3M	system frequency divided by 8  (24M/8  = 3MHz)
//			  PLL_1_5M  system frequency divided by 16 (24M/16 = 1.5MHz = 1500KHz)
//			  PLL_750K  system frequency divided by 32 (24M/32 = 750kHz)
//			  PLL_375K  system frequency divided by 64 (24M/64 = 375kMHz)
//			  PLL_187_5K  system frequency divided by 128(24M/128 = 187.5kHz) 
//
// example		: to use PLL 24MHz as the system clock source, the function is used as shown below
//			  PLL_System_Init(PLL_12M);		  // (24M/2 = 12MHz) 
//*********************************************************************
void PLL_System_Init(unsigned char F_div_sel){

	PLLCR0_PLLEN  = 1;                     	  // enable PLL
	while(PLLCR0_PLLRDY ==0);				  // wait for PLL to be ready
	PLL_Freq_Division(F_div_sel);			  // PLL frequency division selection
    CLKCR0_SCKSEL = 1;                        // switch clock source to PLL
	
	while(CLKST_SCKSRC == 0x01 && CLKST_SCKRDY == 0);// wait for system clock to be ready
}


//*********************************************************************
// name			: PLL_Freq_Division()
// brief		: PLL frequency division selection
// note			: 
//*********************************************************************
void PLL_Freq_Division(unsigned char F_div_sel){


	CLKCR0_SCKPSC = F_div_sel;                // set system clock frequency division
  

}

