//*************************************************************************************
// file			: SQ7653_LXTAL_System_Init.c
// version		: V1.0 2020/07/17
// brief		: LXTAL related functions
// note			: LXTAL related functions are gathered in this subroutine
//**************************************************************************************

#include "main.h"

//*********************************************************************
// name			: LXTAL_System_Init()
// brief		: LXTAL system clock initialization
// note			: 
// F_div_sel	: LXTAL_32K	system clock frequency divide by 1  (32.768K/1  = 32.768KHz)
//
// example		: to use LXTAL 32KHz as the system clock source , the function is used as shown below.
//			  LXTAL_System_Init(LXTAL_32K);		  // (32.768K/1 = 32.768KHz) 
//*********************************************************************
void LXTAL_System_Init(unsigned char F_div_sel){

	// because of the need to use an external low speed crystal oscillator, the first step is to set the pin of the external crystal oscillator
	//--LXIN (P4.6) ; LXOUT (P4.5)-------
	P4CFGCR |= 0xEF;  				    	  // P4.6 is set to LXIN 1 110 1111
	P4CFGCR |= 0xDF;						  // P4.5 is set to LXOUT 1 101 1111

    CLKCR2_SCKLF  = 1;                        // set system clock to LXTAL
	CLKCR1_LXEN   = 1;				          // enable LXTAL external low-speed system clock
	while(CLKST_LXRDY ==0);			      // wait for LXTAL to be ready
    
    // the LXTAL is ready, switch the system clock source to LXTAL
    
	//LXTAL_Freq_Division(F_div_sel);		  // LXTAL system clock divider selection
    CLKCR0_SCKSEL = 0x04;				      // switch the system clock source to LXTAL
	
	while(CLKST_SCKRDY == 0);                 // wait for sysytem clock to be ready
    // system clock is ready
    
}


//*********************************************************************
// name			: LXTAL_Freq_Division()
// brief		: LXTAL system clock divider selection
// note			: 
//*********************************************************************
void LXTAL_Freq_Division(unsigned char F_div_sel){


	CLKCR0_SCKPSC = F_div_sel;                // set system clock frequency division
  

}

