//*************************************************************************************
// file			: SQ7653_SIO_Master.h
// version		: V1.0 2020/07/17
// brief		: SIO0_Master header file
// note			: 
//**************************************************************************************
#ifndef _SQ7653_SIO_Master_H__
#define _SQ7653_SIO_Master_H__

/* ---------------------- extern global variables ------------------------- */




/* ---------------------- user-defined macros ------------------------------ */
#define SIO_0  0

#define SIO_CKS_DIV512   0x00
#define SIO_CKS_DIV64    0x01
#define SIO_CKS_DIV32    0x02
#define SIO_CKS_DIV16    0x03
#define SIO_CKS_DIV8     0x04
#define SIO_CKS_DIV4     0x05
#define SIO_CKS_DIV2     0x06
#define SIO_CKS_EXT      0x07

//------------------------------------------------------------------
void SIO0_Init(void);                       // SIO0 initialization
void SIO0_Start(void);                      // start SIO
void SIO0_Stop(void);                       // stop SIO0
void SIO0_IntEnable(void);                  // enable SIO interrupt
void SIO_ByteSend(unsigned char txdata);	 // SO transmits data
unsigned char SIO_ByteRead(unsigned char sio);				// SI receives data
void SIO_ReservedStopWait(unsigned char sio);				// wait for SIO stop

void __interrupt SIO0_IRQ(void);            // SIO0 interrupt service routine

#endif

